/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IGeocodeConstraints;
import java.util.Locale;
import java.util.Set;

public class DEU_Constraints
extends Constraints {
    private static final String RELAXED_MODE = "RelaxedMode";
    private static final String EXACT_MODE = "ExactMode";
    private static final String DEFAULT_MODE = "DefaultMode";
    private boolean m_isRelaxedMode;
    private boolean m_isExactMode;
    private boolean m_isdefultsMode;
    private boolean isSegmenetedPrefferd;
    private boolean isAPPrefferd;
    private boolean m_hadSingleLineInput = false;
    private Set<Integer> m_ignoredSacs;
    private Set<Integer> m_searchedSacs;
    private boolean isDataConstructionConstraint;

    public DEU_Constraints() {
        this.setDefualtValues();
    }

    public DEU_Constraints(IGeocodeConstraints geocodeConstraints) {
        super(geocodeConstraints);
    }

    public DEU_Constraints(IConstraints constraints) {
        super(constraints);
        if (constraints instanceof DEU_Constraints) {
            this.m_hadSingleLineInput = ((DEU_Constraints)constraints).m_hadSingleLineInput;
        } else if (constraints.getCustomString("ORIGINAL_SINGLE_LINE") != null) {
            this.m_hadSingleLineInput = true;
        }
    }

    private void setDefualtValues() {
        this.setGeocodeType(0);
        this.setClientCoordinateSystem("epsg:4326");
        this.setClientLocale(Locale.GERMANY);
        this.setReturnCloseCandidatesOnly(false);
        this.setMustMatchPostalCode(false);
        this.setMustMatchAddressNumber(false);
        this.setReturnCloseCandidatesOnly(false);
        this.setMustMatchArea3(false);
        this.setMustMatchArea4(false);
        this.setMustMatchInput(false);
        this.setMustMatchMainAddress(false);
        this.setFallbackToGeographic(false);
        this.setFallbackToPostal(false);
        this.setMustMatchCountry(true);
        this.setMaxCandidates(3);
        this.setMaxRanges(-1);
        this.setCornerOffset(7.0);
        this.setStreetOffset(7.0);
        this.setCornerOffsetUnits("m");
        this.setStreetOffsetUnits("m");
        this.setCustomString(RELAXED_MODE, "true");
    }

    public void setRelaxedMode(boolean relaxMode) {
        this.m_isRelaxedMode = relaxMode;
    }

    public void setExactMode(boolean exactMode) {
        this.m_isExactMode = exactMode;
    }

    public void setStandardMode(boolean stdMode) {
        this.m_isdefultsMode = stdMode;
    }

    public boolean isRelaxedMatchMode() {
        return this.m_isRelaxedMode;
    }

    public boolean isExactMatchMode() {
        return this.m_isExactMode;
    }

    public boolean isStandardMatchMode() {
        return this.m_isdefultsMode;
    }

    protected void setDefaultSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(false);
        constraints.setMustMatchArea2(false);
        constraints.setMustMatchArea3(false);
        constraints.setMustMatchArea4(false);
        constraints.setMustMatchAddressNumber(true);
        constraints.setMustMatchMainAddress(true);
        constraints.setMustMatchPostalCode(false);
        constraints.setMustMatchInput(false);
        constraints.setMustMatchCountry(true);
        this.setStandardMode(true);
    }

    protected void setExactMatchSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(true);
        constraints.setMustMatchArea2(true);
        constraints.setMustMatchArea3(true);
        constraints.setMustMatchArea4(true);
        constraints.setMustMatchAddressNumber(true);
        constraints.setMustMatchMainAddress(true);
        constraints.setMustMatchPostalCode(true);
        constraints.setMustMatchInput(true);
        constraints.setMustMatchCountry(true);
        this.setExactMode(true);
    }

    protected void setRelaxedMatchSettings(IGeocodeConstraints constraints) {
        constraints.setMustMatchArea1(false);
        constraints.setMustMatchArea2(false);
        constraints.setMustMatchArea3(false);
        constraints.setMustMatchArea4(false);
        constraints.setMustMatchAddressNumber(false);
        constraints.setMustMatchMainAddress(false);
        constraints.setMustMatchPostalCode(false);
        constraints.setMustMatchInput(false);
        constraints.setMustMatchCountry(true);
        this.setRelaxedMode(true);
    }

    public static IConstraints convertFromConstraints(IConstraints inConstraints) {
        if (inConstraints instanceof DEU_Constraints) {
            return inConstraints;
        }
        DEU_Constraints specificConstarints = new DEU_Constraints(inConstraints);
        specificConstarints.setHandler(inConstraints.getHandler());
        return specificConstarints;
    }

    public boolean isPreferSegmentDictionary() {
        return this.isSegmenetedPrefferd;
    }

    public boolean isPreferAPDictionary() {
        return this.isAPPrefferd;
    }

    public void setPreferSegmentDictionary(boolean value) {
        this.isSegmenetedPrefferd = value;
    }

    public void setPreferAPDictionary(boolean value) {
        this.isAPPrefferd = value;
    }

    public boolean getDataConstructionConstraint() {
        return this.isDataConstructionConstraint;
    }

    public void setDataConstructionConstraint(boolean dataConstruction) {
        this.isDataConstructionConstraint = dataConstruction;
    }

    public boolean isSingleLineInput() {
        return this.m_hadSingleLineInput;
    }

    public void setIgnoredSacs(Set<Integer> ignoredSacs) {
        this.m_ignoredSacs = ignoredSacs;
    }

    public Set<Integer> getIgnoredSacs() {
        return this.m_ignoredSacs;
    }

    public void setSearchedSacs(Set<Integer> ignoredSacs) {
        this.m_searchedSacs = ignoredSacs;
    }

    public Set<Integer> getSearchedSacs() {
        return this.m_searchedSacs;
    }
}

