/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_StreetCandidateAddress;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class DEU_InternalBrowseAddress
extends InternalBrowseAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    private StreetBasedIdentifier m_identifier = null;
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String PRE_SEPARATOR_CHAR = "PRE_SEP";
    public static final String POST_SEPARATOR_CHAR = "POST_SEP";

    public DEU_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        Segment segment = this.getSegmentAt(0);
        candidate.setAreaName1(segment.getLeftAreaName1());
        candidate.setAreaName2(segment.getLeftAreaName2());
        candidate.setAreaName3(segment.getLeftAreaName3());
        candidate.setAreaName4(segment.getLeftAreaName4());
        candidate.setPostCode1(segment.getLeftPostCode1());
        candidate.setPreAddress(null);
        candidate.setFormattedLocationAddress(candidate.getPostCode1() + " " + candidate.getAreaName3());
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        return candidate;
    }

    public boolean isAPCandidate() {
        return ((DEU_StreetCandidateAddress)this.getStreetCandidateAddress()).isAPCandidate();
    }

    public static String getFormattedPreAddress(Address cand) {
        StringBuffer buff = new StringBuffer();
        String tmp = DEU_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_COMMON));
        if (tmp.length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = DEU_InternalBrowseAddress.noNulls(cand.getPreAddress())).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = DEU_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp);
        }
        return buff.toString().trim();
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    protected String getFormattedStreetAddress() {
        String preSep;
        String tempStr;
        String postSep;
        String type;
        StringBuffer str = new StringBuffer();
        String original_address = this.getGenericField4();
        if (original_address != null && original_address.length() != 0) {
            return StringUtilities.toProperCase((String)original_address);
        }
        HashMap adFields = this.getAdditionalFields();
        if (this.getPreThoroughfareType() != null && (type = DEU_ThoroughfareTypes.lookupProperName(this.getPreThoroughfareType())) != null) {
            type = StringUtilities.toProperCase((String)type);
            str.append(type);
        }
        if (adFields != null && !adFields.isEmpty() && (postSep = (String)adFields.get(POST_SEPARATOR_CHAR)) != null && postSep.length() > 0) {
            str.append(postSep);
        }
        if ((tempStr = this.getPreAddress()) != null) {
            str.append(tempStr);
            int len = tempStr.length();
            if (len > 0 && tempStr.charAt(len - 1) != '-') {
                str.append(' ');
            }
        }
        if (this.getMainAddress() != null) {
            str.append(this.getMainAddress());
        }
        boolean upperCasePostType = false;
        if (adFields != null && !adFields.isEmpty() && (preSep = (String)adFields.get(PRE_SEPARATOR_CHAR)) != null && preSep.length() > 0) {
            upperCasePostType = true;
            str.append(preSep);
        }
        if (this.getPostThoroughfareType() != null) {
            String postType = DEU_ThoroughfareTypes.lookupProperName(this.getPostThoroughfareType());
            if (upperCasePostType) {
                str.append(postType.substring(0, 1).toUpperCase());
                str.append(postType.substring(1));
            } else {
                str.append(postType);
            }
        }
        tempStr = this.getPostAddress();
        if (this.getPostAddress() != null && tempStr.length() > 0) {
            if (str.length() > 0 && (tempStr.charAt(0) != ' ' || tempStr.charAt(0) != '-')) {
                str.append(' ');
            }
            str.append(tempStr);
        }
        return StringUtilities.toProperCase((String)str.toString());
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

