/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import java.util.Comparator;

public class DEU_StreetMultipleSegmentComparator
implements Comparator {
    public int compare(Object o1, Object o2) {
        DEU_InternalCandidateAddress candidate1 = (DEU_InternalCandidateAddress)((Object)o1);
        DEU_InternalCandidateAddress candidate2 = (DEU_InternalCandidateAddress)((Object)o2);
        long candidateOffsetDiff = candidate1.getStreetOffset() - candidate2.getStreetOffset();
        if (candidateOffsetDiff > 0L) {
            return 1;
        }
        if (candidateOffsetDiff < 0L) {
            return -1;
        }
        double postCodeScoreDiff = candidate1.getPostCode1Score() - candidate2.getPostCode1Score();
        if (postCodeScoreDiff > 0.0) {
            return 1;
        }
        if (postCodeScoreDiff < 0.0) {
            return -1;
        }
        double an3ScoreDiff = candidate1.getAreaName3Score() - candidate2.getAreaName3Score();
        if (an3ScoreDiff > 0.0) {
            return 1;
        }
        if (an3ScoreDiff < 0.0) {
            return -1;
        }
        double placeNameScoreDiff = candidate1.getPlaceNameScore() - candidate2.getPlaceNameScore();
        if (placeNameScoreDiff > 0.0) {
            return 1;
        }
        if (placeNameScoreDiff < 0.0) {
            return -1;
        }
        double hnrScoreDiff = candidate1.getAddressNumberScore() - candidate2.getAddressNumberScore();
        if (hnrScoreDiff > 0.0) {
            return 1;
        }
        if (hnrScoreDiff < 0.0) {
            return -1;
        }
        if (candidate1.hasClosestRange() && candidate2.hasClosestRange()) {
            long hnrOffsetDiff = candidate1.getAdjustedOffset() - candidate2.getAdjustedOffset();
            if (hnrOffsetDiff > 0L) {
                return -1;
            }
            if (hnrOffsetDiff < 0L) {
                return 1;
            }
            return this.compareCandidateRangeOffset(candidate1, candidate2);
        }
        if (candidate1.hasClosestRange()) {
            return 1;
        }
        if (candidate2.hasClosestRange()) {
            return -1;
        }
        return 0;
    }

    private int compareCandidateRangeOffset(DEU_InternalCandidateAddress candiate1, DEU_InternalCandidateAddress candidate2) {
        int rangedOffseDiff = 0;
        Segment segment1 = candiate1.getSegment();
        Segment segment2 = candidate2.getSegment();
        if (segment1 != null && segment2 != null) {
            Range range1 = segment1.getRangeAt(candiate1.getMatchedRangeNumber(), candiate1.getSegmentSide());
            Range range2 = segment2.getRangeAt(candidate2.getMatchedRangeNumber(), candidate2.getSegmentSide());
            if (range1 != null && range2 != null) {
                long matchedaddressnumber2;
                long matchedaddressnumber1 = range1.getMatchedRangeNumber().getAddressNumber();
                if (matchedaddressnumber1 < (matchedaddressnumber2 = range2.getMatchedRangeNumber().getAddressNumber())) {
                    rangedOffseDiff = 1;
                } else if (matchedaddressnumber1 > matchedaddressnumber2) {
                    rangedOffseDiff = -1;
                }
            }
        }
        return rangedOffseDiff;
    }
}

