/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU;

import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IResettableStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.MMJLog;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeSet;

public class DEU_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder
implements IResettableStreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private Address m_savedParsedAddress;
    protected boolean m_resetConstraints;
    protected boolean m_resetParsedAddress;
    private boolean m_flag = false;
    private Address m_OrigScoringAddress;

    public DEU_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        int previousResultSize;
        boolean tryAgain = false;
        DEU_Constraints deuConstraints = (DEU_Constraints)constraints;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        Address searchParsedAddress = ((ICoreStreetGeocoder)deuConstraints.getHandler()).getSearchParsedAddress();
        if (!this.m_resetParsedAddress) {
            this.m_savedParsedAddress = new AddressImpl(deuConstraints.getHandler().getParsedAddress());
        } else {
            this.setSearchParsedAddress((Address)new AddressImpl(this.m_savedParsedAddress));
            this.setParsedAddress((Address)new AddressImpl(this.m_savedParsedAddress));
            this.m_resetParsedAddress = false;
        }
        if (this.m_resetConstraints) {
            deuConstraints.removeCustomObject("KEY_DEU_ALTERNATE_SOUNDEX_CODES");
            this.m_resetConstraints = false;
        }
        Address inputAddress = deuConstraints.getHandler().getInputAddress();
        Address pa = deuConstraints.getHandler().getParsedAddress();
        boolean exactStreet = false;
        boolean matchingPOBox = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false"));
        CoreHandler handler = (CoreHandler)deuConstraints.getHandler();
        List previousResultList = handler.getIntermediateMatchResults();
        int n = previousResultSize = previousResultList == null ? 0 : previousResultList.size();
        if (previousResultSize > 0) {
            ArrayList<Long> previousStreetOffsets = (ArrayList<Long>)deuConstraints.getCustomObject("KEY_STREETS_TO_REMOVE");
            if (previousStreetOffsets == null) {
                previousStreetOffsets = new ArrayList<Long>(previousResultSize);
            }
            for (int i = 0; i < previousResultSize; ++i) {
                InternalCandidateAddress candAddr = (InternalCandidateAddress)previousResultList.get(i);
                Long streetOffset = new Long(candAddr.getStreetOffset());
                if (previousStreetOffsets.contains(streetOffset)) continue;
                previousStreetOffsets.add(streetOffset);
            }
            deuConstraints.setCustomObject("KEY_STREETS_TO_REMOVE", previousStreetOffsets);
        }
        if (this.m_currentCase == 0) {
            String mustMatchMainAddr = deuConstraints.getCustomString("MustMatchMainAddr");
            deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
            if (mustMatchMainAddr != null && mustMatchMainAddr.equalsIgnoreCase("TRUE")) {
                exactStreet = true;
            }
        }
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                if (deuConstraints.isSingleLineInput() && constraints.getHandler().getParsedAddress().getAreaName1() != null && constraints.getHandler().getParsedAddress().getPostCode1() != null) {
                    String origAreaName3 = constraints.getHandler().getParsedAddress().getAreaName1();
                    String origAreaName1 = constraints.getHandler().getParsedAddress().getAreaName3();
                    if (origAreaName1.length() <= 2) {
                        this.m_savedParsedAddress.setAreaName3(origAreaName3);
                        this.m_savedParsedAddress.setAreaName1(origAreaName1);
                    }
                    searchParsedAddress.setAreaName3(origAreaName3);
                    searchParsedAddress.setAreaName1(origAreaName1);
                    this.setParsedAddress(searchParsedAddress);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.m_currentCase;
                if (!matchingPOBox && deuConstraints.isSingleLineInput()) {
                    String origMainAddress = deuConstraints.getHandler().getInputAddress().getMainAddress();
                    String origPostAddress = deuConstraints.getHandler().getInputAddress().getPostAddress();
                    if (!StringUtilities.isEmpty((String)origMainAddress) && !StringUtilities.isEmpty((String)origPostAddress)) {
                        StringTokenizer token = new StringTokenizer(origPostAddress, " -", true);
                        LinkedList list = StringUtilities.tokensToList((StringTokenizer)token);
                        StringBuffer buf = new StringBuffer();
                        String temp = null;
                        String pc = null;
                        for (int i = 0; i < list.size(); ++i) {
                            temp = list.get(i).toString();
                            if (StringUtilities.isNumeric((String)temp) && temp.length() == 5) {
                                pc = temp;
                                continue;
                            }
                            buf.append(temp);
                        }
                        AddressImpl modified_Pa = new AddressImpl();
                        modified_Pa.setMainAddress(buf.toString().trim());
                        modified_Pa.setPostAddress(origMainAddress);
                        Address newPa = null;
                        try {
                            newPa = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)modified_Pa, (IConstraints)deuConstraints)[0];
                        }
                        catch (ParserException e) {
                            newPa = null;
                        }
                        newPa.setPostCode1(pc);
                        if (newPa.getAddressNumber() == null && pa.getAddressNumber() != null) {
                            newPa.setAddressNumber(pa.getAddressNumber());
                        }
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        break;
                    }
                }
            }
            case 2: {
                ++this.m_currentCase;
                String sacMustMatchGeoAndPostal = deuConstraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                if (sacMustMatchGeoAndPostal != null && sacMustMatchGeoAndPostal.equalsIgnoreCase("TRUE")) {
                    deuConstraints.removeCustomObject("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                long number;
                ++this.m_currentCase;
                if (!matchingPOBox && deuConstraints.isSingleLineInput() && !StringUtilities.isEmpty((String)searchParsedAddress.getMainAddress()) && (number = DEU_AddressTerm.convertRomanToLong(searchParsedAddress.getMainAddress())) != 0L) {
                    searchParsedAddress.setMainAddress(searchParsedAddress.getAreaName3());
                    searchParsedAddress.setAreaName3(null);
                    searchParsedAddress.setAreaName1(null);
                    if (StringUtilities.isEmpty((String)searchParsedAddress.getPostThoroughfareType()) && !StringUtilities.isEmpty((String)searchParsedAddress.getPreThoroughfareType())) {
                        searchParsedAddress.setPostThoroughfareType(searchParsedAddress.getPreThoroughfareType());
                        searchParsedAddress.setPreThoroughfareType(null);
                    }
                    this.setParsedAddress(searchParsedAddress);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 4: {
                ++this.m_currentCase;
                String postcode = searchParsedAddress.getPostCode1();
                if (postcode != null && postcode.length() < 5 && postcode.charAt(0) != '0') {
                    postcode = '0' + postcode;
                    searchParsedAddress.setPostCode1(postcode);
                    this.m_resetParsedAddress = true;
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    this.m_savedParsedAddress.setPostCode1(postcode);
                    break;
                }
            }
            case 5: {
                ++this.m_currentCase;
                deuConstraints.setCustomObject("KEY_GEOBASE_FOR_AREA4", "true");
                this.shouldConsiderIgnoreSaclist(deuConstraints);
                tryAgain = true;
                break;
            }
            case 6: {
                ++this.m_currentCase;
                boolean bStringKey = new Boolean(deuConstraints.getCustomString("KEY_GEOBASE_STRING_ONLY"));
                if (bStringKey) {
                    deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    break;
                }
            }
            case 7: {
                ++this.m_currentCase;
                if (!(matchingPOBox || !deuConstraints.isSingleLineInput() || StringUtilities.isEmpty((String)searchParsedAddress.getMainAddress()) || StringUtilities.isEmpty((String)searchParsedAddress.getAreaName3()) || StringUtilities.isEmpty((String)searchParsedAddress.getAreaName1()))) {
                    String probableMainAddr = searchParsedAddress.getAreaName1();
                    String probablePreAddr = searchParsedAddress.getAreaName3();
                    String probableAN3 = searchParsedAddress.getMainAddress();
                    searchParsedAddress.setMainAddress(probableMainAddr);
                    searchParsedAddress.setPreAddress(probablePreAddr);
                    searchParsedAddress.setAreaName3(probableAN3);
                    this.setParsedAddress(searchParsedAddress);
                    this.m_resetParsedAddress = true;
                    tryAgain = true;
                    break;
                }
            }
            case 8: {
                String newMainAddress;
                ++this.m_currentCase;
                String oldMainAddress = pa.getMainAddress();
                String oldStreettype = pa.getPreThoroughfareType();
                if (!matchingPOBox && oldMainAddress != null && oldStreettype != null && StringUtilities.hasNumeric((String)oldMainAddress) && (newMainAddress = DEU_ThoroughfareTypes.lookupProperName(oldStreettype)) != null) {
                    searchParsedAddress.setMainAddress(newMainAddress);
                    searchParsedAddress.setPreThoroughfareType(null);
                    searchParsedAddress.setPostAddress(oldMainAddress);
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    this.m_resetParsedAddress = true;
                    break;
                }
            }
            case 9: {
                Address newPa;
                String preAddr;
                ++this.m_currentCase;
                String string = preAddr = searchParsedAddress.getPreAddress() == null ? "" : searchParsedAddress.getPreAddress().trim();
                if (!(matchingPOBox || preAddr.length() == 0 || searchParsedAddress.getPostThoroughfareType() != null && searchParsedAddress.getPreThoroughfareType() != null)) {
                    AddressImpl ura = new AddressImpl(inputAddress);
                    ura.setMainAddress(preAddr);
                    newPa = null;
                    try {
                        newPa = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)ura, (IConstraints)deuConstraints)[0];
                    }
                    catch (ParserException e) {
                        newPa = null;
                    }
                    if (newPa != null && (newPa.getPostThoroughfareType() != null || newPa.getPreThoroughfareType() != null)) {
                        if (StringUtilities.hasNumeric((String)searchParsedAddress.getMainAddress()) && searchParsedAddress.getAddressNumber() == null) {
                            newPa.setAddressNumber(searchParsedAddress.getMainAddress());
                            deuConstraints.setPreferAPDictionary(true);
                            deuConstraints.setPreferSegmentDictionary(false);
                        } else if (!DEU_AddressTerm.isDirectional(searchParsedAddress.getMainAddress())) {
                            newPa.setPostAddress(searchParsedAddress.getMainAddress());
                        } else {
                            newPa.setPostDirectional(searchParsedAddress.getMainAddress());
                        }
                        if (newPa.getAddressNumber() == null && searchParsedAddress.getAddressNumber() != null) {
                            newPa.setAddressNumber(searchParsedAddress.getAddressNumber());
                        }
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        this.shouldConsiderIgnoreSaclist(deuConstraints);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 10: {
                String preAddr;
                ++this.m_currentCase;
                String string = preAddr = searchParsedAddress.getPreAddress() == null ? "" : searchParsedAddress.getPreAddress().trim();
                if (!matchingPOBox && preAddr.length() != 0) {
                    int spacePos = preAddr.lastIndexOf(32);
                    String newMainAddr = null;
                    if (spacePos != -1) {
                        newMainAddr = preAddr.substring(spacePos + 1) + searchParsedAddress.getMainAddress();
                        preAddr = preAddr.substring(0, spacePos);
                    } else {
                        spacePos = preAddr.lastIndexOf(45);
                        if (spacePos != -1) {
                            newMainAddr = preAddr.substring(spacePos + 1) + searchParsedAddress.getMainAddress();
                            preAddr = preAddr.substring(0, spacePos);
                        } else {
                            String prevmainAddr = searchParsedAddress.getMainAddress();
                            if (prevmainAddr.startsWith("(")) {
                                newMainAddr = preAddr;
                            } else if (DEU_AddressTerm.isDirectional(prevmainAddr)) {
                                newMainAddr = preAddr;
                                searchParsedAddress.setPostDirectional(prevmainAddr);
                            } else {
                                newMainAddr = preAddr + prevmainAddr;
                            }
                            preAddr = null;
                        }
                    }
                    searchParsedAddress.setMainAddress(newMainAddr);
                    searchParsedAddress.setPreAddress(preAddr);
                    this.setParsedAddress((Address)new AddressImpl(searchParsedAddress));
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    this.m_resetParsedAddress = true;
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 11: {
                Address newPa;
                ++this.m_currentCase;
                if (!matchingPOBox && searchParsedAddress.getPostThoroughfareType() == null) {
                    AddressImpl ura = new AddressImpl(inputAddress);
                    StringBuffer newMainAddr = new StringBuffer();
                    if (searchParsedAddress.getPreAddress() != null) {
                        newMainAddr.append(searchParsedAddress.getPreAddress());
                        char lastch = newMainAddr.charAt(newMainAddr.length() - 1);
                        if (lastch != ' ' || lastch != '-') {
                            newMainAddr.append(' ');
                        }
                    }
                    newMainAddr.append(searchParsedAddress.getMainAddress());
                    if (searchParsedAddress.getPostAddress() != null) {
                        newMainAddr.append(searchParsedAddress.getPostAddress());
                    }
                    newMainAddr.append(". ");
                    if (searchParsedAddress.getAddressNumber() != null) {
                        newMainAddr.append(searchParsedAddress.getAddressNumber());
                    }
                    ura.setMainAddress(newMainAddr.toString());
                    newPa = null;
                    try {
                        newPa = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)ura, (IConstraints)deuConstraints)[0];
                    }
                    catch (ParserException e) {
                        newPa = null;
                    }
                    if (newPa != null && newPa.getPostThoroughfareType() != null) {
                        searchParsedAddress = newPa;
                        this.setParsedAddress(newPa);
                        this.shouldConsiderIgnoreSaclist(deuConstraints);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 12: {
                ++this.m_currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this.m_resetConstraints = true;
                    deuConstraints.setCustomObject("KEY_DEU_ALTERNATE_SOUNDEX_CODES", new Integer(10));
                    tryAgain = true;
                    Address spa = handler.getSearchParsedAddress();
                    if (spa.getPostCode1() != null && spa.getAreaName3() != null) {
                        deuConstraints.setCustomObject("KEY_GEOBASE_STRING_ONLY", "true");
                    }
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 13: {
                ++this.m_currentCase;
                if (!matchingPOBox && !exactStreet) {
                    this.m_resetConstraints = true;
                    int code = 16;
                    deuConstraints.setCustomObject("KEY_DEU_ALTERNATE_SOUNDEX_CODES", new Integer(code |= 4));
                    tryAgain = true;
                    Address spa = handler.getSearchParsedAddress();
                    if (spa.getPostCode1() != null && spa.getAreaName3() != null) {
                        deuConstraints.setCustomObject("KEY_GEOBASE_STRING_ONLY", "true");
                    }
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 14: {
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                String sacMustMatchGeoAndPostal = deuConstraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                if (sacMustMatchGeoAndPostal != null && sacMustMatchGeoAndPostal.equalsIgnoreCase("TRUE")) {
                    deuConstraints.removeCustomObject("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                }
                if (!matchingPOBox && searchParsedAddress.getPreAddress() != null && searchParsedAddress.getPreAddress().trim().length() != 0) {
                    String preAddr = searchParsedAddress.getPreAddress().trim();
                    int spacePos = preAddr.lastIndexOf(32);
                    String newMainAddr = null;
                    if (spacePos > -1) {
                        newMainAddr = preAddr.substring(spacePos + 1);
                        preAddr = preAddr.substring(0, spacePos + 1);
                    } else {
                        newMainAddr = preAddr;
                        preAddr = null;
                    }
                    if (newMainAddr != null || newMainAddr.trim().length() > 0) {
                        String newPostAddr = searchParsedAddress.getPostAddress();
                        newPostAddr = searchParsedAddress.getMainAddress() + ' ' + (newPostAddr == null ? "" : newPostAddr.trim());
                        searchParsedAddress.setPreAddress(preAddr);
                        searchParsedAddress.setMainAddress(newMainAddr);
                        searchParsedAddress.setPostAddress(newPostAddr);
                        this.setParsedAddress(searchParsedAddress);
                        this.shouldConsiderIgnoreSaclist(deuConstraints);
                        tryAgain = true;
                        this.m_resetParsedAddress = true;
                        deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                        break;
                    }
                }
            }
            case 15: {
                boolean parsed;
                AddressImpl newInput;
                String newMainAddress;
                int originalOffset;
                String originalMainAddress;
                String lastWord;
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                String mainAddress = searchParsedAddress.getMainAddress();
                if (!matchingPOBox && mainAddress != null && mainAddress.trim().length() != 0) {
                    int offset;
                    String preType = searchParsedAddress.getPreThoroughfareType();
                    String postType = searchParsedAddress.getPostThoroughfareType();
                    if (!(preType != null && preType.trim().length() != 0 || postType != null && postType.trim().length() != 0 || (offset = mainAddress.lastIndexOf(" ")) <= 0)) {
                        lastWord = mainAddress.substring(offset + 1);
                        originalMainAddress = inputAddress.getMainAddress();
                        originalOffset = originalMainAddress.lastIndexOf(lastWord);
                        if (originalOffset > 0) {
                            newMainAddress = originalMainAddress.substring(0, originalOffset - 1);
                            if (originalMainAddress.length() > originalOffset + lastWord.length()) {
                                newMainAddress = newMainAddress + " " + originalMainAddress.substring(originalOffset + (lastWord.length() + 1));
                            }
                            newInput = new AddressImpl(inputAddress);
                            String possibleHNR = null;
                            if (StringUtilities.isNumeric((String)lastWord) && searchParsedAddress.getAddressNumber() == null) {
                                possibleHNR = lastWord;
                                newInput.setAddressNumber(possibleHNR);
                                this.m_flag = true;
                                this.m_OrigScoringAddress = new AddressImpl(deuConstraints.getHandler().getParsedAddress());
                            }
                            newInput.setMainAddress(newMainAddress);
                            parsed = true;
                            try {
                                searchParsedAddress = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)newInput, (IConstraints)deuConstraints)[0];
                                if (this.m_flag) {
                                    deuConstraints.getHandler().setParsedAddress(searchParsedAddress);
                                }
                            }
                            catch (ParserException PEx) {
                                throw new ParserException(PEx.getErrorCode());
                            }
                            if (parsed) {
                                this.shouldConsiderIgnoreSaclist(deuConstraints);
                                tryAgain = true;
                                this.m_resetParsedAddress = true;
                                deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                }
            }
            case 16: {
                boolean parsed;
                AddressImpl newInput;
                String newMainAddress;
                int originalOffset;
                String originalMainAddress;
                String lastWord;
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                if (this.m_flag && this.m_OrigScoringAddress != null) {
                    deuConstraints.getHandler().setParsedAddress(this.m_OrigScoringAddress);
                    this.m_flag = false;
                }
                String mainAddress = searchParsedAddress.getMainAddress();
                if (!matchingPOBox && mainAddress != null && mainAddress.trim().length() != 0) {
                    int offset;
                    String preType = searchParsedAddress.getPreThoroughfareType();
                    String postType = searchParsedAddress.getPostThoroughfareType();
                    if (!(preType != null && preType.trim().length() != 0 || postType != null && postType.trim().length() != 0 || (offset = mainAddress.lastIndexOf(" ")) <= 0)) {
                        lastWord = mainAddress.substring(offset + 1);
                        originalMainAddress = inputAddress.getMainAddress();
                        originalOffset = originalMainAddress.lastIndexOf(lastWord);
                        if (originalOffset > 0) {
                            String newPostType;
                            newMainAddress = originalMainAddress.substring(0, originalOffset - 1);
                            if (originalMainAddress.length() > originalOffset + lastWord.length()) {
                                newMainAddress = newMainAddress + " " + originalMainAddress.substring(originalOffset + (lastWord.length() + 1));
                            }
                            newInput = new AddressImpl(inputAddress);
                            newInput.setMainAddress(newMainAddress);
                            Address newParsed = null;
                            parsed = true;
                            try {
                                newParsed = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)newInput, (IConstraints)deuConstraints)[0];
                            }
                            catch (ParserException PEx) {
                                throw new ParserException(PEx.getErrorCode());
                            }
                            if (parsed && (newPostType = newParsed.getPostThoroughfareType()) != null && newPostType.trim().length() != 0) {
                                newMainAddress = newParsed.getMainAddress() + DEU_ThoroughfareTypes.lookupProperName(newPostType) + " " + lastWord;
                                searchParsedAddress.setMainAddress(newMainAddress);
                                this.shouldConsiderIgnoreSaclist(deuConstraints);
                                tryAgain = true;
                                this.m_resetParsedAddress = true;
                                deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                }
            }
            case 17: {
                ++this.m_currentCase;
                if (!matchingPOBox && !exactStreet) {
                    deuConstraints.setCustomObject("KEY_GEOBASE_STRING_ONLY", "true");
                    this.m_resetConstraints = true;
                    deuConstraints.setCustomObject("KEY_DEU_ALTERNATE_SOUNDEX_CODES", new Integer(1));
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 18: {
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                if (!matchingPOBox && !exactStreet) {
                    String additionalField;
                    HashMap additinalFields;
                    String[] strArray;
                    Address newParsed;
                    Address searchedAddress = handler.getInputAddress();
                    String mainAddress = searchedAddress.getMainAddress();
                    String addressNumber = searchedAddress.getAddressNumber();
                    if (mainAddress != null) {
                        mainAddress = mainAddress + " 100";
                    }
                    AddressImpl newAddress = new AddressImpl(searchedAddress);
                    newAddress.setMainAddress(mainAddress);
                    if (addressNumber == null) {
                        newAddress.setAddressNumber((String)null);
                    }
                    try {
                        newParsed = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)newAddress, (IConstraints)deuConstraints)[0];
                    }
                    catch (ParserException PEx) {
                        throw new ParserException(PEx.getErrorCode());
                    }
                    String hnr = newParsed.getAddressNumber();
                    if ("100".equals(hnr)) {
                        newParsed.setAddressNumber((String)null);
                    } else if (hnr != null && (strArray = hnr.split("-")).length > 1) {
                        newParsed.setAddressNumber(strArray[0]);
                    }
                    HashMap hashMap = additinalFields = newParsed.getAdditionalFields() == null ? null : newParsed.getAdditionalFields();
                    if (additinalFields != null && (additionalField = (String)additinalFields.get("unparsed_input_street")) != null && additionalField.length() > 0) {
                        additinalFields.put("unparsed_input_street", additionalField.replace("100", ""));
                    }
                    this.setSearchParsedAddress(newParsed);
                    this.setParsedAddress(newParsed);
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    break;
                }
            }
            case 19: {
                Address address;
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                if (!matchingPOBox && !exactStreet) {
                    String sacMustMatchGeoAndPostal;
                    address = new AddressImpl(handler.getSearchParsedAddress());
                    String mainAddress = address.getMainAddress();
                    if (mainAddress != null && DEU_AddressTerm.isRomanNumber(mainAddress.split(" ")[0])) {
                        String str = mainAddress.split(" ")[0];
                        str = str.replace(')', ' ');
                        mainAddress = mainAddress.replaceFirst(str.split(" ")[0], String.valueOf(DEU_AddressTerm.convertRomanToLong(mainAddress.split(" ")[0])));
                    }
                    if ((sacMustMatchGeoAndPostal = deuConstraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL")) != null && address.getPostCode1() == null) {
                        deuConstraints.removeCustomObject("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    }
                    address.setMainAddress(mainAddress);
                    this.setSearchParsedAddress(address);
                    this.setParsedAddress(address);
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    this.shouldConsiderIgnoreSaclist(deuConstraints);
                    tryAgain = true;
                    break;
                }
            }
            case 20: {
                ++this.m_currentCase;
                if (!matchingPOBox && pa.getMainAddress() != null && pa.getMainAddress().length() == 1) {
                    deuConstraints.setCustomObject("KEY_GEOBASE_STRING_ONLY", "true");
                    this.m_resetConstraints = true;
                    deuConstraints.setCustomObject("KEY_DEU_ALTERNATE_SOUNDEX_CODES", new Integer(32));
                    tryAgain = true;
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    break;
                }
            }
            case 21: {
                Address newParsed;
                ++this.m_currentCase;
                deuConstraints.removeCustomObject("KEY_GEOBASE_STRING_ONLY");
                Address address = handler.getInputAddress();
                try {
                    newParsed = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse(address, (IConstraints)deuConstraints)[0];
                }
                catch (ParserException PEx) {
                    throw new ParserException(PEx.getErrorCode());
                }
                this.setSearchParsedAddress(newParsed);
                this.setParsedAddress(newParsed);
                String sacPostTownOnly = deuConstraints.getCustomString("KEY_GEOBASE_FOR_AREA3");
                if (sacPostTownOnly != null && sacPostTownOnly.equalsIgnoreCase("true")) {
                    deuConstraints.setCustomObject("KEY_GEOBASE_FOR_AREA4", "true");
                    deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    if (pa.getAreaName3() != null || pa.getAreaName4() != null) {
                        this.shouldConsiderIgnoreSaclist(deuConstraints);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 22: {
                Address newParsed;
                String additionalField;
                HashMap additinalFields;
                ++this.m_currentCase;
                if (matchingPOBox || exactStreet) break;
                AddressImpl newAddress = new AddressImpl(handler.getInputAddress());
                HashMap hashMap = additinalFields = searchParsedAddress.getAdditionalFields() == null ? null : searchParsedAddress.getAdditionalFields();
                if (additinalFields != null && (additionalField = (String)additinalFields.get("unparsed_input_street")) != null && additionalField.length() > 0) {
                    additionalField = additionalField.replaceAll("[\\.]{1,}\\b", "\\. ").replaceAll("([a-z]+)(\\d+)", "$1 $2").trim();
                    newAddress.setMainAddress(additionalField);
                }
                try {
                    newParsed = ((ICoreParseHandler)deuConstraints.getHandler()).getParser().parse((Address)newAddress, (IConstraints)deuConstraints)[0];
                }
                catch (ParserException PEx) {
                    throw new ParserException(PEx.getErrorCode());
                }
                this.setSearchParsedAddress(newParsed);
                this.setParsedAddress(newParsed);
                deuConstraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                this.shouldConsiderIgnoreSaclist(deuConstraints);
                tryAgain = true;
                break;
            }
        }
        if (this.m_resetParsedAddress) {
            this.setSearchParsedAddress(searchParsedAddress);
        }
        if (this.m_resetParsedAddress && debugLevel >= 1) {
            MMJLog.getLog().debug("\nCurrent Case: " + (this.m_currentCase - 1));
            MMJLog.getLog().debug("New Parsed Address:");
            MMJLog.getLog().debug(searchParsedAddress.toString());
        } else if (tryAgain && debugLevel >= 1) {
            MMJLog.getLog().debug("\nCurrent Case: " + (this.m_currentCase - 1));
        }
        return tryAgain;
    }

    private void shouldConsiderIgnoreSaclist(DEU_Constraints deuConstraints) {
        if (deuConstraints.isExactMatchMode() || deuConstraints.isMustMatchInput()) {
            this.updateIgnoredSacList(deuConstraints);
        }
    }

    private void updateIgnoredSacList(DEU_Constraints constraints) {
        Set<Integer> searchedSacs = constraints.getSearchedSacs();
        if (searchedSacs != null && searchedSacs.size() > 0) {
            Set<Integer> ignoredSacs = constraints.getIgnoredSacs();
            if (ignoredSacs == null) {
                constraints.setIgnoredSacs(searchedSacs);
            } else {
                ignoredSacs.addAll(searchedSacs);
            }
            constraints.setSearchedSacs(null);
        }
    }

    private void clearIgnoredSacList(DEU_Constraints constraints) {
        constraints.setSearchedSacs(null);
        constraints.setIgnoredSacs(null);
    }

    @Override
    public void combineCandidateLists(List savedCandidates, List newCandidates) {
        TreeSet candidates = new TreeSet();
        Iterator iter = newCandidates.iterator();
        while (iter.hasNext()) {
            InternalCandidateAddress cand = (InternalCandidateAddress)iter.next();
            if (!cand.isCloseMatch()) continue;
            savedCandidates.add(cand);
            iter.remove();
        }
        candidates.addAll(newCandidates);
        savedCandidates.addAll(candidates);
    }

    public void resetRetryCases(IConstraints constraints) {
        this.m_currentCase = 0;
    }
}

