/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp;

import com.mapinfo.mapmarker.DEU.dp.binary.DEU_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.dp.IEMEA_FlagDataSourceRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class DEU_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    protected DEU_GeoInfoFetcherImpl m_infoFetcher = null;

    public DEU_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex, boolean isAPDictioanry) {
        super(dataProperties, soundex);
        String geoInfoLoc = dataProperties.getProperty("geo2sac_geoinfoLoc");
        try {
            this.m_infoFetcher = new DEU_GeoInfoFetcherImpl(geoInfoLoc, null, null, isAPDictioanry);
        }
        catch (DataDictionaryIntializationException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            String town = input.getAreaName3();
            String shortTown = DEU_ParsePostAddressRule.removeCommonWords(town);
            if (shortTown == null) {
                shortTown = town;
            }
            ArrayList<EMEA_GeoBase> baseHolder = new ArrayList<EMEA_GeoBase>(4);
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(shortTown)));
            baseHolder.add(new EMEA_GeoBase(this.getStringKey(shortTown)));
            String firstName = this.getFirstName(shortTown);
            if (firstName != null && !firstName.equalsIgnoreCase(shortTown)) {
                baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(firstName)));
            }
            ArrayList altLangNames = (ArrayList)this.m_infoFetcher.getAltLangNames(town.toUpperCase());
            int size = altLangNames.size();
            for (int i = 0; i < size; ++i) {
                String altLangName = (String)altLangNames.get(i);
                StringTokenizer tokens = new StringTokenizer(altLangName, "/", false);
                while (tokens.hasMoreTokens()) {
                    String s = tokens.nextToken();
                    baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(s)));
                }
            }
            short flag = (short)((IEMEA_FlagDataSourceRecord)input).getFlag();
            int length = baseHolder.size();
            for (int i = 0; i < length; ++i) {
                ((EMEA_GeoBase)baseHolder.get(i)).setFlag(flag);
            }
            IGeoBase[] bases = baseHolder.toArray(new EMEA_GeoBase[0]);
            return bases;
        }
        return null;
    }

    private MiSoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    private String getFirstName(String name) {
        String result = null;
        StringTokenizer st = new StringTokenizer(name, " /-");
        if (st.countTokens() != 1) {
            result = st.nextToken();
        }
        return result;
    }
}

