/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.dp.ud.tab.DEU_TabUDDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.AlternateSearchTypeKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.IDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataWriter;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJPost2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJPostInfoItem;
import com.mapinfo.mapmarker.common.dp.binary.PostInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataFileStatistics;
import com.mapinfo.mapmarker.common.dp.binary.StreetDataGroup;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexSingleValue;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexValue;
import com.mapinfo.mapmarker.common.dp.binary.index.StreetDataIndexValue;
import com.mapinfo.mapmarker.common.dp.index.spatial.binary.SpatialIndexValue;
import com.mapinfo.mapmarker.utils.NIOOutputStream;
import com.mapinfo.mapmarker.utils.RandomAccessNIOOutputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DEU_MMJDataWriter
extends MMJDataWriter {
    private IDataProvider m_provider;
    private RandomAccessNIOOutputStream m_streetDataFile;
    private RandomAccessNIOOutputStream m_streetIndexFile;
    private RandomAccessNIOOutputStream m_streetBrowseIndexFile;
    private RandomAccessNIOOutputStream m_sac2fnFile;
    private RandomAccessNIOOutputStream m_geo2SacFile;
    private RandomAccessNIOOutputStream m_post2SacFile;
    private RandomAccessNIOOutputStream m_postInfoDataFile;
    private RandomAccessNIOOutputStream m_postInfoIndexFile;
    private RandomAccessNIOOutputStream m_geoInfoDataFile;
    private RandomAccessNIOOutputStream m_geoInfoIndexFile;
    private NIOOutputStream m_streetSpatialIndexFile;

    public DEU_MMJDataWriter(IDataProvider provider) {
        super(provider);
        this.m_provider = provider;
        this.m_streetDataFile = null;
        this.m_streetIndexFile = null;
        this.m_streetBrowseIndexFile = null;
        this.m_sac2fnFile = null;
        this.m_geo2SacFile = null;
        this.m_post2SacFile = null;
        this.m_postInfoDataFile = null;
        this.m_postInfoIndexFile = null;
        this.m_geoInfoDataFile = null;
        this.m_geoInfoIndexFile = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processStreets(String streetFileBaseName) throws DataCreationException {
        try {
            this.m_provider.preProcessStreetDataSet();
            Object key = null;
            int sac = -1;
            boolean bFirst = true;
            StreetDataFileStatistics stats = StreetDataFileStatistics.getStreetFileStatisticsObject();
            MMJComplexDataFileMetadata metadata = this.m_provider.getStreetMetadata();
            LinkedList<AlternateDataItem> alternateDataItems = new LinkedList<AlternateDataItem>();
            StreetDataGroup group = this.m_provider.getNextStreetGroup();
            while (group != null) {
                if (bFirst) {
                    bFirst = false;
                    this.createIndexFile(streetFileBaseName);
                    this.createStreetBrowseIndexFile(streetFileBaseName);
                    this.createSac2FnFile(streetFileBaseName);
                    this.createStreetFile(streetFileBaseName, metadata);
                    this.createStreetSpatialIndexFile(streetFileBaseName);
                    stats.incrementSacCount();
                    stats.incrementSacSoundexCount();
                    try {
                        this.writeIndexEntry(group.getKey(), this.m_streetDataFile.getFilePointer());
                    }
                    catch (IOException e) {
                        throw new DataCreationException(200, (Throwable)e);
                    }
                    this.writeSac2FnEntry(group.getSac(), streetFileBaseName);
                    sac = group.getSac();
                    key = group.getKey();
                } else if (sac != group.getSac()) {
                    this.writeSac2FnEntry(group.getSac(), streetFileBaseName);
                    sac = group.getSac();
                    stats.incrementSacCount();
                    this.writeCurrentAlternates(alternateDataItems, this.m_streetDataFile);
                    try {
                        this.writeIndexEntry(group.getKey(), this.m_streetDataFile.getFilePointer());
                    }
                    catch (IOException e) {
                        throw new DataCreationException(200, (Throwable)e);
                    }
                    key = group.getKey();
                    stats.incrementSacSoundexCount();
                } else if (!key.equals(group.getKey())) {
                    try {
                        this.writeIndexEntry(group.getKey(), this.m_streetDataFile.getFilePointer());
                    }
                    catch (IOException e) {
                        throw new DataCreationException(200, (Throwable)e);
                    }
                    key = group.getKey();
                    stats.incrementSacSoundexCount();
                }
                IDataFileDataItem street = group.getNextStreet();
                int streetRecordCount = (int)group.getNumberOfStreet();
                int currentStreetRecordNumber = 0;
                StreetSegments[] segments = new StreetSegments[streetRecordCount];
                if (street != null) {
                    try {
                        this.m_streetDataFile.writeShort((int)group.getNumberOfStreet());
                    }
                    catch (IOException e) {
                        throw new DataCreationException(100, (Throwable)e);
                    }
                }
                while (street != null) {
                    try {
                        long streetOffset = this.m_streetDataFile.getFilePointer();
                        StreetSegments streetSegments = new StreetSegments();
                        streetSegments.addStreetSegments((ArrayList)((GenericStreet)street).getSegments());
                        street.write((DataOutput)this.m_streetDataFile, (MMJDataFileMetadata)metadata);
                        streetSegments.setStreetRecordSegmentOffset((int)this.m_streetDataFile.getFilePointer());
                        this.m_streetDataFile.writeInt(0);
                        List browseKeys = group.getNextStreetBrowseKeys();
                        this.writeStreetBrowseIndexEntries(browseKeys, streetOffset);
                        this.writeStreetSpatialIndexValues(group.getNextSpatialIndexValues(), streetOffset);
                        List streetAlternateItems = group.getNextAlternateDataItems();
                        for (AlternateDataItem alternateItem : streetAlternateItems) {
                            alternateItem.getAlternateDataRecord().setStreetOffset(streetOffset);
                            alternateDataItems.add(alternateItem);
                        }
                        segments[currentStreetRecordNumber] = streetSegments;
                        ++currentStreetRecordNumber;
                        street = group.getNextStreet();
                    }
                    catch (IOException e) {
                        throw new DataCreationException(100, (Throwable)e);
                    }
                    catch (MMJEDataCorruptedException e) {
                        throw new DataCreationException(100, (Throwable)e);
                    }
                }
                for (int i = 0; i < segments.length; ++i) {
                    try {
                        int segmentBlockOffset = (int)this.m_streetDataFile.getFilePointer();
                        ArrayList segmentList = segments[i].getSegments();
                        this.m_streetDataFile.writeShort(segmentList.size());
                        for (int j = 0; j < segmentList.size(); ++j) {
                            IDataFileDataItem segment = (IDataFileDataItem)segmentList.get(j);
                            segment.write((DataOutput)this.m_streetDataFile, (MMJDataFileMetadata)metadata);
                        }
                        int currentFilePosition = (int)this.m_streetDataFile.getFilePointer();
                        this.m_streetDataFile.seek((long)segments[i].getStreetRecordSegmentOffset());
                        this.m_streetDataFile.writeInt(segmentBlockOffset);
                        this.m_streetDataFile.seek((long)currentFilePosition);
                        continue;
                    }
                    catch (IOException e) {
                        throw new DataCreationException(100, (Throwable)e);
                    }
                    catch (MMJEDataCorruptedException e) {
                        throw new DataCreationException(100, "Unable to write segments for street.", (Throwable)e);
                    }
                }
                group = this.m_provider.getNextStreetGroup();
            }
            this.writeCurrentAlternates(alternateDataItems, this.m_streetDataFile);
        }
        finally {
            try {
                this.closeStreetFiles();
            }
            catch (IOException IOEx) {
                DataCreationLogger.getLogger().logError("Error closing data files.");
                DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)IOEx);
            }
        }
        DataCreationLogger.getLogger().logStatus("\n\nFinished creating street files.");
    }

    private void closeStreetFiles() throws IOException, DataCreationException {
        if (this.m_streetIndexFile != null) {
            this.m_streetIndexFile.close();
        }
        if (this.m_streetBrowseIndexFile != null) {
            this.m_streetBrowseIndexFile.close();
        }
        if (this.m_streetDataFile != null) {
            Date today = new Date();
            this.m_streetDataFile.writeUTF(today.toString());
            this.m_streetDataFile.close();
        }
        if (this.m_sac2fnFile != null) {
            this.m_sac2fnFile.close();
        }
        this.m_provider.closeAllAternateIndexes();
        if (this.m_provider.supportsReverseGeocode() && this.m_streetSpatialIndexFile != null) {
            this.m_streetSpatialIndexFile.close();
        }
    }

    private void createIndexFile(String streetFileBaseName) throws DataCreationException {
        try {
            this.m_streetIndexFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getStreetFilePath(), (String)streetFileBaseName, (String)".tdx")));
        }
        catch (IOException e) {
            throw new DataCreationException(200, (Throwable)e);
        }
    }

    private void createStreetBrowseIndexFile(String streetFileBaseName) throws DataCreationException {
        try {
            this.m_streetBrowseIndexFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getStreetFilePath(), (String)streetFileBaseName, (String)".tbx")));
        }
        catch (IOException e) {
            throw new DataCreationException(200, (Throwable)e);
        }
    }

    private void createStreetFile(String streetFileBaseName, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            this.m_streetDataFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getStreetFilePath(), (String)streetFileBaseName, (String)".jdr")));
            metadata.write((DataOutput)this.m_streetDataFile);
        }
        catch (IOException e) {
            throw new DataCreationException(100, (Throwable)e);
        }
    }

    private void writeCurrentAlternates(List alternateDataItems, RandomAccessNIOOutputStream streetDataFile) throws DataCreationException {
        Collections.sort(alternateDataItems);
        Iterator alternateSearchIterator = alternateDataItems.iterator();
        while (alternateSearchIterator.hasNext()) {
            try {
                long alternateOffset = streetDataFile.getFilePointer();
                AlternateDataItem item = (AlternateDataItem)alternateSearchIterator.next();
                AlternateDataRecord record = item.getAlternateDataRecord();
                record.write((DataOutput)streetDataFile);
                this.writeAlternateSearchDataIndexEntry(new AlternateSearchTypeKey(item.getAlternateSearchType(), item.getSearchKey()), alternateOffset);
                this.writeAlternateBrowseDataIndexEntry(new AlternateSearchTypeKey(item.getAlternateSearchType(), item.getBrowseKey()), alternateOffset);
            }
            catch (IOException e) {
                throw new DataCreationException(100, (Throwable)e);
            }
        }
        alternateDataItems.clear();
    }

    private void writeAlternateBrowseDataIndexEntry(AlternateSearchTypeKey key, long offset) throws DataCreationException {
        if (key.getSearchKey() == null) {
            return;
        }
        MapMarkerIndexSingleValue value = new MapMarkerIndexSingleValue(offset);
        RandomAccessFile temporaryIndexFile = this.m_provider.getAlternateBrowseIndexFile(key.getSearchType());
        if (temporaryIndexFile != null) {
            try {
                key.getSearchKey().write((DataOutput)temporaryIndexFile);
                value.write((DataOutput)temporaryIndexFile);
            }
            catch (IOException e) {
                throw new DataCreationException(200, (Throwable)e);
            }
        }
    }

    private void writeAlternateSearchDataIndexEntry(AlternateSearchTypeKey key, long offset) throws DataCreationException {
        if (key.getSearchKey() == null) {
            return;
        }
        MapMarkerIndexSingleValue value = new MapMarkerIndexSingleValue(offset);
        RandomAccessFile temporaryIndexFile = this.m_provider.getAlternateSearchIndexFile(key.getSearchType());
        if (temporaryIndexFile != null) {
            try {
                key.getSearchKey().write((DataOutput)temporaryIndexFile);
                value.write((DataOutput)temporaryIndexFile);
            }
            catch (IOException e) {
                throw new DataCreationException(200, (Throwable)e);
            }
        }
    }

    private void createSac2FnFile(String streetFileBaseName) throws DataCreationException {
        String sac2FnFilename = this.m_provider.forUserDictionary() ? (((DEU_TabUDDataProvider)this.m_provider).isAPDataProvider() ? "sac2fn_ud_ap.mmj" : "sac2fn_ud.mmj") : streetFileBaseName + "_" + "sac2fn.mmj";
        try {
            this.m_sac2fnFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getStreetFilePath(), (String)sac2FnFilename)));
        }
        catch (IOException e) {
            throw new DataCreationException(-1, (Throwable)e);
        }
    }

    private void writeIndexEntry(MapMarkerIndexKey key, long offset) throws DataCreationException {
        StreetDataIndexValue value = new StreetDataIndexValue(offset);
        try {
            key.write((DataOutput)this.m_streetIndexFile);
            value.write((DataOutput)this.m_streetIndexFile);
        }
        catch (IOException e) {
            throw new DataCreationException(200, (Throwable)e);
        }
    }

    private void writeStreetBrowseIndexEntries(List keys, long offset) throws DataCreationException {
        MapMarkerIndexSingleValue value = new MapMarkerIndexSingleValue(offset);
        if (keys != null) {
            for (MapMarkerIndexKey key : keys) {
                try {
                    key.write((DataOutput)this.m_streetBrowseIndexFile);
                    value.write((DataOutput)this.m_streetBrowseIndexFile);
                }
                catch (IOException e) {
                    throw new DataCreationException(200, (Throwable)e);
                }
            }
        }
    }

    private void writeSac2FnEntry(int sac, String fn) throws DataCreationException {
        try {
            this.m_sac2fnFile.writeInt(sac);
            this.m_sac2fnFile.writeUTF(fn);
        }
        catch (IOException e) {
            throw new DataCreationException(-1, (Throwable)e);
        }
    }

    public void createGeo2SacFile() throws DataCreationException {
        try {
            this.m_geo2SacFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getGeo2SacFilePath(), (String)"geo2sac.mmj")));
        }
        catch (IOException e) {
            throw new DataCreationException(700, (Throwable)e);
        }
    }

    public void createPost2SacFile() throws DataCreationException {
        try {
            this.m_post2SacFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getPost2SacFilePath(), (String)"post2sac.mmj")));
        }
        catch (IOException e) {
            throw new DataCreationException(800, (Throwable)e);
        }
    }

    public void processPost2Sac() throws DataCreationException {
        this.m_provider.preProcessPost2SacDataSet();
        this.createPost2SacFile();
        SacMetadata metadata = this.m_provider.getPost2SacMetadata();
        try {
            metadata.write((DataOutput)this.m_post2SacFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write metadata to post2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(800, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataCreationException(800, (Throwable)e);
        }
        int sacCount = 0;
        MMJPost2SacRecord record = this.m_provider.getNextPost2SacRecord();
        while (record != null) {
            ++sacCount;
            try {
                record.write((DataOutput)this.m_post2SacFile);
            }
            catch (IOException e) {
                DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write to post2sac file.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataCreationException(800, (Throwable)e);
            }
            catch (MMJEDataCorruptedException e) {
                throw new DataCreationException(800, (Throwable)e);
            }
            record = this.m_provider.getNextPost2SacRecord();
        }
        metadata.updatedNumOfEntries(sacCount);
        try {
            this.m_post2SacFile.seek(0L);
            metadata.write((DataOutput)this.m_post2SacFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write updated metadata to post2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(800, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataCreationException(800, (Throwable)e);
        }
        try {
            this.m_post2SacFile.close();
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("ERROR: Unable to close post2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(800, (Throwable)e);
        }
    }

    public void processGeo2Sac() throws DataCreationException {
        this.m_provider.preProcessGeo2SacDataSet();
        this.createGeo2SacFile();
        SacMetadata metadata = this.m_provider.getGeo2SacMetadata();
        try {
            metadata.write((DataOutput)this.m_geo2SacFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write metadata to geo2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(700, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataCreationException(700, (Throwable)e);
        }
        int sacCount = 0;
        MMJGeo2SacRecord record = this.m_provider.getNextGeo2SacRecord();
        while (record != null) {
            ++sacCount;
            try {
                record.write((DataOutput)this.m_geo2SacFile);
            }
            catch (IOException e) {
                DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write to geo2sac file.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataCreationException(700, (Throwable)e);
            }
            catch (MMJEDataCorruptedException e) {
                throw new DataCreationException(700, (Throwable)e);
            }
            record = this.m_provider.getNextGeo2SacRecord();
        }
        metadata.updatedNumOfEntries(sacCount);
        try {
            this.m_geo2SacFile.seek(0L);
            metadata.write((DataOutput)this.m_geo2SacFile);
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("FATAL ERROR: Unable to write updated metadata to geo2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(700, (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataCreationException(700, (Throwable)e);
        }
        try {
            this.m_geo2SacFile.close();
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("ERROR: Unable to close post2sac file.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(700, (Throwable)e);
        }
    }

    public void processPostInfo(String postInfoFileBaseName) throws DataCreationException {
        this.m_provider.preProcessPostInfoDataSet();
        Object key = null;
        boolean bFirst = true;
        MMJPostInfoItem item = this.m_provider.getNextPostInfoItem();
        while (item != null) {
            if (bFirst) {
                bFirst = false;
                this.createPostInfoIndexFile(postInfoFileBaseName);
                this.createPostInfoDataFile(postInfoFileBaseName, this.m_provider.getPostInfoMetadata());
                try {
                    this.writePostInfoIndexEntry(item.getKey(), this.m_postInfoDataFile.getFilePointer());
                }
                catch (IOException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
                key = item.getKey();
            } else if (!key.equals(item.getKey())) {
                try {
                    this.writePostInfoIndexEntry(item.getKey(), this.m_postInfoDataFile.getFilePointer());
                }
                catch (IOException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
                key = item.getKey();
            }
            PostInfoDataItem record = item.getItem();
            if (record != null) {
                try {
                    record.write((DataOutput)this.m_postInfoDataFile, (MMJDataFileMetadata)this.m_provider.getPostInfoMetadata());
                }
                catch (IOException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
                catch (MMJEDataCorruptedException e) {
                    throw new DataCreationException(500, (Throwable)e);
                }
            }
            item = this.m_provider.getNextPostInfoItem();
        }
        try {
            if (this.m_postInfoIndexFile != null) {
                this.m_postInfoIndexFile.close();
            }
            if (this.m_postInfoDataFile != null) {
                this.m_postInfoDataFile.close();
            }
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("Error closing data files.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(500, (Throwable)e);
        }
    }

    public void processGeoInfo(String geoInfoFileBaseName) throws DataCreationException {
        this.m_provider.preProcessGeoInfoDataSet();
        MMJGeoInfoItem item = this.m_provider.getNextGeoInfoItem();
        this.createGeoInfoIndexFile(geoInfoFileBaseName);
        this.createGeoInfoDataFile(geoInfoFileBaseName, this.m_provider.getGeoInfoMetadata());
        while (item != null) {
            try {
                this.writeGeoInfoIndexEntry(item.getKey(), this.m_geoInfoDataFile.getFilePointer());
            }
            catch (IOException e) {
                throw new DataCreationException(300, (Throwable)e);
            }
            GeoInfoDataItem record = item.getItem();
            if (record != null) {
                try {
                    record.write((DataOutput)this.m_geoInfoDataFile, (MMJDataFileMetadata)this.m_provider.getGeoInfoMetadata());
                }
                catch (IOException e) {
                    throw new DataCreationException(300, (Throwable)e);
                }
                catch (MMJEDataCorruptedException e) {
                    throw new DataCreationException(300, (Throwable)e);
                }
            }
            item = this.m_provider.getNextGeoInfoItem();
        }
        try {
            this.m_geoInfoIndexFile.close();
            this.m_geoInfoDataFile.close();
        }
        catch (IOException e) {
            DataCreationLogger.getLogger().logError("Error closing data files.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(300, (Throwable)e);
        }
    }

    private void createPostInfoIndexFile(String postInfoFileBaseName) throws DataCreationException {
        try {
            this.m_postInfoIndexFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getPostInfoFilePath(), (String)postInfoFileBaseName, (String)".tdx")));
        }
        catch (IOException e) {
            throw new DataCreationException(600, (Throwable)e);
        }
    }

    private void createPostInfoDataFile(String postInfoFileBaseName, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            this.m_postInfoDataFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getPostInfoFilePath(), (String)postInfoFileBaseName, (String)".jdr")));
            metadata.write((DataOutput)this.m_postInfoDataFile);
        }
        catch (IOException e) {
            throw new DataCreationException(500, (Throwable)e);
        }
    }

    private void writePostInfoIndexEntry(MapMarkerIndexKey key, long offset) throws DataCreationException {
        PostInfoIndexValue value = new PostInfoIndexValue(offset);
        try {
            key.write((DataOutput)this.m_postInfoIndexFile);
            value.write((DataOutput)this.m_postInfoIndexFile);
        }
        catch (IOException e) {
            throw new DataCreationException(600, (Throwable)e);
        }
    }

    private void createGeoInfoIndexFile(String geoInfoFileBaseName) throws DataCreationException {
        try {
            this.m_geoInfoIndexFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getGeoInfoFilePath(), (String)geoInfoFileBaseName, (String)".tdx")));
        }
        catch (IOException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
    }

    private void createGeoInfoDataFile(String geoInfoFileBaseName, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            this.m_geoInfoDataFile = new RandomAccessNIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getGeoInfoFilePath(), (String)geoInfoFileBaseName, (String)".jdr")));
            metadata.write((DataOutput)this.m_geoInfoDataFile);
        }
        catch (IOException e) {
            throw new DataCreationException(300, (Throwable)e);
        }
    }

    private void writeGeoInfoIndexEntry(MapMarkerIndexKey key, long offset) throws DataCreationException {
        MapMarkerIndexSingleValue value = new MapMarkerIndexSingleValue(offset);
        try {
            key.write((DataOutput)this.m_geoInfoIndexFile);
            value.write((DataOutput)this.m_geoInfoIndexFile);
        }
        catch (IOException e) {
            throw new DataCreationException(400, (Throwable)e);
        }
    }

    private void createStreetSpatialIndexFile(String streetFileBaseName) throws DataCreationException {
        if (this.m_provider.supportsReverseGeocode()) {
            try {
                this.m_streetSpatialIndexFile = new NIOOutputStream(new File(StringUtilities.appendToPath((String)this.m_provider.getStreetFilePath(), (String)streetFileBaseName, (String)".tsx")));
            }
            catch (IOException IOEx) {
                throw new DataCreationException(200, (Throwable)IOEx);
            }
        }
    }

    private void writeStreetSpatialIndexValues(List<SpatialIndexValue> values, long offset) throws DataCreationException {
        if (this.m_provider.supportsReverseGeocode()) {
            for (SpatialIndexValue value : values) {
                value.setStreetOffset(offset);
                try {
                    value.write((DataOutput)this.m_streetSpatialIndexFile);
                }
                catch (IOException IOEx) {
                    throw new DataCreationException(200, (Throwable)IOEx);
                }
            }
        }
    }

    private class StreetSegments {
        private ArrayList m_segments = null;
        private int m_streetRecordSegmentOffset = 0;

        private StreetSegments() {
        }

        private void addStreetSegments(ArrayList segments) {
            this.m_segments = segments;
        }

        private ArrayList getSegments() {
            return this.m_segments;
        }

        private void setStreetRecordSegmentOffset(int streetRecordSegmentOffset) {
            this.m_streetRecordSegmentOffset = streetRecordSegmentOffset;
        }

        private int getStreetRecordSegmentOffset() {
            return this.m_streetRecordSegmentOffset;
        }
    }
}

