/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.dp.DEU_GeoinfoDependentHandler;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParseMainAddressRule;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_StreetBuilder;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericSegment;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MultiSegmentStreet;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexMultiValue;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.IOException;
import java.util.List;
import java.util.Properties;

public class DEU_StreetBuilder
extends EMEA_StreetBuilder {
    private DEU_GeoinfoDependentHandler m_geoinfoHandler;
    private boolean m_isAPDictionary;

    public DEU_StreetBuilder(Properties datacreationProperties, boolean isAPDictioanry) {
        this.m_isAPDictionary = isAPDictioanry;
        this.m_geoinfoHandler = new DEU_GeoinfoDependentHandler(datacreationProperties);
    }

    public IDataFileDataItem buildStreetFromRecord(MultiSegmentStreet record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericStreet street = (GenericStreet)super.buildStreetFromRecord(record, metadata);
        Address address = record.getAddress();
        if (address.hasAdditionalFields()) {
            try {
                String commanterm;
                String postSeperator;
                String preSeperator = (String)address.getAdditionalFields().get(DEU_ParseMainAddressRule.PRE_SEPARATOR_CHAR);
                if (preSeperator != null && preSeperator.length() == 1) {
                    street.putChar(32, preSeperator.charAt(0));
                }
                if ((postSeperator = (String)address.getAdditionalFields().get(DEU_ParseMainAddressRule.POST_SEPARATOR_CHAR)) != null && postSeperator.length() == 1) {
                    street.putChar(33, postSeperator.charAt(0));
                }
                if ((commanterm = (String)address.getAdditionalFields().get("input_street_commonterm")) != null) {
                    street.putString(34, commanterm);
                }
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("Unable to add to the street.");
                DataCreationLogger.getLogger().logInternalError("Attempting to add: " + address.toString());
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                System.exit(1);
            }
        }
        return street;
    }

    public IDataFileDataItem buildGeoInfoFromRecord(GeoInfoRecord record, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GeoInfoDataItem item = (GeoInfoDataItem)super.buildGeoInfoFromRecord(record, metadata);
        try {
            String postcode = ((EMEA_GeoInfoRecord)record).getPostCode();
            if (postcode != null) {
                item.putString(33, postcode);
            }
        }
        catch (MMJETypeArraySizeExceededException MMJETASEEx) {
            DataCreationLogger.getLogger().logInternalError("ERROR: Unable to set the code in the DEU_GeoInfoRecord.");
            DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
            System.exit(1);
        }
        return item;
    }

    @Override
    protected IDataFileDataItem buildSegmentFromRecord(MMJSegmentRecord segmentRecord, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        GenericSegment segment;
        block47: {
            segment = (GenericSegment)this.getSegmentDataObject();
            try {
                String segmentId;
                int postVal;
                String leftPostalCode1 = segmentRecord.getLeftPostalCode1();
                String rightPostalCode1 = segmentRecord.getRightPostalCode1();
                if (leftPostalCode1 != null && rightPostalCode1 != null && leftPostalCode1.equals(rightPostalCode1)) {
                    if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                        postVal = Integer.parseInt(leftPostalCode1);
                        if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                            segment.putShort(32, (short)postVal);
                        } else {
                            segment.putInt(32, postVal);
                        }
                    } else {
                        segment.putString(12, leftPostalCode1);
                    }
                } else {
                    if (leftPostalCode1 != null) {
                        if (StringUtilities.isNumeric((String)leftPostalCode1)) {
                            postVal = Integer.parseInt(leftPostalCode1);
                            if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                                segment.putShort(33, (short)postVal);
                            } else {
                                segment.putInt(33, postVal);
                            }
                        } else {
                            segment.putString(0, leftPostalCode1);
                        }
                    }
                    if (rightPostalCode1 != null) {
                        if (StringUtilities.isNumeric((String)rightPostalCode1)) {
                            postVal = Integer.parseInt(rightPostalCode1);
                            if (postVal < Short.MAX_VALUE && postVal > Short.MIN_VALUE) {
                                segment.putShort(34, (short)postVal);
                            } else {
                                segment.putInt(34, postVal);
                            }
                        } else {
                            segment.putString(1, rightPostalCode1);
                        }
                    }
                }
                String leftAreaName1 = segmentRecord.getLeftAreaName1();
                String rightAreaName1 = segmentRecord.getRightAreaName1();
                if (leftAreaName1 != null && rightAreaName1 != null && leftAreaName1.equals(rightAreaName1)) {
                    segment.putString(14, leftAreaName1);
                } else {
                    if (leftAreaName1 != null) {
                        segment.putString(4, leftAreaName1);
                    }
                    if (rightAreaName1 != null) {
                        segment.putString(5, rightAreaName1);
                    }
                }
                String leftAreaName2 = segmentRecord.getLeftAreaName2();
                String rightAreaName2 = segmentRecord.getRightAreaName2();
                if (leftAreaName2 != null && rightAreaName2 != null && leftAreaName2.equals(rightAreaName2)) {
                    segment.putString(15, leftAreaName2);
                } else {
                    if (leftAreaName2 != null) {
                        segment.putString(6, leftAreaName2);
                    }
                    if (rightAreaName2 != null) {
                        segment.putString(7, rightAreaName2);
                    }
                }
                String leftAreaName4 = segmentRecord.getLeftAreaName4();
                String rightAreaName4 = segmentRecord.getRightAreaName4();
                if (leftAreaName4 != null && rightAreaName4 != null && leftAreaName4.equals(rightAreaName4)) {
                    segment.putString(17, leftAreaName4);
                } else {
                    if (leftAreaName4 != null) {
                        segment.putString(10, leftAreaName4);
                    }
                    if (rightAreaName4 != null) {
                        segment.putString(11, rightAreaName4);
                    }
                }
                String leftAreaName3 = segmentRecord.getLeftAreaName3();
                String rightAreaName3 = segmentRecord.getRightAreaName3();
                if (leftAreaName3 != null && rightAreaName3 != null) {
                    if (this.m_geoIndex != null) {
                        if (leftAreaName3.equalsIgnoreCase(rightAreaName3) && this.isLeftRightPostalCode1Same(leftPostalCode1, rightPostalCode1)) {
                            this.handleGeoInfoOffsetAndGenericAn3(segment, leftAreaName1, leftAreaName2, leftAreaName3, leftAreaName4, leftPostalCode1, SideType.BOTH_SIDE, metadata);
                        } else {
                            if (leftAreaName3 != null) {
                                segment.putString(8, leftAreaName3);
                            }
                            if (rightAreaName3 != null) {
                                segment.putString(9, rightAreaName3);
                            }
                        }
                    }
                } else {
                    if (leftAreaName3 != null && this.m_geoIndex != null) {
                        this.handleGeoInfoOffsetAndGenericAn3(segment, leftAreaName1, leftAreaName2, leftAreaName3, leftAreaName4, leftPostalCode1, SideType.LEFT_SIDE, metadata);
                    }
                    if (rightAreaName3 != null && this.m_geoIndex != null) {
                        this.handleGeoInfoOffsetAndGenericAn3(segment, rightAreaName1, rightAreaName2, rightAreaName3, rightAreaName4, rightPostalCode1, SideType.RIGHT_SIDE, metadata);
                    }
                }
                if (((DEU_MMJComplexDataFileMetadata)metadata).isUserDictionary() && this.m_geoIndex == null) {
                    if (!StringUtilities.isEmpty((String)leftAreaName3)) {
                        segment.putString(8, leftAreaName3);
                    }
                    if (!StringUtilities.isEmpty((String)rightAreaName3)) {
                        segment.putString(9, rightAreaName3);
                    }
                }
                if ((segmentId = segmentRecord.getId()) == null) break block47;
                boolean storeSegmentIdAsLong = false;
                try {
                    segment.putLong(3, Long.parseLong(segmentId));
                    storeSegmentIdAsLong = true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (!storeSegmentIdAsLong) {
                    segment.putString(19, segmentId);
                }
            }
            catch (MMJETypeArraySizeExceededException e) {
                DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
                DataCreationLogger.getLogger().logInternalError(e.getMessage());
                DataCreationLogger.getLogger().logStackTrace((Throwable)e);
                throw new DataCreationException(106, (Throwable)e);
            }
        }
        this.storeSegmentPoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        this.storeHousePoints(segmentRecord, (IDataFileDataItem)segment, (MMJDataFileMetadata)metadata);
        MMJRangeRecord lastRange = null;
        List addressRanges = segmentRecord.getRanges();
        if (addressRanges != null) {
            for (MMJRangeRecord range : addressRanges) {
                this.compressRange(range, lastRange);
                lastRange = range;
                this.addRangeToSegment((IDataFileDataItem)segment, this.buildRangeFromRangeRecord(range, metadata));
                ++this.totalRanges;
            }
        }
        return segment;
    }

    private boolean isLeftRightPostalCode1Same(String left, String right) {
        if (DEU_AddressUtils.isEmpty(left)) {
            return DEU_AddressUtils.isEmpty(right);
        }
        if (DEU_AddressUtils.isEmpty(right)) {
            return false;
        }
        return left.equalsIgnoreCase(right);
    }

    private void handleGeoInfoOffsetAndGenericAn3(GenericSegment segment, String an1, String an2, String an3, String an4, String postalCode1, SideType sideType, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        try {
            String combinedKey = an4 == null ? "" : an4;
            combinedKey = combinedKey + (an3 == null ? "" : an3);
            combinedKey = combinedKey + (an2 == null ? "" : an2);
            combinedKey = combinedKey + (an1 == null ? "" : an1);
            MiStringIndexKey key = new MiStringIndexKey(combinedKey.toUpperCase());
            MapMarkerIndexMultiValue val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
            if (val == null) {
                key = new MiStringIndexKey(EMEA_GeoInfoAliasKeyCreator.createKey(an3, postalCode1 == null ? "" : postalCode1));
                val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                if (val == null) {
                    key = new MiStringIndexKey(an3.toUpperCase());
                    val = (MapMarkerIndexMultiValue)this.m_geoIndex.search((MapMarkerIndexKey)key);
                }
                if (val == null) {
                    DataCreationLogger.getLogger().logInternalError("\n\nUnable to locate a geoinfo record for: " + an3);
                    DataCreationLogger.getLogger().logInternalError("Address Info: " + segment.toString());
                    DataCreationLogger.getLogger().logInternalError("In postalCode1: " + postalCode1);
                }
            }
            if (val != null && !((DEU_MMJComplexDataFileMetadata)metadata).isUserDictionary()) {
                short geoinfoOffsetIndex = this.getProperGeoinfoOffsetIndex(val, an4, an3, an2, an1);
                long geoOffset = val.getOffsetAt(geoinfoOffsetIndex);
                if (geoOffset > 0L) {
                    segment.putLong(0, geoOffset);
                }
            } else if (sideType == SideType.BOTH_SIDE) {
                segment.putString(8, an3);
                segment.putString(9, an3);
            } else if (sideType == SideType.LEFT_SIDE) {
                segment.putString(8, an3);
            } else if (sideType == SideType.RIGHT_SIDE) {
                segment.putString(9, an3);
            }
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate segment data.");
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(106, (Throwable)e);
        }
        catch (IOException IOEx) {
            DataCreationLogger.getLogger().logInternalError("Problem building generic segment.  Unable to lookup areaName in geoinfo.");
            DataCreationLogger.getLogger().logInternalError(IOEx.getMessage());
            System.exit(1);
        }
    }

    @Override
    public void setGeoInfoBaseName(String geoInfoFileBaseName) {
        try {
            this.m_geoinfoHandler.loadGeoinfoFetcher(this.m_isAPDictionary);
            if (this.m_geoinfoHandler.isGeoinfoFetcherInitialized()) {
                this.m_geoIndex = this.m_geoinfoHandler.getGeoinfoIndexFileHandle();
            }
        }
        catch (DataDictionaryIntializationException e) {
            DataCreationLogger.getLogger().logInternalError(e.getCause().getMessage());
            System.exit(1);
        }
    }

    private short getProperGeoinfoOffsetIndex(MapMarkerIndexMultiValue multiIndexValue, String ... areanmes) {
        short offsetCount = multiIndexValue.getValueCount();
        if (offsetCount > 1) {
            GeoInfoRecord geoinfoRecord = null;
            for (short i = 0; i < offsetCount; i = (short)(i + 1)) {
                geoinfoRecord = this.m_geoinfoHandler.getgeoinfoFetcherHandle().getGeoInfoRecord(multiIndexValue.getOffsetAt(i));
                if (!this.doesgeoInfoRecordPerfectlyMatches(geoinfoRecord, areanmes)) continue;
                return i;
            }
        }
        return 0;
    }

    private boolean doesgeoInfoRecordPerfectlyMatches(GeoInfoRecord record, String ... areanames) {
        return DEUGermanSoundex.getStringKeyForDataChecck(record.getAreaName3()).equals(DEUGermanSoundex.getStringKeyForDataChecck(areanames[1])) && DEUGermanSoundex.getStringKeyForDataChecck(record.getAreaName2()).equals(DEUGermanSoundex.getStringKeyForDataChecck(areanames[2])) && DEUGermanSoundex.getStringKeyForDataChecck(record.getAreaName1()).equals(DEUGermanSoundex.getStringKeyForDataChecck(areanames[3]));
    }

    private static final class SideType {
        private static final SideType LEFT_SIDE = new SideType("left");
        private static final SideType RIGHT_SIDE = new SideType("right");
        private static final SideType BOTH_SIDE = new SideType("both");
        private String m_name;

        private SideType(String typeName) {
            this.m_name = typeName;
        }

        public String toString() {
            return this.m_name;
        }
    }
}

