/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.binary.index;

import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.dp.binary.index.EMEA_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class DEU_GeoInfoSoundexIndexer
extends EMEA_GeoInfoSoundexIndexer {
    public DEU_GeoInfoSoundexIndexer() {
        this.sndx = new DEUGermanSoundex();
    }

    protected ArrayList makeKeys(GeoInfoDataItem item, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        return this.makeKeys(item);
    }

    protected ArrayList makeKeys(GeoInfoDataItem item) {
        ArrayList<ISoundexKey> list = new ArrayList<ISoundexKey>();
        if (item != null) {
            String areaName3 = DEU_ParsePostAddressRule.removeCommonWords(this.getAreaName3(item));
            String altAreaName3 = DEU_ParsePostAddressRule.removeCommonWords(this.getAltLanguageNames(item));
            String altAreaName4 = DEU_ParsePostAddressRule.removeCommonWords(this.getAltAreaName4(item));
            String areaName4 = DEU_ParsePostAddressRule.removeCommonWords(this.getAreaName4(item));
            ISoundexKey sndxKey = null;
            byte precision = this.getPrecision(item);
            if (precision == 11) {
                if (areaName4 != null && areaName4.length() > 0 && !list.contains(sndxKey = this.sndx.getSoundex(areaName4))) {
                    list.add(sndxKey);
                }
                if (altAreaName4 != null && altAreaName4.length() > 0) {
                    StringTokenizer st = new StringTokenizer(altAreaName4, "/");
                    while (st.hasMoreTokens()) {
                        String altArea = st.nextToken().trim();
                        sndxKey = this.sndx.getSoundex(altArea);
                        if (list.contains(sndxKey)) continue;
                        list.add(sndxKey);
                    }
                }
            } else {
                if (areaName3 != null && areaName3.length() > 0) {
                    String firstWord;
                    list.add(this.sndx.getSoundex(areaName3));
                    int spacePos = areaName3.indexOf(32);
                    if (spacePos > -1 && !list.contains(sndxKey = this.sndx.getSoundex(firstWord = areaName3.substring(0, spacePos)))) {
                        list.add(sndxKey);
                    }
                }
                if (altAreaName3 != null && altAreaName3.length() > 0) {
                    StringTokenizer st = new StringTokenizer(altAreaName3, "/");
                    while (st.hasMoreTokens()) {
                        String altArea = st.nextToken().trim();
                        sndxKey = this.sndx.getSoundex(altArea);
                        if (list.contains(sndxKey)) continue;
                        list.add(sndxKey);
                    }
                }
            }
        }
        if (list.isEmpty()) {
            return null;
        }
        return list;
    }

    private String getAltAreaName4(GeoInfoDataItem item) {
        String ret = null;
        if (item != null && item.hasString(7)) {
            try {
                ret = item.getString(7);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("ERROR: unable to get alt areaName3 from geoInfo item.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                System.exit(1);
            }
        }
        return this.cleanAreaNameString(ret);
    }

    private byte getPrecision(GeoInfoDataItem item) {
        byte ret = 0;
        if (item != null && item.hasByte(0)) {
            try {
                ret = item.getByte(0);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("ERROR: unable to get the precesion from the geoinfo item.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                System.exit(1);
            }
        }
        return ret;
    }

    private String getAreaName4(GeoInfoDataItem item) {
        String ret = null;
        if (item != null && item.hasString(3)) {
            try {
                ret = item.getString(3);
            }
            catch (MMJETypeArraySizeExceededException MMJETASEEx) {
                DataCreationLogger.getLogger().logInternalError("ERROR: unable to get areaName4 from geoInfo item.");
                DataCreationLogger.getLogger().logInternalError(MMJETASEEx.getMessage());
                System.exit(1);
            }
        }
        return this.cleanAreaNameString(ret);
    }

    private String cleanAreaNameString(String areaName) {
        if (areaName == null || areaName.length() == 0) {
            return null;
        }
        int pos = areaName.indexOf(40);
        if (pos > 0) {
            String newAreaName = areaName.substring(0, pos).trim();
            return newAreaName;
        }
        return areaName;
    }

    public static final void main(String[] args) throws DataCreationException {
        if (args == null || args.length < 1) {
            DataCreationLogger.getLogger().logInternalError("DEU_GeoInfoSoundexIndexer <geoinfo data file>");
        }
        DEU_GeoInfoSoundexIndexer indexer = new DEU_GeoInfoSoundexIndexer();
        String geoInfoFileName = args[0];
        int extensionStart = geoInfoFileName.indexOf(".");
        if (extensionStart > 0) {
            geoInfoFileName = geoInfoFileName.substring(0, extensionStart);
        }
        indexer.processGeoInfoFile(geoInfoFileName);
    }
}

