/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.dp.ud;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.DEU.DEUGermanSoundex;
import com.mapinfo.mapmarker.DEU.DEU_AddressUtils;
import com.mapinfo.mapmarker.DEU.DEU_InternalCandidateAddress;
import com.mapinfo.mapmarker.DEU.DEU_InternalGeographicCandidate;
import com.mapinfo.mapmarker.DEU.DEU_ScoringHelper;
import com.mapinfo.mapmarker.DEU.dp.binary.DEU_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.DEU.dp.binary.ap.DEU_MMJAPRangeRecord;
import com.mapinfo.mapmarker.DEU.parser.DEU_ParsePostAddressRule;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.EMEA.dp.ud.EMEA_UDStreetDataSourceRecordConvertor;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IIntermediateDataRecord;
import com.mapinfo.mapmarker.common.dp.IRangeDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.ISegmentDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IStreetDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IUDNonStreetDataHandler;
import com.mapinfo.mapmarker.common.dp.UDGeo2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.UDPost2SacDataHandler;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataItem;
import com.mapinfo.mapmarker.common.dp.binary.AlternateDataRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.UserDictSacData;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexStreetDataIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.common.dp.tab.TabIntermediateRangeDataSourceRecordImpl;
import com.mapinfo.mapmarker.core.parser.IParser;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public class DEU_UDStreetDataSourceRecordConvertor
extends EMEA_UDStreetDataSourceRecordConvertor {
    public static final int ODD_EVEN_UNKNOWN = -1;
    private DEU_GeoInfoFetcherImpl m_geoInfoFetcher;
    private IUDNonStreetDataHandler m_geoInfoHandler;
    private boolean m_isAPDataRecord;

    public DEU_UDStreetDataSourceRecordConvertor(Properties dataProperties, UDPost2SacDataHandler post2SacHandler, UDGeo2SacDataHandler geo2SacHandler, Soundex soundex, CollationKeyGenerator generator, IParser parser, Constraints parserConstraints, IUDNonStreetDataHandler geoInfoHandler, boolean isAPDataRecord) throws DataCreationException {
        super(soundex, dataProperties, generator, parser, parserConstraints, post2SacHandler, geo2SacHandler);
        this.m_geoInfoHandler = geoInfoHandler;
        this.m_isAPDataRecord = isAPDataRecord;
        String dataSetPath = dataProperties.getProperty("dataSetPath");
    }

    public void close() {
        try {
            if (this.m_geoInfoFetcher != null) {
                this.m_geoInfoFetcher.close();
                this.m_geoInfoFetcher = null;
            }
        }
        catch (DataAccessException dataAccessException) {
            // empty catch block
        }
    }

    @Override
    protected MMJSegmentRecord convertSegmentRecord(ISegmentDataSourceRecord input, int sac, boolean convertLeft, boolean convertRight) throws DataSourceException {
        MMJSegmentRecord record = super.convertSegmentRecord(input, sac, convertLeft, convertRight);
        return record;
    }

    private boolean isLeftRightSameForAddingGeoInfoRecord(ISegmentDataSourceRecord input) throws DataSourceException {
        if (input.hasLeftAreaName1() ? (input.hasRightAreaName1() ? !this.compareString(input.getLeftAreaName1(), input.getRightAreaName1()) : !DEU_AddressUtils.isEmpty(input.getLeftAreaName1())) : input.hasRightAreaName1() && !DEU_AddressUtils.isEmpty(input.getRightAreaName1())) {
            return false;
        }
        if (input.hasLeftAreaName2() ? (input.hasRightAreaName2() ? !this.compareString(input.getLeftAreaName2(), input.getRightAreaName2()) : !DEU_AddressUtils.isEmpty(input.getLeftAreaName2())) : input.hasRightAreaName2() && !DEU_AddressUtils.isEmpty(input.getRightAreaName2())) {
            return false;
        }
        if (input.hasLeftAreaName3() ? (input.hasRightAreaName3() ? !this.compareString(input.getLeftAreaName3(), input.getRightAreaName3()) : !DEU_AddressUtils.isEmpty(input.getLeftAreaName3())) : input.hasRightAreaName3() && !DEU_AddressUtils.isEmpty(input.getRightAreaName3())) {
            return false;
        }
        if (input.hasLeftAreaName4() ? (input.hasRightAreaName4() ? !this.compareString(input.getLeftAreaName4(), input.getRightAreaName4()) : !DEU_AddressUtils.isEmpty(input.getLeftAreaName4())) : input.hasRightAreaName4() && !DEU_AddressUtils.isEmpty(input.getRightAreaName4())) {
            return false;
        }
        return !(input.hasLeftPostCode1() ? (input.hasRightPostCode1() ? !this.compareString(input.getLeftPostCode1(), input.getRightPostCode1()) : !DEU_AddressUtils.isEmpty(input.getLeftPostCode1())) : input.hasRightPostCode1() && !DEU_AddressUtils.isEmpty(input.getRightPostCode1()));
    }

    private EMEA_GeoInfoRecord lookupGeoInfoRecord(Address addr) throws DataSourceException {
        List possibles;
        if (addr == null) {
            return null;
        }
        if (DEU_AddressUtils.isEmpty(addr.getAreaName3())) {
            return null;
        }
        try {
            int listSize = 0;
            String combinedKey = addr.getAreaName4() == null ? "" : addr.getAreaName4();
            combinedKey = combinedKey + (addr.getAreaName3() == null ? "" : addr.getAreaName3());
            combinedKey = combinedKey + (addr.getAreaName2() == null ? "" : addr.getAreaName2());
            combinedKey = combinedKey + (addr.getAreaName1() == null ? "" : addr.getAreaName1());
            possibles = this.m_geoInfoFetcher.getGeoInfoAlias(combinedKey.toUpperCase());
            listSize = possibles.size();
            if (listSize < 1) {
                possibles = this.m_geoInfoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(addr.getAreaName3(), addr.getPostCode1()));
                listSize = possibles.size();
            }
            if (listSize < 1) {
                possibles = this.m_geoInfoFetcher.getGeoInfoAlias(addr.getAreaName3().toUpperCase());
            }
            possibles = this.makeGeoInfoCandidate(addr, possibles);
        }
        catch (Throwable t) {
            throw new DataSourceException("error reading geoinfo" + addr);
        }
        if (possibles == null) {
            return null;
        }
        EMEA_GeoInfoRecord exactMatchedRecord = null;
        EMEA_GeoInfoRecord firstLevelMatchedRecord = null;
        EMEA_GeoInfoRecord secondLevelMatchedRecord = null;
        EMEA_GeoInfoRecord thirdLevelMatchedRecord = null;
        for (int index = 0; index < possibles.size(); ++index) {
            EMEA_InternalGeographicCandidate cand = (EMEA_InternalGeographicCandidate)((Object)possibles.get(index));
            EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)cand.getGeoInfoRecord();
            if (!this.isTownValidAndMatched(record, addr)) continue;
            if (this.compareProvince(record.getAreaName1(), addr.getAreaName1())) {
                if (DEU_AddressUtils.isEmpty(addr.getAreaName4()) || this.compareString(record.getAreaName4(), addr.getAreaName4())) {
                    if (this.compareString(record.getAreaName2(), addr.getAreaName2())) {
                        exactMatchedRecord = record;
                        break;
                    }
                    firstLevelMatchedRecord = record;
                    continue;
                }
                secondLevelMatchedRecord = record;
                continue;
            }
            thirdLevelMatchedRecord = record;
        }
        if (exactMatchedRecord != null) {
            return exactMatchedRecord;
        }
        if (firstLevelMatchedRecord != null) {
            return firstLevelMatchedRecord;
        }
        if (secondLevelMatchedRecord != null) {
            return secondLevelMatchedRecord;
        }
        return thirdLevelMatchedRecord;
    }

    private boolean compareProvince(String province1, String province2) {
        return this.compareString(province1, province2);
    }

    private Address constructGeoInfoSearchingAddress(ISegmentDataSourceRecord input, boolean bLeft) throws DataSourceException {
        AddressImpl addr = new AddressImpl();
        if (bLeft) {
            if (input.hasLeftPostCode1()) {
                addr.setPostCode1(input.getLeftPostCode1());
            }
            if (input.hasLeftAreaName4()) {
                addr.setAreaName4(input.getLeftAreaName4());
            }
            if (input.hasLeftAreaName3()) {
                addr.setAreaName3(input.getLeftAreaName3());
            }
            if (input.hasLeftAreaName2()) {
                addr.setAreaName2(input.getLeftAreaName2());
            }
            if (input.hasLeftAreaName1()) {
                addr.setAreaName1(input.getLeftAreaName1());
            }
        } else {
            if (input.hasRightPostCode1()) {
                addr.setPostCode1(input.getRightPostCode1());
            }
            if (input.hasRightAreaName4()) {
                addr.setAreaName4(input.getRightAreaName4());
            }
            if (input.hasRightAreaName3()) {
                addr.setAreaName3(input.getRightAreaName3());
            }
            if (input.hasRightAreaName2()) {
                addr.setAreaName2(input.getRightAreaName2());
            }
            if (input.hasRightAreaName1()) {
                addr.setAreaName1(input.getRightAreaName1());
            }
        }
        return addr;
    }

    private void addGeoInfoRecordIntoHandler(ISegmentDataSourceRecord input, boolean bLeft) throws DataSourceException {
        Address addr = this.constructGeoInfoSearchingAddress(input, bLeft);
        EMEA_GeoInfoRecord matchedRecord = this.lookupGeoInfoRecord(addr);
        if (matchedRecord == null) {
            return;
        }
        StringBuffer buf = new StringBuffer(20);
        buf.append(addr.getAreaName4() == null ? "" : addr.getAreaName4());
        buf.append(addr.getAreaName3() == null ? "" : addr.getAreaName3());
        buf.append(addr.getAreaName2() == null ? "" : addr.getAreaName2());
        buf.append(addr.getAreaName1() == null ? "" : addr.getAreaName1());
        MapMarkerIndexKey key = this.makeExactGeoInfoKey(buf.toString().toUpperCase(), 0);
        MMJGeoInfoRecord mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)matchedRecord, key);
        this.m_geoInfoHandler.addRecord(mmjRecord);
        key = this.makeExactGeoInfoKey(addr.getAreaName3().toUpperCase(), 0);
        mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)matchedRecord, key);
        this.m_geoInfoHandler.addRecord(mmjRecord);
        String postalCode1ForSearching = DEU_AddressUtils.isEmpty(matchedRecord.getPostCode()) ? addr.getPostCode1() : matchedRecord.getPostCode();
        if (DEU_AddressUtils.isEmpty(postalCode1ForSearching)) {
            return;
        }
        String searchKey = EMEA_GeoInfoAliasKeyCreator.createKey(addr.getAreaName3(), postalCode1ForSearching);
        ArrayList localityRecordList = this.m_geoInfoFetcher.getGeoInfoAlias(searchKey);
        if (localityRecordList == null) {
            return;
        }
        for (int index = 0; index < localityRecordList.size(); ++index) {
            EMEA_GeoInfoRecord record = (EMEA_GeoInfoRecord)((Object)localityRecordList.get(index));
            key = this.makeExactGeoInfoKey(searchKey, index);
            mmjRecord = new MMJGeoInfoRecord((GeoInfoRecord)record, key);
            this.m_geoInfoHandler.addRecord(mmjRecord);
        }
    }

    private boolean isTownValidAndMatched(EMEA_GeoInfoRecord record, Address addr) {
        String recordTown = record.getAreaName3();
        if (DEU_AddressUtils.isEmpty(recordTown)) {
            return false;
        }
        String addrTown = addr.getAreaName3();
        if (DEU_AddressUtils.isEmpty(addrTown)) {
            return false;
        }
        return recordTown.equalsIgnoreCase(addrTown);
    }

    private MapMarkerIndexKey makeExactGeoInfoKey(String strKey, int index) {
        return new MiStringIndexKey(strKey);
    }

    @Override
    protected IPostalBase makePostalBase(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String postcode = null;
        if (left && input.hasLeftPostCode1() && this.stringExists(input.getLeftPostCode1())) {
            postcode = input.getLeftPostCode1().trim();
        }
        if (!left && input.hasRightPostCode1() && this.stringExists(input.getRightPostCode1())) {
            postcode = input.getRightPostCode1().trim();
        }
        StandardPostalBase base = null;
        if (!DEU_AddressUtils.isEmpty(postcode)) {
            if (postcode.length() > 2) {
                postcode = postcode.substring(0, 3);
            }
            base = new StandardPostalBase(postcode);
        }
        return base;
    }

    private IGeoBase[] makeGeoBases(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3 = this.getAreaName3(input, left);
        return this.makeGeoBases(areaName3, (short)3);
    }

    private IGeoBase[] makeGeoBases(String geoBaseStr, short flag) {
        IGeoBase[] bases = null;
        if (!DEU_AddressUtils.isEmpty(geoBaseStr) && !DEU_AddressUtils.isEmpty(geoBaseStr = geoBaseStr.trim())) {
            bases = new IGeoBase[2];
            String shortGeoBaseStr = DEU_ParsePostAddressRule.removeCommonWords(geoBaseStr);
            if (shortGeoBaseStr == null) {
                shortGeoBaseStr = geoBaseStr;
            }
            ISoundexKey sndxKey = DEUGermanSoundex.getStringKey(shortGeoBaseStr);
            bases[0] = new EMEA_GeoBase((MiSoundexKey)sndxKey, flag);
            sndxKey = this.m_soundex.getSoundex(shortGeoBaseStr);
            bases[1] = new EMEA_GeoBase((MiSoundexKey)sndxKey, flag);
        }
        return bases;
    }

    protected IGeoBase makeGeoBase(ISegmentDataSourceRecord input, boolean left) {
        throw new UnsupportedOperationException();
    }

    private String getAreaName3(ISegmentDataSourceRecord input, boolean left) throws DataSourceException {
        String areaName3 = null;
        if (left && input.hasLeftAreaName3() && this.stringExists(input.getLeftAreaName3())) {
            areaName3 = input.getLeftAreaName3();
        } else if (!left && input.hasRightAreaName3() && this.stringExists(input.getRightAreaName3())) {
            areaName3 = input.getRightAreaName3();
        }
        return areaName3;
    }

    private boolean compareString(String src, String target) {
        if (DEU_AddressUtils.isEmpty(src) && DEU_AddressUtils.isEmpty(target)) {
            return true;
        }
        if (DEU_AddressUtils.isEmpty(src) || DEU_AddressUtils.isEmpty(target)) {
            return false;
        }
        return src.equalsIgnoreCase(target);
    }

    protected int[] getSacsFromGeo2Sac(IStreetDataSourceRecord input, boolean left) throws DataSourceException {
        IGeoBase[] bases = this.makeGeoBases(input.getSegment(), left);
        if (bases == null) {
            return new int[]{this.NO_SAC};
        }
        int[] sacs = this.getGeo2Sac(bases[0]);
        return sacs;
    }

    private void addAdditionalGeo2SacRecords(IStreetDataSourceRecord input, boolean left, int[] sacs) throws DataSourceException {
        String postcode;
        ISegmentDataSourceRecord segment = input.getSegment();
        String areaName3 = this.getAreaName3(segment, left);
        if (areaName3 == null) {
            return;
        }
        Address addr = this.constructGeoInfoSearchingAddress(segment, left);
        EMEA_GeoInfoRecord matchedRecord = this.lookupGeoInfoRecord(addr);
        if (matchedRecord == null) {
            return;
        }
        DEU_GeoInfoFetcherImpl DEUGeoInfoFetcher = this.m_geoInfoFetcher;
        String town = matchedRecord.getAreaName3();
        if (DEU_AddressUtils.isEmpty(town)) {
            return;
        }
        ArrayList list = (ArrayList)DEUGeoInfoFetcher.getAltLangNames(town = town.trim());
        if (list != null) {
            for (int index = 0; index < list.size(); ++index) {
                IGeoBase[] bases = this.makeGeoBases((String)list.get(index), (short)3);
                if (bases == null) continue;
                for (int j = 0; j < bases.length; ++j) {
                    this.addGeo2SacRecords(bases[j], sacs);
                }
            }
        }
        String string = postcode = left ? segment.getLeftPostCode1() : segment.getRightPostCode1();
        if (DEU_AddressUtils.isEmpty(postcode)) {
            return;
        }
        int sacFromPost2Sac = this.getSacFromPost2Sac(input, left);
        ArrayList localityList = DEUGeoInfoFetcher.getGeoInfoAlias(EMEA_GeoInfoAliasKeyCreator.createKey(town, postcode));
        for (int index = 0; index < localityList.size(); ++index) {
            IGeoBase[] geoBases;
            EMEA_GeoInfoRecord tempRecord = (EMEA_GeoInfoRecord)((Object)localityList.get(index));
            String localityAlias = tempRecord.getAliasedLocality();
            if (localityAlias == null || (geoBases = this.makeGeoBases(localityAlias, (short)4)) == null) continue;
            for (int j = 0; j < geoBases.length; ++j) {
                if (sacFromPost2Sac != this.NO_SAC) {
                    this.addGeo2SacRecord(geoBases[j], sacFromPost2Sac);
                    continue;
                }
                SacData o = this.m_geo2sac.getSacForGeoBase(geoBases[j]);
                if (o == null) continue;
                UserDictSacData userSacData = new UserDictSacData((Object)o);
                this.addGeo2SacRecords(geoBases[j], userSacData.getSacs());
            }
        }
    }

    private void addGeo2SacRecord(IGeoBase base, int sac) {
        this.addRecordToSet(this.makeGeo2SacDataRecordType(sac, base));
    }

    private void addGeo2SacRecords(IGeoBase base, int[] sacs) {
        for (int i = 0; i < sacs.length; ++i) {
            this.addGeo2SacRecord(base, sacs[i]);
        }
    }

    protected void populateAlternateDataItems(MMJRangeRecord range, IRangeDataSourceRecord input, int sac) throws DataSourceException {
        String placeName = range.getPlaceName();
        if (placeName != null && placeName.length() > 0) {
            MiSoundexStreetDataIndexKey searchKey = new MiSoundexStreetDataIndexKey(sac, this.makeSoundexKey(placeName));
            MapMarkerBrowseMultiLevelIndexKey browseKey = this.makePlaceBrowseKey(sac, placeName);
            if (searchKey != null || browseKey != null) {
                AlternateDataRecord placeRecord = new AlternateDataRecord();
                placeRecord.setAlternateDataID(placeName);
                AlternateDataItem placeItem = new AlternateDataItem(0, placeRecord, (MapMarkerIndexKey)searchKey, (MapMarkerIndexKey)browseKey);
                range.addAlternateDataItem(placeItem);
            }
        }
    }

    private MapMarkerBrowseMultiLevelIndexKey makePlaceBrowseKey(int sac, String browseString) {
        MapMarkerBrowseMultiLevelIndexKey key = null;
        char c = DEU_ScoringHelper.getFirstNormChar(browseString);
        int[] collationKey = this.m_generator.getCollationKey(browseString);
        key = new MapMarkerBrowseMultiLevelIndexKey(sac, c, collationKey);
        return key;
    }

    protected MapMarkerIndexKey makeAlternateTypeBrowseKey(String alternateBrowseString, int sac) {
        String keyBase = alternateBrowseString;
        int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
        char c = DEU_ScoringHelper.getFirstNormChar(keyBase);
        return new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey);
    }

    protected MapMarkerIndexKey[] makeStreetBrowseKeys(Address address, int sac) {
        ArrayList keyBases = this.getKeyBases(address);
        if (keyBases == null) {
            return null;
        }
        ArrayList<MapMarkerBrowseMultiLevelIndexKey> keys = new ArrayList<MapMarkerBrowseMultiLevelIndexKey>(keyBases.size());
        for (String keyBase : keyBases) {
            int[] mainCollationKey = this.m_generator.getCollationKey(keyBase);
            char c = DEU_ScoringHelper.getFirstNormChar(keyBase);
            keys.add(new MapMarkerBrowseMultiLevelIndexKey(sac, c, mainCollationKey));
        }
        MapMarkerIndexKey[] keyArray = new MapMarkerIndexKey[keys.size()];
        return keys.toArray(keyArray);
    }

    private ArrayList getKeyBases(Address address) {
        String postKey;
        if (DEU_AddressUtils.isEmpty(address.getMainAddress())) {
            return null;
        }
        String mainKey = address.getMainAddress().toUpperCase();
        ArrayList<String> keys = new ArrayList<String>(1);
        keys.add(mainKey);
        String preKey = address.getPreAddress();
        if (!DEU_AddressUtils.isEmpty(preKey)) {
            keys.add(preKey.toUpperCase());
        }
        if (!DEU_AddressUtils.isEmpty(postKey = address.getPostAddress())) {
            keys.add(postKey.toUpperCase());
        }
        keys.add(DEU_AddressUtils.getFormattedStreetAddress(address, false).toUpperCase());
        return keys;
    }

    public boolean canReassembleAddress(String original_street, Address parsed) {
        String parsed_street = DEU_InternalCandidateAddress.reconstructAddress(new InternalCandidateAddress(parsed));
        boolean result = parsed_street.equalsIgnoreCase(original_street);
        return result;
    }

    @Override
    public Object convert(IDataSourceRecord inputData) throws DataCreationException {
        int i;
        boolean useAlternate;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return this.getNextDataRecord();
            }
            return null;
        }
        IStreetDataSourceRecord input = (IStreetDataSourceRecord)inputData;
        List addressList = null;
        try {
            if (!(input.hasMainAddress() && this.stringExists(input.getMainAddress()) || input.hasAlternateMainAddress() && this.stringExists(input.getAlternateMainAddress()))) {
                DataCreationLogger.getLogger().logInternalError("DEU_UDStreetDataSourceRecordConvertorImpl:: All streets should have main addresses.");
                return null;
            }
            addressList = this.getAllPossibleMainAddresses(input);
            if (addressList == null || addressList.size() == 0) {
                DataCreationLogger.getLogger().logInternalError("DEU_UDStreetDataSourceRecordConvertorImpl:: No main adddress found.");
                return null;
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        int[] leftSacs = this.getLeftSacs(input);
        int[] rightSacs = this.getRightSacs(input);
        int[] commonSacs = this.getCommonSacs(leftSacs, rightSacs);
        int uniqueLeftSacs = this.getNumberOfNonNoSacs(leftSacs);
        int uniqueRightSacs = this.getNumberOfNonNoSacs(rightSacs);
        int uniqueCommonSacs = this.getNumberOfNonNoSacs(commonSacs);
        int uniqueSacs = uniqueLeftSacs + uniqueRightSacs + uniqueCommonSacs;
        if (uniqueSacs == 0) {
            DataCreationLogger.getLogger().logInternalError("StreetDataSourceRecordConvertorImpl:: No unique sacs on either side of the street.");
            return null;
        }
        boolean bl = useAlternate = addressList.size() > 1;
        if (uniqueSacs == 1 && !useAlternate) {
            this.m_dataRecords = null;
            this.m_nextDataRecordIndex = -1;
        } else {
            this.m_dataRecords = new Object[uniqueSacs * addressList.size() - 1];
        }
        MMJStreetRecord record = null;
        this.m_nextDataRecordIndex = 0;
        int dataRecordsIndex = 0;
        if (commonSacs != null) {
            for (i = 0; i < commonSacs.length; ++i) {
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, commonSacs[i], commonSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueLeftSacs > 0) {
            for (i = 0; i < leftSacs.length; ++i) {
                if (leftSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, leftSacs[i], this.NO_SAC);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (uniqueRightSacs > 0) {
            for (i = 0; i < rightSacs.length; ++i) {
                if (rightSacs[i] == this.NO_SAC) continue;
                if (record == null) {
                    try {
                        record = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                        continue;
                    }
                    catch (DataSourceException DSEx) {
                        throw new DataCreationException(101, (Throwable)DSEx);
                    }
                }
                try {
                    this.m_dataRecords[dataRecordsIndex] = this.createStreetRecord(input, this.NO_SAC, rightSacs[i]);
                    ++dataRecordsIndex;
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        if (useAlternate) {
            try {
                for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                    this.m_dataRecords[uniqueSacs + altNum - 1] = this.createAlternateStreetRecord(record, input, (Address)addressList.get(altNum + 1));
                }
            }
            catch (DataSourceException DSEx) {
                throw new DataCreationException(101, (Throwable)DSEx);
            }
            for (i = 1; i < uniqueSacs; ++i) {
                try {
                    for (int altNum = 0; altNum < addressList.size() - 1; ++altNum) {
                        this.m_dataRecords[uniqueSacs + i + altNum - 1] = this.createAlternateStreetRecord((MMJStreetRecord)this.m_dataRecords[i + altNum - 1], input, (Address)addressList.get(altNum + 1));
                    }
                    continue;
                }
                catch (DataSourceException DSEx) {
                    throw new DataCreationException(101, (Throwable)DSEx);
                }
            }
        }
        try {
            this.updateMainAddress(record, input);
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(101, (Throwable)DSEx);
        }
        return record;
    }

    private void updateMainAddress(MMJStreetRecord record, IStreetDataSourceRecord inputRecord) throws DataSourceException {
        Address address = record.getAddress();
        if (address.getMainAddress().equals(inputRecord.getAlternateMainAddress())) {
            address.setMainAddress(null);
        }
    }

    private int getNumberOfNonNoSacs(int[] sacs) {
        if (sacs == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < sacs.length; ++i) {
            if (sacs[i] == this.NO_SAC) continue;
            ++count;
        }
        return count;
    }

    private int[] getCommonSacs(int[] leftSacs, int[] rightSacs) {
        int[] finalCommonSacs;
        int[] tempCommonSacs = leftSacs.length < rightSacs.length ? new int[leftSacs.length] : new int[rightSacs.length];
        for (int i = 0; i < tempCommonSacs.length; ++i) {
            tempCommonSacs[i] = this.NO_SAC;
        }
        int commonIndex = 0;
        boolean foundCommon = false;
        for (int l = 0; l < leftSacs.length; ++l) {
            for (int r = 0; r < rightSacs.length; ++r) {
                if (leftSacs[l] != rightSacs[r] || leftSacs[l] == this.NO_SAC) continue;
                foundCommon = true;
                tempCommonSacs[commonIndex] = leftSacs[l];
                ++commonIndex;
                leftSacs[l] = rightSacs[r] = this.NO_SAC;
            }
        }
        if (foundCommon) {
            int commonCount = 0;
            int totalCommonSacs = this.getNumberOfNonNoSacs(tempCommonSacs);
            finalCommonSacs = new int[totalCommonSacs];
            for (int i = 0; i < tempCommonSacs.length; ++i) {
                if (tempCommonSacs[i] == this.NO_SAC) continue;
                finalCommonSacs[commonCount] = tempCommonSacs[i];
                ++commonCount;
            }
        } else {
            return null;
        }
        return finalCommonSacs;
    }

    @Override
    protected Address parseStreet(Address input) {
        Address addr;
        input.setAreaName3("DummyTownName");
        String mainAddress = input.getMainAddress();
        String tempMainAddress = null;
        if (mainAddress != null) {
            tempMainAddress = mainAddress.substring(0, mainAddress.indexOf("100"));
        }
        if ((addr = this.privateParseStreet(input)).getAddressNumber() != null && addr.getAddressNumber().equals("100")) {
            addr.setAddressNumber((ParsedNumber)null);
        } else {
            addr.setMainAddress(tempMainAddress);
            addr = this.privateParseStreet(addr);
        }
        if (addr.getAddressNumber() != null) {
            String postAddr = addr.getPostAddress();
            postAddr = postAddr == null ? "" : postAddr;
            postAddr = postAddr + " " + addr.getAddressNumber();
            addr.setPostAddress(postAddr);
            addr.setAddressNumber((ParsedNumber)null);
        }
        addr.setAreaName3(null);
        return addr;
    }

    protected Address privateParseStreet(Address input) {
        Address[] parsedAddresses;
        try {
            parsedAddresses = this.m_parser.parse(input, (IConstraints)this.m_parserConstraints);
        }
        catch (ParserException PEx) {
            DataCreationLogger.getLogger().logInternalError("AbstractStreetDataSourceConvertor:: getParsedAddress(): Unable to parse street address: \n" + input.getMainAddress());
            DataCreationLogger.getLogger().logInternalError(PEx.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)PEx);
            return null;
        }
        if (parsedAddresses == null || parsedAddresses.length != 1) {
            return null;
        }
        return parsedAddresses[0];
    }

    @Override
    protected int getOddEven(IRangeDataSourceRecord input) throws DataSourceException {
        int result;
        int structValue = 4;
        String status = input.getStatus();
        if (status != null) {
            structValue = Integer.parseInt(status);
        }
        switch (structValue) {
            case 0: 
            case 1: 
            case 5: {
                result = -1;
                break;
            }
            case 2: {
                result = 2;
                break;
            }
            case 3: {
                result = 1;
                break;
            }
            case 4: {
                result = 0;
                break;
            }
            default: {
                throw new DataSourceException(9);
            }
        }
        return result;
    }

    protected void populateAlternateDataItems(MMJStreetRecord street, IStreetDataSourceRecord input, int sac) throws DataCreationException, DataSourceException {
        List recordRanges = street.getSegment().getRanges();
        ArrayList inputRanges = input.getSegment().getRanges();
        if (recordRanges != null) {
            int inputRangesCounter = 0;
            for (MMJRangeRecord rangeRecord : recordRanges) {
                rangeRecord.setPlaceName(input.getAlternateMainAddress());
                this.populateAlternateDataItems(rangeRecord, (IRangeDataSourceRecord)inputRanges.get(inputRangesCounter), sac);
                ++inputRangesCounter;
            }
        }
    }

    @Override
    protected String makeMainAddressString(String street, String houseNumber) {
        String addressString = null;
        if (street != null) {
            addressString = street + " " + houseNumber;
        }
        return addressString;
    }

    protected Address makePreParsedAddress(IStreetDataSourceRecord input) throws DataSourceException {
        Address address = super.makePreParsedAddress(input);
        String mainAddress = input.getMainAddress();
        if (mainAddress != null && mainAddress.length() > 0) {
            address.setMainAddress(mainAddress);
        } else {
            address.setMainAddress(input.getAlternateMainAddress());
        }
        return address;
    }

    protected List getAllPossibleMainAddresses(IStreetDataSourceRecord input) throws DataSourceException {
        ArrayList<Address> list = new ArrayList<Address>();
        Address preParsed = this.makePreParsedAddress(input);
        preParsed.setMainAddress(this.makeMainAddressString(preParsed.getMainAddress(), "100"));
        Address addr = this.getParsedStreet(input, preParsed);
        if (addr != null) {
            list.add(addr);
        }
        return list;
    }

    protected MMJRangeRecord makeRangeRecordType() {
        if (!this.m_isAPDataRecord) {
            return new MMJRangeRecord();
        }
        return new DEU_MMJAPRangeRecord();
    }

    protected List makeGeoInfoCandidate(Address addr, List list) {
        ArrayList<DEU_InternalGeographicCandidate> candidateList = new ArrayList<DEU_InternalGeographicCandidate>();
        DEU_InternalGeographicCandidate candidate = null;
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            candidate = new DEU_InternalGeographicCandidate();
            candidate.setCountry(addr.getCountry());
            candidate.setGeoInfoRecord((EMEA_GeoInfoRecord)((Object)iter.next()));
            candidateList.add(candidate);
        }
        return candidateList;
    }

    protected MMJRangeRecord convertRangeRecord(IRangeDataSourceRecord input, int sac) throws DataSourceException {
        DirectPosition rangePoint;
        IIntermediateDataRecord[] dataRecordArray;
        String from = input.getFrom();
        String to = input.getFrom();
        if (!this.m_isAPDataRecord) {
            if (input.hasFrom() != input.hasTo()) {
                throw new DataSourceException(16);
            }
            if (!(input.hasFrom() && this.stringExists(input.getFrom()) && input.hasTo() && this.stringExists(input.getTo()))) {
                return null;
            }
            if (!this.isValidRange(from, to)) {
                return null;
            }
            to = input.getTo();
        }
        MMJRangeRecord range = this.makeRangeRecordType();
        range.setFromHouse(from);
        range.setToHouse(to);
        range.setOddEven(this.getOddEven(input));
        if (input.hasPlaceName() && this.stringExists(input.getPlaceName())) {
            range.setPlaceName(input.getPlaceName());
        }
        if (input.isLeft()) {
            range.setLeft();
        } else {
            range.setRight();
        }
        if (input instanceof TabIntermediateRangeDataSourceRecordImpl && (dataRecordArray = ((TabIntermediateRangeDataSourceRecordImpl)input).getIntermediateRecordArray()) != null) {
            range.setIntermediateDataRecordArray(dataRecordArray);
        }
        this.populateAlternateDataItems(range, input, sac);
        if (range.getFromHouse() != null && !range.getFromHouse().isEmpty() && range.getFromHouse().equals((Object)range.getToHouse()) && (rangePoint = input.getPoint()) != null) {
            range.setPoint(rangePoint);
        }
        return range;
    }
}

