/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.parser;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class DEU_Abbreviations {
    private static Properties m_abbr = null;
    private static HashMap m_WordKeys = null;

    public static void load() throws Throwable {
        try {
            if (m_abbr == null) {
                Properties temp = new Properties();
                m_abbr = new Properties();
                m_WordKeys = new HashMap();
                temp.load(DEU_Abbreviations.class.getResourceAsStream("DEU_Abbreviations.properties"));
                Enumeration<Object> em = temp.keys();
                while (em.hasMoreElements()) {
                    String key = (String)em.nextElement();
                    m_abbr.put(key.toUpperCase(), ((String)temp.get(key)).toUpperCase());
                    m_WordKeys.put(key.toUpperCase(), ((String)temp.get(key)).toUpperCase());
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for DEU_Parser.");
        }
    }

    public static boolean isAbbreviation(String abbr) {
        return m_abbr.containsValue(abbr.toUpperCase());
    }

    public static boolean hasAbbreviation(String term) {
        if (term == null || term.trim().length() == 0) {
            return false;
        }
        return m_abbr.containsKey(term.trim().toUpperCase());
    }

    public static String getAbbreviation(String word) {
        if (word == null || word.trim().length() == 0) {
            return null;
        }
        return (String)m_abbr.get(word.trim().toUpperCase());
    }

    public static boolean containAbbreviations(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!DEU_Abbreviations.isAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static boolean containWordThatCanBeAbbreviated(String words) {
        if (words == null || words.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(words, " ");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            if (!DEU_Abbreviations.hasAbbreviation(temp)) continue;
            return true;
        }
        return false;
    }

    public static String abbreviateWords(String words) {
        if (words == null || words.trim().length() == 0) {
            return null;
        }
        StringBuffer output = new StringBuffer(words.length());
        StringTokenizer st = new StringTokenizer(words, " .-,");
        while (st.hasMoreTokens()) {
            String temp = st.nextToken();
            String abbr = DEU_Abbreviations.getAbbreviation(temp);
            if (abbr != null) {
                output.append(abbr);
            } else {
                output.append(temp);
            }
            output.append(" ");
        }
        return output.toString().trim();
    }

    public static ArrayList getWordsForAbbreviation(String abbreviation) {
        ArrayList<String> words = new ArrayList<String>();
        String temp = null;
        String value = null;
        int i = 0;
        if (m_abbr.containsValue(abbreviation.toUpperCase())) {
            Enumeration<Object> keys = m_abbr.keys();
            while (keys.hasMoreElements()) {
                temp = (String)keys.nextElement();
                value = (String)m_abbr.get(temp);
                if (!value.equalsIgnoreCase(abbreviation)) continue;
                words.add(temp);
                ++i;
            }
        }
        return words;
    }

    static {
        try {
            DEU_Abbreviations.load();
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage());
        }
    }
}

