/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.parser;

import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.DEU.parser.DEU_SpecialStreetsHandling;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.core.address.CoreStreetGeocoder;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DEU_ParseMainAddressRule
implements IParseRule {
    public static final String PRE_SEPARATOR_CHAR = new String("PRE_SEP");
    public static final String POST_SEPARATOR_CHAR = new String("POST_SEP");
    public static final int MAX_ADDITIONAL_FIELDS = 2;
    private static final char[] excludeChars = new char[]{',', '-', ' ', '.'};
    public static final String UNPARSED_HNR = "unparsed_hnr";
    public static final String ABBR_MAIN_ADDRESS = "abbr_main_address";
    private static final char[] specialChars = new char[]{',', '-', ' ', '.', '/', '(', ')'};
    private static List singlePrep = new ArrayList();
    private static List leadPrep = new ArrayList();
    private static List midPrep = new ArrayList();
    private static List endPrep = new ArrayList();
    private static final String regexPatternForPOBox = "(((\\b[P]\\s*\\.*\\s*(OST|O)\\.*\\s*\\.*\\s*(BOX))|(POST\\s*FACH))\\.*\\s*(NUMBER|NO|#)?\\.*\\s*\\d+)";
    private static Pattern pobPattern = Pattern.compile("(((\\b[P]\\s*\\.*\\s*(OST|O)\\.*\\s*\\.*\\s*(BOX))|(POST\\s*FACH))\\.*\\s*(NUMBER|NO|#)?\\.*\\s*\\d+)", 2);
    private final int SEARCH_FORWARD = 1;
    private final int SEARCH_BACKWARD = 2;
    private String hnrContainsChars = "-/\\+, ";
    private boolean postHnrFound = false;
    public static final String POST_HNR_FOUND = "POST_HNR_FOUND";
    private static final Object[] ERROR_MSG;
    private static String TEMP_NULL;

    protected char[] getExcludeChars() {
        return excludeChars;
    }

    public void parse(Address ura, Address pa, IConstraints constraints) throws ParserException {
        String str;
        if (!StringUtilities.isEmpty((String)pa.getMainAddress()) && !StringUtilities.isEmpty((String)pa.getGenericField1())) {
            StringBuilder buf = new StringBuilder(pa.getMainAddress());
            buf.append(' ');
            buf.append(pa.getGenericField1());
            pa.setMainAddress(buf.toString());
            pa.setGenericField1(null);
        }
        if ((str = pa.getMainAddress()) != null && str.length() != 0) {
            str = str.replaceAll("\"", "");
        }
        if (ura == null) {
            throw new ParserException(2000);
        }
        if (pa == null) {
            throw new ParserException(2001);
        }
        if (str == null || str.length() == 0) {
            return;
        }
        DEU_ParseMainAddressRule.handlePOBox(pa);
        str = pa.getMainAddress();
        if (!StringUtilities.isEmpty((String)str)) {
            str = str.replaceAll("\"", "");
        }
        if (!CoreStreetGeocoder.doPOBoxValidation()) {
            if (pa.getAdditionalFields().get(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD) != null) {
                pa.setMainAddress(null);
                pa.setAddressNumber((String)null);
                pa.getAdditionalFields().remove(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD);
                return;
            }
            if (pa.getAdditionalFields().get(AddressImpl.KEY_POBOX) != null) {
                pa.getAdditionalFields().remove(AddressImpl.KEY_POBOX);
                pa.getAdditionalFields().remove(AddressImpl.KEY_POBOX_NUMBER);
            }
        }
        if (str != null) {
            if (DEU_SpecialStreetsHandling.handleSpecialStreet(pa, str)) {
                HashMap<String, String> addFields = new HashMap<String, String>();
                addFields.put("unparsed_input_street", str);
                addFields.put("input_house_number", ura.getAddressNumber());
                pa.setAdditionalFields(addFields);
                return;
            }
            if (str.trim().compareTo("") != 0) {
                String upMainAddress;
                String inputMainAddress = upMainAddress = str.trim();
                String ptfType = "";
                if (pa.getPostThoroughfareType() == null || (ptfType = pa.getPostThoroughfareType().trim()).length() > 0) {
                    // empty if block
                }
                if (pa.getPreThoroughfareType() == null || (ptfType = pa.getPreThoroughfareType().trim()).length() > 0) {
                    // empty if block
                }
                StringTokenizer tokens = new StringTokenizer(upMainAddress, " .,/-()+&", true);
                LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                String mainAddress = "";
                if ((listOfTokens = this.cleanAddress(listOfTokens)) != null && listOfTokens.size() != 0) {
                    if (listOfTokens.size() == 1) {
                        mainAddress = ((String)listOfTokens.getFirst()).trim();
                    } else {
                        String houseNum = this.getHouseNumber(listOfTokens);
                        StringBuffer address = new StringBuffer();
                        for (int i = 0; i < listOfTokens.size(); ++i) {
                            address.append(listOfTokens.get(i));
                        }
                        mainAddress = address.toString().trim();
                        if (houseNum != null) {
                            inputMainAddress = mainAddress;
                        }
                        if (pa.getAddressNumber() == null) {
                            if (houseNum != null && houseNum.trim().length() > 0) {
                                StringTokenizer strAddNumTokens;
                                pa.setAddressNumber(houseNum);
                                if (pa.getAddressNumber() != null && (strAddNumTokens = new StringTokenizer(pa.getAddressNumber(), "-", false)).countTokens() > 1) {
                                    String firstAddNum = strAddNumTokens.nextToken();
                                    if (strAddNumTokens.nextToken().equals("null")) {
                                        pa.setAddressNumber(firstAddNum);
                                    }
                                }
                            } else if (pa.getAddressNumber() == null) {
                                pa.setAddressNumber(TEMP_NULL);
                            }
                        }
                    }
                    int maCount = 0;
                    if (mainAddress != null) {
                        mainAddress = mainAddress.trim();
                        maCount = mainAddress.length();
                    }
                    if (maCount > 0) {
                        String[] inStrings;
                        String inpuMainAddress;
                        DEU_ThoroughfareTypes tft;
                        String delim = "., /\\-";
                        StringBuffer buf = new StringBuffer(mainAddress);
                        while (buf.length() > 0 && delim.indexOf(buf.charAt(buf.length() - 1)) > -1) {
                            buf.deleteCharAt(buf.length() - 1);
                        }
                        mainAddress = buf.toString();
                        int spacePos = mainAddress.lastIndexOf(" ");
                        if (spacePos > 0) {
                            String lastWord = mainAddress.substring(spacePos + 1);
                            if (DEU_AddressTerm.isIgnoreWord(lastWord)) {
                                mainAddress = mainAddress.substring(0, spacePos);
                            }
                            buf = new StringBuffer(mainAddress);
                            while (buf.length() > 0 && delim.indexOf(buf.charAt(buf.length() - 1)) > -1) {
                                buf.deleteCharAt(buf.length() - 1);
                            }
                            mainAddress = buf.toString();
                        }
                        if ((tft = new DEU_ThoroughfareTypes()) == null) {
                            throw new ParserException(2009, ERROR_MSG);
                        }
                        String StringToReplace = "STR ";
                        if (mainAddress.toUpperCase().startsWith(StringToReplace)) {
                            StringBuffer tempBuf = new StringBuffer();
                            tempBuf.append("STR. ");
                            tempBuf.append(mainAddress.substring(StringToReplace.length()));
                            mainAddress = tempBuf.toString();
                        }
                        if (inputMainAddress != null && inputMainAddress.endsWith(".") && tft.findStreetType(inputMainAddress)) {
                            mainAddress = mainAddress + ".";
                        }
                        if (tft.findStreetType(mainAddress)) {
                            if (tft.foundAtStart()) {
                                String restAddr = null;
                                if (mainAddress.length() > tft.getTypeName().length()) {
                                    restAddr = mainAddress.substring(tft.getTypeName().length()).trim();
                                }
                                if (DEU_ParseMainAddressRule.isValidMainAddress(restAddr)) {
                                    pa.setPreThoroughfareType(tft.getTypeName());
                                    mainAddress = mainAddress.substring(tft.getTypeName().length()).trim();
                                    if (tft.hasPostSeparator()) {
                                        HashMap<String, String> t = pa.getAdditionalFields();
                                        if (t == null) {
                                            t = new HashMap<String, String>();
                                        }
                                        t.put(POST_SEPARATOR_CHAR, tft.getSeparatorChar());
                                        pa.setAdditionalFields(t);
                                    }
                                }
                            }
                            if (tft.foundAtEnd() && (mainAddress.lastIndexOf(" ") > 0 || tft.getTypeName().length() > 1)) {
                                int startOfLastWord = mainAddress.lastIndexOf(" ") + 1;
                                int startOfPTT = mainAddress.substring(0, tft.getTypeNameLocation()).trim().length();
                                if (startOfPTT - startOfLastWord > 1 || mainAddress.charAt(startOfPTT) == ' ') {
                                    pa.setPostThoroughfareType(tft.getTypeName());
                                    mainAddress = mainAddress.substring(0, tft.getTypeNameLocation()).trim();
                                    if (tft.hasPreSeparator()) {
                                        HashMap<String, String> t = pa.getAdditionalFields();
                                        if (t == null) {
                                            t = new HashMap<String, String>();
                                        }
                                        t.put(PRE_SEPARATOR_CHAR, tft.getSeparatorChar());
                                        pa.setAdditionalFields(t);
                                    }
                                }
                            }
                        } else {
                            String properTypeName;
                            String preffredName = DEU_ThoroughfareTypes.getPreferredTypeName(mainAddress);
                            if (preffredName != null && (properTypeName = DEU_ThoroughfareTypes.lookupProperName(preffredName)) != null) {
                                mainAddress = StringUtilities.toProperCase((String)properTypeName);
                            }
                        }
                        if ((maCount = mainAddress.length()) > 0) {
                            char c = mainAddress.charAt(maCount - 1);
                            if (StringUtilities.isSpecialChar((char)c, (char[])this.getExcludeChars())) {
                                mainAddress = mainAddress.substring(0, maCount - 1).trim();
                            }
                            if ((maCount = mainAddress.length()) > 0 && StringUtilities.isSpecialChar((char)(c = mainAddress.charAt(0)), (char[])this.getExcludeChars())) {
                                mainAddress = mainAddress.substring(1, maCount).trim();
                            }
                        }
                        String newMainAddr = null;
                        String preAddr = null;
                        String postAddr = "";
                        String[] splitName1 = this.splitNumberFromWord(mainAddress);
                        newMainAddr = splitName1 != null ? splitName1[0].trim() + ' ' + splitName1[1].trim() : mainAddress;
                        String[] splitName = this.splitMainAddress(newMainAddr);
                        if (splitName != null) {
                            if (StringUtilities.isNumeric((String)splitName[1].trim()) || splitName[1].trim().length() < 2 && pa.getPostThoroughfareType() == null || DEU_AddressTerm.isIgnoreWord(splitName[1])) {
                                String term;
                                postAddr = ' ' + splitName[1].trim();
                                preAddr = splitName[0].trim();
                                newMainAddr = null;
                                spacePos = preAddr.lastIndexOf(32);
                                while (spacePos != -1 && (term = preAddr.substring(spacePos + 1).trim()).length() > 0) {
                                    if (StringUtilities.isNumeric((String)term)) {
                                        postAddr = ' ' + term + postAddr;
                                        preAddr = preAddr.substring(0, spacePos);
                                    } else if (DEU_ParseMainAddressRule.isSpecialChars(term)) {
                                        postAddr = term + postAddr;
                                        preAddr = preAddr.substring(0, spacePos);
                                    } else {
                                        newMainAddr = term;
                                        preAddr = preAddr.substring(0, spacePos);
                                        break;
                                    }
                                    spacePos = preAddr.lastIndexOf(32);
                                }
                                if (newMainAddr == null) {
                                    newMainAddr = preAddr;
                                    preAddr = null;
                                }
                            } else {
                                String[] strArray;
                                preAddr = splitName[0].trim();
                                if (preAddr.lastIndexOf(" ") > -1 && StringUtilities.isNumeric((String)(strArray = preAddr.split(" "))[1].trim())) {
                                    pa.setAddressNumber(strArray[1].trim());
                                    splitName[1] = strArray[0];
                                    preAddr = null;
                                }
                                if (DEU_AddressTerm.isRomanNumber(preAddr)) {
                                    String temp = String.valueOf(DEU_AddressTerm.convertRomanToLong(preAddr));
                                    if ((temp = DEU_AddressTerm.isromanWord(temp)) != null) {
                                        preAddr = temp;
                                    }
                                }
                                newMainAddr = splitName[1].trim();
                            }
                        }
                        String newPreAddr = pa.getPreAddress() == null ? "" : pa.getPreAddress().trim() + " ";
                        newPreAddr = preAddr == null ? newPreAddr : newPreAddr + preAddr.trim();
                        String string = postAddr = postAddr == null ? "" : postAddr.trim();
                        if (DEU_AddressTerm.isCommonWord(newMainAddr) && pa.getPostThoroughfareType() != null && newPreAddr.length() == 0 && postAddr.length() == 0) {
                            newPreAddr = newMainAddr;
                            String prefferedName = DEU_ThoroughfareTypes.getPreferredTypeName(pa.getPostThoroughfareType());
                            if (prefferedName == null) {
                                prefferedName = pa.getPostThoroughfareType();
                            }
                            newMainAddr = DEU_ThoroughfareTypes.lookupProperName(prefferedName);
                            newMainAddr = StringUtilities.toProperCase((String)newMainAddr);
                            pa.setPostThoroughfareType(null);
                        }
                        if (newPreAddr.length() > 0) {
                            if (!DEU_AddressTerm.isCommonWord(newPreAddr)) {
                                pa.setPreAddress(newPreAddr);
                            } else {
                                pa.getAdditionalFields().put("input_street_commonterm", newPreAddr);
                            }
                        } else {
                            pa.setPreAddress(null);
                        }
                        pa.setMainAddress(newMainAddr);
                        if (postAddr.length() > 0) {
                            pa.setPostAddress(postAddr);
                        } else {
                            pa.setPostAddress(null);
                        }
                        if (this.postHnrFound) {
                            HashMap<String, String> t = pa.getAdditionalFields();
                            if (t == null) {
                                t = new HashMap<String, String>();
                            }
                            t.put(POST_HNR_FOUND, "true");
                            pa.setAdditionalFields(t);
                        }
                        if ((inpuMainAddress = (String)pa.getAdditionalFields().get("unparsed_input_street")) != null && (inStrings = inpuMainAddress.split(" ")).length == 2 && DEU_AddressTerm.isIgnoreWord(inStrings[0]) && StringUtilities.isNumeric((String)inStrings[1])) {
                            pa.setMainAddress(inStrings[0]);
                            pa.setAddressNumber(inStrings[1]);
                        }
                    }
                }
            }
        }
    }

    public static boolean isValidHouseNumber(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen > 1 && Character.isLetter(hnr.charAt(hnrLen - 1))) {
            return DEU_ParseMainAddressRule.isValidNumberFormat(hnr.substring(0, hnrLen - 1), hnrLen - 1);
        }
        return DEU_ParseMainAddressRule.isValidNumberFormat(hnr, hnrLen);
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-/");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!DEU_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return DEU_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    protected LinkedList cleanAddress(LinkedList list) {
        int i;
        String curToken;
        if (list == null || list.size() == 0) {
            return null;
        }
        LinkedList<String> outList = new LinkedList<String>();
        int numberOfTokens = list.size();
        String preToken = "";
        int foundSlashAt = -1;
        for (int i2 = 0; i2 < numberOfTokens; ++i2) {
            String curToken2 = (String)list.get(i2);
            if (curToken2.equals("_") || curToken2.equals("&") || curToken2.equals("+")) {
                curToken2 = "-";
            }
            if (curToken2.equals("\\")) {
                curToken2 = "/";
            }
            if (curToken2.equals(",")) {
                curToken2 = " ";
            }
            if (curToken2.equals(" ") || curToken2.equals("-") || curToken2.equals(".") || curToken2.equals(",")) {
                if (preToken.equals(" ")) {
                    outList.removeLast();
                    outList.addLast(curToken2);
                } else if (!curToken2.equals(preToken)) {
                    outList.addLast(curToken2);
                }
            } else if (curToken2.equals("/")) {
                if (foundSlashAt <= 0) {
                    foundSlashAt = i2;
                }
                if (!curToken2.equals(preToken)) {
                    outList.addLast(curToken2);
                }
            } else {
                outList.addLast(curToken2);
            }
            preToken = curToken2;
        }
        numberOfTokens = outList.size();
        String bufTemp = "ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789\u00c0\u00c1\u00c2\u00c3\u00c4\u00c5\u00c6\u00c7\u00c8\u00c9\u00ca\u00cb\u00cc\u00cd\u00ce\u00cf\u00d0\u00d1\u00d2\u00d3\u00d4\u00d5\u00d6\u00d7\u00d8\u00d9\u00da\u00db\u00dc\u00dd\u00de\u00df\u00e0\u00e1\u00e2\u00e3\u00e4\u00e5\u00e6\u00e7\u00e8\u00e9\u00ea\u00eb\u00ec\u00ed\u00ee\u00ef\u00f0\u00f1\u00f2\u00f3\u00f4\u00f5\u00f6\u00f7\u00f8\u00f9\u00fa\u00fb\u00fc\u00fd\u00fe\u00ff" + String.valueOf(specialChars);
        for (int i3 = 0; i3 < numberOfTokens; ++i3) {
            curToken = (String)outList.get(i3);
            curToken = StringUtilities.trimToCharsIgnoreCase((String)curToken, (String)bufTemp);
            outList.set(i3, curToken);
        }
        int outlistSlashAt = -1;
        if (foundSlashAt > 0) {
            outlistSlashAt = outList.indexOf("/");
            curToken = (String)outList.get(outlistSlashAt - 1);
            if (curToken.equals(" ") && outlistSlashAt - 2 >= 0) {
                curToken = (String)outList.get(outlistSlashAt - 2);
            }
            if (this.isHouseNumber(curToken) && outlistSlashAt + 1 < outList.size()) {
                curToken = (String)outList.get(outlistSlashAt + 1);
                if (curToken.equals(" ") && outlistSlashAt + 2 < outList.size()) {
                    curToken = (String)outList.get(outlistSlashAt + 2);
                }
                if (this.isHouseNumber(curToken)) {
                    int lastSlash = outlistSlashAt;
                    outlistSlashAt = -1;
                    for (int i4 = lastSlash + 1; i4 < outList.size(); ++i4) {
                        curToken = (String)outList.get(i4);
                        if (!curToken.equals("/")) continue;
                        outlistSlashAt = i4;
                        break;
                    }
                }
            }
            numberOfTokens = outList.size();
            if (outlistSlashAt > 0) {
                for (i = outlistSlashAt; i < numberOfTokens; ++i) {
                    outList.removeLast();
                }
            }
        }
        LinkedList newList = new LinkedList(outList);
        for (i = 0; i < outList.size() - 1; ++i) {
            String term = (String)outList.get(i);
            if (!DEU_AddressTerm.isIgnoreWord(term)) continue;
            outList.remove(i);
        }
        this.removeDelimitersFromEnds(outList);
        if (outList.size() == 1 && StringUtilities.isNumeric((String)outList.get(0).toString())) {
            return newList;
        }
        return outList;
    }

    public static boolean isValidNumberFormat(String num, int len) {
        boolean bRc = true;
        if (num == null || num.trim().length() == 0) {
            return false;
        }
        if (num.trim().length() == len) {
            for (int i = 0; i < num.length(); ++i) {
                char ch = num.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                bRc = false;
                break;
            }
        } else {
            bRc = false;
        }
        return bRc;
    }

    protected boolean isHouseNumber(String hn) {
        boolean bRc = true;
        if (!DEU_ParseMainAddressRule.isValidNumberFormat(hn, hn.length()) && (bRc = StringUtilities.hasNumeric((String)hn))) {
            bRc = hn.indexOf("-") != 0 && hn.indexOf("/") != 0;
        }
        return bRc;
    }

    private String[] splitMainAddress(String mainAddr) {
        String[] addrs = null;
        if (mainAddr != null) {
            StringBuffer buf = new StringBuffer();
            String lastWord = null;
            StringTokenizer st = new StringTokenizer(mainAddr.trim(), " -", true);
            while (st.hasMoreTokens()) {
                String str = st.nextToken();
                if (st.hasMoreTokens()) {
                    buf.append(str);
                    continue;
                }
                lastWord = str;
            }
            if (lastWord == null || buf.length() == 0) {
                return null;
            }
            addrs = new String[]{buf.toString(), lastWord};
            return addrs;
        }
        return null;
    }

    private String stripHouseNumberFromEnd(LinkedList list) {
        int itemPos = list.size();
        String addressNum = null;
        for (int i = list.size() - 1; i > 0; --i) {
            addressNum = (String)list.get(i);
            if (!DEU_AddressTerm.isPunctuation(addressNum)) {
                itemPos = i;
                break;
            }
            list.remove(i);
        }
        if (DEU_AddressTerm.isRomanNumber(addressNum)) {
            list.remove(itemPos);
            return String.valueOf(DEU_AddressTerm.convertRomanToLong(addressNum));
        }
        int numberOfTokens = list.size();
        int hnrStartPos = numberOfTokens - 1;
        StringBuffer addressNumber = new StringBuffer();
        int hnrEndPos = this.getHouseNumberEndPos(list, hnrStartPos, 2);
        String rangeDelimiter = "+/,-";
        if (hnrEndPos > 0) {
            int i;
            String lastTerm = "";
            for (i = hnrEndPos; i <= hnrStartPos; ++i) {
                String term = (String)list.get(i);
                if (lastTerm.equals(" ")) {
                    if (term.length() == 1 && (DEU_ParseMainAddressRule.isAlpha(term.charAt(0)) || rangeDelimiter.indexOf(term.charAt(0)) > -1)) {
                        addressNumber.deleteCharAt(addressNumber.length() - 1);
                    }
                } else if (lastTerm.length() == 1 && rangeDelimiter.indexOf(lastTerm.charAt(0)) > -1 && term.equals(" ")) continue;
                lastTerm = term;
                addressNumber.append(term);
            }
            for (i = hnrEndPos; i < numberOfTokens; ++i) {
                list.removeLast();
            }
        }
        return addressNumber.toString().trim();
    }

    private String stripHouseNumberFromStart(LinkedList list) {
        int itemPos;
        int hnrStartPos = itemPos = 0;
        String addressNumber = null;
        if (!DEU_ParseMainAddressRule.isValidHouseNumber(addressNumber = (String)list.get(itemPos++))) {
            return null;
        }
        int hnrEndPos = this.getHouseNumberEndPos(list, hnrStartPos, 1);
        if (hnrEndPos > hnrStartPos) {
            int i;
            addressNumber = "";
            for (i = hnrStartPos; i < hnrEndPos; ++i) {
                addressNumber = addressNumber + (String)list.get(i);
            }
            for (i = 0; i < hnrEndPos; ++i) {
                list.removeFirst();
            }
        }
        return addressNumber;
    }

    private void removeDelimitersFromEnds(LinkedList list) {
        String tempItem;
        if (list == null || list.size() == 0) {
            return;
        }
        while (list.size() > 0 && ((tempItem = (String)list.getFirst()).equals(" ") || tempItem.equals("-") || tempItem.equals(".") || tempItem.equals("/") || tempItem.equals(",") || tempItem.equals("+"))) {
            list.removeFirst();
        }
        while (list.size() > 0 && ((tempItem = (String)list.getLast()).equals(" ") || tempItem.equals("-") || tempItem.equals("/") || tempItem.equals(",") || tempItem.equals("+"))) {
            list.removeLast();
        }
    }

    private boolean isSpecialCase(LinkedList list) {
        if (list == null || list.size() == 0) {
            return false;
        }
        int itemPos = 0;
        int listSize = list.size();
        String token = (String)list.get(itemPos);
        if (this.isStringWithinArray(token = token.toUpperCase(), leadPrep)) {
            if ((itemPos += 2) >= listSize) {
                return false;
            }
            token = (String)list.get(itemPos);
            if (this.isStringWithinArray(token = token.toUpperCase(), midPrep)) {
                if ((itemPos += 2) >= listSize) {
                    return false;
                }
                token = (String)list.get(itemPos);
                if (this.isStringWithinArray(token = token.toUpperCase(), endPrep)) {
                    if ((itemPos += 2) >= listSize) {
                        return true;
                    }
                    token = (String)list.get(itemPos);
                    if (StringUtilities.isNumeric((String)(token = token.toUpperCase()))) {
                        return true;
                    }
                }
            }
        } else if (this.isStringWithinArray(token, singlePrep)) {
            if ((itemPos += 2) >= listSize) {
                return true;
            }
            token = (String)list.get(itemPos);
            if (StringUtilities.isNumeric((String)(token = token.toUpperCase()))) {
                return (itemPos += 2) >= listSize;
            }
            return false;
        }
        if (token.length() == 1) {
            char c = token.charAt(0);
            if (c >= 'A' || c <= 'Z') {
                if ((itemPos += 2) >= listSize) {
                    return true;
                }
                token = (String)list.get(itemPos);
                if (StringUtilities.isNumeric((String)(token = token.toUpperCase()))) {
                    return (itemPos += 2) >= listSize;
                }
                return false;
            }
            return false;
        }
        return false;
    }

    private String getHouseNumber(LinkedList list) {
        if (list == null || list.size() == 0) {
            return null;
        }
        String houseNum = this.stripHouseNumberFromEnd(list);
        if (houseNum == null || houseNum.length() == 0) {
            houseNum = this.stripHouseNumberFromStart(list);
            this.removeDelimitersFromEnds(list);
        }
        if (houseNum != null && houseNum.length() != 0) {
            this.removeDelimitersFromEnds(list);
            if (list.size() > 0 && !StringUtilities.isNumeric((String)((String)list.getLast())) && this.isSpecialCase(list)) {
                String tempHnr;
                String temp;
                int spacePos;
                int n = spacePos = houseNum.indexOf(32) > -1 ? houseNum.indexOf(32) : houseNum.indexOf(44);
                if (spacePos != -1) {
                    temp = houseNum.substring(0, spacePos);
                    tempHnr = houseNum.substring(spacePos + 1);
                } else {
                    temp = houseNum;
                    tempHnr = null;
                }
                char ch = temp.toUpperCase().charAt(temp.length() - 1);
                if (ch < 'A' || ch > 'Z') {
                    list.addLast(" ");
                    list.addLast(temp);
                    if (tempHnr == null) {
                        return null;
                    }
                    houseNum = tempHnr;
                }
            }
        }
        if (houseNum == null) {
            int foundHouseNumAt = -1;
            for (int i = 2; i < list.size(); ++i) {
                String token = (String)list.get(i);
                if (!DEU_ParseMainAddressRule.isValidHouseNumber(token)) continue;
                foundHouseNumAt = i;
                break;
            }
            if (foundHouseNumAt == -1) {
                return null;
            }
            int houseNumEndsAt = this.getHouseNumberEndPos(list, foundHouseNumAt, 1);
            if (houseNumEndsAt == -1) {
                return null;
            }
            houseNum = "";
            for (int i = foundHouseNumAt; i < houseNumEndsAt; ++i) {
                houseNum = houseNum + (String)list.get(i);
            }
            this.postHnrFound = true;
            if (list != null && list.size() != 0) {
                int numberOfTokens = list.size();
                for (int i = foundHouseNumAt; i < numberOfTokens; ++i) {
                    list.removeLast();
                }
            }
        }
        if (houseNum != null) {
            int len;
            houseNum = houseNum.trim();
            houseNum = houseNum.replace('+', '-');
            houseNum = houseNum.replace(',', '-');
            houseNum = houseNum.replace('/', '-');
            houseNum = houseNum.replace(' ', '-');
            StringTokenizer tokens = new StringTokenizer(houseNum, "-", true);
            StringBuffer finalAddressNumber = new StringBuffer();
            boolean rangeFound = false;
            while (tokens.hasMoreTokens()) {
                String hnrPart = tokens.nextToken();
                if (finalAddressNumber.length() == 0 && (hnrPart.equals(" ") || hnrPart.equals("-"))) continue;
                if (hnrPart.equals("-")) {
                    if (rangeFound) break;
                    rangeFound = true;
                    finalAddressNumber.append(hnrPart);
                    continue;
                }
                if (rangeFound) {
                    if (!DEU_ParseMainAddressRule.isValidHouseNumberRange(finalAddressNumber.toString() + hnrPart)) break;
                    finalAddressNumber.append(hnrPart);
                    continue;
                }
                if (!DEU_ParseMainAddressRule.isValidHouseNumber(finalAddressNumber.toString() + hnrPart)) break;
                finalAddressNumber.append(hnrPart);
            }
            if ((len = finalAddressNumber.length()) > 0 && finalAddressNumber.charAt(len - 1) == '-') {
                finalAddressNumber.deleteCharAt(len - 1);
            }
            return finalAddressNumber.toString();
        }
        return houseNum;
    }

    private int getHouseNumberEndPos(LinkedList list, int startPos, int direction) {
        int houseNumberEndPos = -1;
        int numberOfTokens = list.size();
        if (list == null || numberOfTokens == 0) {
            return houseNumberEndPos;
        }
        int curPos = startPos;
        String houseNum = (String)list.get(curPos);
        String token = "";
        if (direction == 1) {
            if (!DEU_ParseMainAddressRule.isValidHouseNumber(houseNum)) {
                return houseNumberEndPos;
            }
            houseNumberEndPos = startPos + 1;
            if (++curPos >= numberOfTokens) {
                return houseNumberEndPos;
            }
            if ((token = (String)list.get(curPos++)).equals(" ")) {
                token = (String)list.get(curPos++);
            }
            if (DEU_ParseMainAddressRule.isValidHouseNumber(houseNum + token)) {
                houseNum = houseNum + token;
                houseNumberEndPos = curPos;
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                token = (String)list.get(curPos++);
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                if (token.equals(" ")) {
                    token = (String)list.get(curPos++);
                }
            }
            if (token.equals("-") || token.equals("/")) {
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                token = (String)list.get(curPos++);
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                if (token.equals(" ")) {
                    token = (String)list.get(curPos++);
                }
            }
            if (DEU_ParseMainAddressRule.isValidHouseNumberRange(houseNum + "-" + token)) {
                houseNum = houseNum + "-" + token;
                houseNumberEndPos = curPos;
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                token = (String)list.get(curPos++);
                if (curPos >= numberOfTokens) {
                    return houseNumberEndPos;
                }
                if (token.equals(" ")) {
                    token = (String)list.get(curPos++);
                }
                if (DEU_ParseMainAddressRule.isValidHouseNumberRange(houseNum + token)) {
                    houseNumberEndPos = curPos;
                    houseNum = houseNum + token;
                }
            }
            return houseNumberEndPos;
        }
        if (direction == 2) {
            int lastAlphaPos = -1;
            while (curPos > -1) {
                String hnrPart = (String)list.get(curPos);
                if (hnrPart.length() == 1 && DEU_ParseMainAddressRule.isAlpha(hnrPart.charAt(0))) {
                    lastAlphaPos = curPos--;
                    continue;
                }
                if (hnrPart.equals(" ")) {
                    --curPos;
                    continue;
                }
                if (DEU_ParseMainAddressRule.isValidHouseNumber(hnrPart) || this.hnrContainsChars.indexOf(hnrPart) > -1) {
                    lastAlphaPos = -1;
                    --curPos;
                    continue;
                }
                if (startPos >= curPos + 1) {
                    ++curPos;
                    break;
                }
                curPos = -1;
                break;
            }
            if (lastAlphaPos != -1) {
                if (startPos > lastAlphaPos) {
                    curPos = lastAlphaPos + 1;
                } else if (startPos == lastAlphaPos) {
                    curPos = -1;
                }
            }
            return curPos;
        }
        return -1;
    }

    private boolean isStringWithinArray(String val, List list) {
        boolean flag = false;
        if (val == null || list.size() == 0) {
            flag = false;
        } else if (list.contains(val.toUpperCase())) {
            flag = true;
        }
        return flag;
    }

    private String[] splitNumberFromWord(String word) {
        char ch;
        String[] ret = null;
        if (word == null) {
            return null;
        }
        word = word.trim();
        int len = word.length();
        int pos = -1;
        int i = len - 1;
        while (i > -1 && (ch = word.charAt(i)) >= '0' && ch <= '9') {
            pos = i--;
        }
        if (pos != -1) {
            ret = new String[]{word.substring(0, pos), word.substring(pos)};
        }
        return ret;
    }

    private static boolean isSpecialChars(String str) {
        if (str == null || specialChars == null) {
            return false;
        }
        String specialCharsString = new String(specialChars);
        for (int i = 0; i < str.length(); ++i) {
            if (specialCharsString.indexOf(str.charAt(i)) >= 0) continue;
            return false;
        }
        return true;
    }

    public static boolean isValidMainAddress(String addr) {
        if (addr == null || addr.trim().length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(addr, " ,-/\\().");
        while (st.hasMoreTokens()) {
            String term = st.nextToken();
            if (StringUtilities.isNumeric((String)term) || DEU_AddressTerm.isIgnoreWord(term)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAlpha(char ch) {
        char c = Character.toUpperCase(ch);
        return c >= 'A' && c <= 'Z';
    }

    public static void handlePOBox(Address parsed) {
        if (StringUtilities.isEmpty((String)parsed.getMainAddress())) {
            return;
        }
        String mainAddr = parsed.getMainAddress();
        StringBuilder remaining = new StringBuilder(mainAddr);
        String pob = null;
        Matcher matcher = pobPattern.matcher(mainAddr);
        if (matcher.find()) {
            int startPos = matcher.start();
            int endPos = matcher.end();
            pob = mainAddr.substring(startPos, endPos);
            remaining.replace(startPos, endPos, "");
            String rem = remaining.toString().trim();
            if (rem.length() > 0) {
                String[] split;
                parsed.setMainAddress(rem);
                if (pob != null && (split = pob.split(" ")).length > 1) {
                    parsed.getAdditionalFields().put(AddressImpl.KEY_POBOX, "POSTFACH");
                    parsed.getAdditionalFields().put(AddressImpl.KEY_POBOX_NUMBER, split[split.length - 1]);
                }
            } else if (pob != null) {
                int pos = pob.indexOf(32);
                parsed.setAddressNumber(pob.substring(pos + 1));
                parsed.setMainAddress("POSTFACH");
                parsed.getAdditionalFields().put(AddressImpl.POB_IN_MAIN_ADDRESS_FIELD, "true");
            }
        }
    }

    static {
        String[] singlePreps = new String[]{"STRASSE", "STRASE", "STRA\u00dfE", "STR", "BIEM", "AM", "IM"};
        for (int i = 0; i < singlePreps.length; ++i) {
            singlePrep.add(singlePreps[i].trim().toUpperCase());
        }
        String[] leadPreps = new String[]{"AN", "AUF", "BEI", "HINTER", "IN", "NEBEN", "SWISCHEN", "VOR", "\u00dcBER", "UNTER", "ZU"};
        for (int i = 0; i < leadPreps.length; ++i) {
            leadPrep.add(leadPreps[i].trim().toUpperCase());
        }
        String[] midPreps = new String[]{"DEM", "DEN", "DER"};
        for (int i = 0; i < midPreps.length; ++i) {
            midPrep.add(midPreps[i].trim().toUpperCase());
        }
        String[] endPreps = new String[]{"ALTEN"};
        for (int i = 0; i < endPreps.length; ++i) {
            endPrep.add(endPreps[i].trim().toUpperCase());
        }
        ERROR_MSG = new Object[]{"Could not create DEU Thoroughfare Type Class"};
        TEMP_NULL = null;
    }
}

