/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.parser;

import com.mapinfo.mapmarker.DEU.DEU_Constraints;
import com.mapinfo.mapmarker.DEU.DEU_LocaliserProperties;
import com.mapinfo.mapmarker.DEU.parser.DEU_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class DEU_ParsePostAddressRule
implements IParseRule {
    private static final String m_punctuations = " ()-/.\"',\\";
    private final String POST_CODE_INVALID = "Post Code supplied is alphanumeric or has an invalid number of digits";
    private final String[] REGION_CODES = DEU_LocaliserProperties.getPostCodePrefixes();

    public void parse(Address inputAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        DEU_Constraints deuConstraints;
        if (inputAddress == null) {
            throw new ParserException(2000);
        }
        if (parsedAddress == null) {
            throw new ParserException(2001);
        }
        boolean isDataCreation = false;
        if (constraints != null && (deuConstraints = (DEU_Constraints)constraints) != null) {
            isDataCreation = deuConstraints.getDataConstructionConstraint();
        }
        String postCode1 = parsedAddress.getPostCode1();
        String areaName3 = parsedAddress.getAreaName3();
        if (postCode1 != null && postCode1.trim().length() != 0 && areaName3 != null && areaName3.trim().length() != 0) {
            if (!this.parsePostalFields(postCode1.trim(), areaName3.trim(), parsedAddress, false)) {
                throw new ParserException(2008, new Object[]{"Post Code supplied is alphanumeric or has an invalid number of digits"});
            }
        } else {
            LinkedList listOfTokens;
            StringTokenizer tokens;
            String postAddress = parsedAddress.getPostAddress();
            postAddress = this.replaceTabsWithSpaces(postAddress);
            if (!isDataCreation && areaName3 == null && postAddress != null) {
                parsedAddress.setGenericField2("true");
            }
            if ((postAddress = this.stripRegionFromZip(postAddress)) != null && postAddress.trim().length() != 0) {
                tokens = new StringTokenizer(postAddress, " ,");
                if (tokens.countTokens() == 0) {
                    return;
                }
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                if (listOfTokens == null || listOfTokens.size() < 1) {
                    return;
                }
                int tokenCount = listOfTokens.size();
                if (tokenCount == 1) {
                    String token = (String)listOfTokens.getFirst();
                    token = this.removeCountryCode(token);
                    if (postAddress.length() > 2 && StringUtilities.isNumeric((String)token)) {
                        parsedAddress.setPostCode1(token);
                    } else if (!StringUtilities.hasNumeric((String)token) && !DEU_AddressTerm.isIgnoreWord(token) && token.length() != 1) {
                        parsedAddress.setAreaName3(token.trim());
                        parsedAddress.setPostAddress(null);
                    }
                } else {
                    int i;
                    int i2;
                    String postCode = null;
                    int index = -1;
                    for (int i3 = 0; i3 < listOfTokens.size(); ++i3) {
                        postCode = listOfTokens.get(i3).toString().trim();
                        if (StringUtilities.isNumeric((String)postCode) && postCode.length() <= 5) {
                            index = i3;
                            break;
                        }
                        postCode = null;
                    }
                    if (!StringUtilities.isEmpty(postCode)) {
                        parsedAddress.setPostCode1(postCode);
                        listOfTokens.remove(index);
                    }
                    StringBuffer city = new StringBuffer();
                    if (index != -1) {
                        if (index < listOfTokens.size()) {
                            for (i2 = index; i2 < listOfTokens.size(); ++i2) {
                                city.append((String)listOfTokens.get(i2) + " ");
                            }
                        } else {
                            for (i2 = 0; i2 < index; ++i2) {
                                city.append((String)listOfTokens.get(i2) + " ");
                            }
                        }
                    } else {
                        for (i2 = 0; i2 < listOfTokens.size(); ++i2) {
                            city.append((String)listOfTokens.get(i2) + " ");
                        }
                    }
                    boolean bSwap = false;
                    if (!this.parsePostalFields(postCode, city.toString(), parsedAddress, true) || parsedAddress.getPostCode1() == null) {
                        bSwap = true;
                    }
                    boolean notParsed = false;
                    if (bSwap) {
                        postCode = (String)listOfTokens.getLast();
                        city = null;
                        city = new StringBuffer();
                        if (StringUtilities.isNumeric((String)postCode)) {
                            for (i = 0; i < listOfTokens.size() - 1; ++i) {
                                city.append((String)listOfTokens.get(i) + " ");
                            }
                        } else {
                            for (i = 0; i < listOfTokens.size(); ++i) {
                                city.append((String)listOfTokens.get(i) + " ");
                            }
                        }
                        if (!this.parsePostalFields(postCode, city.toString(), parsedAddress, true) || parsedAddress.getPostCode1() == null) {
                            notParsed = true;
                        }
                    }
                    if (notParsed) {
                        postCode = (String)listOfTokens.get(0);
                        if (StringUtilities.hasNumeric((String)postCode)) {
                            // empty if block
                        }
                        if (StringUtilities.hasNumeric((String)(postCode = (String)listOfTokens.get(listOfTokens.size() - 1)))) {
                            // empty if block
                        }
                        postCode = null;
                        city = null;
                        city = new StringBuffer();
                        for (i = 0; i < listOfTokens.size(); ++i) {
                            city.append((String)listOfTokens.get(i) + " ");
                        }
                        if (!this.parsePostalFields(postCode, city.toString(), parsedAddress, true)) {
                            // empty if block
                        }
                    }
                }
            }
            if (areaName3 != null && areaName3.trim().length() != 0) {
                tokens = new StringTokenizer(areaName3, m_punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                areaName3 = this.concatanateList(listOfTokens);
                this.parseCity(areaName3.trim(), parsedAddress, false);
            }
            if (postCode1 != null && postCode1.trim().length() != 0) {
                tokens = new StringTokenizer(postCode1, m_punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                String pc = this.stripRegionFromZip((postCode1 = this.concatanateList(listOfTokens)).trim());
                if (this.isPostalCode(pc)) {
                    parsedAddress.setPostCode1(pc);
                } else if (parsedAddress.getAreaName3() == null) {
                    return;
                }
            }
            if (parsedAddress.getPostCode1() != null && parsedAddress.getPostCode1().equalsIgnoreCase("0")) {
                parsedAddress.setPostCode1(null);
            }
            if (!(parsedAddress.getPostCode1() != null && parsedAddress.getPostCode1().trim().length() != 0 || parsedAddress.getAreaName3() != null && parsedAddress.getAreaName3().trim().length() != 0)) {
                parsedAddress.setAreaName4(null);
            }
            if (!isDataCreation) {
                if (((DEU_Constraints)constraints).isSingleLineInput() && StringUtilities.isEmpty((String)parsedAddress.getAreaName3()) && !StringUtilities.isEmpty((String)parsedAddress.getAreaName1())) {
                    parsedAddress.setAreaName3(parsedAddress.getAreaName1());
                }
                parsedAddress.setPostAddress(null);
            }
        }
    }

    private void parseTown(Address parsedAddress, boolean isDataCreation, String areaName3) {
        if (!isDataCreation) {
            StringTokenizer tokens = new StringTokenizer(areaName3.trim(), m_punctuations, true);
            LinkedList token = StringUtilities.tokensToList((StringTokenizer)tokens);
            boolean isMultiwordFound = false;
            StringBuffer buff = new StringBuffer();
            String lastMultiword = null;
            for (int i = 0; i < token.size(); ++i) {
                buff.append(token.get(i));
                if (!DEU_AddressTerm.isMultiWordAreaName(buff.toString())) continue;
                lastMultiword = buff.toString();
            }
            if (lastMultiword != null) {
                parsedAddress.setAreaName3(lastMultiword);
                isMultiwordFound = true;
                if (parsedAddress.getAreaName1() == null) {
                    parsedAddress.setAreaName1(DEU_AddressTerm.removePunctuationChars(areaName3.replaceAll(lastMultiword, ""), true));
                }
            }
            if (!isMultiwordFound) {
                buff.delete(0, buff.length());
                parsedAddress.setAreaName3(token.get(0).toString());
                for (int i = 1; i < token.size(); ++i) {
                    buff.append(token.get(i));
                }
                if (parsedAddress.getAreaName1() == null) {
                    parsedAddress.setAreaName1(DEU_AddressTerm.removePunctuationChars(buff.toString(), true));
                }
            }
        }
    }

    private void parseCity(String city, Address pa, boolean fromPostAddressfield) {
        String originalCity = city;
        boolean flag = false;
        if (fromPostAddressfield) {
            int spaceIdx = city.indexOf(" ");
            int dashIndx = city.indexOf("-");
            if (spaceIdx != -1 && dashIndx == -1) {
                if (pa.getAreaName1() == null) {
                    pa.setAreaName1(city.substring(spaceIdx));
                    flag = true;
                }
                city = city.substring(0, spaceIdx);
            }
        }
        if (!StringUtilities.hasNumeric((String)city)) {
            if (!DEU_AddressTerm.isCommonWord(city)) {
                pa.setAreaName3(city);
                return;
            }
            if (flag) {
                pa.setAreaName1(null);
            }
            pa.setAreaName3(originalCity);
        }
    }

    private String stripRegionFromZip(String zip) {
        if (zip == null) {
            return null;
        }
        StringTokenizer st = new StringTokenizer(zip, " -/.,", true);
        int count = this.REGION_CODES.length;
        StringBuffer outBuf = new StringBuffer(zip.length());
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            boolean tokenIsRegionCode = false;
            for (int i = 0; i < count; ++i) {
                if (!token.equalsIgnoreCase(this.REGION_CODES[i])) continue;
                tokenIsRegionCode = true;
                break;
            }
            if (tokenIsRegionCode) continue;
            outBuf.append(token);
        }
        String delimiters = " -/.,()";
        while (outBuf.length() > 0 && delimiters.indexOf(outBuf.charAt(0)) != -1) {
            outBuf.deleteCharAt(0);
        }
        while (outBuf.length() > 0 && delimiters.indexOf(outBuf.charAt(outBuf.length() - 1)) != -1) {
            outBuf.deleteCharAt(outBuf.length() - 1);
        }
        return outBuf.toString();
    }

    private boolean isPostalCode(String pc) {
        return pc != null && pc.length() > 2 && StringUtilities.isNumeric((String)pc);
    }

    public String replaceTabsWithSpaces(String term) {
        if (term == null) {
            return null;
        }
        if (term.trim().equals("")) {
            return term;
        }
        StringBuffer newTerm = new StringBuffer();
        for (int i = 0; i < term.length(); ++i) {
            char c = term.charAt(i);
            if (c == '\t') {
                newTerm.append(' ');
                continue;
            }
            newTerm.append(c);
        }
        return newTerm == null ? null : newTerm.toString();
    }

    public static String removeCommonWords(String str) {
        String[] strArray = DEU_AddressTerm.removeCommonWords(str);
        if (strArray != null && strArray[0] != null) {
            return strArray[0];
        }
        return str;
    }

    public String removeCountryCode(String input) {
        String newPostCode;
        if (input == null || input.trim().length() < 6 || input.trim().length() > 6) {
            return input;
        }
        if (StringUtilities.isNumeric((String)input)) {
            return input;
        }
        if (input.substring(0, 1).equals("D") && StringUtilities.isNumeric((String)(newPostCode = input.substring(1)))) {
            return newPostCode;
        }
        return input;
    }

    protected boolean parsePostalFields(String postCode, String city, Address pa, boolean isPostAddressfiled) {
        StringTokenizer tokens;
        if (city != null && city.trim().length() > 0) {
            tokens = new StringTokenizer(city, m_punctuations, true);
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            StringBuffer buff = new StringBuffer();
            String lastMultiword = null;
            for (int i = 0; i < listOfTokens.size(); ++i) {
                buff.append(listOfTokens.get(i));
                if (!DEU_AddressTerm.isMultiWordAreaName(buff.toString())) continue;
                lastMultiword = buff.toString();
                pa.setGenericField3("true");
            }
            if (StringUtilities.isEmpty(lastMultiword)) {
                city = this.concatanateList(listOfTokens);
                this.parseCity(city, pa, isPostAddressfiled);
            } else {
                pa.setAreaName3(lastMultiword);
                if (pa.getAreaName1() == null && lastMultiword.length() < buff.length() && pa.getAreaName1() == null) {
                    pa.setAreaName1(buff.substring(lastMultiword.length()));
                }
            }
        }
        boolean foundCity = false;
        if (pa.getAreaName3() != null) {
            foundCity = true;
        }
        if (postCode != null && postCode.trim().length() > 0) {
            int postcodeNum;
            tokens = new StringTokenizer(postCode, m_punctuations, true);
            LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            postCode = this.concatanateList(listOfTokens);
            postCode = this.stripRegionFromZip(postCode);
            if (StringUtilities.isNumeric((String)(postCode = postCode.trim())) && (postcodeNum = Integer.parseInt(postCode)) == 0) {
                pa.setPostCode1(null);
            }
            if (StringUtilities.isNumeric((String)postCode) && postCode.length() > 2) {
                pa.setPostCode1(postCode);
            } else if (!foundCity) {
                return false;
            }
        }
        return foundCity;
    }

    private String concatanateList(LinkedList listOfTokens) {
        String term;
        int numberOfPunc = 0;
        while (listOfTokens.size() > 0 && DEU_AddressTerm.isPunctuation(term = (String)listOfTokens.getFirst())) {
            if (numberOfPunc > 1) {
                listOfTokens.removeFirst();
            }
            ++numberOfPunc;
        }
        while (listOfTokens.size() > 0 && DEU_AddressTerm.isPunctuation(term = (String)listOfTokens.getLast())) {
            listOfTokens.removeLast();
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < listOfTokens.size(); ++i) {
            buf.append(listOfTokens.get(i));
        }
        return buf.toString();
    }
}

