/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.DEU.parser;

import com.mapinfo.mapmarker.DEU.parser.DEU_ParseMainAddressRule;
import com.mapinfo.mapmarker.DEU.parser.DEU_ThoroughfareTypes;
import com.mapinfo.mapmarker.DEU.parser.ISpecialStreetHandling;
import com.mapinfo.mapmarker.DEU.parser.SpecialStreetHandlingHelper;
import com.mapinfo.mapmarker.DEU.parser.SpecialStreetInfo;
import com.mapinfo.mapmarker.DEU.parser.SpecialStreetInfoParser;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.List;

public final class GenericSpecialStreetHandling
implements ISpecialStreetHandling {
    private SpecialStreetHandlingHelper m_helper;

    private GenericSpecialStreetHandling(SpecialStreetInfo info) {
        this.m_helper = new SpecialStreetHandlingHelper(info);
    }

    public static List getgenericSpecialStreetHandlers() {
        List infos = SpecialStreetInfoParser.parseStreets("DEU_GenericSpecialStreets.xml", GenericSpecialStreetHandling.class);
        ArrayList<GenericSpecialStreetHandling> handlers = new ArrayList<GenericSpecialStreetHandling>(infos.size());
        if (infos.size() > 0) {
            for (int index = 0; index < infos.size(); ++index) {
                SpecialStreetInfo info = (SpecialStreetInfo)infos.get(index);
                handlers.add(new GenericSpecialStreetHandling(info));
            }
        }
        return handlers;
    }

    @Override
    public boolean handle(Address pa, String[] tokens) {
        if (!this.m_helper.simpleCheck(pa, tokens)) {
            return false;
        }
        boolean isQualified = false;
        int endPos = 1;
        StringBuffer next = new StringBuffer(tokens[1]);
        DEU_ThoroughfareTypes tft = new DEU_ThoroughfareTypes();
        String temp = null;
        String tempString = null;
        StringBuffer tempBuf = new StringBuffer();
        for (int index = 2; index <= tokens.length; ++index) {
            tempString = next.toString();
            temp = tempString.toUpperCase();
            if (tft.findStreetType(temp) && (tempString.lastIndexOf(" ") > 0 || tft.getTypeName().length() > 1)) {
                int startOfLastWord = tempString.lastIndexOf(" ") + 1;
                int startOfPTT = tempString.substring(0, tft.getTypeNameLocation()).trim().length();
                if (startOfPTT - startOfLastWord > 1 || tempString.charAt(startOfPTT) == ' ') {
                    try {
                        tempBuf.append(tempString.substring(0, tft.getTypeNameLocation()).trim());
                    }
                    catch (Exception e) {
                        System.out.println(pa);
                    }
                    tempBuf.append(" " + DEU_ThoroughfareTypes.lookupProperName(tft.getPreferredTypeName()));
                }
            }
            if (tempBuf != null && tempBuf.toString().length() != 0) {
                temp = tempBuf.toString();
                tempBuf.delete(0, tempBuf.length());
            }
            if (this.m_helper.contains(temp.toUpperCase())) {
                isQualified = true;
                endPos = index;
                break;
            }
            if (index == tokens.length) continue;
            next.append(" " + tokens[index]);
        }
        if (isQualified) {
            String mainToken = tokens[0];
            int arrayLen = 0;
            if (temp != null) {
                arrayLen = temp.split(" ").length;
            }
            if (arrayLen == 2) {
                String ptt = temp.split(" ")[1];
                if (!StringUtilities.isNumeric((String)ptt)) {
                    pa.setMainAddress(mainToken + " " + temp.split(" ")[0]);
                    pa.setPostThoroughfareType(ptt);
                } else {
                    pa.setMainAddress(mainToken + " " + temp);
                }
            } else {
                pa.setMainAddress(mainToken + " " + temp);
            }
            if (!(pa.getAddressNumber() != null && DEU_ParseMainAddressRule.isValidHouseNumber(pa.getAddressNumber()) || tokens.length <= endPos)) {
                for (int index = endPos; index < tokens.length; ++index) {
                    if (!DEU_ParseMainAddressRule.isValidHouseNumber(tokens[index])) continue;
                    pa.setAddressNumber(tokens[index]);
                    break;
                }
            }
            return true;
        }
        return false;
    }
}

