/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.EMEA.EMEA_AddressFilter;
import com.mapinfo.mapmarker.GeocodeResult;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MMGeneralGeocoderException;
import com.mapinfo.mapmarker.MMInternalFatalException;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.ICandidate;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.dp.IDataManager;
import com.mapinfo.mapmarker.core.IGeocoder;
import com.mapinfo.mapmarker.core.address.IAddressGeocoder;
import com.mapinfo.mapmarker.core.browse.IBrowseGeocoder;
import com.mapinfo.mapmarker.core.custom.ICustomGeocoder;
import com.mapinfo.mapmarker.core.geographic.IGeographicGeocoder;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.core.postal.IPostalGeocoder;
import com.mapinfo.mapmarker.core.standardize.IStandardizeGeocoder;
import com.mapinfo.mapmarker.utils.MapMarkerResourceLoader;
import java.util.Locale;
import java.util.ResourceBundle;

public class EMEA_Geocoder
implements IGeocoder {
    private IHandler m_handler;
    private static String m_localStrings = "com.mapinfo.mapmarker.GeocodableAddressStrings";
    private ResourceBundle m_errorBundle;

    public EMEA_Geocoder(IHandler handler) {
        this.m_handler = handler;
    }

    public void setErrorBundle(ResourceBundle bundle) {
        this.m_errorBundle = bundle;
    }

    public IConstraints convertConstraints(IConstraints constraints) {
        IConstraints result = this.m_handler.getLocalConstraintsHelper().convertToLocalConstraints(constraints, this.m_handler);
        return result;
    }

    public void prepareAndParse(int geocodeType, IConstraints constraints) throws ParserException, MapMarkerInternalException {
        constraints.setGeocodeType(geocodeType);
        if (this.m_errorBundle == null) {
            this.m_errorBundle = MapMarkerResourceLoader.loadForLocale((Locale)constraints.getClientLocale(), (String)m_localStrings);
        }
        constraints.setHandler(this.m_handler);
        constraints.getHandler().getParseHandler().getParsedAddresses(constraints.getHandler().getInputAddress(), constraints);
    }

    public GeocodeResult geocode(IConstraints constraints) throws MMInternalFatalException, MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(0, constraints);
        }
        if (!constraints.getHandler().isGeocodeSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IAddressGeocoder geo = constraints.getHandler().getAddressGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        GeocodeResult geocodeResult = geo.geocode(constraints, this.m_errorBundle);
        this.filterGeocodeResult(constraints, geocodeResult);
        return geocodeResult;
    }

    public GeocodeResult geocodePostal(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(1, constraints);
        }
        if (!constraints.getHandler().isGeocodePostalSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IPostalGeocoder geo = constraints.getHandler().getPostalGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        GeocodeResult geocodeResult = geo.geocodePostal(constraints);
        this.filterGeocodeResult(constraints, geocodeResult);
        return geocodeResult;
    }

    public GeocodeResult geocodeGeographic(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(4, constraints);
        }
        if (!constraints.getHandler().isGeocodeGeographicSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IGeographicGeocoder geo = constraints.getHandler().getGeographicGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        GeocodeResult geocodeResult = geo.geocodeGeographic(constraints);
        this.filterGeocodeResult(constraints, geocodeResult);
        return geocodeResult;
    }

    public GeocodeResult geocodeCustom(int geocodeType, IConstraints constraints) throws MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(geocodeType, constraints);
        }
        if (!constraints.getHandler().isGeocodeCustomSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        ICustomGeocoder geo = constraints.getHandler().getCustomGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.geocodeCustom(geocodeType, constraints);
    }

    public GeocodeResult standardize(IConstraints constraints) throws MapMarkerInternalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(5, constraints);
        }
        if (!constraints.getHandler().isStandardizeSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IStandardizeGeocoder geo = constraints.getHandler().getStandardizeGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.standardize(constraints);
    }

    public GeocodeResult browse(IConstraints constraints) throws MapMarkerInternalException, MMInternalFatalException {
        if (constraints.getHandler() == null) {
            this.prepareAndParse(6, constraints);
        }
        if (!constraints.getHandler().isBrowseSupported()) {
            throw new MMGeneralGeocoderException(2307);
        }
        IBrowseGeocoder geo = constraints.getHandler().getBrowseGeocoder();
        if (geo == null) {
            throw new MMGeneralGeocoderException(2307);
        }
        return geo.browse(constraints);
    }

    public CandidateAddress getIndexedCandidate(int i, IConstraints preferences) throws MapMarkerInternalException {
        IConstraints localPrefs = this.convertConstraints(preferences);
        if (i > localPrefs.getHandler().getGeocodeResult().getNumberCandidates()) {
            return null;
        }
        ICandidate cand = (ICandidate)localPrefs.getHandler().getMatchResults().get(i);
        return cand.toCandidateAddress(localPrefs.getHandler().getParsedAddress(), localPrefs);
    }

    public CandidateAddress getIndexedCoords(int candIndex, CandidateRange range, IConstraints preferences) throws MapMarkerInternalException {
        IConstraints localPrefs = this.convertConstraints(preferences);
        if (candIndex > localPrefs.getHandler().getGeocodeResult().getNumberCandidates()) {
            return null;
        }
        InternalCandidateAddress cand = (InternalCandidateAddress)localPrefs.getHandler().getMatchResults().get(candIndex);
        return cand.reinterpolate(localPrefs.getHandler().getParsedAddress(), range, localPrefs);
    }

    public ICountryGeographyInfo getCountryGeographyInfo() {
        IDataManager data = this.m_handler.getDataManager();
        if (data != null) {
            return data.getCountryGeographyInfo();
        }
        return null;
    }

    protected void filterGeocodeResult(IConstraints constraints, GeocodeResult geocodeResult) {
        EMEA_AddressFilter.filterAddresses(constraints, geocodeResult);
    }
}

