/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;
import java.util.ResourceBundle;

public abstract class EMEA_InternalCandidateAddress
extends InternalCandidateAddress {
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String IS_MAJOR_ROAD = "is.major.road";
    private String m_aliasedLocality = null;
    private String m_addressNumber = null;
    protected boolean m_adjustS4;
    private boolean m_houseNumberFromPlace;
    protected boolean m_bInputNumberNull;

    public EMEA_InternalCandidateAddress() {
    }

    public EMEA_InternalCandidateAddress(Address addr) {
        super(addr);
    }

    public boolean isAdjusteS4() {
        return this.m_adjustS4;
    }

    public String getPostCode1() {
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null) {
            return segment.getLeftPostCode1();
        }
        return postCode1;
    }

    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            areaName3 = segment.getLeftAreaName3();
        }
        return areaName3;
    }

    public String getAreaName4() {
        Segment segment;
        String areaName4 = super.getAreaName4();
        if (areaName4 == null && (segment = this.getSegment()) != null) {
            areaName4 = segment.getLeftAreaName4();
        }
        return areaName4;
    }

    public String getForeignLanguageAreaNames() {
        String aliases;
        EMEA_GeoInfoRecord geoinfoRecord;
        if (this.getSegment() != null && (geoinfoRecord = (EMEA_GeoInfoRecord)this.getSegment().getGeoInfoRecord()) != null && (aliases = geoinfoRecord.getAltLanguageNames()) != null) {
            return aliases;
        }
        return null;
    }

    public String getAreaName2() {
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && this.getSegment() != null) {
            GeoInfoRecord geoinfoRecord = this.getSegment().getGeoInfoRecord();
            if (geoinfoRecord == null) {
                String an2 = this.getSegment().getLeftAreaName2();
                if (an2 != null) {
                    return an2;
                }
            } else {
                String an2 = geoinfoRecord.getAreaName2();
                if (an2 != null) {
                    return an2;
                }
            }
        }
        return areaName2;
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            String right;
            String left = segment.getLeftAreaName1();
            areaName1 = left != null ? left : (right = segment.getRightAreaName1());
        }
        return areaName1;
    }

    public void writeAddressNumber(String addrNum) {
        this.m_addressNumber = addrNum;
    }

    public void matchAddressNumber(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) {
        super.matchAddressNumber(location, constraints);
        String rgAddressNumber = super.getAddressNumber();
        if (!StringUtilities.isEmpty((String)rgAddressNumber)) {
            this.writeAddressNumber(rgAddressNumber);
        }
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    public String getAltAreaName3() {
        Segment segment = this.getSegment();
        if (segment != null) {
            String left = segment.getLeftAltAreaName();
            String right = segment.getRightAltAreaName();
            if (left != null && right != null && left.equals(right)) {
                return left;
            }
        }
        return null;
    }

    protected void setAddressNumberFlags(Address input, CandidateAddress candidate) {
        String number = input.getAddressNumber();
        ParsedNumber num = new ParsedNumber(this.getAddressNumber());
        if (!num.isEmpty()) {
            if (this.getAddressNumberScore() == 1.0) {
                candidate.setAddressNumberMatched();
                candidate.setAddressNumber(number);
            }
        } else if (input.getAddressNumber() == null) {
            candidate.setAddressNumberMatched();
        }
    }

    public void findClosestRange() {
        this.calculateSegmentOffset(0);
        this.calculateSegmentOffset(1);
    }

    private void calculateSegmentOffset(int side) {
        ParsedNumber parsedNumber = this.getInputNumber();
        if (parsedNumber == null) {
            return;
        }
        Segment segment = this.getSegment();
        int numRanges = segment.getRangeCount(side);
        List theseRanges = segment.getRanges(side);
        int inputOddEven = parsedNumber.isRangeOddEvenBoth();
        long bestOffset = Long.MAX_VALUE;
        for (int i = 0; i < numRanges; ++i) {
            Range range = (Range)theseRanges.get(i);
            int oddEven = range.getOddEven();
            if (oddEven != 0 && inputOddEven != oddEven && (oddEven != 5 || range.getIntermediateRecordArray() == null)) continue;
            long offset = range.computeOffsetFromRange(parsedNumber);
            if (!range.getParsedFrom().equals((Object)range.getParsedTo())) {
                offset *= 2L;
            }
            if (offset >= bestOffset) continue;
            this.setClosestRange(i);
            this.setClosestSegmentSide(side);
            bestOffset = offset;
        }
    }

    public long getAdjustedOffset() {
        Range range = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
        long offset = range.getRangeOffset();
        if (!range.getParsedFrom().equals((Object)range.getParsedTo())) {
            offset *= 2L;
        }
        return offset;
    }

    protected void findBestPlaceNameMatch(ScoringAddress inputAddress) {
        Segment segment = this.getSegment();
        double bestRangeScore = 0.0;
        double placeMinimum = this.getPlaceMinimum();
        if (segment == null) {
            return;
        }
        String placeName = null;
        for (int side = 0; side < 2; ++side) {
            List rangeList = segment.getRanges(side);
            int rangeCount = rangeList.size();
            for (int i = 0; i < rangeCount; ++i) {
                Range range = (Range)rangeList.get(i);
                if (!range.getParsedFrom().equals((Object)range.getParsedTo())) continue;
                String currentPlaceName = range.getPlaceName();
                double currentRangeScore = inputAddress.scorePlaceName(currentPlaceName);
                if (currentRangeScore < placeMinimum) {
                    currentRangeScore = 0.0;
                }
                if (!(currentRangeScore > bestRangeScore)) continue;
                bestRangeScore = currentRangeScore;
                this.maybeSetSegmentSide(side, range);
                this.setMatchedRangeNumber(i);
                this.setNumberFromPlaceMatch(true);
                this.m_bInputNumberNull = false;
                placeName = currentPlaceName;
            }
        }
        this.setPlaceNameScore(bestRangeScore);
    }

    public ParsedNumber getParsedAddressNumber() {
        Segment segment = this.getSegment();
        ParsedNumber inputNumber = this.getInputNumber();
        if (this.hasMatchingRange()) {
            Range range = null;
            List rangeList = segment.getRanges(this.getSegmentSide());
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.getMatchedRangeNumber());
            }
            if (range != null) {
                if (this.isHouseNumberFromPlaceMatch()) {
                    return range.getParsedFrom();
                }
                return range.getMatchedRangeNumber();
            }
        } else if (!this.m_bInputNumberNull && inputNumber != null && this.hasClosestRange()) {
            Range range = null;
            List rangeList = segment.getRanges(this.getClosestSegmentSide());
            if (rangeList != null && rangeList.size() > 0) {
                range = (Range)rangeList.get(this.getClosestRangeNumber());
            }
            if (range != null) {
                return range.getClosestAddressNumber(inputNumber);
            }
        }
        return this.getStreetCandidateAddress().getParsedAddressNumber();
    }

    public String getAddressNumber() {
        if (this.m_addressNumber != null) {
            return this.m_addressNumber;
        }
        Segment segment = this.getSegment();
        ParsedNumber inputNumber = this.getInputNumber();
        StreetCandidateAddress address = this.getStreetCandidateAddress();
        if (!this.m_bInputNumberNull && inputNumber != null) {
            if (this.hasMatchingRange()) {
                Range range = null;
                List rangeList = segment.getRanges(this.getSegmentSide());
                if (rangeList != null && rangeList.size() > 0) {
                    range = (Range)rangeList.get(this.getMatchedRangeNumber());
                }
                if (range != null) {
                    if (this.isHouseNumberFromPlaceMatch()) {
                        return range.getParsedFrom().getCombinedAddressNumber();
                    }
                    return range.getMatchedRangeNumber().getCombinedAddressNumber();
                }
            } else if (this.hasClosestRange()) {
                Range range = null;
                List rangeList = segment.getRanges(this.getClosestSegmentSide());
                if (rangeList != null && rangeList.size() > 0) {
                    range = (Range)rangeList.get(this.getClosestRangeNumber());
                }
                if (range != null) {
                    return range.getClosestAddressNumber(inputNumber).getCombinedAddressNumber();
                }
            } else {
                return address.getAddressNumber();
            }
        }
        return address.getAddressNumber();
    }

    public void checkSegmentSides(ScoringAddress parsedAddress, int side) {
        if (this.m_bInputNumberNull || this.getInputNumber() == null) {
            return;
        }
        Segment segment = this.getSegment();
        Range bestRange = null;
        double bestRangePlaceNameScore = 0.0;
        double placeMinimum = this.getPlaceInRangeMinimum();
        if (segment == null) {
            return;
        }
        ParsedNumber unitNumber = new ParsedNumber(parsedAddress.getUnitValue());
        String unitType = parsedAddress.getUnitType();
        List rangeList = segment.getRanges(side);
        int inputOddEven = this.getInputNumber().isRangeOddEvenBoth();
        int count = rangeList.size();
        for (int i = 0; i < count; ++i) {
            double rangePlaceNameScore;
            Range range = (Range)rangeList.get(i);
            int oddEven = range.getOddEven();
            if (!(oddEven == 0 || oddEven == 2 && inputOddEven != 1 || oddEven == 1 && inputOddEven != 2) && (oddEven != 5 || range.getIntermediateRecordArray() == null)) continue;
            int fieldsMatched = range.isNumberInRange(this.getInputNumber());
            if (fieldsMatched > 0 && unitNumber != null) {
                range.findMatchingRangeUnit(unitNumber, unitType);
            }
            if ((rangePlaceNameScore = parsedAddress.scorePlaceName(range.getPlaceName())) < placeMinimum) {
                rangePlaceNameScore = 0.0;
            }
            if (fieldsMatched > this.getCntAddressNumberFieldsMatched()) {
                this.setCntAddressNumberFieldsMatched(fieldsMatched);
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (fieldsMatched <= 0 || fieldsMatched != this.getCntAddressNumberFieldsMatched()) continue;
            if (bestRange == null) {
                bestRange = (Range)segment.getRanges(this.getSegmentSide()).get(this.getMatchedRangeNumber());
                bestRangePlaceNameScore = parsedAddress.scorePlaceName(bestRange.getPlaceName());
            }
            if (range.computeAddressesInRange() < bestRange.computeAddressesInRange()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && !bestRange.hasMatchingRangeUnit()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (range.hasMatchingRangeUnit() && bestRange.hasMatchingRangeUnit() && range.getRangeUnitAt(range.getMatchingRangeUnit()).getTypeMatched() && !bestRange.getRangeUnitAt(range.getMatchingRangeUnit()).getTypeMatched()) {
                this.setMatchedRangeNumber(i);
                bestRange = range;
                bestRangePlaceNameScore = rangePlaceNameScore;
                this.setSegmentSide(side);
                continue;
            }
            if (!(rangePlaceNameScore > bestRangePlaceNameScore)) continue;
            this.setMatchedRangeNumber(i);
            bestRange = range;
            this.setSegmentSide(side);
            bestRangePlaceNameScore = rangePlaceNameScore;
        }
    }

    public void setInputNumber(ParsedNumber inputNumber) {
        super.setInputNumber(inputNumber);
        this.m_bInputNumberNull = false;
    }

    public String getFormattedStreetAddress() {
        int len;
        String tmp;
        StringBuffer str = new StringBuffer();
        if (this.getAddressNumberScore() == 1.0 && !this.m_bInputNumberNull) {
            str.append(this.getInputNumber().getCombinedAddressNumber());
            str.append(" ");
        } else {
            tmp = this.getAddressNumber();
            if (tmp != null) {
                str.append(tmp);
                str.append(" ");
            }
        }
        tmp = this.getPreAddress();
        if (tmp != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPreThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getMainAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostThoroughfareType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getPostAddress()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitValue()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((tmp = this.getUnitType()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    public boolean isHouseNumberFromPlaceMatch() {
        return this.m_houseNumberFromPlace;
    }

    protected void setNumberFromPlaceMatch(boolean value) {
        this.m_houseNumberFromPlace = value;
    }

    protected void maybeSetSegmentSide(int side, Range range) {
        ParsedNumber to;
        long to_value;
        ParsedNumber from = range.getParsedFrom();
        long from_value = from.getAddressNumber();
        if (from_value != 0L && (to_value = (to = range.getParsedTo()).getAddressNumber()) != 0L) {
            this.setSegmentSide(side);
        }
    }

    public void setGeocodedPoint(CandidateAddress candidate, int debugLevel, IConstraints constraints, ResourceBundle errorBundle) {
        super.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        if (candidate.getLocationPoint() != null && candidate.getAddressNumber() == null) {
            candidate.setLocationPrecision(2);
        }
    }

    public static String reconstructMainAddress(Address pa) {
        String unparsedAddress = pa.getGenericField1();
        if (unparsedAddress != null && unparsedAddress.length() > 0) {
            return unparsedAddress;
        }
        StringBuffer buff = new StringBuffer();
        String tmp = EMEA_InternalCandidateAddress.noNulls(pa.getMainAddress());
        if (tmp.length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = EMEA_InternalCandidateAddress.noNulls(pa.getPostAddress())).length() > 0) {
            buff.append(' ');
            buff.append(tmp);
        }
        return buff.toString();
    }

    public static String getFormattedPreAddress(Address cand) {
        StringBuffer buff = new StringBuffer();
        String tmp = EMEA_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_COMMON));
        if (tmp.length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = EMEA_InternalCandidateAddress.noNulls(cand.getPreAddress())).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = EMEA_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp);
        }
        return buff.toString().trim();
    }

    public String getAliasedLocality() {
        return this.m_aliasedLocality;
    }

    public void setAliasedLocality(String loc) {
        this.m_aliasedLocality = loc;
    }

    protected String getCompleteFormattedStreetAddress() {
        StringBuffer buf = new StringBuffer();
        String foramttedMainAddressString = this.getFormattedStreetAddress();
        buf.append(foramttedMainAddressString);
        if (this.m_adjustS4) {
            buf.append(" " + this.getInputNumber().getCombinedAddressNumber());
        } else if (this.getAddressNumber() != null && this.getAddressNumber().length() != 0) {
            buf.append(" " + this.getAddressNumber());
        }
        return buf.toString();
    }
}

