/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.EMEA.dp;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoAliasKeyCreator;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import java.util.HashMap;
import java.util.Properties;

public abstract class EMEA_GeoInfoDataSourceRecordConvertorImpl
extends GeoInfoDataSourceRecordConvertorImpl {
    public static final int FLAG_DONTCARE = 0;
    public static final int FLAG_TOWN = 1;
    public static final int FLAG_LOCALITY = 2;
    public static final int FLAG_ALIAS = 3;
    private static HashMap m_aliasKeyMap;

    public EMEA_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
        m_aliasKeyMap = new HashMap();
    }

    public MMJGeoInfoRecord convert(IDataSourceRecord inputData, EMEA_GeoInfoRecord baseRecord) throws DataCreationException {
        String region = null;
        String province = null;
        String areaName3 = null;
        String languageAlias = null;
        String additionalLocality = null;
        String postCode = null;
        String locality = null;
        int flag = -1;
        if (inputData == null) {
            if (this.hasNextDataRecord()) {
                return (MMJGeoInfoRecord)this.getNextDataRecord();
            }
            return null;
        }
        IGeoInfoDataSourceRecord input = (IGeoInfoDataSourceRecord)inputData;
        try {
            if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
                areaName3 = input.getAreaName3();
            }
            if (input.hasAlternateAreaName3() && this.stringExists(input.getAlternateAreaName3())) {
                languageAlias = input.getAlternateAreaName3();
            }
            if (input.hasAreaName4() && this.stringExists(input.getAreaName4())) {
                locality = input.getAreaName4();
            }
            if (input.hasAlternateAreaName4() && this.stringExists(input.getAlternateAreaName4())) {
                additionalLocality = input.getAlternateAreaName4();
            }
            if (input.hasAlternateAreaName2() && this.stringExists(input.getAlternateAreaName2())) {
                postCode = input.getAlternateAreaName2();
            }
            if (areaName3 != null && additionalLocality != null && areaName3.equalsIgnoreCase(additionalLocality)) {
                additionalLocality = null;
            }
            if (input.hasAreaName2() && this.stringExists(input.getAreaName2())) {
                province = input.getAreaName2();
            }
            if (input.hasAreaName1() && this.stringExists(input.getAreaName1())) {
                region = input.getAreaName1();
            }
            if (input.hasPrecision()) {
                flag = input.getPrecision();
            }
            if (areaName3 != null) {
                if (province != null && province.trim().length() > 0) {
                    baseRecord.setAreaName2(province.trim());
                }
                if (region != null && region.trim().length() > 0) {
                    baseRecord.setAreaName1(region.trim());
                }
                baseRecord.setAreaName3(areaName3.trim());
                if (languageAlias != null) {
                    baseRecord.setAltLanguageNames(languageAlias);
                }
                if (locality != null && locality.trim().length() > 0) {
                    baseRecord.setAreaName4(locality.trim());
                }
                if (additionalLocality != null && additionalLocality.trim().length() > 0) {
                    baseRecord.setAliasedLocality(additionalLocality);
                }
                if (input.hasCentroid()) {
                    baseRecord.setPoint(input.getCentroid());
                }
                MiStringIndexKey key = null;
                switch (flag) {
                    case 0: {
                        baseRecord.setPrecision((byte)0);
                        String combinedKey = baseRecord.getAreaName4() == null ? "" : baseRecord.getAreaName4();
                        combinedKey = combinedKey + (baseRecord.getAreaName3() == null ? "" : baseRecord.getAreaName3());
                        combinedKey = combinedKey + (baseRecord.getAreaName2() == null ? "" : baseRecord.getAreaName2());
                        combinedKey = combinedKey + (baseRecord.getAreaName1() == null ? "" : baseRecord.getAreaName1());
                        key = new MiStringIndexKey(this.getGeoInfoAliasKey(combinedKey));
                        break;
                    }
                    case 3: {
                        baseRecord.setPrecision((byte)0);
                        key = new MiStringIndexKey(this.getGeoInfoAliasKey(EMEA_GeoInfoAliasKeyCreator.createKey(areaName3, postCode)));
                        break;
                    }
                    case 1: {
                        baseRecord.setPrecision((byte)10);
                        key = new MiStringIndexKey(this.getGeoInfoAliasKey(areaName3));
                        break;
                    }
                    case 2: {
                        baseRecord.setPrecision((byte)11);
                        key = new MiStringIndexKey(this.getGeoInfoAliasKey(areaName3));
                    }
                }
                return new MMJGeoInfoRecord((GeoInfoRecord)baseRecord, key);
            }
        }
        catch (DataSourceException DSEx) {
            throw new DataCreationException(301, (Throwable)DSEx);
        }
        return null;
    }

    protected String getGeoInfoAliasKey(String key) {
        Integer nItem = (Integer)m_aliasKeyMap.get(key);
        int nextIndexNumber = 0;
        if (nItem != null) {
            nextIndexNumber = nItem;
        }
        String properAliasKey = nextIndexNumber + key;
        m_aliasKeyMap.put(key, new Integer(nextIndexNumber + 1));
        return properAliasKey;
    }

    protected GeoInfoRecord makeGeoInfoRecordType() {
        return new EMEA_GeoInfoRecord();
    }
}

