/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.FIN.FIN_InternalCandidateAddress;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;

public class FIN_InternalBrowseAddress
extends InternalBrowseAddress {
    private StreetBasedIdentifier m_identifier = null;
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";

    public FIN_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        Segment segment = this.getSegmentAt(0);
        candidate.setAreaName1(segment.getLeftAreaName1());
        candidate.setAreaName2(segment.getLeftAreaName2());
        candidate.setAreaName3(segment.getLeftAreaName3());
        candidate.setAreaName4(segment.getLeftAreaName4());
        candidate.setPostCode1(segment.getLeftPostCode1());
        candidate.setFormattedStreetAddress(StringUtilities.toProperCase((String)candidate.getFormattedStreetAddress()));
        candidate.setPreAddress(FIN_InternalCandidateAddress.getFormattedPreAddress((Address)this));
        candidate.setAdditionalFields(null);
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        return candidate;
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    public static String getFormattedPreAddress(Address cand) {
        StringBuffer buff = new StringBuffer();
        String tmp = FIN_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_COMMON));
        if (tmp.length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = FIN_InternalBrowseAddress.noNulls(cand.getPreAddress())).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = FIN_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp);
        }
        return buff.toString().trim();
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    protected String getFormattedStreetAddress() {
        String postAddr;
        String postTT;
        String newMainAddress;
        String preMainAddrCommon;
        HashMap fields = this.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String properStreet = this.getGenericField4();
        if (properStreet != null && properStreet.length() != 0) {
            String postTT2 = this.getPostThoroughfareType();
            if (postTT2 != null && postTT2.length() != 0) {
                String properStreetNoExChar = FIN_AddressTerm.replaceExtendedChars(properStreet).toUpperCase();
                int index = properStreetNoExChar.lastIndexOf(postTT2.toUpperCase());
                if (index > 0) {
                    char c = properStreet.charAt(index - 1);
                    if (c == ' ') {
                        buf.append(properStreet.substring(0, index - 1));
                    } else {
                        buf.append(properStreet.substring(0, index));
                    }
                    buf.append(properStreet.substring(index));
                } else {
                    buf.append(properStreet);
                }
            } else {
                buf.append(properStreet);
            }
            return StringUtilities.toProperCase((String)buf.toString());
        }
        String addrStart = (String)fields.get("address.start");
        addrStart = addrStart == null ? " " : addrStart;
        String postStrTypeCommon = (String)fields.get(POST_STREET_TYPE_COMMON);
        postStrTypeCommon = postStrTypeCommon == null ? " " : postStrTypeCommon;
        String preAddress = this.getPreAddress();
        if (preAddress != null && preAddress.length() != 0) {
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainAddrCommon = (String)fields.get(PRE_MAIN_ADDRESS_COMMON)) != null && preMainAddrCommon.length() != 0) {
            buf.append(preMainAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((newMainAddress = this.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress);
        }
        if ((postTT = this.getPostThoroughfareType()) != null && postTT.length() != 0) {
            buf.append(postTT);
        }
        if (buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postAddr = this.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        return StringUtilities.toProperCase((String)buf.toString().trim());
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

