/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalCandidateAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_DataManager;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.user.IResponseCandidate;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.DebugLevel;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.StringTokenizer;

public class FIN_InternalCandidateAddress
extends EMEA_InternalCandidateAddress {
    private int m_numAddrNumberFields = 0;
    private int m_numAddrNumberFieldsMatched = 0;
    private String m_addressNumber = null;
    public static int MATCH_NONE = 0;
    public static int MATCH_FIRST = 1;
    public static int MATCH_SECOND = 2;
    public static int MATCH_BOTH_DIFFERENT = 3;
    public static int MATCH_BOTH = 4;
    private static final double EXACT_CLOSE_MATCH_SCORE = 1.0;
    private int m_matchType = MATCH_NONE;
    protected static StringScorer plainScorer = new StringScorer(false, new Locale("fi", "FI"));
    private static ItemsCachedScore[] m_scoreCache = new ItemsCachedScore[20];
    private static final int MAX_SCORE_CACHE = 20;
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String POST_STREET_TYPE_SEPARATOR = "address.separator.post.st_type";

    public FIN_InternalCandidateAddress() {
    }

    public FIN_InternalCandidateAddress(Address addr) {
        super(addr);
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        CandidateAddress candidate = this.constructCandidateAddress(input, constraints);
        String matchedNumber = input.getAddressNumber();
        if (matchedNumber != null && matchedNumber.length() > 0) {
            StringTokenizer st = new StringTokenizer(matchedNumber, "-/");
            if (st != null && st.countTokens() > 1) {
                if (this.m_matchType == MATCH_BOTH || this.m_matchType == MATCH_BOTH_DIFFERENT || this.m_matchType == MATCH_FIRST) {
                    matchedNumber = st.nextToken();
                } else if (this.m_matchType == MATCH_SECOND && st.hasMoreTokens()) {
                    matchedNumber = st.nextToken();
                }
            }
            Range range = null;
            if (this.hasMatchingRange()) {
                range = (Range)this.getSegment().getRanges(this.getSegmentSide()).get(this.getMatchedRangeNumber());
            }
            if (range != null) {
                // empty if block
            }
        }
        candidate.setMainAddress(this.getFormattedStreetAddressWithoutType());
        String alisedLocality = this.getAliasedLocality();
        if (alisedLocality != null) {
            candidate.setAreaName4(alisedLocality);
        }
        this.performCandidateFieldCleanUp((IResponseCandidate)candidate);
        if (candidate.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidate.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
            candidate.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        this.populateSegmentId((Address)candidate);
        candidate.addKeyValueToAdditionalFields("INPUT_MATCH_SCORE", String.valueOf(this.inputMatchScore));
        return candidate;
    }

    @Override
    public String getPostCode1() {
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftPostCode1();
            String right = segment.getRightPostCode1();
            if (left != null && right != null && left.equals(right)) {
                postCode1 = left;
            }
        }
        return postCode1;
    }

    @Override
    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName3();
            String right = segment.getRightAreaName3();
            if (left != null && right != null && left.equals(right)) {
                areaName3 = left;
            }
        }
        return areaName3;
    }

    @Override
    public String getAreaName2() {
        String areaName2 = null;
        Segment segment = this.getSegment();
        if (segment != null) {
            String left = segment.getLeftAreaName2();
            String right = segment.getRightAreaName2();
            if (left != null && right != null && left.equals(right)) {
                areaName2 = left;
            }
        }
        return areaName2;
    }

    @Override
    public String getAltAreaName3() {
        GeoInfoRecord record;
        String result = null;
        Segment segment = this.getSegment();
        if (segment != null && (record = segment.getGeoInfoRecord()) != null) {
            result = record.getAltAreaName3();
        }
        if (result == null || result.trim().length() == 0) {
            return null;
        }
        return result.trim();
    }

    @Override
    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName1();
            String right = segment.getRightAreaName1();
            if (left != null && right != null && left.equals(right)) {
                areaName1 = left;
            }
        }
        return areaName1;
    }

    public void computeScores(ScoringAddress parsedAddress, String charsToIgnore) {
        super.computeScores(parsedAddress, charsToIgnore);
        this.scoreAdditionalParserFields(parsedAddress);
    }

    public void scoreAddressNumber(ScoringAddress parsedAddress) {
        String addressNumber;
        int secondMatchedRange = -1;
        int secondSegmentSide = -1;
        ParsedNumber secondNumber = null;
        String firstAddressNumber = addressNumber = parsedAddress.getAddressNumber();
        String secondAddressNumber = null;
        if (addressNumber != null) {
            StringTokenizer st = new StringTokenizer(addressNumber, "-/ ");
            if (st.countTokens() > 1) {
                firstAddressNumber = st.nextToken();
                ParsedNumber parsedNumber = new ParsedNumber(firstAddressNumber);
                if (parsedNumber.getAddressNumberExists()) {
                    firstAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                }
                while (st.hasMoreTokens() && (secondAddressNumber = st.nextToken()) != null) {
                    parsedNumber = new ParsedNumber(secondAddressNumber);
                    if (parsedNumber.getAddressNumberExists()) {
                        secondAddressNumber = Long.toString(parsedNumber.getAddressNumber());
                        break;
                    }
                    secondAddressNumber = null;
                }
            }
            if (secondAddressNumber != null) {
                parsedAddress.setAddressNumber(secondAddressNumber);
                super.scoreAddressNumber(parsedAddress);
                this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                    this.m_matchType = MATCH_SECOND;
                    secondMatchedRange = this.getMatchedRangeNumber();
                    secondSegmentSide = this.getSegmentSide();
                    secondNumber = this.getInputNumber();
                    this.setCntAddressNumberFieldsMatched(0);
                }
                this.setInputNumber(null);
                this.setMatchedRangeNumber(-1);
                this.setSegmentSide(-1);
                this.setClosestRange(-1);
                super.setClosestSegmentSide(-1);
                this.setMatchingFlag(0);
            }
        }
        parsedAddress.setAddressNumber(firstAddressNumber);
        super.scoreAddressNumber(parsedAddress);
        if (this.getInputNumber() != null) {
            this.m_numAddrNumberFields += this.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == MATCH_SECOND) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = MATCH_BOTH;
                        this.m_addressNumber = firstAddressNumber;
                    } else {
                        this.m_matchType = MATCH_BOTH_DIFFERENT;
                        this.m_addressNumber = firstAddressNumber;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = MATCH_FIRST;
                }
            }
            if (this.m_matchType == MATCH_SECOND) {
                this.setInputNumber(secondNumber);
                this.setMatchedRangeNumber(secondMatchedRange);
                this.setSegmentSide(secondSegmentSide);
                this.m_addressNumber = secondAddressNumber;
            }
            parsedAddress.setAddressNumber(addressNumber);
        }
        if (this.getInputNumber() == null || this.m_numAddrNumberFields == 0) {
            this.setAddressNumberScore(0.0);
        } else {
            this.setAddressNumberScore((double)this.m_numAddrNumberFieldsMatched / (double)this.m_numAddrNumberFields);
        }
    }

    @Override
    public String getAddressNumber() {
        if (this.m_addressNumber != null) {
            return this.m_addressNumber;
        }
        return super.getAddressNumber();
    }

    public String getFormattedStreetAddressWithoutType() {
        String unparsedAddress = this.getGenericField1();
        if (unparsedAddress != null && unparsedAddress.length() > 0) {
            return unparsedAddress;
        }
        FIN_InternalCandidateAddress cand = this;
        StringBuffer buff = new StringBuffer();
        String tmp = FIN_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(ADDRESS_START));
        if (tmp.length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FIN_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_COMMON))).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FIN_InternalCandidateAddress.noNulls(this.getPreAddress())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FIN_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FIN_InternalCandidateAddress.noNulls(cand.getMainAddress())).length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = FIN_InternalCandidateAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_SEPARATOR))).equalsIgnoreCase("true") && buff.charAt(buff.length() - 1) != '-') {
            buff.append(" ");
        }
        return buff.toString();
    }

    @Override
    public String getFormattedStreetAddress() {
        String postAddr;
        String postTT;
        String newMainAddress;
        String preMainAddrCommon;
        String unparsedAddress = this.getGenericField1();
        if (unparsedAddress != null && unparsedAddress.length() > 0) {
            return unparsedAddress;
        }
        HashMap fields = this.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String properStreet = this.getGenericField4();
        if (properStreet != null && properStreet.length() != 0) {
            String postTT2 = this.getPostThoroughfareType();
            if (postTT2 != null && postTT2.length() != 0) {
                String properStreetNoExChar = FIN_AddressTerm.replaceExtendedChars(properStreet).toUpperCase();
                int index = properStreetNoExChar.lastIndexOf(postTT2.toUpperCase());
                if (index > 0) {
                    char c = properStreet.charAt(index - 1);
                    if (c == ' ') {
                        buf.append(properStreet.substring(0, index - 1));
                    } else {
                        buf.append(properStreet.substring(0, index));
                    }
                    buf.append(properStreet.substring(index));
                } else {
                    buf.append(properStreet);
                }
            } else {
                buf.append(properStreet);
            }
            if (this.getAddressNumber() != null && this.getAddressNumber().length() != 0) {
                buf.append(" " + this.getAddressNumber());
            }
            return StringUtilities.toProperCase((String)buf.toString());
        }
        String addrStart = (String)fields.get(ADDRESS_START);
        addrStart = addrStart == null ? " " : addrStart;
        String postStrTypeCommon = (String)fields.get(POST_STREET_TYPE_COMMON);
        postStrTypeCommon = postStrTypeCommon == null ? " " : postStrTypeCommon;
        String preAddress = this.getPreAddress();
        if (preAddress != null && preAddress.length() != 0) {
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainAddrCommon = (String)fields.get(PRE_MAIN_ADDRESS_COMMON)) != null && preMainAddrCommon.length() != 0) {
            buf.append(preMainAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((newMainAddress = this.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress);
        }
        if ((postTT = this.getPostThoroughfareType()) != null && postTT.length() != 0) {
            buf.append(postTT);
        }
        if (buf.length() > 0 && buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postAddr = this.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (this.m_adjustS4) {
            buf.append(this.getInputNumber().getCombinedAddressNumber());
        } else if (this.getAddressNumber() != null && this.getAddressNumber().length() != 0) {
            buf.append(this.getAddressNumber());
        }
        return StringUtilities.toProperCase((String)buf.toString().trim());
    }

    public static String reconstructAddress(InternalCandidateAddress addr, boolean bAppendAddressNumber) {
        String addrNum;
        String postAddr;
        String postTT;
        String postStrTypeSep;
        String newMainAddress;
        String preMainAddrCommon;
        HashMap fields = addr.getAdditionalFields();
        StringBuffer buf = new StringBuffer(100);
        String properStreet = addr.getGenericField4();
        if (properStreet != null && properStreet.length() != 0) {
            return properStreet;
        }
        String addrStart = (String)fields.get(ADDRESS_START);
        addrStart = addrStart == null ? " " : addrStart;
        String postStrTypeCommon = (String)fields.get(POST_STREET_TYPE_COMMON);
        postStrTypeCommon = postStrTypeCommon == null ? " " : postStrTypeCommon;
        String preAddress = addr.getPreAddress();
        if (preAddress != null && preAddress.length() != 0) {
            buf.append(preAddress);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((preMainAddrCommon = (String)fields.get(PRE_MAIN_ADDRESS_COMMON)) != null && preMainAddrCommon.length() != 0) {
            buf.append(preMainAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if ((newMainAddress = addr.getMainAddress()) != null && newMainAddress.length() != 0) {
            buf.append(newMainAddress);
        }
        if ((postStrTypeSep = (String)fields.get(POST_STREET_TYPE_SEPARATOR)) != null && buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postTT = addr.getPostThoroughfareType()) != null && postTT.length() != 0) {
            buf.append(postTT);
        }
        if (buf.charAt(buf.length() - 1) != '-') {
            buf.append(' ');
        }
        if ((postAddr = addr.getPostAddress()) != null && postAddr.length() != 0) {
            buf.append(postAddr);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (bAppendAddressNumber && (addrNum = addr.getAddressNumber()) != null && addrNum.length() != 0) {
            if (buf.length() > 0 && buf.charAt(buf.length() - 1) != ' ') {
                buf.append(' ');
            }
            buf.append(addrNum);
        }
        return buf.toString().trim();
    }

    public void scoreAdditionalParserFields(ScoringAddress parsedAddress) {
        String cand_pre_main_addr_common = (String)this.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        String cand_address_start = (String)this.getAdditionalFields().get(ADDRESS_START);
        String cand_address_end = (String)this.getAdditionalFields().get(ADDRESS_END);
        String cand_post_street_type_common = (String)this.getAdditionalFields().get(POST_STREET_TYPE_COMMON);
        EMEA_ScoringAddress input = (EMEA_ScoringAddress)parsedAddress;
        String input_pre_main_addr = (String)input.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON);
        String input_post_street_type_common = (String)input.getAdditionalFields().get(POST_STREET_TYPE_COMMON);
        String input_address_start = (String)input.getAdditionalFields().get(ADDRESS_START);
        String input_address_end = (String)input.getAdditionalFields().get(ADDRESS_END);
        double pre_main_addr_score = input.scoreItems(cand_pre_main_addr_common, input_pre_main_addr);
        double post_street_type_common_score = input.scoreItems(cand_post_street_type_common, input_post_street_type_common);
        double address_start_score = input.scoreItems(cand_address_start, input_address_start);
        double address_end_score = input.scoreItems(cand_address_end, input_address_end);
        double score = pre_main_addr_score + post_street_type_common_score + address_start_score + address_end_score;
        this.setAdditionalParserFieldsScore(score);
    }

    public int compareTo(Object o2) {
        double score2;
        FIN_InternalCandidateAddress cand2 = (FIN_InternalCandidateAddress)((Object)o2);
        if (this.equals((Object)cand2)) {
            return 0;
        }
        boolean bthisMatch = this.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bthisMatch && bCand2Match) {
            return -1;
        }
        if (bthisMatch && !bCand2Match) {
            return 1;
        }
        bthisMatch = this.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bthisMatch && bCand2Match) {
            return -1;
        }
        if (bthisMatch && !bCand2Match) {
            return 1;
        }
        double score1 = this.getCombinedAddressScore();
        if (score1 == (score2 = cand2.getCombinedAddressScore())) {
            score1 = this.getMainAddressScore();
            if (score1 < (score2 = cand2.getMainAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPreThoroughfareTypeScore();
            score2 = cand2.getPreThoroughfareTypeScore();
            if (score2 > score1) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostThoroughfareTypeScore();
            score2 = cand2.getPostThoroughfareTypeScore();
            if (score2 > score1) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostAddressScore();
            if (score1 < (score2 = cand2.getPostAddressScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getCombinedAdditionalFieldScore();
            if (score1 < (score2 = cand2.getCombinedAdditionalFieldScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getAreaName3Score();
            if (score1 < (score2 = cand2.getAreaName3Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getPostCode1Score();
            if (score1 < (score2 = cand2.getPostCode1Score())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            score1 = this.getAddressNumberScore();
            if (score1 < (score2 = cand2.getAddressNumberScore())) {
                return -1;
            }
            if (score1 > score2) {
                return 1;
            }
            if (score1 != 1.0 && score2 != 1.0) {
                if (this.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range thisClosest = this.getSegment().getRangeAt(this.getClosestRangeNumber(), this.getClosestSegmentSide());
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                    long thisOffset = thisClosest.getRangeOffset();
                    if (thisOffset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (thisOffset > cand2Offset) {
                        return -1;
                    }
                } else {
                    if (this.hasClosestRange()) {
                        return 1;
                    }
                    if (cand2.hasClosestRange()) {
                        return -1;
                    }
                }
            }
        } else {
            if (score1 < score2) {
                return -1;
            }
            return 1;
        }
        return 0;
    }

    public void setAreaNameScore(int area, double score) {
        switch (area) {
            case 1: {
                this.setAreaName1Score(score);
                break;
            }
            case 2: {
                this.setAreaName2Score(score);
                break;
            }
            case 3: {
                this.setAreaName3Score(score);
                break;
            }
            case 4: {
                this.setAreaName4Score(score);
                break;
            }
        }
    }

    public void scoreAreaNames(ScoringAddress parsedAddress) {
        double score = 0.0;
        String[] parsedAreas = new String[]{null, parsedAddress.getAreaName1(), parsedAddress.getAreaName2(), parsedAddress.getAreaName3(), parsedAddress.getAreaName4()};
        int numOfParsedAreas = 0;
        double[] scores = new double[]{0.0, 0.0, 0.0, 0.0, 0.0};
        double highScore = 0.0;
        for (int i = 1; i <= 4; ++i) {
            if (parsedAreas[i] == null || parsedAreas[i].trim().length() <= 0) continue;
            parsedAreas[i] = parsedAreas[i].toUpperCase();
            ++numOfParsedAreas;
        }
        EMEA_ScoringAddress scorer = (EMEA_ScoringAddress)parsedAddress;
        String areaName3 = this.getAreaName3();
        if (areaName3 != null) {
            areaName3 = areaName3.toUpperCase();
        }
        highScore = scorer.scoreItems(parsedAreas[3], areaName3);
        String pStr = null;
        if (parsedAreas[3] != null) {
            pStr = FIN_AddressTerm.replaceExtendedChars(parsedAreas[3].toString());
        }
        String cStr = FIN_AddressTerm.replaceExtendedChars(this.getAreaName3());
        if (parsedAreas[3] != null && pStr.charAt(0) != cStr.charAt(0)) {
            highScore -= 0.01;
        }
        if (highScore != 1.0 && (score = scorer.scoreItems(parsedAreas[3], this.getAreaName4() != null ? this.getAreaName4().toUpperCase() : null)) == 1.0) {
            highScore = score;
        }
        this.scoreAltAreaName3(parsedAreas[3], 3, highScore, scorer);
        scores[3] = highScore;
        this.setAreaName1Score(scorer.scoreItems(parsedAreas[1], this.getAreaName1() != null ? this.getAreaName1().toUpperCase() : null));
        scores[1] = this.getAreaName1Score();
        this.setAreaName2Score(scorer.scoreItems(parsedAreas[2], this.getAreaName2() != null ? this.getAreaName2().toUpperCase() : null));
        scores[2] = this.getAreaName2Score();
        int exactMatchedAreas = this.getNumberExactMatchedAreas(parsedAreas);
        boolean alternativeLookup = false;
        if ((this.getAliasedLocality() == null || this.getAliasedLocality().length() == 0) && exactMatchedAreas < numOfParsedAreas) {
            alternativeLookup = true;
        }
        if (alternativeLookup) {
            EMEA_GeoInfoRecord geoRecord = null;
            double geoInfoHighScore = scores[3];
            String bestArea = null;
            ArrayList geoInfoRecordArray = FIN_DataManager.getGeoInfoAlias(FIN_AddressTerm.removeDiacritics(this.getAreaName3().toUpperCase()), FIN_ParsePostAddressRule.getOutwardSortingCode(this.getPostCode1()), 0);
            String recordTown = null;
            for (int n = 0; n < geoInfoRecordArray.size(); ++n) {
                geoRecord = (EMEA_GeoInfoRecord)((Object)geoInfoRecordArray.get(n));
                recordTown = this.getGeoInfoAreaName(4, geoRecord);
                double geoInfoScore = scorer.scoreItems(parsedAreas[3], recordTown != null ? recordTown.toUpperCase() : null);
                if (!(geoInfoScore > geoInfoHighScore)) continue;
                geoInfoHighScore = geoInfoScore;
                bestArea = recordTown;
                if (geoInfoScore == 1.0) break;
            }
            if (bestArea != null && bestArea.length() > 0) {
                this.setAliasedLocality(bestArea);
                this.setAreaName3Score(geoInfoHighScore);
            }
        }
    }

    public void scoreAltAreaName3(String parsedAreaName, int AreaNameToScore, double highscore, ScoringAddress scorer) {
        String altAreaName3 = this.getAltAreaName3();
        if (highscore != 1.0 && altAreaName3 != null) {
            StringTokenizer tokens = new StringTokenizer(altAreaName3, "/", false);
            String altAreaName3Tokens = null;
            while (tokens.hasMoreTokens()) {
                altAreaName3Tokens = tokens.nextToken().toUpperCase();
                double tempScore = ((EMEA_ScoringAddress)scorer).scoreItems(altAreaName3Tokens, parsedAreaName);
                if (!(tempScore > highscore)) continue;
                highscore = tempScore;
            }
        }
        this.setAreaNameScore(AreaNameToScore, highscore);
    }

    protected int getNumberExactMatchedAreas(String[] parsedAreaNames) {
        int matches = 0;
        if (this.getAreaName1Score() == 1.0 && parsedAreaNames[1] != null) {
            ++matches;
        }
        if (this.getAreaName2Score() == 1.0 && parsedAreaNames[2] != null) {
            ++matches;
        }
        if (this.getAreaName3Score() == 1.0 && parsedAreaNames[3] != null) {
            ++matches;
        }
        if (this.getAreaName4Score() == 1.0 && parsedAreaNames[4] != null) {
            ++matches;
        }
        return matches;
    }

    public String getGeoInfoAreaName(int area, GeoInfoRecord geoRecord) {
        switch (area) {
            case 1: {
                return geoRecord.getAreaName1();
            }
            case 2: {
                return geoRecord.getAreaName2();
            }
            case 3: {
                return geoRecord.getAreaName3();
            }
            case 4: {
                return geoRecord.getAreaName4();
            }
        }
        return null;
    }

    private CandidateAddress constructCandidateAddress(Address input, IConstraints constraints) {
        boolean bPostTypeMatched;
        boolean bPostDirMatched;
        int debugLevel = DebugLevel.getDebugLevel((int)1);
        ResourceBundle errorBundle = this.loadResourceBundleForLocale(constraints.getClientLocale());
        if (this.fieldExists(input.getPostCode1()) && this.getPostCode1Score() == 1.0 && (constraints.isMustMatchInput() || constraints.isMustMatchPostalCode()) && input.getGenericField1() != null && StringUtilities.isNumeric((String)input.getGenericField1()) && input.getGenericField1().endsWith("1")) {
            this.setCloseMatchFlag(false);
        }
        CandidateAddress candidate = new CandidateAddress((Address)this);
        candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
        candidate.setFormattedLocationAddress(this.getFormattedLocationAddress());
        candidate.setSourceStreetID(this.getStreetOffset());
        if (this.fromUserDictionary()) {
            candidate.setFromUserDictionary();
        }
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        ParsedNumber num = new ParsedNumber(input.getAddressNumber());
        ParsedNumber unitNum = new ParsedNumber(input.getUnitValue());
        if (!num.isEmpty() && this.getAddressNumberScore() == 1.0 || num.isEmpty()) {
            candidate.setAddressNumberMatched();
        }
        if (this.getPostAddressScore() == 1.0 && this.getPreAddressScore() == 1.0) {
            candidate.setStreetPrefixAndSuffixMatched();
        }
        boolean bPreDirMatched = this.getAdditionalParserFieldsScore() == 4.0;
        boolean bl = bPostDirMatched = this.getAdditionalParserFieldsScore() == 4.0;
        if (bPreDirMatched) {
            candidate.setPreDirectionalMatched();
        }
        if (bPostDirMatched) {
            candidate.setPostDirectionalMatched();
        }
        boolean bPreTypeMatched = this.getPreThoroughfareTypeScore() == 1.0;
        boolean bl2 = bPostTypeMatched = this.getPostThoroughfareTypeScore() == 1.0;
        if (bPreTypeMatched && bPostTypeMatched) {
            candidate.setThoroughfareTypeMatched();
        }
        if (this.fieldExists(input.getPostCode1()) && this.getPostCode1Score() == 1.0 && (input.getGenericField1() == null || !StringUtilities.isNumeric((String)input.getGenericField1()))) {
            candidate.setPostalCode1Matched();
        }
        if (this.fieldExists(input.getPostCode2()) && this.getPostCode2Score() == 1.0) {
            candidate.setPostalCode2Matched();
        }
        if (this.fieldExists(input.getAreaName1()) && this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (this.fieldExists(input.getAreaName2()) && this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (this.fieldExists(input.getAreaName3()) && this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.fieldExists(input.getAreaName4()) && this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.fieldExists(input.getPlaceName()) && this.getPlaceNameScore() == 1.0) {
            candidate.setPlaceNameMatched();
        }
        if (this.fieldExists(input.getMainAddress()) && this.getMainAddressScore() == 1.0) {
            candidate.setStreetNameMatched();
        }
        this.setGeocodedPoint(candidate, debugLevel, constraints, errorBundle);
        int maxRanges = constraints.getMaxRanges();
        candidate.setNumberOfReturnableRanges(maxRanges);
        if (maxRanges != 0) {
            CandidateRange candRange;
            int i;
            Segment segment = this.getSegment();
            int numLeftRanges = segment.getRangeCount(0);
            int numRightRanges = segment.getRangeCount(1);
            Range range = null;
            for (i = 0; i < numLeftRanges; ++i) {
                range = segment.getRangeAt(i, 0);
                candRange = range.toCandidateRange(num, 1, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
            for (i = 0; i < numRightRanges; ++i) {
                range = segment.getRangeAt(i, 1);
                candRange = range.toCandidateRange(num, 2, unitNum, constraints);
                candidate.addCandidateRange(candRange);
            }
        }
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        return candidate;
    }

    public void scorePostalInformation(ScoringAddress parsedAddress) {
        double score = this.scoreItems(this.getPostCode1(), parsedAddress.getPostCode1(), plainScorer);
        if (score != 1.0 && parsedAddress.getPostCode1() != null && FIN_ParsePostAddressRule.getPostCodeType(parsedAddress.getPostCode1()) == 4) {
            String pc = parsedAddress.getPostCode1();
            if (pc != null && pc.length() < 5 && pc.charAt(0) != '0') {
                pc = '0' + pc;
            }
            score = this.scoreItems(this.getPostCode1(), pc, plainScorer);
        }
        this.setPostCode1Score(score);
        this.setPostCode2Score(1.0);
    }

    public String getFormattedLocationAddress() {
        int len;
        StringBuffer str = new StringBuffer();
        String tmp = this.getPostCode1();
        if (tmp != null) {
            str.append(tmp);
            str.append("  ");
        }
        if ((tmp = this.getPostCode2()) != null) {
            str.append(tmp);
            str.append("  ");
        }
        if ((tmp = this.getAreaName3()) != null) {
            str.append(tmp);
            str.append(" ");
        }
        if ((len = str.length()) != 0) {
            str.deleteCharAt(len - 1);
        }
        return str.toString();
    }

    private ItemsCachedScore findCachedScore(String item1, String item2) {
        for (int i = 0; i < 20; ++i) {
            ItemsCachedScore cachedScore = m_scoreCache[i];
            if (cachedScore == null) {
                return null;
            }
            if (!cachedScore.equalItems(item1, item2)) continue;
            return cachedScore;
        }
        return null;
    }

    private void addIntoScoreCache(String item1, String item2, double score) {
        ItemsCachedScore cachedScore = new ItemsCachedScore(item1, item2, score);
        for (int i = 18; i >= 0; --i) {
            FIN_InternalCandidateAddress.m_scoreCache[i + 1] = m_scoreCache[i];
        }
        FIN_InternalCandidateAddress.m_scoreCache[0] = cachedScore;
    }

    private double scoreItems(String item1, String item2, StringScorer scorer) {
        return this.scoreItems(item1, item2, this.getCharsToIgnore(), scorer);
    }

    private double scoreItems(String item1, String item2, String charsToIgnore, StringScorer scorer) {
        double score = 0.0;
        if (item1 != null && item2 != null) {
            ItemsCachedScore cachedScore = this.findCachedScore(item1, item2);
            if (cachedScore != null) {
                score = cachedScore.getScore();
            } else {
                score = scorer.scoreString(item1, item2, charsToIgnore);
                this.addIntoScoreCache(item1, item2, score);
            }
        } else {
            score = scorer.scoreString(item1, item2, charsToIgnore);
        }
        return score;
    }

    private void performCandidateFieldCleanUp(IResponseCandidate candidateAddress) {
        HashMap map = candidateAddress.getAdditionalFields();
        candidateAddress.setGenericField1(null);
        candidateAddress.setGenericField2(null);
        candidateAddress.setGenericField3(null);
        candidateAddress.setGenericField4(null);
        candidateAddress.setPreThoroughfareType(null);
        candidateAddress.setPreAddress(null);
        if (map != null) {
            map.remove(ADDRESS_START);
            map.remove(ADDRESS_END);
            map.remove(PRE_MAIN_ADDRESS_COMMON);
            map.remove(POST_STREET_TYPE_COMMON);
            map.remove("input_house_number");
            map.remove("unparsed_input_street");
        }
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        ReverseGeocodeCandidateAddress cand = super.toCandidateAddress(location, constraints);
        this.performCandidateFieldCleanUp((IResponseCandidate)cand);
        return cand;
    }

    class ItemsCachedScore {
        private double score;
        private String firstItem;
        private String secondItem;

        public ItemsCachedScore(String item1, String item2, double score) {
            this.firstItem = item1;
            this.secondItem = item2;
            this.score = score;
        }

        public double getScore() {
            return this.score;
        }

        public boolean equalItems(String item1, String item2) {
            return item1 != null && item1.equals(this.firstItem) && item2 != null && item2.equals(this.secondItem);
        }
    }
}

