/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.EMEA.EMEA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Locale;
import java.util.StringTokenizer;

public class FIN_InternalGeographicCandidate
extends EMEA_InternalGeographicCandidate {
    private String m_possibleLocality;
    private static final double LOCALITY_PERFECT_MATCHED_SCORE = 0.999999;
    private static final double EXACT_CLOSE_MATCH_SCORE = 1.0;

    public FIN_InternalGeographicCandidate() {
        StringBuffer buf = new StringBuffer();
        buf.append("& c ; \u00e7 ");
        buf.append("& n ; \u00f1 ");
        buf.append("& a ; \u00e0 , \u00e1 , \u00e4 , \u00e2 , \u00e3, \u00e5, ae ,\u00e4e");
        buf.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea ");
        buf.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef ");
        buf.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f6, \u00f5 ");
        buf.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc ");
        this.setStringScorer(new StringScorer(true, new Locale("fi", "FI"), buf.toString().toUpperCase()));
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        EMEA_GeoInfoRecord geoInfoRecord = (EMEA_GeoInfoRecord)this.getGeoInfoRecord();
        CandidateAddress candidate = new CandidateAddress();
        candidate.setAreaName1(this.getAreaName1());
        candidate.setAreaName2(this.getAreaName2());
        candidate.setAreaName3(this.getAreaName3());
        candidate.setAreaName4(this.getAreaName4());
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (inputAddress.getAreaName3() != null && this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        String areaName3 = this.getAreaName3();
        int precesion = this.getPrecision();
        String areaName4 = this.getAreaName4();
        if (areaName4 != null && precesion == 11) {
            candidate.setAreaName3(areaName4.toUpperCase());
            candidate.setAreaName4(geoInfoRecord.getAliasedLocality().toUpperCase());
        } else if (areaName3 != null) {
            candidate.setAreaName3(areaName3.toUpperCase());
        }
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (inputAddress.getAreaName1() != null && this.getAreaName1Score() == 1.0) {
            candidate.setAreaName1Matched();
        }
        if (inputAddress.getAreaName2() != null && this.getAreaName2Score() == 1.0) {
            candidate.setAreaName2Matched();
        }
        if (inputAddress.getAreaName3() != null && this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (inputAddress.getAreaName4() != null && this.getAreaName4Score() == 1.0) {
            candidate.setAreaName4Matched();
        }
        if (this.getAreaName3Score() == 1.0) {
            candidate.setAreaName3Matched();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getCentroid() != null) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)this.getCentroid()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        } else {
            candidate.setLocation(new DirectPosition());
        }
        candidate.setLocationPrecision(precesion);
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidate;
    }

    public String toString() {
        return "\nFIN_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreCandidate(Address parsedAddress, String charsToIgnore) {
        String[] parsed = new String[5];
        String[] areaNames = new String[3];
        parsed[0] = null;
        parsed[1] = parsedAddress.getAreaName1();
        parsed[2] = parsedAddress.getAreaName2();
        parsed[3] = parsedAddress.getAreaName3();
        for (int i = 0; i <= 4; ++i) {
            if (parsed[i] == null) continue;
            parsed[i] = parsed[i].toUpperCase();
        }
        String candAN3 = this.getAreaName3();
        String candAN4 = FIN_AddressTerm.removeCommonTerms(this.getAreaName4());
        areaNames[0] = null;
        areaNames[1] = this.getAreaName1();
        areaNames[2] = this.getAreaName2();
        StringScorer scorer = this.getStringScorer();
        for (int i = 1; i <= 4; ++i) {
            double secondScore;
            double firstScore;
            if (i <= 2) {
                firstScore = 0.0;
                secondScore = 0.0;
                firstScore = scorer.scoreString(parsed[i], areaNames[i], charsToIgnore);
                secondScore = scorer.scoreString(parsed[i], FIN_AddressTerm.removeCommonTerms(areaNames[i]), charsToIgnore);
                if (secondScore > firstScore) {
                    this.setAreaNameScore(i, secondScore);
                    continue;
                }
                this.setAreaNameScore(i, firstScore);
                continue;
            }
            firstScore = 0.0;
            secondScore = 0.0;
            firstScore = scorer.scoreString(parsed[i], candAN3.toUpperCase(), charsToIgnore);
            secondScore = scorer.scoreString(parsed[i], candAN4, charsToIgnore);
            if (secondScore > firstScore) {
                this.scoreAltAreaName3(parsed[i], i, secondScore, charsToIgnore);
                continue;
            }
            this.scoreAltAreaName3(parsed[i], i, firstScore, charsToIgnore);
        }
        this.scoreCountry(parsedAddress);
    }

    public boolean doesAreaName3PerfectMatched() {
        boolean flag = false;
        if (this.getAreaName3Score() == 1.0) {
            flag = true;
        } else if (this.m_possibleLocality != null && this.getAreaName3Score() == 0.999999) {
            flag = true;
        }
        return flag;
    }

    public void scoreAltAreaName3(String parsedAreaName, int AreaNameToScore, double highscore, String charsToIgnore) {
        GeoInfoRecord record = this.getGeoInfoRecord();
        if (record != null) {
            String altAreaName3 = ((EMEA_GeoInfoRecord)record).getAltLanguageNames();
            if (highscore != 1.0 && altAreaName3 != null) {
                StringTokenizer tokens = new StringTokenizer(altAreaName3, "/", false);
                while (tokens.hasMoreTokens()) {
                    String altAreaName3Token = tokens.nextToken().toUpperCase();
                    double tempScore = this.getStringScorer().scoreString(parsedAreaName, altAreaName3Token, charsToIgnore);
                    if (!(tempScore > highscore)) continue;
                    highscore = tempScore;
                }
            }
        }
        this.setAreaNameScore(AreaNameToScore, highscore);
    }
}

