/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.EMEA.EMEA_MatcherHandler;
import com.mapinfo.mapmarker.FIN.FIN_StreetMultipleSegmentComparator;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.InternalMatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.utils.StringUtilities;

public final class FIN_MatcherHandler
extends EMEA_MatcherHandler {
    public FIN_MatcherHandler() {
        this.setComparator(new FIN_StreetMultipleSegmentComparator());
    }

    public void computeMaximumAddressScore(Address parsedAddress, InternalMatcherConstants constants) {
        double maxScore = 0.0;
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        maxScore = this.fieldExists(parsedAddress.getPreThoroughfareType()) ? (maxScore += matchedConstants.getPreThoroughfareType()) : (maxScore += blankConstants.getPreThoroughfareType());
        maxScore = this.fieldExists(parsedAddress.getPreAddress()) ? (maxScore += matchedConstants.getPreAddress()) : (maxScore += blankConstants.getPreAddress());
        maxScore = this.fieldExists(parsedAddress.getMainAddress()) ? (maxScore += matchedConstants.getMainAddress()) : (maxScore += blankConstants.getMainAddress());
        maxScore = this.fieldExists(parsedAddress.getPostThoroughfareType()) ? (maxScore += matchedConstants.getPostThoroughfareType()) : (maxScore += blankConstants.getPostThoroughfareType());
        maxScore = this.fieldExists(parsedAddress.getPostAddress()) ? (maxScore += matchedConstants.getPostAddress()) : (maxScore += blankConstants.getPostAddress());
        if (parsedAddress.hasAdditionalFields()) {
            maxScore += matchedConstants.getAdditionalFields() * 2.0;
        }
        this.setMaximumAddressScore(maxScore);
    }

    @Override
    public void scoreCandidate(InternalCandidateAddress candidate, ScoringAddress scoringAddress, InternalMatcherConstants constants) {
        double score = 0.0;
        candidate.computeScores(scoringAddress, constants.getCharsToIgnore());
        FieldScores matchedConstants = constants.getMatched();
        FieldScores blankConstants = constants.getBlank();
        score = this.fieldExists(scoringAddress.getPreAddress()) || this.fieldExists(candidate.getPreAddress()) ? (score += matchedConstants.getPreAddress() * candidate.getPreAddressScore()) : (score += blankConstants.getPreAddress() * candidate.getPreAddressScore());
        score = this.fieldExists(scoringAddress.getMainAddress()) || this.fieldExists(candidate.getMainAddress()) ? (score += matchedConstants.getMainAddress() * candidate.getMainAddressScore()) : (score += blankConstants.getMainAddress() * candidate.getMainAddressScore());
        score = this.fieldExists(scoringAddress.getPostAddress()) || this.fieldExists(candidate.getPostAddress()) ? (score += matchedConstants.getPostAddress() * candidate.getPostAddressScore()) : (score += blankConstants.getPostAddress() * candidate.getPostAddressScore());
        score = this.fieldExists(scoringAddress.getPreThoroughfareType()) || this.fieldExists(candidate.getPreThoroughfareType()) ? (score += matchedConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore()) : (score += blankConstants.getPreThoroughfareType() * candidate.getPreThoroughfareTypeScore());
        score = this.fieldExists(scoringAddress.getPostThoroughfareType()) || this.fieldExists(candidate.getPostThoroughfareType()) ? (score += matchedConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore()) : (score += blankConstants.getPostThoroughfareType() * candidate.getPostThoroughfareTypeScore());
        if (this.fieldExists(scoringAddress.getPlaceName()) || this.fieldExists(candidate.getPlaceName())) {
            score += matchedConstants.getPlaceName() * candidate.getPlaceNameScore();
        }
        if (scoringAddress.hasAdditionalFields()) {
            score += matchedConstants.getAdditionalFields() * candidate.getAdditionalParserFieldsScore();
        }
        candidate.setCombinedAddressScore(score / this.getMaximumAddressScore());
        score = 0.0;
        score = this.fieldExists(scoringAddress.getPostCode1()) ? (score += matchedConstants.getPostalCode1() * candidate.getPostCode1Score()) : (score += blankConstants.getPostalCode1() * candidate.getPostCode1Score());
        score = this.fieldExists(scoringAddress.getPostCode2()) ? (score += matchedConstants.getPostalCode2() * candidate.getPostCode2Score()) : (score += blankConstants.getPostalCode2() * candidate.getPostCode2Score());
        score = this.fieldExists(scoringAddress.getAreaName1()) ? (score += matchedConstants.getAreaName1() * candidate.getAreaName1Score()) : (score += blankConstants.getAreaName1() * candidate.getAreaName1Score());
        score = this.fieldExists(scoringAddress.getAreaName2()) ? (score += matchedConstants.getAreaName2() * candidate.getAreaName2Score()) : (score += blankConstants.getAreaName2() * candidate.getAreaName2Score());
        score = this.fieldExists(scoringAddress.getAreaName3()) ? (score += matchedConstants.getAreaName3() * candidate.getAreaName3Score()) : (score += blankConstants.getAreaName3() * candidate.getAreaName3Score());
        score = this.fieldExists(scoringAddress.getAreaName4()) ? (score += matchedConstants.getAreaName4() * candidate.getAreaName4Score()) : (score += blankConstants.getAreaName4() * candidate.getAreaName4Score());
        candidate.setCombinedAdditionalFieldScore(score / this.getMaximumAdditionalFieldScore());
        candidate.buildInputMatchScore((Address)scoringAddress, matchedConstants);
    }

    public void decideCloseMatch(IMatchPreferences preferences, InternalCandidateAddress candidate, InternalMatcherConstants matcherConstants, ScoringAddress scoringAddress) {
        if (candidate.isPointHouseCandidate(null) && StringUtilities.isEmpty((String)scoringAddress.getAddressNumber()) && !StringUtilities.isEmpty((String)candidate.getAddressNumber()) && !candidate.isHouseNumberFromPlaceMatch()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode1() && candidate.getPostCode1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchPostalCode2() && candidate.getPostCode2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchStreetNameFields() && (candidate.getMainAddressScore() != 1.0 || candidate.getPostAddressScore() != 1.0 || candidate.getPreAddressScore() != 1.0 || candidate.getPreThoroughfareTypeScore() != 1.0 || candidate.getPostThoroughfareTypeScore() != 1.0 || candidate.getAdditionalParserFieldsScore() != 4.0)) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if ((candidate.getSegment().getRangeCount(0) > 0 || candidate.getSegment().getRangeCount(1) > 0) && preferences.getExactMatchAddressNumber() && candidate.getAddressNumberScore() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName1() && candidate.getAreaName1Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName2() && candidate.getAreaName2Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName3() && candidate.getAreaName3Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (preferences.getExactMatchAreaName4() && candidate.getAreaName4Score() != 1.0) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAddressScore() < matcherConstants.getCloseMatchCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        if (candidate.getCombinedAdditionalFieldScore() < matcherConstants.getAdditionalFieldsCutOff()) {
            candidate.setCloseMatchFlag(false);
            return;
        }
        candidate.setCloseMatchFlag(true);
    }

    @Override
    public boolean removeSecondCandidate(InternalCandidateAddress best, InternalCandidateAddress other) {
        if (!this.stringEquals(best.getPostCode1(), other.getPostCode1())) {
            return false;
        }
        if (!this.stringEquals(best.getAreaName3(), other.getAreaName3())) {
            return false;
        }
        if (!this.stringEquals(best.getAddressNumber(), other.getAddressNumber())) {
            return false;
        }
        if (!this.stringEquals(best.getPlaceName(), other.getPlaceName())) {
            return false;
        }
        return this.stringEquals(best.getAreaName2(), other.getAreaName2());
    }

    private boolean stringEquals(String string1, String string2) {
        if (string1 == null && string2 == null) {
            return true;
        }
        if (string1 == null || string2 == null) {
            return false;
        }
        return string1.equalsIgnoreCase(string2);
    }
}

