/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.EMEA.EMEA_ScoringAddress;
import com.mapinfo.mapmarker.FIN.FIN_InternalCandidateAddress;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;

public class FIN_StreetCandidateAddress
extends StreetCandidateAddress {
    public static final String ADDRESS_START = "address.start";
    public static final String ADDRESS_END = "address.end";
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String IS_MAJOR_ROAD = "is.major.road";
    public static final double THOROUGHFARE_TYPE_THRESHOLD = 0.99;

    public FIN_StreetCandidateAddress() {
    }

    public FIN_StreetCandidateAddress(Address addr) {
        super(addr);
    }

    public void score(ScoringAddress input) {
        this.setCountryScore(input.scoreCountry(this.getCountry()));
        this.setGenericField1Score(input.scoreGenericField1(this.getGenericField1()));
        this.setGenericField2Score(input.scoreGenericField2(this.getGenericField2()));
        this.setGenericField3Score(input.scoreGenericField3(this.getGenericField3()));
        this.setGenericField4Score(input.scoreGenericField4(this.getGenericField4()));
        this.scoreThoroughfareType(input);
        this.scorePreAddress((EMEA_ScoringAddress)input);
        this.setMainAddressScore(input.scoreMainAddress(this.getMainAddress()));
        this.setPostAddressScore(input.scorePostAddress(this.getPostAddress()));
        this.setPreDirectionalScore(input.scorePreDirectional(this.getPreDirectional()));
        this.setPreThoroughfareTypeScore(input.scorePreThoroughfareType(this.getPreThoroughfareType()));
        this.setPostThoroughfareTypeScore(input.scorePostThoroughfareType(this.getPostThoroughfareType()));
        this.setPostDirectionalScore(input.scorePostDirectional(this.getPostDirectional()));
        this.setIsScored(true);
    }

    public void scorePreAddress(EMEA_ScoringAddress input) {
        double preAddressScore = 0.0;
        String parsedPreAddress = input.getPreAddress();
        String candPreAddress = this.getPreAddress();
        if (parsedPreAddress != null && parsedPreAddress.length() == 0 || candPreAddress != null && candPreAddress.length() == 0) {
            preAddressScore = 0.8;
        } else {
            String candidatePreAddressFull;
            String parsedPreAddressFull;
            double score;
            preAddressScore = input.scorePreAddress(candPreAddress != null ? candPreAddress.toUpperCase() : null);
            if (preAddressScore != 1.0 && (score = input.scoreStrings(parsedPreAddressFull = FIN_InternalCandidateAddress.getFormattedPreAddress((Address)input), candidatePreAddressFull = FIN_InternalCandidateAddress.getFormattedPreAddress((Address)this))) > preAddressScore && score > 0.9) {
                preAddressScore = score;
            }
        }
        this.setPreAddressScore(preAddressScore);
    }

    private void scoreThoroughfareType(ScoringAddress input) {
        boolean canSwitch = this.getPreThoroughfareTypeScore() != -1.0 || this.getPostThoroughfareTypeScore() != -1.0;
        String parsedPreType = input.getPreThoroughfareType();
        String candPreType = this.getPreThoroughfareType();
        String parsedPostType = input.getPostThoroughfareType();
        String candPostType = this.getPostThoroughfareType();
        if (parsedPreType != null && parsedPreType.length() == 0) {
            parsedPreType = null;
        }
        if (candPreType != null && candPreType.length() == 0) {
            candPreType = null;
        }
        if (parsedPostType != null && parsedPostType.length() == 0) {
            parsedPostType = null;
        }
        if (candPostType != null && candPostType.length() == 0) {
            candPostType = null;
        }
        if (candPreType != null) {
            this.setPreThoroughfareTypeScore(input.scorePreThoroughfareType(candPreType));
        }
        if (candPostType != null) {
            this.setPostThoroughfareTypeScore(input.scorePostThoroughfareType(candPostType));
        }
        double savedPreTypeScore = this.getPreThoroughfareTypeScore();
        double savedPostTypeScore = this.getPostThoroughfareTypeScore();
        if (canSwitch && (savedPreTypeScore < 0.99 || savedPostTypeScore < 0.99) && (candPostType != null || parsedPostType != null)) {
            input.setPreThoroughfareType(parsedPostType);
            input.setPostThoroughfareType(parsedPreType);
            this.setPreThoroughfareTypeScore(-1.0);
            this.setPostThoroughfareTypeScore(-1.0);
            this.scoreThoroughfareType(input);
            double newPreTypeScore = this.getPreThoroughfareTypeScore();
            double newPostTypeScore = this.getPostThoroughfareTypeScore();
            input.setPreThoroughfareType(parsedPreType);
            input.setPostThoroughfareType(parsedPostType);
            if (!(!(newPreTypeScore < savedPreTypeScore) && !(newPostTypeScore < savedPostTypeScore) || (newPreTypeScore >= 0.99 || newPostTypeScore > 0.99) && savedPreTypeScore < 0.99 && savedPostTypeScore < 0.99)) {
                this.setPreThoroughfareTypeScore(savedPreTypeScore);
                this.setPostThoroughfareTypeScore(savedPostTypeScore);
            }
        }
    }
}

