/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN;

import com.mapinfo.mapmarker.EMEA.EMEA_StreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParseMainAddressRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.ICoreParseHandler;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.List;

public class FIN_StreetSingleAddressGeocoder
extends EMEA_StreetSingleAddressGeocoder {
    private int m_currentCase = 0;
    private boolean resetParsedAddress;
    private Address savedParsedAddress;

    public FIN_StreetSingleAddressGeocoder(IHandler handler) {
        super(handler);
    }

    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        int previousResultSize;
        boolean tryAgain = false;
        if (!this.resetParsedAddress) {
            this.savedParsedAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        } else {
            this.setParsedAddress((Address)new AddressImpl(this.savedParsedAddress));
            this.resetParsedAddress = false;
        }
        Address pa = constraints.getHandler().getParsedAddress();
        Address inputAddress = constraints.getHandler().getInputAddress();
        CoreHandler handler = (CoreHandler)constraints.getHandler();
        List previousResultList = handler.getIntermediateMatchResults();
        int n = previousResultSize = previousResultList == null ? 0 : previousResultList.size();
        if (previousResultSize > 0) {
            HashMap<Long, Long> previousStreetOffsets = (HashMap<Long, Long>)constraints.getCustomObject((Object)"KEY_STREETS_TO_REMOVE");
            if (previousStreetOffsets == null) {
                previousStreetOffsets = new HashMap<Long, Long>(previousResultSize);
            }
            for (int i = 0; i < previousResultSize; ++i) {
                InternalCandidateAddress candAddr = (InternalCandidateAddress)previousResultList.get(i);
                Long streetOffset = new Long(candAddr.getStreetOffset());
                if (previousStreetOffsets.containsKey(streetOffset)) continue;
                previousStreetOffsets.put(streetOffset, streetOffset);
            }
            constraints.setCustomObject((Object)"KEY_STREETS_TO_REMOVE", previousStreetOffsets);
        }
        if (this.m_currentCase == 0) {
            String mustMatchMainAddr = constraints.getCustomString("MustMatchMainAddr");
            constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
            if (mustMatchMainAddr == null || mustMatchMainAddr.equalsIgnoreCase("TRUE")) {
                // empty if block
            }
        }
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                this.setSearchParsedAddress(pa);
                this.setParsedAddress(pa);
                this.resetParsedAddress = true;
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                String geoAndPostConstraint = constraints.getCustomString("KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                if (geoAndPostConstraint != null && geoAndPostConstraint.equalsIgnoreCase("TRUE")) {
                    constraints.removeCustomObject((Object)"KEY_SAC_MUSTMATCH_GEO_AND_POSTAL");
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.m_currentCase;
                String postcode = pa.getPostCode1();
                if (postcode != null && postcode.length() < 5) {
                    postcode = '0' + postcode;
                    pa.setPostCode1(postcode);
                    this.resetParsedAddress = true;
                    tryAgain = true;
                    this.setSearchParsedAddress(pa);
                    break;
                }
            }
            case 2: {
                ++this.m_currentCase;
                constraints.setCustomString("KEY_GEOBASE_FOR_AREA4", "true");
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA3");
                tryAgain = true;
                break;
            }
            case 3: {
                ++this.m_currentCase;
                boolean bStringKey = new Boolean(constraints.getCustomString("KEY_GEOBASE_STRING_ONLY"));
                if (bStringKey) {
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_STRING_ONLY");
                    constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                    constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
                    constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                    tryAgain = true;
                    break;
                }
            }
            case 4: {
                ++this.m_currentCase;
                String mainAddress = this.savedParsedAddress.getMainAddress();
                if (mainAddress != null && mainAddress.trim().length() != 0) {
                    int offset;
                    String preType = this.savedParsedAddress.getPreThoroughfareType();
                    String postType = this.savedParsedAddress.getPostThoroughfareType();
                    if (!(preType != null && preType.trim().length() != 0 || postType != null && postType.trim().length() != 0 || (offset = mainAddress.lastIndexOf(" ")) <= 0)) {
                        String lastWord = mainAddress.substring(offset + 1);
                        inputAddress = constraints.getHandler().getInputAddress();
                        String originalMainAddress = inputAddress.getMainAddress();
                        int originalOffset = originalMainAddress.lastIndexOf(lastWord);
                        if (originalOffset > 0) {
                            String newMainAddress = originalMainAddress.substring(0, originalOffset - 1);
                            newMainAddress = newMainAddress.replaceAll(mainAddress, "");
                            newMainAddress = newMainAddress.replaceAll("-", "");
                            newMainAddress = newMainAddress.replaceAll(" ", "");
                            if (originalMainAddress.length() > originalOffset + lastWord.length()) {
                                newMainAddress = newMainAddress + " " + originalMainAddress.substring(originalOffset + (lastWord.length() + 1));
                            }
                            AddressImpl newInput = new AddressImpl(inputAddress);
                            String possibleHNR = null;
                            if (StringUtilities.isNumeric((String)lastWord)) {
                                possibleHNR = lastWord;
                                newInput.setAddressNumber(possibleHNR);
                            }
                            newInput.setMainAddress(newMainAddress);
                            boolean parsed = true;
                            try {
                                this.savedParsedAddress = ((ICoreParseHandler)constraints.getHandler()).getParser().parse((Address)newInput, constraints)[0];
                                constraints.getHandler().setParsedAddress(this.savedParsedAddress);
                                this.setSearchParsedAddress(this.savedParsedAddress);
                            }
                            catch (ParserException PEx) {
                                throw new ParserException(PEx.getErrorCode());
                            }
                            if (parsed) {
                                tryAgain = true;
                                this.resetParsedAddress = true;
                                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                                break;
                            }
                        }
                    }
                }
            }
            case 5: {
                ++this.m_currentCase;
                constraints.setCustomString("KEY_GEOBASE_FOR_AREA4", "true");
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA3");
                tryAgain = true;
                break;
            }
            case 6: {
                ++this.m_currentCase;
                constraints.setCustomObject((Object)"KEY_FIN_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(8));
                constraints.setCustomString("KEY_IGNORE_NO_SAC_ERROR", "true");
                tryAgain = true;
                break;
            }
            case 7: {
                ++this.m_currentCase;
                constraints.setCustomString("KEY_GEOBASE_FOR_AREA3", "true");
                constraints.removeCustomObject((Object)"KEY_GEOBASE_FOR_AREA4");
                boolean isVillage = FIN_ParseMainAddressRule.doVillageCheck(pa);
                if (isVillage) {
                    constraints.setFallbackToGeographic(true);
                    this.setSearchParsedAddress(pa);
                    this.setParsedAddress(pa);
                    this.resetParsedAddress = false;
                    tryAgain = false;
                    break;
                }
                tryAgain = true;
            }
        }
        return tryAgain;
    }

    protected String replace(String original, char chFrom, String strTo) {
        if (original == null || original.trim().length() == 0) {
            return null;
        }
        if (strTo == null || strTo.trim().length() == 0) {
            return null;
        }
        int loc = (original = original.toUpperCase()).indexOf(chFrom);
        if (loc == -1) {
            return original;
        }
        StringBuffer newString = new StringBuffer();
        for (int i = 0; i < original.length(); ++i) {
            if (original.charAt(i) != chFrom) {
                newString.append(original.charAt(i));
                continue;
            }
            newString.append(strTo);
        }
        return newString == null ? null : newString.toString();
    }
}

