/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.browse;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoInfoRecord;
import com.mapinfo.mapmarker.FIN.FIN_AddressUtils;
import com.mapinfo.mapmarker.FIN.FIN_InternalBrowseAddress;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_DataManager;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.FIN.parser.FIN_ParsePostAddressRule;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.browse.IBrowseFilter;
import com.mapinfo.mapmarker.core.matcher.IMatchPreferences;
import com.mapinfo.mapmarker.core.matcher.MatcherException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class FIN_BrowseFilter
implements IBrowseFilter,
Comparator {
    private Address m_inputAddr = null;

    public List filterAddresses(IConstraints constraints, Address pa, List candidates) throws MatcherException {
        if (candidates == null || candidates.isEmpty()) {
            return candidates;
        }
        this.removeDuplicateAddresses(candidates);
        return this.filterCandidates(constraints, pa, candidates);
    }

    private void removeDuplicateAddresses(List candidates) {
        HashSet<FIN_InternalBrowseAddress.StreetBasedIdentifier> set = new HashSet<FIN_InternalBrowseAddress.StreetBasedIdentifier>(candidates.size());
        Iterator iter = candidates.iterator();
        while (iter.hasNext()) {
            FIN_InternalBrowseAddress FINBrowseAddress = (FIN_InternalBrowseAddress)((Object)iter.next());
            FIN_InternalBrowseAddress.StreetBasedIdentifier identifier = FINBrowseAddress.getStreetBasedIdentifier();
            if (set.contains(identifier)) {
                iter.remove();
                continue;
            }
            set.add(identifier);
        }
    }

    private List filterCandidates(IConstraints constraints, Address pa, List candidates) {
        FieldScores thresholds = constraints.getHandler().getMatcherConstants().getFieldScores();
        StringScorer scorer = ((CoreHandler)constraints.getHandler()).getScoringHelper().makeStringScorer();
        ArrayList<FIN_InternalBrowseAddress> filteredCandidates = new ArrayList<FIN_InternalBrowseAddress>(candidates.size());
        for (FIN_InternalBrowseAddress address : candidates) {
            FIN_InternalBrowseAddress filteredAddress = this.filterAddress(address, pa, thresholds, constraints, scorer);
            if (filteredAddress == null) continue;
            filteredCandidates.add(filteredAddress);
        }
        return filteredCandidates;
    }

    private FIN_InternalBrowseAddress filterAddress(InternalBrowseAddress address, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        int index;
        FIN_InternalBrowseAddress filteredAddress = (FIN_InternalBrowseAddress)constraints.getHandler().getBrowseHelper().makeBrowseAddress((Address)address);
        this.m_inputAddr = inputAddress;
        ArrayList<Segment> listOfSegments = new ArrayList<Segment>();
        int segmentCount = address.getSegmentCount();
        for (index = 0; index < segmentCount; ++index) {
            int dictNum;
            Segment segment = address.getSegmentAt(index);
            Segment filteredSegment = this.filterSegment(segment, dictNum = filteredAddress.getDictionaryNumber(), inputAddress, thresholds, constraints, scorer);
            if (filteredSegment == null) continue;
            listOfSegments.add(filteredSegment);
        }
        if (listOfSegments != null && listOfSegments.size() > 0) {
            Collections.sort(listOfSegments, this);
            for (index = 0; index < listOfSegments.size(); ++index) {
                filteredAddress.addSegment((Segment)listOfSegments.get(index));
            }
        }
        if (filteredAddress.getSegmentCount() > 0) {
            return filteredAddress;
        }
        return null;
    }

    private Segment filterSegment(Segment segment, int dictNum, Address inputAddress, FieldScores thresholds, IConstraints constraints, StringScorer scorer) {
        double postcode1Score;
        double score;
        double an3Score;
        IMatchPreferences constants = constraints.getHandler().getMatchConstraintsConverter().repackageGeocodingConstraints(constraints, inputAddress);
        EMEA_GeoInfoRecord geoinfo = (EMEA_GeoInfoRecord)segment.getGeoInfoRecord();
        String an3 = inputAddress.getAreaName3();
        String an4 = inputAddress.getGenericField1();
        String charsToIgnore = constraints.getHandler().getMatcherConstants().getStreetMatcherConstants().getCharsToIgnore();
        if (an4 != null && StringUtilities.isNumeric((String)an4)) {
            an4 = null;
        }
        if (FIN_AddressUtils.isEmpty(an3) && FIN_AddressUtils.isEmpty(an4)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else if (geoinfo != null) {
            String an4FromGeoInfo;
            double an4Score;
            String shortNameFromGeoInfo = geoinfo.getAreaName3Short();
            if (FIN_AddressUtils.isEmpty(shortNameFromGeoInfo)) {
                an3Score = scorer.scoreString(an3, geoinfo.getAreaName3(), charsToIgnore);
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName3(), charsToIgnore);
                if (FIN_AddressUtils.isEmpty(an4)) {
                    if (an3Score == 1.0) {
                        an4Score = 1.0;
                    }
                } else if (an4Score == 1.0) {
                    an3Score = 1.0;
                }
            } else {
                an3Score = scorer.scoreString(FIN_AddressTerm.removeCommonTerms(an3), shortNameFromGeoInfo);
                an4Score = scorer.scoreString(an4, geoinfo.getAreaName3());
            }
            if (geoinfo.getAltAreaName3() != null && (an3Score != 1.0 || an4Score != 1.0)) {
                int index;
                String[] tokens = geoinfo.getAltAreaName3().split("/");
                boolean shortIsSameAsFull = true;
                if (!FIN_AddressUtils.isEmpty(an3) && an3Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        String fullAlias = tokens[index].trim();
                        String shortAlias = FIN_AddressTerm.removeCommonTerms(fullAlias);
                        if (shortAlias == null) {
                            shortAlias = fullAlias;
                        }
                        if (!(an3Score < (score = scorer.scoreString(an3, shortAlias)))) continue;
                        shortIsSameAsFull = shortAlias.length() == fullAlias.length();
                        an3Score = score;
                        if (an3Score == 1.0) break;
                    }
                }
                if (!FIN_AddressUtils.isEmpty(an4) && an4Score != 1.0) {
                    for (index = 0; index < tokens.length; ++index) {
                        score = scorer.scoreString(an4, tokens[index]);
                        double d = an4Score = an4Score < score ? score : an4Score;
                        if (an4Score == 1.0) break;
                    }
                }
                if (FIN_AddressUtils.isEmpty(an4)) {
                    if (an3Score > an4Score) {
                        if (constants.getExactMatchAreaName3()) {
                            if (shortIsSameAsFull) {
                                an4Score = an3Score;
                            }
                        } else {
                            an4Score = an3Score;
                        }
                    }
                } else if (an4Score > an3Score) {
                    an3Score = an4Score;
                }
            }
            if (an3Score != 1.0) {
                double[] scores;
                String locality = geoinfo.getAliasedLocality();
                if (!FIN_AddressUtils.isEmpty(locality) && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0]) {
                    an3Score = scores[0];
                    an4Score = scores[1];
                }
                if (an3Score != 1.0) {
                    String leftPostCode1 = segment.getLeftPostCode1();
                    String rightPostCode1 = segment.getRightPostCode1();
                    ArrayList geoRecords = null;
                    boolean isLeftRightPostCode1Same = true;
                    if (!FIN_AddressUtils.isEmpty(leftPostCode1)) {
                        geoRecords = FIN_DataManager.getGeoInfoAlias(FIN_AddressTerm.removeDiacritics(geoinfo.getAreaName3()), leftPostCode1, dictNum);
                        isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                    }
                    if (!isLeftRightPostCode1Same && !FIN_AddressUtils.isEmpty(rightPostCode1)) {
                        ArrayList rightList = FIN_DataManager.getGeoInfoAlias(geoinfo.getAreaName3(), rightPostCode1, dictNum);
                        if (geoRecords != null && rightList != null) {
                            geoRecords.addAll(rightList);
                        } else {
                            geoRecords = rightList;
                        }
                    }
                    if (geoRecords != null) {
                        String bestArea = null;
                        for (int index = 0; index < geoRecords.size(); ++index) {
                            double[] scores2;
                            locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                            if (FIN_AddressUtils.isEmpty(locality) || !((scores2 = this.calculateAn3An4Scores(scorer, an3, an4, locality != null ? locality.toUpperCase() : null))[0] > an3Score)) continue;
                            an3Score = scores2[0];
                            an4Score = scores2[1];
                            bestArea = locality;
                            if (an3Score == 1.0) break;
                        }
                        if (bestArea != null && bestArea.length() > 0) {
                            segment.setLeftAreaName4(bestArea);
                        }
                    }
                }
            }
            if (an3Score != 1.0 && !FIN_AddressUtils.isEmpty(an4FromGeoInfo = geoinfo.getAreaName4()) && !an4FromGeoInfo.equals(geoinfo.getAreaName3())) {
                String fullTownName;
                String string = fullTownName = FIN_AddressUtils.isEmpty(an4) ? an3 : an4;
                if (!FIN_AddressUtils.isEmpty(fullTownName)) {
                    double tempScore = scorer.scoreString(fullTownName, an4FromGeoInfo);
                    if (an3Score < tempScore) {
                        an3Score = tempScore;
                    }
                    if (an4Score < tempScore) {
                        an4Score = tempScore;
                    }
                }
            }
        } else if (FIN_AddressUtils.isEmpty(an3)) {
            an3Score = 1.0;
            double an4Score = 1.0;
        } else {
            double[] scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getLeftAreaName3());
            an3Score = scores[0];
            double an4Score = scores[1];
            if (an3Score != 1.0 && an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, segment.getRightAreaName3()))[0]) {
                an3Score = scores[0];
                an4Score = scores[1];
            }
            if (an3Score != 1.0) {
                String leftPostCode1 = segment.getLeftPostCode1();
                String rightPostCode1 = segment.getRightPostCode1();
                ArrayList geoRecords = null;
                boolean isLeftRightPostCode1Same = true;
                if (!FIN_AddressUtils.isEmpty(leftPostCode1)) {
                    geoRecords = FIN_DataManager.getGeoInfoAlias(segment.getLeftAreaName3(), leftPostCode1, dictNum);
                    isLeftRightPostCode1Same = leftPostCode1.equalsIgnoreCase(rightPostCode1);
                }
                if (!isLeftRightPostCode1Same && !FIN_AddressUtils.isEmpty(rightPostCode1)) {
                    ArrayList rightList = FIN_DataManager.getGeoInfoAlias(segment.getRightAreaName3(), rightPostCode1, dictNum);
                    if (geoRecords != null && rightList != null) {
                        geoRecords.addAll(rightList);
                    } else {
                        geoRecords = rightList;
                    }
                }
                if (geoRecords != null) {
                    String bestArea = null;
                    for (int index = 0; index < geoRecords.size(); ++index) {
                        String locality = ((EMEA_GeoInfoRecord)((Object)geoRecords.get(index))).getAliasedLocality();
                        if (FIN_AddressUtils.isEmpty(locality) || !(an3Score < (scores = this.calculateAn3An4Scores(scorer, an3, an4, locality))[0])) continue;
                        an3Score = scores[0];
                        an4Score = scores[1];
                        bestArea = locality;
                        if (an3Score == 1.0) break;
                    }
                    if (bestArea != null && bestArea.length() > 0) {
                        segment.setLeftAreaName4(bestArea);
                    }
                }
            }
        }
        double scoreInputAn2 = 0.0;
        String inputAn2 = inputAddress.getAreaName2();
        String candidateAn2 = geoinfo.getAreaName2();
        if (inputAn2 != null) {
            scoreInputAn2 = scorer.scoreString(inputAn2, candidateAn2);
        }
        if (constants.getExactMatchAreaName3() ? an3Score != 1.0 : an3Score < thresholds.getAreaName3()) {
            return null;
        }
        String postcode1 = inputAddress.getPostCode1();
        if (FIN_AddressUtils.isEmpty(postcode1)) {
            postcode1Score = 1.0;
        } else {
            score = scorer.scoreString(postcode1, segment.getLeftPostCode1());
            postcode1Score = score;
            if (postcode1Score != 1.0) {
                score = scorer.scoreString(postcode1, segment.getRightPostCode1());
                double d = postcode1Score = postcode1Score < score ? score : postcode1Score;
            }
        }
        if (constants.getExactMatchPostalCode1() ? postcode1Score != 1.0 : postcode1Score < thresholds.getPostalCode1()) {
            return null;
        }
        if (constants.getExactMatchAreaName2() ? scoreInputAn2 != 1.0 : inputAddress.getAreaName2() != null && scoreInputAn2 < thresholds.getAreaName2()) {
            return null;
        }
        return segment;
    }

    private double[] calculateAn3An4Scores(StringScorer scorer, String an3, String an4, String town) {
        double an3Score = 0.0;
        double an4Score = 0.0;
        if (!FIN_AddressUtils.isEmpty(town)) {
            String shortTown = FIN_AddressTerm.removeCommonTerms(town);
            String areaName3 = FIN_AddressTerm.removeCommonTerms(an3);
            if (FIN_AddressUtils.isEmpty(shortTown)) {
                shortTown = town;
                areaName3 = an3;
            }
            an3Score = scorer.scoreString(FIN_AddressTerm.removeCommonTerms(areaName3), shortTown);
            an4Score = shortTown.length() != town.length() ? scorer.scoreString(an4, town) : (FIN_AddressUtils.isEmpty(an4) ? 1.0 : scorer.scoreString(an4, shortTown));
        }
        return new double[]{an3Score, an4Score};
    }

    public int compare(Object o1, Object o2) {
        Segment segment1 = (Segment)o1;
        Segment segment2 = (Segment)o2;
        Address address = this.m_inputAddr;
        String inputAddrOutwardCode = FIN_ParsePostAddressRule.getOutwardSortingCode(address.getPostCode1());
        String segment1OutwardCode = FIN_ParsePostAddressRule.getOutwardSortingCode(segment1.getLeftPostCode1());
        String segment2OutwardCode = FIN_ParsePostAddressRule.getOutwardSortingCode(segment1.getLeftPostCode1());
        if (segment1OutwardCode != null && segment2OutwardCode != null && segment1OutwardCode.equalsIgnoreCase(inputAddrOutwardCode) && segment2OutwardCode.equalsIgnoreCase(inputAddrOutwardCode)) {
            if (segment1.getLeftPostCode1() != null && segment1.getLeftPostCode1().equalsIgnoreCase(address.getPostCode1())) {
                return -1;
            }
            if (segment2.getLeftPostCode1() != null && segment2.getLeftPostCode1().equalsIgnoreCase(address.getPostCode1())) {
                return 1;
            }
        }
        return 0;
    }
}

