/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp;

import com.mapinfo.mapmarker.EMEA.dp.IEMEA_FlagDataSourceRecord;
import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_GeoBase;
import com.mapinfo.mapmarker.FIN.dp.binary.FIN_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.generic.soundex.GenericSoundex;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.util.ArrayList;
import java.util.Properties;

public class FIN_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    protected FIN_GeoInfoFetcherImpl m_infoFetcher = null;

    public FIN_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
        String geoInfoLoc = dataProperties.getProperty("geo2sac_geoinfoLoc");
        try {
            this.m_infoFetcher = new FIN_GeoInfoFetcherImpl(geoInfoLoc, null, null);
        }
        catch (DataDictionaryIntializationException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
        }
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        short flag = (short)((IEMEA_FlagDataSourceRecord)input).getFlag();
        if (input.hasAreaName3() && this.stringExists(input.getAreaName3())) {
            String town = input.getAreaName3();
            String shortTown = FIN_AddressTerm.removeCommonTerms(town);
            if (shortTown == null || shortTown.length() == 0) {
                shortTown = town;
            }
            ArrayList<EMEA_GeoBase> baseHolder = new ArrayList<EMEA_GeoBase>(4);
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(shortTown)));
            baseHolder.add(new EMEA_GeoBase((MiSoundexKey)((GenericSoundex)this.m_soundex).getStringKey(shortTown.toUpperCase())));
            ArrayList altLangNames = (ArrayList)this.m_infoFetcher.getAltLangNames(town.toUpperCase());
            int size = altLangNames.size();
            for (int i = 0; i < size; ++i) {
                String altLangName = (String)altLangNames.get(i);
                if (altLangName == null || altLangName.length() == 0) continue;
                baseHolder.add(new EMEA_GeoBase((MiSoundexKey)this.makeSoundexKey(altLangName)));
            }
            int length = baseHolder.size();
            for (int i = 0; i < length; ++i) {
                ((EMEA_GeoBase)baseHolder.get(i)).setFlag(flag);
            }
            IGeoBase[] bases = baseHolder.toArray(new EMEA_GeoBase[0]);
            return bases;
        }
        return null;
    }

    private MiSoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        str = str.toUpperCase();
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        MiSoundexKey mikey = new MiSoundexKey();
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }
}

