/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.EMEA.dp.binary.EMEA_AddressFetcher;
import com.mapinfo.mapmarker.FIN.FIN_InternalCandidateAddress;
import com.mapinfo.mapmarker.FIN.FIN_StreetCandidateAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GenericStreet;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.HashMap;
import java.util.Properties;

public class FIN_AddressFetcher
extends EMEA_AddressFetcher {
    static NumberFormat postalFormatter = NumberFormat.getInstance();

    public FIN_AddressFetcher(Properties localSettings, Properties localStrings) {
        super(localSettings, localStrings);
        postalFormatter.setMinimumIntegerDigits(5);
        postalFormatter.setMaximumIntegerDigits(5);
        postalFormatter.setGroupingUsed(false);
    }

    @Override
    public NumberFormat getPostalFormatter() {
        return postalFormatter;
    }

    protected void populateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        super.populateCandidateFromData(cand, street, streetOffset, metadata);
        this.privatePopulateCandidateFromData(cand, street, streetOffset, metadata);
    }

    private void privatePopulateCandidateFromData(StreetCandidateAddress cand, IDataFileDataItem street, long streetOffset, MMJDataFileMetadata metadata) throws LocalizationException, IOException {
        HashMap adFields = cand.getAdditionalFields();
        GenericStreet genericStreet = (GenericStreet)street;
        this.fillAdditionalFields(adFields, genericStreet, 39, "address.common.pre.main");
        this.fillAdditionalFields(adFields, genericStreet, 40, "address.common.post.st_type");
        this.fillAdditionalFields(adFields, genericStreet, 41, "address.separator.post.st_type");
    }

    private void fillAdditionalFields(HashMap fields, GenericStreet genericStreet, int intKey, String strKey) throws LocalizationException {
        if (genericStreet.hasString(intKey)) {
            String value = GenericDataItemAccessor.getDataString((int)intKey, (GenericDataItem)genericStreet);
            fields.put(strKey, value);
        }
    }

    public InternalCandidateAddress makeInternalCandidateAddress() {
        return new FIN_InternalCandidateAddress();
    }

    protected InternalCandidateAddress makeInternalCandidateAddress(StreetCandidateAddress street, IConstraints constraints) {
        return new FIN_InternalCandidateAddress((Address)street);
    }

    protected StreetCandidateAddress getStreetCandidateAddressObject() {
        return new FIN_StreetCandidateAddress();
    }
}

