/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import java.util.Collections;

public class FIN_MMJStreetRecordComparator
extends MMJStreetRecordComparator {
    protected MMJRangeRecordComparator rangeComparator = new MMJRangeRecordComparator();

    public int compare(Object o1, Object o2) {
        MMJStreetRecord record1 = (MMJStreetRecord)o1;
        MMJStreetRecord record2 = (MMJStreetRecord)o2;
        if (record1.getSegment().getRanges() != null && !record1.getSegment().rangesSorted()) {
            Collections.sort(record1.getSegment().getRanges(), this.rangeComparator);
            record1.getSegment().setRangesSorted();
        }
        if (record2.getSegment().getRanges() != null && !record2.getSegment().rangesSorted()) {
            Collections.sort(record2.getSegment().getRanges(), this.rangeComparator);
            record2.getSegment().setRangesSorted();
        }
        if (record1.getSac() == record2.getSac()) {
            if (record1.getKey().equals(record2.getKey())) {
                return this.compareStreetInfo(record1, record2);
            }
            return record1.getKey().compareTo((Object)record2.getKey());
        }
        if (record1.getSac() < record2.getSac()) {
            return -1;
        }
        return 1;
    }

    protected int compareStreetInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        String addressString2;
        String addressString1 = this.buildStreetString(record1.getAddress());
        if (addressString1.equals(addressString2 = this.buildStreetString(record2.getAddress()))) {
            return this.comparePostalInfo(record1, record2);
        }
        return addressString1.compareTo(addressString2);
    }

    protected String buildStreetString(Address address) {
        if (address == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(address.getPreAddress() == null ? "" : address.getPreAddress());
        buffer.append(address.getMainAddress() == null ? "" : address.getMainAddress());
        buffer.append(address.getPostAddress() == null ? "" : address.getPostAddress());
        buffer.append(address.getPostThoroughfareType() == null ? "" : address.getPostThoroughfareType());
        return buffer.toString();
    }

    protected int comparePostalInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getLeftPostalCode1() != null && record1.getSegment().getRightPostalCode1() != null && record1.getSegment().getLeftPostalCode1().equals(record1.getSegment().getRightPostalCode1())) {
            if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
                if (record1.getSegment().getLeftPostalCode1().equals(record2.getSegment().getLeftPostalCode1())) {
                    return this.compareGeoInfo(record1, record2);
                }
                return record1.getSegment().getLeftPostalCode1().compareTo(record2.getSegment().getLeftPostalCode1());
            }
            return 1;
        }
        if (record2.getSegment().getLeftPostalCode1() != null && record2.getSegment().getRightPostalCode1() != null && record2.getSegment().getLeftPostalCode1().equals(record2.getSegment().getRightPostalCode1())) {
            return -1;
        }
        return this.compareGeoInfo(record1, record2);
    }

    protected int compareGeoInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        String rec2GeoString;
        String rec1AreaName1 = record1.getSegment().getLeftAreaName1();
        String rec2AreaName1 = record2.getSegment().getLeftAreaName1();
        String rec1AreaName2 = record1.getSegment().getLeftAreaName2();
        String rec2AreaName2 = record2.getSegment().getLeftAreaName2();
        String rec1AreaName3 = record1.getSegment().getLeftAreaName3();
        String rec2AreaName3 = record2.getSegment().getLeftAreaName3();
        String rec1AreaName4 = record1.getSegment().getLeftAreaName4();
        String rec2AreaName4 = record2.getSegment().getLeftAreaName4();
        String rec1GeoString = (rec1AreaName1 == null ? "" : rec1AreaName1) + (rec1AreaName2 == null ? "" : rec1AreaName2) + (rec1AreaName3 == null ? "" : rec1AreaName3) + (rec1AreaName4 == null ? "" : rec1AreaName4);
        if (rec1GeoString.equals(rec2GeoString = (rec2AreaName1 == null ? "" : rec2AreaName1) + (rec2AreaName2 == null ? "" : rec2AreaName2) + (rec2AreaName3 == null ? "" : rec2AreaName3) + (rec2AreaName4 == null ? "" : rec2AreaName4))) {
            return this.compareRangeInfo(record1, record2);
        }
        return rec1GeoString.compareTo(rec2GeoString);
    }

    protected int compareRangeInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getRanges() != null) {
            if (record2.getSegment().getRanges() != null) {
                ParsedNumber lowestHouse1 = record1.getSegment().getLowestHouse();
                ParsedNumber lowestHouse2 = record2.getSegment().getLowestHouse();
                return lowestHouse1.compareTo((Object)lowestHouse2);
            }
            return 1;
        }
        if (record2.getSegment().getRanges() != null) {
            return -1;
        }
        return 0;
    }
}

