/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.FIN.dp.binary.FIN_DataManager;
import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.FIN.parser.FIN_SpecialStreetsHandling;
import com.mapinfo.mapmarker.FIN.parser.FIN_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class FIN_ParseMainAddressRule
implements IParseRule {
    public static final int MAX_ADDITIONAL_FIELDS = 2;
    public static final String UNPARSED_HNR = "unparsed_hnr";
    public static final String STREET_NUM = "street_num";
    private static boolean debug = false;
    private HashMap addFields;

    public void parse(Address UnrefinedAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        String hnr = parsedAddress.getAddressNumber();
        String street = parsedAddress.getMainAddress();
        if (street != null) {
            street = street.replaceAll("\\p{Punct}", " ");
            int spaceIndex = street.indexOf("  ");
            while (spaceIndex != -1) {
                String str1 = street.substring(0, spaceIndex);
                String str2 = street.substring(street.indexOf("  "), street.length()).trim();
                street = str1 + " " + str2;
                spaceIndex = street.indexOf("  ");
            }
            parsedAddress.setMainAddress(street);
        }
        if (hnr != null) {
            hnr = this.getProperHouseNumber(hnr, parsedAddress);
        }
        if (street == null) {
            return;
        }
        if (street.length() == 0) {
            return;
        }
        if (FIN_SpecialStreetsHandling.handleSpecialStreet(parsedAddress, street)) {
            HashMap addFields = parsedAddress.getAdditionalFields();
            addFields.put("unparsed_input_street", UnrefinedAddress.getAdditionalFields().get("unparsed_input_street"));
            addFields.put("input_house_number", UnrefinedAddress.getAdditionalFields().get("input_house_number"));
            parsedAddress.setAdditionalFields(addFields);
            return;
        }
        this.addFields = new HashMap();
        StringTokenizer tokens = new StringTokenizer(street, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        StringBuffer streetBuffer = new StringBuffer();
        StringBuffer hnrBuffer = new StringBuffer();
        StringBuffer origBuffer = new StringBuffer();
        StringBuffer streetTypeBuffer = new StringBuffer();
        this.clean(listOfTokens);
        this.removeJunk(listOfTokens);
        LinkedList origList = listOfTokens;
        boolean expansionAttempted = false;
        int count = 0;
        block1: while (count < listOfTokens.size()) {
            String term = (String)listOfTokens.get(count);
            if (this.hasStreetTypeEnding(term)) {
                this.debug(term + " has street type ending");
                streetTypeBuffer.append(this.getStreetTypeEnding(term));
                streetBuffer.append(this.splitList(0, count, listOfTokens));
                hnrBuffer.append(this.splitList(count + 1, listOfTokens.size() - 1, listOfTokens));
                break;
            }
            if (this.containsDigit(term)) {
                this.debug(term + " contains a digit");
                String initialString = this.separateValidInitialNonDigitSection(term);
                if (this.isMainPresentAfter(listOfTokens, count)) {
                    hnrBuffer.append(term);
                    listOfTokens.remove(count);
                } else if (initialString != null) {
                    origBuffer.append(initialString);
                    hnrBuffer.append(term.substring(initialString.length()));
                } else {
                    streetBuffer.append(this.splitList(0, count - 1, listOfTokens));
                    hnrBuffer.append(this.splitList(count, listOfTokens.size() - 1, listOfTokens));
                    if (expansionAttempted || streetTypeBuffer.length() > 0) {
                        break;
                    }
                }
            } else {
                origBuffer.append(term);
            }
            if (count == listOfTokens.size() - 1) {
                if (expansionAttempted) break;
                expansionAttempted = true;
                count = 0;
                listOfTokens = origList;
                streetBuffer = new StringBuffer();
                streetTypeBuffer = new StringBuffer();
                hnrBuffer = new StringBuffer();
                origBuffer = new StringBuffer();
                String lastLetter = null;
                String lastTwoLetters = null;
                for (int n = listOfTokens.size() - 1; n >= 0; --n) {
                    term = (String)listOfTokens.get(n);
                    if (term != null && term.length() > 0) {
                        lastLetter = term.substring(term.length() - 1);
                        if (term.length() > 1) {
                            lastTwoLetters = term.substring(term.length() - 2);
                        }
                    }
                    if (this.containsDigit(term) || FIN_AddressTerm.isPunctuation(term) || term.length() == 0) continue;
                    if (lastTwoLetters != null && lastTwoLetters.equalsIgnoreCase("KJ")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 2) + "kuja");
                        continue block1;
                    }
                    if (lastTwoLetters != null && lastTwoLetters.equalsIgnoreCase("GT")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 2) + "Gatan");
                        continue block1;
                    }
                    if (lastLetter != null && lastLetter.equalsIgnoreCase("K")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 1) + "katu");
                        continue block1;
                    }
                    if (lastLetter != null && lastLetter.equalsIgnoreCase("T")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 1) + "tie");
                        continue block1;
                    }
                    if (lastLetter != null && lastLetter.equalsIgnoreCase("V")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 1) + "v\u00e4gen");
                        continue block1;
                    }
                    if (lastLetter != null && lastLetter.equalsIgnoreCase("G")) {
                        listOfTokens.set(n, term.substring(0, term.length() - 1) + "gatan");
                        continue block1;
                    }
                    if (lastLetter == null || !lastLetter.equalsIgnoreCase("P")) continue;
                    listOfTokens.set(n, term.substring(0, term.length() - 1) + "polku");
                    continue block1;
                }
                continue;
            }
            ++count;
        }
        if (streetBuffer.length() == 0) {
            String tmp = origBuffer.toString();
            if (FIN_AddressTerm.containsCompanySuffix(tmp)) {
                this.debug("Company postcode likely, setting all buffers to empty");
                streetBuffer = new StringBuffer();
                streetTypeBuffer = new StringBuffer();
                hnrBuffer = new StringBuffer();
            } else {
                streetBuffer.append(origBuffer.toString());
            }
        }
        String streetType = streetTypeBuffer.toString();
        if (hnrBuffer.length() > 0) {
            hnr = hnrBuffer.toString();
        }
        street = streetBuffer.toString();
        this.debug("StreetBuff = " + street);
        this.debug("StreetTypeBuffer = " + streetType);
        this.debug("HouseNumberBuffer = " + hnr);
        if (streetType != null && streetType.length() > 0) {
            if (streetType.trim().equalsIgnoreCase(street.trim())) {
                streetType = null;
                this.debug("Street type = street, therefore set streetType= null");
            } else {
                street = this.removeStreetType(street, streetType);
                this.debug("streetType removed, street = " + street);
            }
            if (streetType != null) {
                parsedAddress.setPostThoroughfareType(FIN_ThoroughfareTypes.lookupProperName(streetType));
            }
        }
        this.sortStreet(street, parsedAddress);
        if (hnr != null) {
            this.debug("Setting unparsed HNR to : " + hnr);
            this.addFields.put(UNPARSED_HNR, hnr);
        }
        String houseNumber = this.getProperHouseNumber(hnr, parsedAddress);
        if (parsedAddress.getAddressNumber() == null && houseNumber != null) {
            parsedAddress.setAddressNumber(houseNumber);
        }
        if (hnr != null && !StringUtilities.isNumeric((String)hnr)) {
            if (houseNumber != null) {
                int houseNumberIndex = hnr.indexOf(houseNumber);
                if (houseNumberIndex != -1) {
                    parsedAddress.setPostAddress(hnr.substring(0, houseNumberIndex).trim());
                }
            } else {
                parsedAddress.setPostAddress(hnr.trim());
            }
        }
        if (parsedAddress.getPreAddress() == null || parsedAddress.getPreAddress().length() == 0) {
            parsedAddress.setPreAddress(null);
        } else if (FIN_AddressTerm.containsCompanySuffix(parsedAddress.getPreAddress())) {
            parsedAddress.setPreAddress(this.stripOutPostCompanySuffixString(parsedAddress.getPreAddress()));
        }
        parsedAddress.setAdditionalFields(this.addFields);
    }

    public String stripOutPostCompanySuffixString(String term) {
        if (term == null || term.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(term, this.getDelimiters());
        StringBuffer result = new StringBuffer();
        boolean startAdding = false;
        while (tokens.hasMoreTokens()) {
            String s = tokens.nextToken();
            if (startAdding) {
                result.append(s);
            }
            if (!FIN_AddressTerm.containsCompanySuffix(s)) continue;
            startAdding = true;
        }
        term = result.toString().trim();
        if (term.length() == 0) {
            return null;
        }
        return term;
    }

    public static boolean doVillageCheck(Address pa) {
        String firstWordInMainInput = null;
        boolean isVillage = false;
        if (pa.getPreAddress() != null && pa.getPreAddress().length() != 0) {
            firstWordInMainInput = pa.getPreAddress();
        } else if (pa.getMainAddress() != null && pa.getMainAddress().length() != 0) {
            firstWordInMainInput = firstWordInMainInput + pa.getMainAddress();
        }
        if (pa.getPostThoroughfareType() != null && pa.getPostThoroughfareType().length() != 0 && firstWordInMainInput != null) {
            firstWordInMainInput = firstWordInMainInput + pa.getPostThoroughfareType();
        }
        if (firstWordInMainInput != null && firstWordInMainInput.length() != 0) {
            if (FIN_DataManager.isGeoInfoPresent(FIN_AddressTerm.removeDiacritics(firstWordInMainInput))) {
                isVillage = true;
            }
            if (isVillage) {
                pa.setAreaName3(firstWordInMainInput);
                pa.setMainAddress(null);
                pa.setAdditionalFields(new HashMap());
                pa.setAddressNumber((ParsedNumber)null);
                pa.setPreAddress(null);
                pa.setPostThoroughfareType(null);
            }
        }
        return isVillage;
    }

    private String separateValidInitialNonDigitSection(String s) {
        StringBuffer buff = new StringBuffer();
        char[] array = s.toCharArray();
        for (int i = 0; i < array.length && !Character.isDigit(array[i]); ++i) {
            buff.append(array[i]);
        }
        String temp = buff.toString();
        if (temp != null && temp.length() >= 3) {
            return temp;
        }
        return null;
    }

    private boolean isMainPresentAfter(LinkedList listOfTokens, int position) {
        for (int i = position + 1; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            if ((term.length() < 3 || this.containsDigit(term)) && !this.hasStreetTypeEnding(term)) continue;
            return true;
        }
        return false;
    }

    private void removeJunk(LinkedList listOfTokens) {
        int i;
        this.debug("removeJunk: List = " + listOfTokens.toString());
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            String mayBeNumber;
            String term = (String)listOfTokens.get(i);
            if (term.equalsIgnoreCase("P")) {
                start = i;
                int n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("O")) {
                            ++n;
                        }
                        if (n < listOfTokens.size()) {
                            if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size()) {
                                if (((String)listOfTokens.get(n)).equalsIgnoreCase("BOX")) {
                                    ++n;
                                } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                    end = n;
                                    break;
                                }
                                if (n < listOfTokens.size()) {
                                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                        ++n;
                                    }
                                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                        end = n;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("PO") || term.equalsIgnoreCase("PL")) {
                start = i;
                int n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("BOX")) {
                            ++n;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("POBOX") || term.equalsIgnoreCase("Postilokero")) {
                start = i;
                int n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BOX")) {
                start = i;
                int n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                        while (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                            ++n;
                        }
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.startsWith("PL")) {
                String mayBeNumber2 = term.substring(2);
                if (StringUtilities.isNumeric((String)mayBeNumber2)) {
                    start = i;
                    listOfTokens.remove(start);
                    end = 0;
                    break;
                }
            } else if (term.startsWith("Postilokero") && StringUtilities.isNumeric((String)(mayBeNumber = term.substring(11)))) {
                start = i;
                listOfTokens.remove(start);
                end = i;
                break;
            }
            if (end > 0) break;
        }
        this.debug("removeJunk: POBOX start = " + start);
        this.debug("removeJunk: POBOX end = " + end);
        if (start >= 0 && end > 0 && start <= end) {
            for (i = start; i <= end; ++i) {
                this.debug("removeJunk: Removing " + listOfTokens.get(start));
                listOfTokens.remove(start);
            }
        }
    }

    private String removeStreetType(String street, String streetType) {
        int begin = 0;
        int end = street.length() - streetType.length();
        street = street.substring(begin, end);
        return street;
    }

    private void sortStreet(String street, Address pa) {
        StringBuffer common = new StringBuffer();
        StringBuffer main = new StringBuffer();
        StringBuffer pre = new StringBuffer();
        boolean mainOccured = false;
        boolean mainWasLastToken = false;
        boolean hyphenBeforeMain = false;
        if (street == null) {
            pa.setMainAddress(null);
            pa.setPreAddress(null);
            this.addFields.put("address.common.pre.main", "");
            return;
        }
        if (street.length() == 0) {
            pa.setMainAddress(null);
            pa.setPreAddress(null);
            this.addFields.put("address.common.pre.main", "");
            return;
        }
        StringTokenizer tokens = new StringTokenizer(street, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        while (listOfTokens.size() > 0) {
            String term = (String)listOfTokens.getLast();
            if (FIN_AddressTerm.isCommonTerm(term)) {
                if (common.length() == 0) {
                    common.append(term);
                } else {
                    common.append(" " + term);
                }
                mainWasLastToken = false;
                listOfTokens.removeLast();
                continue;
            }
            if (FIN_AddressTerm.isPunctuation(term)) {
                listOfTokens.removeLast();
                if (mainWasLastToken && term.equalsIgnoreCase("-")) {
                    hyphenBeforeMain = true;
                }
                mainWasLastToken = false;
                continue;
            }
            if (mainOccured) {
                if (pre.length() == 0) {
                    if (hyphenBeforeMain) {
                        pre.append(term + "-");
                    } else {
                        pre.append(term);
                    }
                } else {
                    pre.append(" " + term);
                }
                listOfTokens.removeLast();
                mainWasLastToken = false;
                continue;
            }
            main.append(term);
            listOfTokens.removeLast();
            mainOccured = true;
            mainWasLastToken = true;
        }
        String mainAdd = main.toString().trim();
        String preAdd = pre.toString().trim();
        String preAddCommon = common.toString().trim();
        mainAdd = this.reverseOrder(mainAdd, " ");
        preAdd = this.reverseOrder(preAdd, " ");
        preAddCommon = this.reverseOrder(preAddCommon, " ");
        pa.setMainAddress(mainAdd);
        pa.setPreAddress(preAdd);
        if (pa.getMainAddress() == null || pa.getMainAddress().length() == 0) {
            if (pa.getPreAddress() != null && pa.getPreAddress().length() != 0) {
                pa.setMainAddress(pa.getPreAddress());
                pa.setPreAddress(null);
            } else if (preAddCommon != null && preAddCommon.length() != 0) {
                pa.setMainAddress(preAddCommon);
                preAddCommon = "";
            }
        }
        this.addFields.put("address.common.pre.main", preAddCommon);
    }

    private String reverseOrder(String s, String delim) {
        this.debug("reverseOrder: Reversing '" + s + "'");
        if (s == null) {
            this.debug("reverseOrder: String is null");
            return null;
        }
        if (s.length() == 0) {
            this.debug("reverseOrder: String is empty");
            return s;
        }
        StringBuffer reversed = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(s, delim, true);
        LinkedList list = StringUtilities.tokensToList((StringTokenizer)tokens);
        for (int i = list.size() - 1; i >= 0; --i) {
            reversed.append((String)list.get(i));
        }
        return reversed.toString();
    }

    private String getStreetTypeEnding(String s) {
        String replaceWord = FIN_AddressTerm.replaceExtendedChars(s);
        if (replaceWord != null) {
            s = replaceWord;
        }
        int lastLetterIndex = s.length();
        for (int i = 0; i < lastLetterIndex - 1; ++i) {
            String endSection = s.substring(i, lastLetterIndex);
            this.debug("getStreetTypeEnding: Checking " + endSection);
            if (!FIN_ThoroughfareTypes.isStreetType(endSection)) continue;
            if (i == 0) {
                this.addFields.put("address.separator.post.st_type", "true");
            }
            return StringUtilities.toProperCase((String)endSection);
        }
        return null;
    }

    private String splitList(int begin, int end, LinkedList listOfTokens) {
        StringBuffer buff = new StringBuffer();
        for (int i = begin; i <= end; ++i) {
            buff.append((String)listOfTokens.get(i));
        }
        return buff.toString();
    }

    private boolean containsDigit(String s) {
        char[] array = s.toCharArray();
        for (int i = 0; i < array.length; ++i) {
            if (!Character.isDigit(array[i])) continue;
            return true;
        }
        return false;
    }

    public static int extractFirstDigits(String s) {
        StringBuffer result = new StringBuffer();
        char[] array = s.trim().toCharArray();
        for (int i = 0; i < array.length && Character.isDigit(array[i]); ++i) {
            result.append(array[i]);
        }
        if (result.length() > 0) {
            return Integer.parseInt(result.toString());
        }
        return -1;
    }

    private boolean hasStreetTypeEnding(String s) {
        String buf = FIN_AddressTerm.replaceExtendedChars(s);
        if (buf.toString().length() != 0) {
            s = buf.toString();
        }
        int lastLetterIndex = s.length();
        for (int i = 0; i < lastLetterIndex - 1; ++i) {
            String endSection = s.substring(i, lastLetterIndex);
            this.debug("hasStreetTypeEnding: Checking " + endSection);
            if (!FIN_ThoroughfareTypes.isStreetType(endSection)) continue;
            return true;
        }
        return false;
    }

    private void clean(LinkedList listOfTokens) {
        String term;
        while (listOfTokens.size() > 0 && FIN_AddressTerm.isPunctuation(term = (String)listOfTokens.getFirst())) {
            listOfTokens.removeFirst();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the beggining");
        }
        while (listOfTokens.size() > 0 && FIN_AddressTerm.isPunctuation(term = (String)listOfTokens.getLast())) {
            listOfTokens.removeLast();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the end");
        }
    }

    private void debug(String message) {
        if (debug) {
            System.out.println("DEBUG: " + message);
        }
    }

    private String getDelimiters() {
        StringBuffer buf = new StringBuffer(20);
        if (FIN_AddressTerm.getPunctuationsAsString() != null) {
            buf.append(FIN_AddressTerm.getPunctuationsAsString());
        }
        if (FIN_AddressTerm.getOrdinalsAsString() != null) {
            buf.append(FIN_AddressTerm.getOrdinalsAsString());
        }
        if (buf.length() > 0) {
            return buf.toString();
        }
        return null;
    }

    protected String standardisePunctuation(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            if (FIN_AddressTerm.isPunctuation(s.substring(i, i + 1))) {
                if (i == 0 || FIN_AddressTerm.isPunctuation(s.substring(i - 1, i))) continue;
                result.append("-");
                continue;
            }
            result.append(s.substring(i, i + 1));
        }
        return result.toString().trim();
    }

    private String formatHouseNumber(String hnrIn) {
        if (hnrIn == null || hnrIn.length() == 0) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        String currentToken = null;
        int currentHigh = 0;
        hnrIn = this.standardisePunctuation(hnrIn);
        StringTokenizer tokens = new StringTokenizer(hnrIn, "-", true);
        while (tokens.hasMoreTokens()) {
            currentToken = tokens.nextToken();
            if (currentToken.equals("-")) {
                if (result.length() == 0) continue;
                result.append(currentToken);
                continue;
            }
            int i = FIN_ParseMainAddressRule.extractFirstDigits(currentToken);
            if (i != -1) {
                if (i > currentHigh) {
                    if (result.length() == 0) {
                        result.append(i);
                        currentHigh = i;
                        continue;
                    }
                    result.append(i);
                    return result.toString().trim();
                }
                this.debug("Second number is lower than first, take first only and remove all hyphens");
                return result.toString().replace('-', ' ').trim();
            }
            this.debug("Invalid house number format");
            return null;
        }
        if (result == null || result.toString().trim().length() == 0) {
            return null;
        }
        return this.removeTrailingPunctuation(result.toString());
    }

    public String removeTrailingPunctuation(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        String tmp = null;
        for (int i = s.length(); i >= 0; --i) {
            tmp = s.substring(s.length() - 1);
            if (!FIN_AddressTerm.isPunctuation(tmp)) {
                return s;
            }
            s = s.substring(0, s.length() - 1);
        }
        return null;
    }

    private void removeKM(LinkedList listOfTokens) {
        int i;
        this.debug("removeKM: List = " + listOfTokens.toString());
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            if (!term.equalsIgnoreCase("KM")) continue;
            start = i;
            int n = i + 1;
            if (n >= listOfTokens.size()) continue;
            if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                ++n;
            }
            if (n >= listOfTokens.size() || !StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) continue;
            end = n;
            break;
        }
        this.debug("removeJunk: KM start = " + start);
        this.debug("removeJunk: KM end = " + end);
        if (start >= 0 && end > 0 && start < end) {
            for (i = start; i <= end; ++i) {
                this.debug("removeJunk: Removing " + listOfTokens.get(start));
                listOfTokens.remove(start);
            }
        }
    }

    private boolean nextStringTokenIsFloor(LinkedList listOfTokens, int n) {
        for (int i = n; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            if (FIN_AddressTerm.isPunctuation(term)) continue;
            if (term.equalsIgnoreCase("TR")) {
                return true;
            }
            if (term.length() >= 3) {
                if (!StringUtilities.isNumeric((String)term.substring(0, term.length() - 2)) || !term.substring(term.length() - 2).equalsIgnoreCase("TR")) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    private String removeFloor(LinkedList listOfTokens) {
        String term;
        boolean houseNumberOccured = false;
        StringBuffer hnr = new StringBuffer();
        for (int i = 0; !(i >= listOfTokens.size() || (term = (String)listOfTokens.get(i)).equals(":") && houseNumberOccured); ++i) {
            if (FIN_AddressTerm.isPunctuation(term) && hnr.length() > 0) {
                hnr.append(term);
            }
            if (StringUtilities.isNumeric((String)((String)listOfTokens.get(i)))) {
                if (this.nextStringTokenIsFloor(listOfTokens, i + 1)) {
                    hnr.append(term);
                    break;
                }
                houseNumberOccured = true;
                hnr.append(term);
                continue;
            }
            if (term.length() == 1 && Character.isLetter(term.charAt(0)) && houseNumberOccured) {
                this.debug("Entrance number detected: Discard rest of list");
                break;
            }
            if (!StringUtilities.isNumeric((String)term.substring(0, 1))) continue;
            int n = 0;
            while (StringUtilities.isNumeric((String)term.substring(n, n + 1))) {
                hnr.append(term.substring(n, n + 1));
                ++n;
            }
            break;
        }
        if (hnr.toString().trim() == null || hnr.toString().trim().length() == 0) {
            this.debug("removeFloor : returning null");
            return null;
        }
        this.debug("removeFloor : " + hnr.toString().trim());
        return hnr.toString().trim();
    }

    private String getProperHouseNumber(String inHnr, Address pa) {
        if (inHnr == null || inHnr.trim().length() == 0) {
            return null;
        }
        this.debug("getProperHouseNumber--HNR = " + inHnr);
        if (inHnr.trim().length() >= 2 && inHnr.substring(0, 1).equalsIgnoreCase("AB") && (pa.getPostThoroughfareType() == null || pa.getPostThoroughfareType().length() == 0)) {
            pa.setMainAddress(null);
            pa.setPostThoroughfareType(null);
            pa.setPreAddress(null);
            pa.setPostAddress(null);
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(inHnr, this.getDelimiters(), true);
        LinkedList listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
        this.debug("getProperHouseNumber: List = " + listOfTokens.toString());
        String houseNum = null;
        this.removeKM(listOfTokens);
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String term = listOfTokens.get(i).toString();
            if (!StringUtilities.isNumeric((String)term) || term.length() != 5 || !StringUtilities.isEmpty((String)pa.getPostCode1())) continue;
            listOfTokens.remove(i);
        }
        if (listOfTokens != null) {
            houseNum = this.removeFloor(listOfTokens);
            houseNum = this.formatHouseNumber(houseNum);
        }
        return houseNum;
    }

    public static boolean isValidHouseNumber(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        int hnrLen = (hnr = hnr.trim()).length();
        if (hnrLen > 1 && Character.isLetter(hnr.charAt(hnrLen - 1))) {
            return FIN_ParseMainAddressRule.isValidNumberFormat(hnr.substring(0, hnrLen - 1), hnrLen - 1);
        }
        return FIN_ParseMainAddressRule.isValidNumberFormat(hnr, hnrLen);
    }

    public static boolean isValidHouseNumberRange(String hnr) {
        if (hnr == null || hnr.length() == 0) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(hnr, "-/");
        if (!st.hasMoreTokens() || st.countTokens() != 2) {
            return false;
        }
        if (!FIN_ParseMainAddressRule.isValidHouseNumber(st.nextToken())) {
            return false;
        }
        return FIN_ParseMainAddressRule.isValidHouseNumber(st.nextToken());
    }

    public static boolean isValidNumberFormat(String num, int len) {
        boolean bRc = true;
        if (num == null || num.trim().length() == 0) {
            return false;
        }
        if (num.trim().length() == len) {
            for (int i = 0; i < num.length(); ++i) {
                char ch = num.charAt(i);
                if (ch >= '0' && ch <= '9') continue;
                bRc = false;
                break;
            }
        } else {
            bRc = false;
        }
        return bRc;
    }
}

