/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.FIN.parser.FIN_AddressTerm;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.core.parser.IParseRule;
import com.mapinfo.mapmarker.core.parser.ParserException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.LinkedList;
import java.util.StringTokenizer;

public class FIN_ParsePostAddressRule
implements IParseRule {
    private static final boolean debug = false;
    private static final String punctuations = "' -()/.,\\";
    private static String[] countryNames = new String[]{"FI", "FIN", "FINLAND", "SUOMI", "SF"};
    public static final int POST_CODE_INVALID = 0;
    public static final int POST_CODE_FULL = 3;
    public static final int POST_CODE_PARTIAL = 4;

    public void parse(Address unrefinedAddress, Address parsedAddress, IConstraints constraints) throws ParserException {
        String areaName3;
        int spaceIndex;
        StringTokenizer tokens;
        LinkedList listOfTokens = null;
        String postCodeUnparsed = parsedAddress.getPostCode1();
        if (postCodeUnparsed != null) {
            postCodeUnparsed = postCodeUnparsed.replaceAll("'", "");
            parsedAddress.setPostCode1(postCodeUnparsed);
        }
        if (postCodeUnparsed != null && postCodeUnparsed.length() != 0) {
            tokens = new StringTokenizer(postCodeUnparsed, punctuations, true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            this.seperatePostcode(listOfTokens, parsedAddress);
        }
        if (!StringUtilities.isNumeric((String)parsedAddress.getPostCode1())) {
            parsedAddress.setPostCode1(null);
            listOfTokens = null;
        }
        if (parsedAddress.getAreaName3() != null && (spaceIndex = (areaName3 = parsedAddress.getAreaName3()).indexOf(" ")) > -1) {
            String str1 = areaName3.substring(0, spaceIndex);
            String str2 = areaName3.substring(areaName3.indexOf(" "), areaName3.length()).trim();
            areaName3 = str1 + " " + str2;
            StringTokenizer tokens2 = new StringTokenizer(areaName3, punctuations, true);
            LinkedList token = StringUtilities.tokensToList((StringTokenizer)tokens2);
            this.seperateTown(token, parsedAddress);
        }
        if (parsedAddress.getPostAddress() != null && parsedAddress.getPostAddress().trim().length() > 0) {
            tokens = new StringTokenizer(parsedAddress.getPostAddress(), punctuations, true);
            listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
            this.debug("List before removeJunk: " + listOfTokens.toString());
            this.removeJunk(listOfTokens);
            this.debug("List after removeJunk: " + listOfTokens.toString());
            listOfTokens = this.removeCountry(listOfTokens);
            if (parsedAddress.getPostCode1() == null) {
                this.seperatePostcode(listOfTokens, parsedAddress);
            }
        } else {
            String allTownNamesBeforeParsing = this.createTownName(parsedAddress);
            if (allTownNamesBeforeParsing != null && allTownNamesBeforeParsing.trim().length() > 0) {
                StringTokenizer tokens3 = new StringTokenizer(allTownNamesBeforeParsing, punctuations, true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens3);
            }
        }
        if (listOfTokens != null) {
            listOfTokens = this.removeCountry(listOfTokens);
        }
        if (listOfTokens != null) {
            this.debug("List before cleanTown: " + listOfTokens.toString());
            this.cleanTown(listOfTokens);
            if (parsedAddress.getAreaName3() == null) {
                this.seperateTown(listOfTokens, parsedAddress);
            }
        }
        String postcode = parsedAddress.getPostCode1();
        if (parsedAddress != null && postcode != null && postcode.length() == 5 && postcode.substring(4).equalsIgnoreCase("1")) {
            parsedAddress.setGenericField1(postcode);
            postcode = postcode.substring(0, 4) + "0";
            parsedAddress.setPostCode1(postcode);
        }
        if (parsedAddress.getPostAddress() != null) {
            parsedAddress.setPostAddress(null);
        }
    }

    protected String createTownName(Address address) {
        if (address == null) {
            return null;
        }
        StringBuffer result = new StringBuffer();
        if (address.getAreaName3() == null) {
            return null;
        }
        result.append(address.getAreaName3() + " ");
        if (address.getAreaName1() != null) {
            result.append(address.getAreaName1() + " ");
        }
        if (result == null || result.toString().trim().length() == 0) {
            return null;
        }
        return result.toString().trim();
    }

    private void removeJunk(LinkedList listOfTokens) {
        int i;
        this.debug("removeJunk: List = " + listOfTokens.toString());
        int start = 0;
        int end = 0;
        for (i = 0; i < listOfTokens.size(); ++i) {
            int n;
            String term = (String)listOfTokens.get(i);
            if (term.equalsIgnoreCase("P")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("O")) {
                            ++n;
                        }
                        if (n < listOfTokens.size()) {
                            if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size()) {
                                if (((String)listOfTokens.get(n)).equalsIgnoreCase("BOX")) {
                                    ++n;
                                } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                    end = n;
                                    break;
                                }
                                if (n < listOfTokens.size()) {
                                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                        ++n;
                                    }
                                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                        end = n;
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("PO") || term.equalsIgnoreCase("PL")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size()) {
                        if (((String)listOfTokens.get(n)).equalsIgnoreCase("BOX")) {
                            ++n;
                        } else if (StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                            end = n;
                            break;
                        }
                        if (n < listOfTokens.size()) {
                            if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                                ++n;
                            }
                            if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                                end = n;
                                break;
                            }
                        }
                    }
                }
            } else if (term.equalsIgnoreCase("POBOX")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            } else if (term.equalsIgnoreCase("BOX")) {
                start = i;
                n = i + 1;
                if (n < listOfTokens.size()) {
                    if (FIN_AddressTerm.isPunctuation((String)listOfTokens.get(n))) {
                        ++n;
                    }
                    if (n < listOfTokens.size() && StringUtilities.isNumeric((String)((String)listOfTokens.get(n)))) {
                        end = n;
                        break;
                    }
                }
            }
            if (end > 0) break;
        }
        this.debug("removeJunk: POBOX start = " + start);
        this.debug("removeJunk: POBOX end = " + end);
        if (start >= 0 && end > 0 && start < end) {
            for (i = start; i <= end; ++i) {
                this.debug("removeJunk: Removing " + listOfTokens.get(start));
                listOfTokens.remove(start);
            }
        }
    }

    public static int getPostCodeType(String postCode) {
        if (postCode.length() == 5) {
            return 3;
        }
        if (postCode.length() >= 2) {
            return 4;
        }
        return 0;
    }

    public static String getOutwardSortingCode(String postCode) {
        if (postCode == null || postCode.trim().length() == 0) {
            return null;
        }
        if (postCode.length() >= 3) {
            return postCode.trim().substring(0, 3);
        }
        return postCode.trim();
    }

    private void seperateTown(LinkedList listOfTokens, Address pa) {
        if (listOfTokens == null || listOfTokens.size() == 0) {
            this.debug("seperateTown: List empty");
            return;
        }
        this.clearAllAreaNames(pa);
        boolean inBrackets = false;
        StringBuffer townBuff = new StringBuffer();
        StringBuffer origTownBuff = new StringBuffer();
        for (int i = 0; i < listOfTokens.size(); ++i) {
            String term = (String)listOfTokens.get(i);
            origTownBuff.append(term);
            if (term.equals("(")) {
                this.debug("seperateTown: Found (, ommiting it");
                inBrackets = true;
                continue;
            }
            if (term.equals(")")) {
                this.debug("seperateTown: Found ), ommiting it");
                inBrackets = false;
                continue;
            }
            if (FIN_AddressTerm.isPunctuation(term)) {
                this.debug("seperateTown: Found punctuation, replacing with space in buffer");
                townBuff.append(" ");
                continue;
            }
            if (FIN_AddressTerm.isCommonTerm(term)) {
                this.debug("seperateTown: Found common term, ommiting it");
                continue;
            }
            if (inBrackets) {
                this.debug("seperateTown: Term is in Brackets, ommiting it");
                continue;
            }
            this.debug("seperateTown: Adding " + term + " to areanames");
            townBuff.append(term);
            String shortTown = FIN_AddressTerm.getValidTerm(townBuff.toString().trim());
            if (FIN_AddressTerm.isMultiWordAreaName(shortTown)) {
                this.clearAllAreaNames(pa);
                pa.setAreaName3(shortTown);
                continue;
            }
            FIN_ParsePostAddressRule.addStringToAreaNames(term, pa);
        }
        String origTown = origTownBuff.toString().trim();
        pa.setGenericField1(origTown);
    }

    public void clearAllAreaNames(Address pa) {
        pa.setAreaName3(null);
        pa.setAreaName4(null);
    }

    public static void addStringToAreaNames(String s, Address pa) {
        if (s == null || s.length() == 0) {
            return;
        }
        if (pa.getAreaName3() == null || pa.getAreaName3().length() == 0) {
            if (!StringUtilities.hasNumeric((String)s)) {
                pa.setAreaName3(s);
            }
        } else if (pa.getAreaName1() == null || pa.getAreaName1().length() == 0) {
            pa.setAreaName1(s);
        }
    }

    private void cleanTown(LinkedList listOfTokens) {
        String term;
        while (listOfTokens.size() > 0 && FIN_AddressTerm.isPunctuation(term = (String)listOfTokens.getFirst())) {
            listOfTokens.removeFirst();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the beggining");
        }
        term = null;
        while (listOfTokens.size() > 0 && FIN_AddressTerm.isPunctuation(term = (String)listOfTokens.getLast())) {
            listOfTokens.removeLast();
            this.debug("cleanTown: " + term + " is a punctuation, remove it from the end");
        }
    }

    private LinkedList removeCountry(LinkedList listOfTokens) {
        boolean countryCodeFound = false;
        StringBuffer buff = new StringBuffer();
        for (int n = 0; n < listOfTokens.size(); ++n) {
            String temp = (String)listOfTokens.get(n);
            if (this.isCountry(temp)) {
                this.debug("removeCountry: Found country space, removing it");
                countryCodeFound = true;
                continue;
            }
            if (temp.equals("-") && countryCodeFound) {
                this.debug("removeCountry:Found '-', removing it");
                continue;
            }
            if (temp.length() >= 3 && this.isCountry(temp.substring(0, 3)) && temp.length() > 3) {
                if (!StringUtilities.isNumeric((String)temp.substring(3, 4))) continue;
                this.debug("removeCountry: '[CountryName]####' Found, setting tokens to ####");
                buff.append(temp.substring(3));
                continue;
            }
            buff.append(temp);
        }
        String newPostAddress = buff.toString().trim();
        this.debug("removeCountry: After processing : " + newPostAddress);
        if (newPostAddress == null || newPostAddress.length() == 0) {
            return null;
        }
        StringTokenizer tokens = new StringTokenizer(newPostAddress, punctuations, true);
        return StringUtilities.tokensToList((StringTokenizer)tokens);
    }

    public boolean isCountry(String country) {
        for (int i = 0; i < countryNames.length; ++i) {
            if (!country.equalsIgnoreCase(countryNames[i])) continue;
            return true;
        }
        return false;
    }

    private void seperatePostcode(LinkedList listOfTokens, Address pa) {
        String result;
        String temp;
        if (listOfTokens == null || listOfTokens.size() == 0) {
            this.debug("seperatePostcode: empty token");
            return;
        }
        int len = listOfTokens.size();
        boolean partPostcode = false;
        StringBuffer postBuf = new StringBuffer();
        this.debug("seperatePostcode: List: " + listOfTokens.toString());
        for (int i = 0; i < len; ++i) {
            temp = (String)listOfTokens.get(i);
            if (temp.equals(" ")) continue;
            if (StringUtilities.isNumeric((String)temp)) {
                if (postBuf.length() < 5 && partPostcode) {
                    if (temp.length() > 5 - postBuf.length()) {
                        listOfTokens.set(i, temp.substring(5 - postBuf.length()));
                        postBuf.append(temp.substring(0, 5 - postBuf.length()));
                    } else {
                        postBuf.append(temp.substring(0));
                        listOfTokens.remove(i);
                        --len;
                    }
                    partPostcode = true;
                } else if (temp.length() > 5) {
                    postBuf.append(temp.substring(0, 5));
                    listOfTokens.set(i, temp.substring(5));
                    partPostcode = false;
                } else {
                    postBuf.append(temp);
                    listOfTokens.remove(i);
                    --len;
                    partPostcode = true;
                }
                if (postBuf.length() != 5) continue;
                if (!postBuf.toString().substring(0, 3).equalsIgnoreCase("000")) break;
                postBuf = new StringBuffer();
                partPostcode = false;
                continue;
            }
            partPostcode = false;
        }
        if ((result = postBuf.toString().trim()).length() > 0) {
            pa.setPostCode1(postBuf.toString());
        } else {
            String postCode = pa.getPostCode1();
            if (postCode != null) {
                StringTokenizer tokens = new StringTokenizer(postCode, "-", true);
                listOfTokens = StringUtilities.tokensToList((StringTokenizer)tokens);
                len = listOfTokens.size();
                postBuf = new StringBuffer();
                for (int i = 0; i < len; ++i) {
                    temp = (String)listOfTokens.get(i);
                    if (this.isCountry(temp) || temp.equals("-")) continue;
                    postBuf.append(temp);
                }
                pa.setPostCode1(postBuf.toString());
            }
        }
    }

    private void debug(String message) {
    }
}

