/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.FIN.parser.FIN_ThoroughfareTypes;
import com.mapinfo.mapmarker.FIN.parser.GenericSpecialStreetHandling;
import com.mapinfo.mapmarker.FIN.parser.ISpecialStreetHandling;
import com.mapinfo.mapmarker.FIN.parser.Tie_SpecialStreetHandling;
import com.mapinfo.mapmarker.common.Address;
import java.util.ArrayList;
import java.util.List;

public final class FIN_SpecialStreetsHandling {
    private static final List SPECIAL_HANLDINGS = new ArrayList(7);

    private FIN_SpecialStreetsHandling() {
    }

    public static boolean handleSpecialStreet(Address pa, String streetName) {
        if (streetName == null) {
            return false;
        }
        streetName = FIN_SpecialStreetsHandling.replaceUnwantedChars(streetName.trim());
        streetName = FIN_SpecialStreetsHandling.splitHyphen(streetName.trim());
        String[] tokens = streetName.split(" ");
        StringBuffer buffer = new StringBuffer();
        buffer.append(tokens[0]);
        for (int i = 1; i < tokens.length; ++i) {
            String term = tokens[i];
            if (FIN_ThoroughfareTypes.isStreetType(term)) {
                buffer.append(term);
                continue;
            }
            buffer.append(" " + term);
        }
        tokens = buffer.toString().split(" ");
        buffer = null;
        if (tokens.length == 1 && (tokens = FIN_SpecialStreetsHandling.splitNumberFromWord(streetName)) != null) {
            tokens[0] = tokens[0] + tokens[1].trim();
            tokens[1] = "";
        }
        if (tokens == null || tokens.length < 1) {
            return false;
        }
        StringBuffer buf = new StringBuffer();
        boolean flag = false;
        for (int i = 0; i < tokens.length; ++i) {
            int len = tokens[i].length();
            if (len > 3) {
                buf.delete(0, buf.length());
                flag = FIN_SpecialStreetsHandling.getProperName(tokens, buf, len - 2, flag, i);
            }
            if (flag || len <= 0) continue;
            buf.delete(0, buf.length());
            flag = FIN_SpecialStreetsHandling.getProperName(tokens, buf, len - 1, flag, i);
        }
        for (int index = 0; index < SPECIAL_HANLDINGS.size(); ++index) {
            ISpecialStreetHandling handling = (ISpecialStreetHandling)SPECIAL_HANLDINGS.get(index);
            if (!handling.handle(pa, tokens)) continue;
            return true;
        }
        return false;
    }

    private static boolean getProperName(String[] tokens, StringBuffer buf, int len, boolean flag, int i) {
        int length = tokens[i].length();
        String temp = tokens[i].substring(len, length);
        buf.append(tokens[i].substring(0, len));
        if (FIN_ThoroughfareTypes.lookupProperName(temp) != null) {
            buf.append(FIN_ThoroughfareTypes.lookupProperName(temp));
            flag = true;
        } else {
            buf.append(temp);
        }
        tokens[i] = buf.toString();
        return flag;
    }

    public static String replaceUnwantedChars(String str) {
        str = str.replaceAll("\\p{Punct}", " ");
        return str;
    }

    private static String[] splitNumberFromWord(String word) {
        char ch;
        String[] ret = null;
        if (word == null) {
            return null;
        }
        boolean flag = false;
        word = word.trim();
        int len = word.length();
        int pos = -1;
        int i = len - 1;
        while (i > -1 && (ch = word.charAt(i)) >= '0' && ch <= '9') {
            pos = i--;
            flag = true;
        }
        if (!flag) {
            for (i = 0; i < len - 1 && (ch = word.charAt(i)) >= '0' && ch <= '9'; ++i) {
                pos = i + 1;
            }
        }
        if (pos != -1) {
            ret = new String[]{word.substring(0, pos), word.substring(pos)};
        }
        return ret;
    }

    private static String splitHyphen(String str) {
        int index = str.indexOf(45);
        if (index > 0) {
            StringBuffer buf = new StringBuffer();
            buf.append(str.substring(0, index));
            buf.append(" ");
            buf.append(str.substring(index));
            str = buf.toString();
        }
        return str;
    }

    static {
        List genericHandlers = GenericSpecialStreetHandling.getgenericSpecialStreetHandlers();
        SPECIAL_HANLDINGS.addAll(genericHandlers);
        SPECIAL_HANLDINGS.add(new Tie_SpecialStreetHandling());
    }
}

