/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Properties;
import java.util.StringTokenizer;

public class FIN_ThoroughfareTypes {
    private static Properties m_streetTypes = null;
    private static HashMap m_keys = new HashMap();

    public static String lookupProperName(String key) {
        if (key == null) {
            return null;
        }
        Object o = m_keys.get(key);
        if (o == null && (o = m_keys.get(key = key.toUpperCase())) == null) {
            return null;
        }
        return ((KeyInfo)o).getProperTypeName();
    }

    public static boolean isStreetType(String aTerm) {
        boolean temp = false;
        temp = m_keys.containsKey(aTerm);
        if (!temp) {
            temp = m_keys.containsKey(aTerm.toUpperCase());
        }
        return temp;
    }

    static {
        try {
            if (m_streetTypes == null) {
                m_streetTypes = new Properties();
                m_streetTypes.load(FIN_ThoroughfareTypes.class.getResourceAsStream("FIN_ThoroughfareTypes.properties"));
                Enumeration<?> e = m_streetTypes.propertyNames();
                while (e.hasMoreElements()) {
                    KeyInfo key = new KeyInfo();
                    String type = (String)e.nextElement();
                    key.loadKey(m_streetTypes, type);
                    m_keys.put(type.toUpperCase(), key);
                }
            }
        }
        catch (Throwable T) {
            throw new RuntimeException("Unable to load required files for FIN_Parser.");
        }
    }

    static class KeyInfo {
        private String m_type = "";
        private String m_preferredType = "";
        private String m_properName = "";
        private boolean m_canStart = false;
        private boolean m_canEnd = false;

        KeyInfo() {
        }

        public String getTypeName() {
            return this.m_type;
        }

        public String getPreferredTypeName() {
            return this.m_preferredType;
        }

        public String getProperTypeName() {
            return this.m_properName;
        }

        public boolean canStart() {
            return this.m_canStart;
        }

        public boolean canEnd() {
            return this.m_canEnd;
        }

        public void loadKey(Properties p, String k) {
            String val = p.getProperty(k);
            StringTokenizer tokens = new StringTokenizer(val, ",");
            this.m_preferredType = tokens.nextToken();
            this.m_properName = tokens.nextToken();
            this.m_canStart = Boolean.valueOf(tokens.nextToken());
            this.m_canEnd = Boolean.valueOf(tokens.nextToken());
        }
    }
}

