/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FIN.parser;

import com.mapinfo.mapmarker.FIN.parser.SpecialStreetInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class SpecialStreetInfoParser {
    private SpecialStreetInfoParser() {
    }

    public static List parseStreets(String fileName, Class cl) {
        return SpecialStreetInfoParser.getStreets(fileName, cl, false);
    }

    public static SpecialStreetInfo parseSingleStreet(String fileName, Class cl) {
        List streets = SpecialStreetInfoParser.getStreets(fileName, cl, true);
        if (streets.size() == 0) {
            return null;
        }
        return (SpecialStreetInfo)streets.get(0);
    }

    private static List getStreets(String fileName, Class cl, boolean bParseSingleStreet) {
        ArrayList<SpecialStreetInfo> streets = new ArrayList<SpecialStreetInfo>();
        try {
            SAXBuilder builder = new SAXBuilder(null, false);
            Document doc = builder.build(cl.getResourceAsStream(fileName));
            Element root = doc.getRootElement();
            List streetElems = root.getChildren("Street");
            for (int index = 0; index < streetElems.size(); ++index) {
                Element streetElem = (Element)streetElems.get(index);
                streets.add(SpecialStreetInfoParser.loadSpecialStreetInfo(streetElem));
                if (!bParseSingleStreet) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load required file " + fileName, e);
        }
        return streets;
    }

    private static SpecialStreetInfo loadSpecialStreetInfo(Element streetElem) {
        String name = streetElem.getAttributeValue("name").trim().toUpperCase();
        List list = streetElem.getChildren("postAddrCommon");
        HashSet<String> values = new HashSet<String>(list.size());
        for (int index = 0; index < list.size(); ++index) {
            values.add(((Element)list.get(index)).getTextTrim().toUpperCase());
        }
        return new SpecialStreetInfo(name, values);
    }
}

