/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FRAFrenchSoundex
extends Soundex {
    private static final int MAX_SOUNDEX_KEY_LENGTH = 9;
    private static final char[] letters = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '\u00c7', '\u00c0', '\u00c1', '\u00c2', '\u00c6', '\u00c9', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u00d3', '\u00d4', '\u00d9', '\u00db', '\u00dc'};
    private static final int[] sounds = new int[]{0, 1, 2, 3, 0, 1, 2, 0, 0, 2, 2, 4, 5, 5, 0, 1, 2, 6, 2, 3, 0, 1, 0, 0, 0, 2, 2, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String soundStr = "000000000000000000000000111122222222334556";
    private static final String charStr = "AEHIOUWY\u00c0\u00c1\u00c2\u00c6\u00c9\u00c8\u00ca\u00cb\u00ce\u00cf\u00d3\u00d4\u00d9\u00db\u00dcXBFPVCGJKQSZ\u00c7DTLMNR";
    private static final String DIGITS = "0123456789";
    protected static final int NUMERIC_CASE_REVERSE = 1;
    protected static final int NUMERIC_CASE_ADDZERO = 2;
    protected static final int NUMERIC_CASE_INCDEC = 3;
    private static final String VALID_CODES = "123456";
    private static final String DISTINCT_SOUNDS = "BSDLMR";
    private static final int SPECIAL_CASE_INITIALDIGIT = 1;
    private static final int SPECIAL_CASE_PO_BOX = 2;
    private static final char PO_BOX_FIRST_LETTER = '#';
    private static final Map<Character, Integer> m_soundHash;
    private static final int INCREASE_DECREASE_VALUE = 3;
    protected static final String[] ignoredWordList;

    public ISoundexKey getSoundex(String str) {
        if (str == null || str.length() == 0) {
            return null;
        }
        int spCaseType = this.isSpecialCase(str);
        if (spCaseType != 0) {
            return this.handleSpecialCases(spCaseType, str);
        }
        char[] inputStringArray = (str = this.removeUnwantedCharsAndWords(str)).toCharArray();
        if (inputStringArray.length == 0) {
            return null;
        }
        FRA_SoundexKey key = new FRA_SoundexKey();
        key.setFirstChar(inputStringArray[0]);
        int inputStringLength = inputStringArray.length;
        int returnCode = 0;
        int base = 1;
        int lastcode = 0;
        int sdx = 0;
        int i = 1;
        int soundexKeysAdded = 0;
        while (i < inputStringLength && soundexKeysAdded < 9) {
            char c = inputStringArray[i];
            boolean bIncrement = true;
            Integer intKey = m_soundHash.get(new Character(c));
            sdx = intKey == null ? 0 : intKey;
            boolean bVowel = false;
            if (sdx == 0) {
                bVowel = true;
                while (i < inputStringLength) {
                    if (Character.isDigit(c = inputStringArray[i++]) || (sdx = (intKey = m_soundHash.get(new Character(c))) == null ? 0 : intKey) == 0) continue;
                    bIncrement = false;
                    break;
                }
            }
            if (sdx != lastcode || bVowel) {
                returnCode += base * sdx;
                base *= 10;
                lastcode = sdx;
                ++soundexKeysAdded;
            }
            if (!bIncrement) continue;
            ++i;
        }
        key.setNumericValue(returnCode);
        return key;
    }

    public static int getCharSoundexCode(char c) {
        Integer i = m_soundHash.get(new Character(c));
        if (i != null) {
            return i;
        }
        return 0;
    }

    protected int isSpecialCase(String str) {
        if (Character.isDigit(str.charAt(0))) {
            return 1;
        }
        if ("BP".equals(str)) {
            return 2;
        }
        if ("CS".equals(str)) {
            return 2;
        }
        return 0;
    }

    protected ISoundexKey handleSpecialCases(int type, String str) {
        FRA_SoundexKey key = null;
        int code = 0;
        switch (type) {
            case 1: {
                code = this.getNumericValue(str);
                key = new FRA_SoundexKey();
                key.setFirstChar('0');
                key.setNumericValue(code);
                break;
            }
            case 2: {
                key = new FRA_SoundexKey();
                key.setFirstChar('#');
            }
        }
        return key;
    }

    protected int getNumericValue(String str) {
        int code = 0;
        try {
            code = Integer.parseInt(StringUtilities.trimToChars((String)str, (String)DIGITS));
        }
        catch (NumberFormatException e) {
            code = 0;
        }
        return code;
    }

    protected RemoveWordResult removeWord(String str, String word) {
        RemoveWordResult ret = new RemoveWordResult();
        ret.retStr = str;
        ret.found = 0;
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        if (str.indexOf(word) == -1) {
            return ret;
        }
        int wordLength = word.length();
        while (str.startsWith(word + ' ')) {
            ret.retStr = str = str.substring(wordLength + 1);
            ret.found = 1;
        }
        while (str.endsWith(' ' + word)) {
            ret.retStr = str = str.substring(0, str.length() - wordLength - 1);
            ret.found = 1;
        }
        int pos = str.indexOf(' ' + word + ' ');
        while (pos > -1) {
            str = str.substring(0, pos) + str.substring(pos + wordLength + 1);
            pos = str.indexOf(' ' + word + ' ');
            ret.retStr = str;
            ret.found = 1;
        }
        if (str.indexOf(" ") == -1) {
            ret.found = -1;
            return ret;
        }
        return ret;
    }

    protected String removeUnwantedCharsAndWords(String str) {
        int i;
        str = str.trim();
        if ((str = str.replace('-', ' ')).indexOf(" ") != -1) {
            int len = ignoredWordList.length;
            for (i = 0; i < len; ++i) {
                RemoveWordResult ret = this.removeWord(str, ignoredWordList[i]);
                str = ret.retStr;
                if (ret.found < 0) break;
            }
        }
        char[] tempArray = str.toCharArray();
        StringBuffer returnBuffer = new StringBuffer(str.length());
        for (i = 0; i < tempArray.length; ++i) {
            char c = tempArray[i];
            if (!Character.isLetterOrDigit(c)) continue;
            returnBuffer.append(c);
        }
        return returnBuffer.toString();
    }

    public List calculateAlternateSoundexKeys(String origString, ISoundexKey origKey, int possibleErrors, List keys) {
        int val;
        int j;
        int i;
        int end;
        FRA_SoundexKey key;
        char sound;
        int idx;
        char c;
        int len;
        StringBuffer nameBuf;
        if (possibleErrors == 0) {
            return keys;
        }
        if (origString == null || origString.length() == 0) {
            return keys;
        }
        int type = this.isSpecialCase(origString);
        if (type == 1) {
            return this.calculateAlternateNumericSoundexKeys(origString, possibleErrors, keys);
        }
        if (type == 2) {
            return keys;
        }
        HashSet<Object> newKeys = new HashSet<Object>();
        newKeys.add(origKey);
        origString = this.removeUnwantedCharsAndWords(origString);
        char firstChar = ((MiSoundexKey)origKey).getFirstChar();
        int origNumericVal = ((MiSoundexKey)origKey).getNumericValue();
        if ((possibleErrors & 0x20) > 0) {
            nameBuf = new StringBuffer(origString);
            len = origString.length() - 1;
            c = nameBuf.charAt(len);
            idx = charStr.indexOf(c);
            if (idx >= 0) {
                char newsound;
                sound = soundStr.charAt(charStr.indexOf(c));
                while (sound != '0' && len > 0 && (idx = charStr.indexOf(c = nameBuf.charAt(--len))) >= 0 && (newsound = soundStr.charAt(charStr.indexOf(c))) == sound) {
                }
                nameBuf.setLength(len + 1);
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                newKeys.add((Object)key);
            }
            nameBuf = new StringBuffer(origString);
            nameBuf.append("AA");
            int lastchar = nameBuf.length() - 1;
            for (int addedSound = 0; addedSound < DISTINCT_SOUNDS.length(); ++addedSound) {
                nameBuf.setCharAt(lastchar, DISTINCT_SOUNDS.charAt(addedSound));
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                newKeys.add((Object)key);
            }
            nameBuf.setCharAt(lastchar, 'L');
            nameBuf.append('T');
            key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
            newKeys.add((Object)key);
        }
        if ((possibleErrors & 1) > 0 && (idx = charStr.indexOf(firstChar)) >= 0) {
            sound = soundStr.charAt(idx);
            end = soundStr.lastIndexOf(sound) + 1;
            for (i = soundStr.indexOf(sound); i < end; ++i) {
                c = charStr.charAt(i);
                if (c == firstChar) continue;
                key = new FRA_SoundexKey();
                key.setNumericValue(origNumericVal);
                key.setFirstChar(c);
                newKeys.add((Object)key);
            }
        }
        if ((possibleErrors & 2) > 0) {
            len = origString.length();
            nameBuf = new StringBuffer(origString);
            for (i = 1; i < len; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                newKeys.add((Object)key);
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 0x40) > 0) {
            len = origString.length();
            nameBuf = new StringBuffer(origString);
            for (i = 1; i < len; ++i) {
                c = nameBuf.charAt(i);
                idx = charStr.indexOf(c);
                if (idx < 0 || (sound = soundStr.charAt(charStr.indexOf(c))) == '0') continue;
                nameBuf.setCharAt(i, 'A');
                key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                if (key != null && !keys.contains((Object)key)) {
                    char d;
                    newKeys.add((Object)key);
                    if (i < len - 1 && nameBuf.charAt(i - 1) == nameBuf.charAt(i + 1) && (idx = charStr.indexOf(d = nameBuf.charAt(i - 1))) >= 0 && (sound = soundStr.charAt(idx)) != '0') {
                        nameBuf.setCharAt(i - 1, 'A');
                        key = (MiSoundexKey)this.getSoundex(nameBuf.toString());
                        newKeys.add((Object)key);
                        nameBuf.setCharAt(i - 1, d);
                    }
                }
                nameBuf.setCharAt(i, c);
            }
        }
        if ((possibleErrors & 4) > 0) {
            String code = String.valueOf(origNumericVal);
            int len2 = code.length();
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len2);
            for (i = 0; i < len2; ++i) {
                for (j = 0; j < end; ++j) {
                    if (code.charAt(i) == VALID_CODES.charAt(j)) continue;
                    sb.delete(0, len2);
                    sb.append(code);
                    sb.replace(i, i + 1, String.valueOf(VALID_CODES.charAt(j)));
                    key = new FRA_SoundexKey();
                    key.setFirstChar(firstChar);
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    newKeys.add((Object)key);
                }
            }
        }
        if ((possibleErrors & 8) > 0) {
            String code = String.valueOf(origNumericVal);
            int len3 = code.length();
            if (len3 == 9) {
                code = code.substring(1);
                --len3;
            }
            end = VALID_CODES.length();
            StringBuffer sb = new StringBuffer(len3 + 1);
            for (i = 0; i < len3 + 1; ++i) {
                for (j = 0; j < end; ++j) {
                    sb.delete(0, len3 + 1);
                    sb.append(code);
                    sb.insert(i, VALID_CODES.charAt(j));
                    key = new FRA_SoundexKey();
                    val = Integer.parseInt(sb.toString());
                    key.setNumericValue(val);
                    key.setFirstChar(firstChar);
                    newKeys.add((Object)key);
                }
            }
        }
        if ((possibleErrors & 0x10) > 0) {
            String code = String.valueOf(origNumericVal);
            int len4 = code.length() - 1;
            StringBuffer sb = new StringBuffer(len4 + 1);
            sb.append(code);
            for (i = 0; i < len4; ++i) {
                char c1 = sb.charAt(i);
                char c2 = sb.charAt(i + 1);
                sb.setCharAt(i, c2);
                sb.setCharAt(i + 1, c1);
                key = new FRA_SoundexKey();
                val = Integer.parseInt(sb.toString());
                key.setNumericValue(val);
                key.setFirstChar(firstChar);
                newKeys.add((Object)key);
                sb.setCharAt(i, c1);
                sb.setCharAt(i + 1, c2);
            }
        }
        newKeys.remove(origKey);
        newKeys.remove(null);
        keys.addAll(newKeys);
        return keys;
    }

    private List calculateAlternateNumericSoundexKeys(String numVal, int caseType, List keys) {
        int intVal;
        if ((numVal = StringUtilities.trimToChars((String)numVal, (String)DIGITS)) == null) {
            return keys;
        }
        try {
            intVal = Integer.parseInt(numVal);
        }
        catch (NumberFormatException nfe) {
            return keys;
        }
        switch (caseType) {
            case 1: {
                keys.clear();
                this.reverseNumericValue(intVal, keys);
                break;
            }
            case 2: {
                keys.clear();
                this.addZeroToNumericValue(intVal, keys);
                break;
            }
            case 3: {
                keys.clear();
                this.increaseDecreaseNumericValue(intVal, keys);
            }
        }
        return keys;
    }

    private void reverseNumericValue(int intVal, List keys) {
        String val = String.valueOf(intVal);
        if (val == null) {
            return;
        }
        StringBuffer revVal = new StringBuffer();
        int cnt = val.length();
        if (cnt == 1) {
            return;
        }
        boolean zeroFound = true;
        for (int i = cnt - 1; i >= 0; --i) {
            if (val.charAt(i) == '0' & zeroFound) continue;
            revVal.append(val.charAt(i));
            zeroFound = false;
        }
        String revValStr = revVal.toString();
        if (!revValStr.equals(val)) {
            FRA_SoundexKey key = new FRA_SoundexKey();
            key.setFirstChar('0');
            try {
                key.setNumericValue(Integer.parseInt(revValStr));
            }
            catch (NumberFormatException e) {
                return;
            }
            keys.add(key);
        }
    }

    private void addZeroToNumericValue(int intVal, List keys) {
        String val = String.valueOf(intVal);
        StringBuffer newVal = new StringBuffer();
        newVal.append(val);
        newVal.append('0');
        FRA_SoundexKey key = null;
        try {
            key = new FRA_SoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(Integer.parseInt(newVal.toString()));
            keys.add(key);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        newVal = null;
        newVal = new StringBuffer();
        newVal.append(val);
        newVal.insert(1, '0');
        if (keys.indexOf(newVal.toString()) == -1) {
            try {
                key = new FRA_SoundexKey();
                key.setFirstChar('0');
                key.setNumericValue(Integer.parseInt(newVal.toString()));
                keys.add(key);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
    }

    private void increaseDecreaseNumericValue(int intVal, List keys) {
        int i;
        int tmp = 0;
        FRA_SoundexKey key = null;
        if (intVal <= 0) {
            return;
        }
        for (i = 1; i <= 3; ++i) {
            tmp = intVal - i;
            if (tmp <= 0) continue;
            key = new FRA_SoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(tmp);
            keys.add(key);
        }
        for (i = 1; i <= 3; ++i) {
            tmp = intVal + i;
            key = new FRA_SoundexKey();
            key.setFirstChar('0');
            key.setNumericValue(tmp);
            keys.add(key);
        }
    }

    public static ISoundexKey getStringKey(String str) {
        if (str == null || str.trim().length() == 0) {
            return null;
        }
        char ch = str.charAt(0);
        int key = 1;
        for (int i = 1; i < str.length(); ++i) {
            key |= i << str.charAt(i);
        }
        FRA_SoundexKey mikey = new FRA_SoundexKey(1);
        mikey.setFirstChar(ch);
        mikey.setNumericValue(key);
        return mikey;
    }

    static {
        HashMap<Character, Integer> temp = new HashMap<Character, Integer>(sounds.length);
        for (int i = 0; i < sounds.length; ++i) {
            temp.put(new Character(letters[i]), new Integer(sounds[i]));
        }
        m_soundHash = Collections.unmodifiableMap(temp);
        ignoredWordList = new String[]{"DE", "DES", "DU", "LA", "LE", "LES"};
    }

    protected class RemoveWordResult {
        String retStr;
        int found;

        protected RemoveWordResult() {
        }
    }
}

