/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.CandidateRange;
import com.mapinfo.mapmarker.FRA.FRA_Segment;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalBrowseAddress;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.utils.StringUtilities;

public class FRA_InternalBrowseAddress
extends InternalBrowseAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "address.common.pre.main";
    public static final String POST_STREET_TYPE_COMMON = "address.common.post.st_type";
    public static final String PRE_STREET_TYPE_COMMON = "pre_street_type_common";
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    public static final String POST_ADDR_COMMON = "post_addr_common";
    private StreetBasedIdentifier m_identifier = null;

    public FRA_InternalBrowseAddress(Address address) {
        super(address);
    }

    public CandidateAddress toCandidateAddress(Address parsed, IConstraints constraints) {
        String primaryName = this.getGenericField1();
        if (!StringUtilities.isEmpty((String)primaryName)) {
            this.setMainAddress(primaryName);
            this.setGenericField1(null);
        }
        CandidateAddress candidate = super.toCandidateAddress(parsed, constraints);
        FRA_ThoroughfareTypes.KeyInfo streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPreThoroughfareType());
        if (streetTypeKey != null) {
            candidate.setPreThoroughfareType(streetTypeKey.getProperTypeName());
        }
        if ((streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPostThoroughfareType())) != null) {
            candidate.setPostThoroughfareType(streetTypeKey.getProperTypeName());
        }
        candidate.setPreAddress(FRA_InternalBrowseAddress.getFormattedPreAddress((Address)this));
        candidate.setGenericField1(null);
        candidate.setGenericField2(null);
        candidate.setGenericField3(null);
        candidate.setGenericField4(null);
        return candidate;
    }

    protected void copySegmentInfoToRange(CandidateRange range, Segment segment, int segmentSide) {
        super.copySegmentInfoToRange(range, segment, segmentSide);
        FRA_Segment fra = (FRA_Segment)segment;
        if (segmentSide == 0) {
            range.setAreaName1(fra.getLeftOriginalAreaName1());
            range.setAreaName2(fra.getLeftOriginalAreaName2());
            range.setAreaName3(fra.getLeftOriginalAreaName3());
            range.setAreaName4(fra.getLeftOriginalAreaName4());
        } else {
            range.setAreaName1(fra.getRightOriginalAreaName1());
            range.setAreaName2(fra.getRightOriginalAreaName2());
            range.setAreaName3(fra.getRightOriginalAreaName3());
            range.setAreaName4(fra.getRightOriginalAreaName4());
        }
    }

    public static String getFormattedPreAddress(Address cand) {
        StringBuffer buff = new StringBuffer();
        String tmp = FRA_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(POST_STREET_TYPE_COMMON));
        if (tmp.length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = FRA_InternalBrowseAddress.noNulls(cand.getPreAddress())).length() > 0) {
            buff.append(tmp);
            if (!tmp.endsWith(" ")) {
                buff.append(" ");
            }
        }
        if ((tmp = FRA_InternalBrowseAddress.noNulls((String)cand.getAdditionalFields().get(PRE_MAIN_ADDRESS_COMMON))).length() > 0) {
            buff.append(tmp);
        }
        return buff.toString().trim();
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    public StreetBasedIdentifier getStreetBasedIdentifier() {
        if (this.m_identifier == null) {
            StreetCandidateAddress streetCand = this.getStreetCandidateAddress();
            int segmentCount = this.getSegmentCount();
            Segment[] segments = new Segment[segmentCount];
            segments = new Segment[segmentCount];
            for (int index = 0; index < segmentCount; ++index) {
                segments[index] = this.getSegmentAt(index);
            }
            this.m_identifier = new StreetBasedIdentifier(streetCand.getDictionaryNumber(), streetCand.getStreetOffset(), streetCand.getSegmentBlockOffset(), segments);
        }
        return this.m_identifier;
    }

    public int getDictionaryNumber() {
        return this.getStreetCandidateAddress().getDictionaryNumber();
    }

    protected String getFormattedStreetAddress() {
        String postAddr;
        String postAddrCommon;
        String preAddrCommon;
        String postStreetTypeCommon;
        String preAddrCommon2;
        StringBuffer buf = new StringBuffer(100);
        if (this.getAddressNumber() != null) {
            buf.append(this.getAddressNumber());
            buf.append(' ');
        }
        if (this.hasAdditionalFields() && (preAddrCommon2 = (String)this.getAdditionalFields().get(PRE_STREET_TYPE_COMMON)) != null) {
            buf.append(preAddrCommon2);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        FRA_ThoroughfareTypes.KeyInfo streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPreThoroughfareType());
        String streetType = null;
        if (streetTypeKey != null) {
            streetType = streetTypeKey.getProperTypeName();
        }
        if (streetType != null) {
            buf.append(streetType);
            buf.append(" ");
        }
        if (this.hasAdditionalFields() && (postStreetTypeCommon = (String)this.getAdditionalFields().get(POST_STREET_TYPE_COMMON)) != null) {
            buf.append(postStreetTypeCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (this.getPreAddress() != null) {
            buf.append(this.getPreAddress());
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        if (this.hasAdditionalFields() && (preAddrCommon = (String)this.getAdditionalFields().get(PRE_ADDR_COMMON)) != null) {
            buf.append(preAddrCommon);
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
        }
        buf.append(this.getMainAddress());
        if (this.hasAdditionalFields() && (postAddrCommon = (String)this.getAdditionalFields().get(POST_ADDR_COMMON)) != null) {
            if (postAddrCommon.charAt(0) != '-') {
                buf.append(' ');
            }
            buf.append(postAddrCommon);
        }
        if ((postAddr = this.getPostAddress()) != null) {
            if (postAddr.charAt(0) != '-' && buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(postAddr);
        }
        streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPostThoroughfareType());
        String postStreetType = null;
        if (streetTypeKey != null) {
            postStreetType = streetTypeKey.getProperTypeName();
        }
        if (postStreetType != null) {
            char lastChar;
            if (buf.length() > 0 && ((lastChar = buf.charAt(buf.length() - 1)) != ' ' || lastChar != '-')) {
                buf.append(' ');
            }
            buf.append(postStreetType);
            buf.append(' ');
        }
        return buf.toString();
    }

    public static class StreetBasedIdentifier {
        private int m_dictNum;
        private long m_streetOffset;
        private long m_blockSegmentOffset;
        private Segment[] m_segments;

        private StreetBasedIdentifier(int dictNum, long streetOffset, long blockSegmentOffset, Segment[] segments) {
            this.m_dictNum = dictNum;
            this.m_streetOffset = streetOffset;
            this.m_blockSegmentOffset = blockSegmentOffset;
            this.m_segments = segments;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            StreetBasedIdentifier that = (StreetBasedIdentifier)o;
            if (this.m_dictNum != that.m_dictNum || this.m_streetOffset != that.m_streetOffset || this.m_blockSegmentOffset != that.m_blockSegmentOffset) {
                return false;
            }
            if (this.m_segments.length != that.m_segments.length) {
                return false;
            }
            for (int index = 0; index < this.m_segments.length; ++index) {
                Segment thisSegment = this.m_segments[index];
                Segment thatSegment = that.m_segments[index];
                if (!this.isRangesEquavilent(thisSegment, thatSegment, 0)) {
                    return false;
                }
                if (this.isRangesEquavilent(thisSegment, thatSegment, 1)) continue;
                return false;
            }
            return true;
        }

        private boolean isRangesEquavilent(Segment thisSegment, Segment thatSegment, int side) {
            if (thisSegment.getRangeCount(side) != thatSegment.getRangeCount(side)) {
                return false;
            }
            int rangeCount = thisSegment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range thisRange = thisSegment.getRangeAt(index, side);
                Range thatRange = thatSegment.getRangeAt(index, side);
                if (thisRange.getRangeOffset() == thatRange.getRangeOffset()) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int result = 27 * this.m_dictNum;
            result += (int)(this.m_streetOffset ^ this.m_streetOffset >>> 32);
            result += (int)(this.m_blockSegmentOffset ^ this.m_blockSegmentOffset >>> 32);
            for (int index = 0; index < this.m_segments.length; ++index) {
                result += this.calculateRangesHashCode(this.m_segments[index], 0);
                result += this.calculateRangesHashCode(this.m_segments[index], 1);
            }
            return result;
        }

        private int calculateRangesHashCode(Segment segment, int side) {
            int result = 0;
            int rangeCount = segment.getRangeCount(side);
            for (int index = 0; index < rangeCount; ++index) {
                Range range = segment.getRangeAt(index, side);
                long offset = range.getRangeOffset();
                result += (int)(offset ^ offset >>> 32);
            }
            return result;
        }
    }
}

