/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.FRA.FRATerritory;
import com.mapinfo.mapmarker.FRA.FRA_Segment;
import com.mapinfo.mapmarker.FRA.FRA_StreetCandidateAddress;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.FRA.parser.FRA_Directionals;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalCandidateAddress;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.common.Range;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Segment;
import com.mapinfo.mapmarker.user.IReverseGeocodeConstraints;
import com.mapinfo.mapmarker.user.ReverseGeocodeCandidateAddress;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.List;

public class FRA_InternalCandidateAddress
extends InternalCandidateAddress
implements FRATerritory {
    public static int MATCH_NONE = 0;
    public static int MATCH_FIRST = 1;
    public static int MATCH_SECOND = 2;
    public static int MATCH_BOTH_DIFFERENT = 3;
    public static int MATCH_BOTH = 4;
    private static double minScoreConsidered = 0.85;
    private static double SORTING_STREET_THRESHHOLD_NOTOWN_PERFECTPOST = 0.25;
    private static double SORTING_TOWN_THRESHHOLD = 0.5;
    private static double SORTING_TOWN_THRESHHOLD_PERFECTPOST = 0.4;
    private static double SORTING_STREET_THRESHHOLD = 0.5;
    private static double SORTING_STREET_THRESHHOLD_PERFECTSTREET = 0.3;
    private static double SORTING_STREET_THRESHHOLD_PERFECTSTREET_PERFECTPOST = 0.1;
    private static double SORTING_POSTCODE_THRESHHOLD = 0.5;
    private static double FAR_BETTER_DIFF = 0.48;
    private static double CLOSE_DIFF = 0.2;
    private static int FAR_BETTER_POSTCODE_DIFF = 1000;
    private static int CLOSE_POSTCODE_DIFF = 100;
    private ParsedNumber m_preservedInputNumber = null;
    private int m_matchType = MATCH_NONE;
    private int m_numAddrNumberFields = 0;
    private int m_numAddrNumberFieldsMatched = 0;
    private int m_matchedAliasIndex = -1;
    private static final double SCORING_LEFT_RIGHT_TOWN_THRESHHOLD = 0.2;
    private boolean m_segmentSidePickedFromPostCode = false;
    private double m_leftPostcode1Score = 0.0;
    private double m_rightPostcode1Score = 0.0;
    private static final double SWAP_AN1AN2_THRESHHOLD = 0.2;
    private boolean m_swappedAN1AN2 = false;
    private boolean m_scoredAN3againstAN4 = false;
    private boolean m_adjustS4 = false;
    private boolean m_poBox = false;

    public FRA_InternalCandidateAddress() {
    }

    public FRA_InternalCandidateAddress(Address addr) {
        super(addr);
        if (addr instanceof FRA_InternalCandidateAddress) {
            FRA_InternalCandidateAddress fraAddr = (FRA_InternalCandidateAddress)addr;
            this.m_preservedInputNumber = fraAddr.m_preservedInputNumber;
            this.m_matchType = fraAddr.m_matchType;
            this.m_numAddrNumberFields = fraAddr.m_numAddrNumberFields;
            this.m_numAddrNumberFieldsMatched = fraAddr.m_numAddrNumberFieldsMatched;
            this.m_matchedAliasIndex = fraAddr.m_matchedAliasIndex;
        }
    }

    protected Segment makeSegment(Segment orig) {
        return new FRA_Segment(orig);
    }

    protected Segment makeSegment() {
        return new FRA_Segment();
    }

    public CandidateAddress toCandidateAddress(Address input, IConstraints constraints) throws MapMarkerInternalException {
        String[] aliases;
        StringBuilder sb;
        ParsedNumber candPN;
        ParsedNumber inputParsedNumber;
        this.prepareForConvert();
        this.m_poBox = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false"));
        boolean bPostDirMatched = this.fieldExists(input.getPostDirectional()) ? this.getPostDirectionalScore() == 1.0 : true;
        this.m_preservedInputNumber = null;
        boolean bInputAlphaMismatch = false;
        ParsedNumber candParsedNumber = this.getParsedAddressNumber();
        if (candParsedNumber != null && (inputParsedNumber = input.getParsedAddressNumber()) != null && !inputParsedNumber.isPureNumeric() && candParsedNumber.getAddressNumber() == inputParsedNumber.getAddressNumber()) {
            if (StringUtilities.isNumeric((String)candParsedNumber.getCombinedAddressNumber())) {
                Range range = this.getMatchedOrClosestRange();
                if (range != null) {
                    if (inputParsedNumber.getSuffixNumber() == 0L) {
                        bInputAlphaMismatch = true;
                    } else if (this.m_matchType == MATCH_BOTH) {
                        inputParsedNumber.setNumberSeparator("-");
                        this.m_preservedInputNumber = inputParsedNumber;
                    }
                }
            } else if (!candParsedNumber.equals((Object)inputParsedNumber)) {
                bInputAlphaMismatch = true;
            }
        }
        if (this.m_swappedAN1AN2) {
            String an1 = input.getAreaName1();
            input.setAreaName1(input.getAreaName2());
            input.setAreaName2(an1);
        }
        boolean bManagedPreTypeScore = false;
        if (this.wasLDTreatedAsNoInput() && this.getPreThoroughfareTypeScore() == 0.75) {
            this.setPreThoroughfareTypeScore(1.0);
            bManagedPreTypeScore = true;
        }
        CandidateAddress candidate = super.toCandidateAddress(input, constraints);
        if (bManagedPreTypeScore) {
            this.setPreThoroughfareTypeScore(0.75);
        }
        if (this.m_preservedInputNumber != null) {
            candidate.setAddressNumber(this.m_preservedInputNumber);
        } else if (!candidate.doesAddressNumberMatch() && candParsedNumber != null && !bInputAlphaMismatch && (candPN = candidate.getParsedAddressNumber()) != null && candPN.getAddressNumber() == candParsedNumber.getAddressNumber() && this.m_matchType != MATCH_NONE) {
            candidate.setAddressNumberMatched();
            StringBuilder sb2 = new StringBuilder(candidate.getPrecisionCode());
            if (sb2.length() == 10 && sb2.charAt(2) == '-') {
                sb2.setCharAt(2, 'H');
                candidate.getAdditionalFields().put("RESULT_CODE", sb2.toString());
            }
        }
        if (bPostDirMatched && (sb = new StringBuilder(candidate.getPrecisionCode())).length() == 10 && sb.charAt(6) == '-') {
            sb.setCharAt(6, 'S');
            candidate.getAdditionalFields().put("RESULT_CODE", sb.toString());
        }
        if (this.m_matchedAliasIndex != -1 && (aliases = this.getOriginalAreaName3Alternates()) != null) {
            candidate.setGenericField3(aliases[this.m_matchedAliasIndex]);
        }
        this.prepareForReturn((Address)candidate);
        if (candidate.getPrecisionCode().startsWith("S4") && StringUtilities.isEmpty((String)candidate.getAddressNumber()) && this.getInputNumber() != null && !StringUtilities.isEmpty((String)this.getInputNumber().getCombinedAddressNumber())) {
            this.m_adjustS4 = true;
            candidate.setFormattedStreetAddress(this.getFormattedStreetAddress());
            candidate.setAddressNumber(this.getInputNumber().getCombinedAddressNumber());
        }
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        return candidate;
    }

    protected boolean getMatchFlagForEmptyStreetFields() {
        return true;
    }

    protected boolean getMatchFlagForEmptyLocationFields() {
        return false;
    }

    protected boolean getMatchFlagForAddressNumberMissingPrefixOrSuffix() {
        return false;
    }

    public void scoreAddressNumber(ScoringAddress parsedAddress) {
        String firstPart = null;
        String secondPart = null;
        ParsedNumber secondMatchedNumber = null;
        int secondMatchedRange = -1;
        int secondSegmentSide = -1;
        ParsedNumber parsedAddressNumber = parsedAddress.getParsedAddressNumber();
        if (parsedAddressNumber != null) {
            String separator = null;
            if (parsedAddressNumber.hasSuffixSeparator()) {
                separator = parsedAddressNumber.getSuffixSeparator();
            } else if (parsedAddressNumber.hasNumberSeparator()) {
                separator = parsedAddressNumber.getNumberSeparator();
            }
            if (separator != null) {
                String combined = parsedAddressNumber.getCombinedAddressNumber();
                int split = combined.indexOf(separator);
                firstPart = combined.substring(0, split);
                secondPart = combined.substring(split + separator.length());
                if (secondPart.length() > 0) {
                    parsedAddress.setAddressNumber(secondPart);
                    parsedAddress.getParsedAddressNumber().setIgnoreLeadingZeros(true);
                    super.scoreAddressNumber(parsedAddress);
                    this.m_numAddrNumberFields = super.getInputNumber().getNumFields();
                    this.m_numAddrNumberFieldsMatched = this.getCntAddressNumberFieldsMatched();
                    if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                        this.m_matchType = MATCH_SECOND;
                        secondMatchedRange = this.getMatchedRangeNumber();
                        secondSegmentSide = this.getSegmentSide();
                        secondMatchedNumber = this.getSegment().getRangeAt(secondMatchedRange, secondSegmentSide).getMatchedRangeNumber();
                    }
                    this.setInputNumber(null);
                    this.setCntAddressNumberFieldsMatched(0);
                    this.setMatchedRangeNumber(-1);
                    this.setSegmentSide(-1);
                    this.setClosestRange(-1);
                    this.setClosestSegmentSide(-1);
                    this.setMatchingFlag(0);
                    if (secondMatchedRange > 0 && secondSegmentSide > 0) {
                        this.getSegment().getRangeAt(secondMatchedRange, secondSegmentSide).setMatchedRangeNumber(null);
                    }
                    parsedAddress.setAddressNumber(firstPart);
                }
            }
        }
        if (parsedAddress.getParsedAddressNumber() != null) {
            parsedAddress.getParsedAddressNumber().setIgnoreLeadingZeros(true);
        }
        super.scoreAddressNumber(parsedAddress);
        if (this.getInputNumber() != null) {
            this.m_numAddrNumberFields += this.getInputNumber().getNumFields();
            this.m_numAddrNumberFieldsMatched += this.getCntAddressNumberFieldsMatched();
            if (this.getMatchedRangeNumber() >= 0 && this.getSegmentSide() >= 0) {
                if (this.m_matchType == MATCH_SECOND) {
                    if (secondMatchedRange == this.getMatchedRangeNumber() && secondSegmentSide == this.getSegmentSide()) {
                        this.m_matchType = MATCH_BOTH;
                        if (secondMatchedNumber != null) {
                            Range r = this.getSegment().getRangeAt(secondMatchedRange, secondSegmentSide);
                            String combinedNumber = r.getMatchedRangeNumber().getCombinedAddressNumber();
                            combinedNumber = combinedNumber + '-' + secondMatchedNumber.getCombinedAddressNumber();
                            r.setMatchedRangeNumber(new ParsedNumber(combinedNumber));
                        }
                    } else {
                        this.m_matchType = MATCH_BOTH_DIFFERENT;
                        ++this.m_numAddrNumberFields;
                    }
                } else {
                    this.m_matchType = MATCH_FIRST;
                }
            }
            if (this.m_matchType == MATCH_SECOND) {
                ParsedNumber secondParsedNumber = new ParsedNumber(secondPart);
                this.setInputNumber(secondParsedNumber);
                this.setSegmentSide(secondSegmentSide);
                this.setMatchedRangeNumber(secondMatchedRange);
                Range r = this.getSegment().getRangeAt(secondMatchedRange, secondSegmentSide);
                r.setMatchedRangeNumber(secondParsedNumber);
                this.setClosestSegmentSide(-1);
                this.setClosestRange(-1);
            }
            parsedAddress.setAddressNumber(parsedAddressNumber);
        }
        if (!StringUtilities.isEmpty((String)parsedAddress.getPlaceName()) && StringUtilities.isEmpty((String)parsedAddress.getMainAddress()) && StringUtilities.isEmpty((String)parsedAddress.getAddressNumber())) {
            this.setAddressNumberScore(1.0);
            return;
        }
    }

    public String getFormattedLocationAddress() {
        StringBuffer buf = new StringBuffer(50);
        buf.append(this.getPostCode1());
        if (buf.length() > 0) {
            buf.append(' ');
        }
        buf.append(this.getOriginalAreaName3());
        return buf.toString();
    }

    public String getFormattedStreetAddress() {
        String num;
        StringBuffer buf = new StringBuffer(100);
        if (this.m_poBox) {
            buf.append(this.getMainAddress());
            buf.append(' ');
        }
        if ((num = this.m_adjustS4 ? this.getInputNumber().getCombinedAddressNumber() : (this.m_preservedInputNumber != null ? this.m_preservedInputNumber.getCombinedAddressNumber() : this.getAddressNumber())) != null) {
            buf.append(num);
            buf.append(' ');
        }
        if (this.m_poBox) {
            return buf.toString().trim();
        }
        String temp = this.getPreDirectional();
        if (temp != null) {
            buf.append(FRA_Directionals.getFullName(temp));
            buf.append(' ');
        }
        FRA_ThoroughfareTypes.KeyInfo streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPreThoroughfareType());
        String streetType = null;
        if (streetTypeKey != null) {
            streetType = streetTypeKey.getProperTypeName();
        }
        if (streetType != null) {
            buf.append(streetType);
            buf.append(' ');
        }
        buf.append(this.getMainAddress());
        streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPostThoroughfareType());
        String postStreetType = null;
        if (streetTypeKey != null) {
            postStreetType = streetTypeKey.getProperTypeName();
        }
        if (postStreetType != null) {
            buf.append(' ');
            buf.append(postStreetType);
        }
        if ((temp = this.getPostDirectional()) != null) {
            if (buf.charAt(buf.length() - 1) != '-') {
                buf.append(' ');
            }
            buf.append(FRA_Directionals.getFullName(temp));
        }
        return buf.toString();
    }

    public int compare(Object o1, Object o2) {
        double score2;
        FRA_InternalCandidateAddress cand1 = (FRA_InternalCandidateAddress)o1;
        FRA_InternalCandidateAddress cand2 = (FRA_InternalCandidateAddress)o2;
        if (cand1.equals(cand2)) {
            return 0;
        }
        boolean bCand1Match = cand1.isCloseMatch();
        boolean bCand2Match = cand2.isCloseMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        bCand1Match = cand1.isPerfectMatch();
        bCand2Match = cand2.isPerfectMatch();
        if (!bCand1Match && bCand2Match) {
            return -1;
        }
        if (bCand1Match && !bCand2Match) {
            return 1;
        }
        double score1 = cand1.getCombinedAddressScore();
        if (score1 == (score2 = cand2.getCombinedAddressScore())) {
            score1 = cand1.getPlaceNameScore();
            if (score1 > (score2 = cand2.getPlaceNameScore())) {
                return 1;
            }
            if (score1 < score2) {
                return -1;
            }
            int cb = this.pickWinner(cand1.getCombinedAdditionalFieldScore(), cand2.getCombinedAdditionalFieldScore());
            if (cb != 0) {
                return cb;
            }
            cb = this.pickWinner(cand1.getAreaName3Score(), cand2.getAreaName3Score());
            if (cb != 0) {
                return cb;
            }
            cb = this.pickWinner(cand1.getPostCode1Score(), cand2.getPostCode1Score());
            if (cb != 0) {
                return cb;
            }
            cb = this.pickWinner(cand1.getMainAddressScore(), cand2.getMainAddressScore());
            if (cb != 0) {
                return cb;
            }
            score1 = cand1.getAddressNumberScore();
            cb = this.pickWinner(score1, score2 = cand2.getAddressNumberScore());
            if (cb != 0) {
                return cb;
            }
            if (score1 != 1.0 && score2 != 1.0) {
                if (cand1.hasClosestRange() && cand2.hasClosestRange()) {
                    long cand2Offset;
                    Range cand1Closest = cand1.getSegment().getRangeAt(cand1.getClosestRangeNumber(), cand1.getClosestSegmentSide());
                    Range cand2Closest = cand2.getSegment().getRangeAt(cand2.getClosestRangeNumber(), cand2.getClosestSegmentSide());
                    long cand1Offset = cand1Closest.getRangeOffset();
                    if (cand1Offset < (cand2Offset = cand2Closest.getRangeOffset())) {
                        return 1;
                    }
                    if (cand1Offset > cand2Offset) {
                        return -1;
                    }
                    return this.compareUserDictionaryPriority(cand1, cand2);
                }
                if (cand1.hasClosestRange()) {
                    return 1;
                }
                if (cand2.hasClosestRange()) {
                    return -1;
                }
                if (!cand1.m_scoredAN3againstAN4 && cand2.m_scoredAN3againstAN4) {
                    return 1;
                }
                if (cand1.m_scoredAN3againstAN4 && !cand2.m_scoredAN3againstAN4) {
                    return -1;
                }
                return this.compareUserDictionaryPriority(cand1, cand2);
            }
            return this.compareUserDictionaryPriority(cand1, cand2);
        }
        if (score1 < score2) {
            return -1;
        }
        return 1;
    }

    private int pickWinner(double score1, double score2) {
        if (score1 < score2) {
            return -1;
        }
        if (score1 > score2) {
            return 1;
        }
        return 0;
    }

    private int compareUserDictionaryPriority(InternalCandidateAddress candidate1, InternalCandidateAddress candidate2) {
        if (candidate1.getUserDictionaryPriority() < candidate2.getUserDictionaryPriority()) {
            return 1;
        }
        if (candidate2.getUserDictionaryPriority() < candidate1.getUserDictionaryPriority()) {
            return -1;
        }
        return 0;
    }

    public boolean equals(Object obj) {
        InternalCandidateAddress cand = (InternalCandidateAddress)obj;
        if (super.equals(obj)) {
            if (this.getPreThoroughfareTypeScore() == 0.0 && cand.getPreThoroughfareTypeScore() == 0.0 && this.getPreThoroughfareType() != null && cand.getPreThoroughfareType() != null) {
                if (this.getPreThoroughfareType().equalsIgnoreCase(cand.getPreThoroughfareType())) {
                    return this.getUserDictionaryPriority() == cand.getUserDictionaryPriority();
                }
                return false;
            }
            return this.getUserDictionaryPriority() == cand.getUserDictionaryPriority();
        }
        return false;
    }

    public void scorePostalInformation(ScoringAddress scoringAddress) {
        int side = this.chooseBestSegmentSide();
        if (side == 0 || side == 1) {
            super.scorePostalInformation(scoringAddress);
            return;
        }
        this.setClosestSegmentSide(0);
        super.scorePostalInformation(scoringAddress);
        this.m_leftPostcode1Score = this.getPostCode1Score();
        this.setClosestSegmentSide(1);
        super.scorePostalInformation(scoringAddress);
        this.m_rightPostcode1Score = this.getPostCode1Score();
        if (this.m_leftPostcode1Score == 1.0 && this.m_rightPostcode1Score != 1.0) {
            this.setClosestSegmentSide(0);
            this.setPostCode1Score(this.m_leftPostcode1Score);
            this.m_segmentSidePickedFromPostCode = true;
        } else if (this.m_rightPostcode1Score == 1.0 && this.m_leftPostcode1Score != 1.0) {
            this.m_segmentSidePickedFromPostCode = true;
        } else {
            this.setClosestSegmentSide(-1);
        }
    }

    public void scoreAreaNames(ScoringAddress scoringAddress) {
        boolean chooseLeft;
        int side = this.chooseBestSegmentSide();
        if (!(this.m_segmentSidePickedFromPostCode || side != 0 && side != 1)) {
            this.innerScoreAreaNames(scoringAddress);
            return;
        }
        double leftAN1Score = 0.0;
        double leftAN2Score = 0.0;
        double leftAN3Score = 0.0;
        double leftAN4Score = 0.0;
        int leftMatchedAliasIndex = -1;
        double rightAN1Score = 0.0;
        double rightAN2Score = 0.0;
        double rightAN3Score = 0.0;
        double rightAN4Score = 0.0;
        int rightMatchedAliasIndex = -1;
        boolean scoredLeft = false;
        boolean scoredRight = false;
        if (side == 0) {
            this.innerScoreAreaNames(scoringAddress);
            if (this.getAreaName3Score() == 1.0 && this.m_matchedAliasIndex < 0) {
                return;
            }
            leftAN1Score = this.getAreaName1Score();
            leftAN2Score = this.getAreaName2Score();
            leftAN3Score = this.getAreaName3Score();
            leftAN4Score = this.getAreaName4Score();
            leftMatchedAliasIndex = this.m_matchedAliasIndex;
            scoredLeft = true;
        } else if (side == 1) {
            this.innerScoreAreaNames(scoringAddress);
            if (this.getAreaName3Score() == 1.0 && this.m_matchedAliasIndex < 0) {
                return;
            }
            rightAN1Score = this.getAreaName1Score();
            rightAN2Score = this.getAreaName2Score();
            rightAN3Score = this.getAreaName3Score();
            rightAN4Score = this.getAreaName4Score();
            rightMatchedAliasIndex = this.m_matchedAliasIndex;
            scoredRight = true;
        }
        if (!scoredLeft) {
            this.setClosestSegmentSide(0);
            this.innerScoreAreaNames(scoringAddress);
            leftAN1Score = this.getAreaName1Score();
            leftAN2Score = this.getAreaName2Score();
            leftAN3Score = this.getAreaName3Score();
            leftAN4Score = this.getAreaName4Score();
            leftMatchedAliasIndex = this.m_matchedAliasIndex;
            scoredLeft = true;
        }
        if (!scoredRight) {
            this.setClosestSegmentSide(1);
            this.innerScoreAreaNames(scoringAddress);
            rightAN1Score = this.getAreaName1Score();
            rightAN2Score = this.getAreaName2Score();
            rightAN3Score = this.getAreaName3Score();
            rightAN4Score = this.getAreaName4Score();
            rightMatchedAliasIndex = this.m_matchedAliasIndex;
            scoredRight = true;
        }
        if (leftAN3Score == 1.0 && rightAN3Score != 1.0) {
            chooseLeft = true;
        } else if (leftAN3Score != 1.0 && rightAN3Score == 1.0) {
            chooseLeft = false;
        } else if (leftAN3Score - rightAN3Score > 0.2) {
            chooseLeft = true;
        } else if (rightAN3Score - leftAN3Score > 0.2) {
            chooseLeft = false;
        } else if (this.m_leftPostcode1Score == 1.0 && this.m_rightPostcode1Score != 1.0) {
            chooseLeft = true;
        } else if (this.m_leftPostcode1Score != 1.0 && this.m_rightPostcode1Score == 1.0) {
            chooseLeft = false;
        } else {
            double leftScore = leftAN1Score + leftAN2Score + leftAN3Score + leftAN4Score + this.m_leftPostcode1Score;
            double rightScore = rightAN1Score + rightAN2Score + rightAN3Score + rightAN4Score + this.m_rightPostcode1Score;
            boolean bl = chooseLeft = leftScore >= rightScore;
        }
        if (chooseLeft) {
            this.setClosestSegmentSide(0);
            this.setAreaName1Score(leftAN1Score);
            this.setAreaName2Score(leftAN2Score);
            this.setAreaName3Score(leftAN3Score);
            this.setAreaName4Score(leftAN4Score);
            this.m_matchedAliasIndex = leftMatchedAliasIndex;
            this.setPostCode1Score(this.m_leftPostcode1Score);
        } else {
            this.setClosestSegmentSide(1);
            this.setAreaName1Score(rightAN1Score);
            this.setAreaName2Score(rightAN2Score);
            this.setAreaName3Score(rightAN3Score);
            this.setAreaName4Score(rightAN4Score);
            this.m_matchedAliasIndex = rightMatchedAliasIndex;
            this.setPostCode1Score(this.m_rightPostcode1Score);
        }
    }

    private void innerScoreAreaNames(ScoringAddress scoringAddress) {
        String secondary;
        double areaName3Score;
        super.scoreAreaNames(scoringAddress);
        boolean hasAN1 = this.fieldExists(scoringAddress.getAreaName1());
        boolean hasAN2 = this.fieldExists(scoringAddress.getAreaName2());
        if (hasAN1 ^ hasAN2) {
            double newScore;
            double savedScore;
            double d = savedScore = hasAN1 ? this.getAreaName1Score() : this.getAreaName2Score();
            if (savedScore <= 0.8 && (newScore = hasAN1 ? scoringAddress.scoreAreaName1(this.getAreaName2()) : scoringAddress.scoreAreaName2(this.getAreaName1())) - savedScore >= 0.2) {
                this.setAreaName1Score(hasAN1 ? 0.0 : newScore);
                this.setAreaName2Score(hasAN2 ? 0.0 : newScore);
                this.m_swappedAN1AN2 = true;
            }
        }
        if ((areaName3Score = this.getAreaName3Score()) != 1.0) {
            double m_areaName3bScore;
            String testAreaName3;
            double s;
            int pos;
            String areaName3;
            this.scoreAltAreaNames(scoringAddress);
            areaName3Score = this.getAreaName3Score();
            if (areaName3Score != 1.0 && (areaName3 = this.getAreaName3()) != null && areaName3.contains(" CEDEX") && (pos = areaName3.indexOf(" CEDEX")) > 0 && (s = scoringAddress.scoreAreaName3(testAreaName3 = areaName3.substring(0, pos))) > areaName3Score) {
                this.setAreaName3Score(s);
            }
            if (areaName3Score != 1.0 && !StringUtilities.isEmpty((String)this.getAreaName4()) && (m_areaName3bScore = scoringAddress.scoreAreaName3(this.getAreaName4())) > areaName3Score && m_areaName3bScore > minScoreConsidered) {
                this.setAreaName3Score(m_areaName3bScore);
                this.m_scoredAN3againstAN4 = true;
            }
        }
        if (scoringAddress.hasAdditionalFields() && (secondary = (String)scoringAddress.getAdditionalFields().get("SECONDARY_INPUT_TOWN")) != null) {
            double score = scoringAddress.scoreAreaName3(this.getAreaName3(), secondary);
            this.setAdditionalParserFieldsScore(score);
        }
    }

    private void scoreAltAreaNames(ScoringAddress scoringAddress) {
        String[] alts = this.getAreaName3Alternates();
        if (alts != null) {
            this.scoreAltAreaName3(scoringAddress, alts);
        }
    }

    private void scoreAltAreaName3(ScoringAddress scoringAddress, String[] alts) {
        double bestScore = this.getAreaName3Score();
        for (int i = 0; i < alts.length && bestScore != 1.0; ++i) {
            double score = scoringAddress.scoreAreaName3(alts[i]);
            if (!(score > bestScore)) continue;
            bestScore = score;
            this.setAreaName3Score(bestScore);
            this.m_matchedAliasIndex = i;
        }
    }

    public boolean isSwappedAN1AN2() {
        return this.m_swappedAN1AN2;
    }

    void setIsScoredAN3AgainstAN4(boolean flag) {
        this.m_scoredAN3againstAN4 = flag;
    }

    public boolean isScoredAN3againstAN4() {
        return this.m_scoredAN3againstAN4;
    }

    protected static String noNulls(String in) {
        return in == null ? "" : in;
    }

    public static String reconstructAddress(Address pa) {
        StringBuffer buff = new StringBuffer();
        String tmp = FRA_InternalCandidateAddress.noNulls(pa.getPreThoroughfareType());
        if (tmp.length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FRA_InternalCandidateAddress.noNulls(pa.getPreAddress())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FRA_InternalCandidateAddress.noNulls(pa.getMainAddress())).length() > 0) {
            buff.append(tmp + " ");
        }
        if ((tmp = FRA_InternalCandidateAddress.noNulls(pa.getPostAddress())).length() > 0) {
            buff.append(tmp);
        }
        if ((tmp = FRA_InternalCandidateAddress.noNulls(pa.getPostThoroughfareType())).length() > 0) {
            buff.append(tmp);
        }
        return buff.toString();
    }

    public int compareTo(Object o1) {
        return this.compare(this, o1);
    }

    public String getAreaName1() {
        Segment segment;
        String areaName1 = super.getAreaName1();
        if (areaName1 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName1();
            String right = segment.getRightAreaName1();
            return this.pickLeftOrRight(left, right);
        }
        return areaName1;
    }

    public String getAreaName2() {
        Segment segment;
        String areaName2 = super.getAreaName2();
        if (areaName2 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName2();
            String right = segment.getRightAreaName2();
            return this.pickLeftOrRight(left, right);
        }
        return areaName2;
    }

    public String getAreaName3() {
        Segment segment;
        String areaName3 = super.getAreaName3();
        if (areaName3 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName3();
            String right = segment.getRightAreaName3();
            return this.pickLeftOrRight(left, right);
        }
        return areaName3;
    }

    public String getAreaName4() {
        Segment segment;
        String areaName4 = super.getAreaName4();
        if (areaName4 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftAreaName4();
            String right = segment.getRightAreaName4();
            return this.pickLeftOrRight(left, right);
        }
        return areaName4;
    }

    private String getOriginalAreaName1() {
        FRA_Segment segment = (FRA_Segment)this.getSegment();
        if (segment != null) {
            return this.pickLeftOrRight(segment.getLeftOriginalAreaName1(), segment.getRightOriginalAreaName1());
        }
        return "";
    }

    private String getOriginalAreaName2() {
        FRA_Segment segment = (FRA_Segment)this.getSegment();
        if (segment != null) {
            return this.pickLeftOrRight(segment.getLeftOriginalAreaName2(), segment.getRightOriginalAreaName2());
        }
        return "";
    }

    private String getOriginalAreaName3() {
        FRA_Segment segment = (FRA_Segment)this.getSegment();
        if (segment != null) {
            return this.pickLeftOrRight(segment.getLeftOriginalAreaName3(), segment.getRightOriginalAreaName3());
        }
        return "";
    }

    private String getOriginalAreaName4() {
        FRA_Segment segment = (FRA_Segment)this.getSegment();
        if (segment != null) {
            return this.pickLeftOrRight(segment.getLeftOriginalAreaName4(), segment.getRightOriginalAreaName4());
        }
        return "";
    }

    public String getPostCode1() {
        Segment segment;
        String postCode1 = super.getPostCode1();
        if (postCode1 == null && (segment = this.getSegment()) != null) {
            String left = segment.getLeftPostCode1();
            String right = segment.getRightPostCode1();
            return this.pickLeftOrRight(left, right);
        }
        return postCode1;
    }

    private String[] getAreaName3Alternates() {
        FRA_GeoInfoRecord geoinfo = this.getGeoInfoRecord();
        if (geoinfo != null) {
            return geoinfo.getAltAreaName3Array();
        }
        return null;
    }

    private String[] getOriginalAreaName3Alternates() {
        FRA_GeoInfoRecord geoinfo = this.getGeoInfoRecord();
        if (geoinfo != null) {
            return geoinfo.getOriginalAltAreaName3Array();
        }
        return null;
    }

    private FRA_GeoInfoRecord getGeoInfoRecord() {
        FRA_Segment segment = (FRA_Segment)this.getSegment();
        if (segment != null) {
            int side = this.getBestSegmentSide();
            if (side == 0) {
                return segment.getLeftGeoInfoRecord();
            }
            if (side == 1) {
                return segment.getRightGeoInfoRecord();
            }
        }
        return null;
    }

    private String pickLeftOrRight(String left, String right) {
        int side = this.getBestSegmentSide();
        if (side == 0) {
            return left;
        }
        if (side == 1) {
            return right;
        }
        if (left != null && right != null) {
            if (!left.equals(right)) {
                return null;
            }
            return left;
        }
        if (left != null) {
            return left;
        }
        if (right != null) {
            return right;
        }
        return null;
    }

    private int getBestSegmentSide() {
        int side = this.getSegmentSide();
        if (side == 0 || side == 1) {
            return side;
        }
        side = this.getClosestSegmentSide();
        if (side == 0 || side == 1) {
            return side;
        }
        return -1;
    }

    private int chooseBestSegmentSide() {
        FRA_Segment segment;
        int side = this.getBestSegmentSide();
        if (side != 0 && side != 1 && (segment = (FRA_Segment)this.getSegment()) != null) {
            boolean noRight;
            boolean noLeft = segment.getLeftAreaName1() == null && segment.getLeftAreaName2() == null && segment.getLeftAreaName3() == null && segment.getLeftPostCode1() == null;
            boolean bl = noRight = segment.getRightAreaName1() == null && segment.getRightAreaName2() == null && segment.getRightAreaName3() == null && segment.getRightPostCode1() == null;
            if (noLeft && noRight) {
                side = 0;
            } else if (noRight) {
                side = 0;
            } else if (noLeft) {
                side = 1;
            } else {
                boolean hasRightTown;
                boolean hasLeftTown = !StringUtilities.isEmpty((String)segment.getLeftAreaName3());
                boolean bl2 = hasRightTown = !StringUtilities.isEmpty((String)segment.getRightAreaName3());
                if (!hasLeftTown && hasRightTown) {
                    side = 1;
                } else if (hasLeftTown && !hasRightTown) {
                    side = 0;
                }
                if (side != 0 && side != 1 && StringUtilities.equalStrings((String)segment.getLeftAreaName1(), (String)segment.getRightAreaName1()) && StringUtilities.equalStrings((String)segment.getLeftAreaName2(), (String)segment.getRightAreaName2()) && StringUtilities.equalStrings((String)segment.getLeftAreaName3(), (String)segment.getRightAreaName3()) && StringUtilities.equalStrings((String)segment.getLeftAreaName4(), (String)segment.getRightAreaName4()) && StringUtilities.equalStrings((String)segment.getLeftPostCode1(), (String)segment.getRightPostCode1())) {
                    side = segment.getRangeCount(1) > segment.getRangeCount(0) ? 1 : 0;
                }
            }
            if (side == 0 || side == 1) {
                this.setClosestSegmentSide(side);
            }
        }
        return side;
    }

    private Range getMatchedOrClosestRange() {
        int side = -1;
        int range = -1;
        if (this.hasMatchingRange()) {
            side = this.getSegmentSide();
            range = this.getMatchedRangeNumber();
        } else if (this.hasClosestRange()) {
            side = this.getClosestSegmentSide();
            range = this.getClosestRangeNumber();
        } else {
            return null;
        }
        List rangeList = this.getSegment().getRanges(side);
        if (rangeList != null && rangeList.size() > 0) {
            return (Range)rangeList.get(range);
        }
        return null;
    }

    public ReverseGeocodeCandidateAddress toCandidateAddress(ReverseGeocodeLocation location, IReverseGeocodeConstraints constraints) throws MapMarkerInternalException {
        this.prepareForConvert();
        ReverseGeocodeCandidateAddress result = super.toCandidateAddress(location, constraints);
        this.prepareForReturn((Address)result);
        return result;
    }

    private void prepareForConvert() {
        String primaryName = this.getGenericField1();
        if (!StringUtilities.isEmpty((String)primaryName)) {
            this.setMainAddress(primaryName);
            this.setGenericField1(null);
        }
    }

    private void prepareForReturn(Address candidate) {
        candidate.setAreaName1(this.getOriginalAreaName1());
        candidate.setAreaName2(this.getOriginalAreaName2());
        candidate.setAreaName3(this.getOriginalAreaName3());
        candidate.setAreaName4(this.getOriginalAreaName4());
        FRA_ThoroughfareTypes.KeyInfo streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPreThoroughfareType());
        if (streetTypeKey != null) {
            candidate.setPreThoroughfareType(streetTypeKey.getProperTypeName());
        }
        if ((streetTypeKey = FRA_ThoroughfareTypes.lookupByTypeName(this.getPostThoroughfareType())) != null) {
            candidate.setPostThoroughfareType(streetTypeKey.getProperTypeName());
        }
    }

    public boolean wasLDTreatedAsNoInput() {
        return ((FRA_StreetCandidateAddress)this.getStreetCandidateAddress()).wasLDTreatedAsNoType();
    }
}

