/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.CandidateAddress;
import com.mapinfo.mapmarker.FRA.FRATerritory;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.utils.CoordConvertor;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.midev.coordsys.CoordSys;
import com.mapinfo.midev.coordsys.util.CoordSysUtilities;
import com.mapinfo.midev.geometry.DirectPosition;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FRA_InternalGeographicCandidate
extends InternalGeographicCandidate
implements FRATerritory {
    private static final double m_blankCandFieldScoreAN2 = 0.8;
    private static final double m_blankCandFieldScoreAN3 = 0.8;
    private static final double m_blankCandFieldScoreAN4 = 0.8;
    private static final double m_minScoreToAllowSwap = 0.85;
    private static final Map<String, String> m_departmentMap;
    private int m_matchedAliasIndex = -1;
    private double m_postCodeScore = 0.0;

    public FRA_InternalGeographicCandidate() {
        this.setStringScorer(FRA_ScoringHelper.getStringScorer());
    }

    public void scoreCountry(Address inputAddress) {
        String inCountry;
        String myCountry = this.getCountry();
        if (StringUtilities.equalStrings((String)myCountry, (String)(inCountry = inputAddress.getCountry())) || StringUtilities.equalStrings((String)"FRA", (String)inCountry)) {
            this.setCountryScore(1.0);
        } else {
            this.setCountryScore(0.0);
        }
    }

    public void setGeoInfoRecord(GeoInfoRecord record) {
        super.setGeoInfoRecord(record);
        String country = m_departmentMap.get(record.getAreaName1());
        if (country != null) {
            this.setCountry(country);
        }
    }

    public CandidateAddress toCandidateAddress(Address inputAddress, IConstraints constraints) {
        CandidateAddress candidate = new CandidateAddress();
        FRA_GeoInfoRecord geoinfo = (FRA_GeoInfoRecord)this.getGeoInfoRecord();
        if (geoinfo != null) {
            candidate.setAreaName1(geoinfo.getOriginalAreaName1());
            candidate.setAreaName2(geoinfo.getOriginalAreaName2());
            candidate.setAreaName3(geoinfo.getOriginalAreaName3());
            candidate.setAreaName4(geoinfo.getOriginalAreaName4());
            candidate.setPostCode1(geoinfo.getPostCode());
            if (this.m_matchedAliasIndex != -1) {
                candidate.setGenericField3(geoinfo.getOriginalAltAreaName3Array()[this.m_matchedAliasIndex]);
            }
        }
        candidate.setCountry(this.getCountry());
        if (this.isCloseMatch()) {
            candidate.setCloseMatch();
        }
        if (this.getCountryScore() == 1.0) {
            candidate.setCountryMatched();
        }
        if (this.getAreaName1Score() == 1.0 && inputAddress.getAreaName1() != null) {
            candidate.setAreaName1Matched();
        }
        if (this.getAreaName2Score() == 1.0 && inputAddress.getAreaName2() != null) {
            candidate.setAreaName2Matched();
        }
        if (this.getAreaName3Score() >= 0.97 && inputAddress.getAreaName3() != null) {
            candidate.setAreaName3Matched();
        }
        if (this.getAreaName4Score() == 1.0 && inputAddress.getAreaName4() != null) {
            candidate.setAreaName4Matched();
        }
        if (this.getCentroid() != null) {
            CoordSys clientCoordSys = constraints.getClientCoordinateSystemObject();
            candidate.setLocation(CoordConvertor.transformPointFromWGS84((CoordSys)clientCoordSys, (DirectPosition)this.getCentroid()));
            candidate.setCoordSysString(CoordSysUtilities.getSRSName((CoordSys)clientCoordSys));
        } else {
            candidate.setLocation(new DirectPosition());
        }
        candidate.setLocationPrecision(this.getPrecision());
        String geores = this.buildPrecisionCode(candidate);
        candidate.addKeyValueToAdditionalFields("RESULT_CODE", geores);
        candidate.addKeyValueToAdditionalFields("StreetDataType", this.getVendorCode());
        candidate.setConfiguredDictionaryNumber(this.getDictionaryPriority() + 1);
        return candidate;
    }

    public String getAltAreaName4() {
        return this.getGeoInfoRecord().getAltAreaName4();
    }

    public String toString() {
        return "\nFRA_InternalGeographicCandidate:" + super.toString();
    }

    public void scoreCandidate(Address inputAddress, String charsToIgnore) {
        super.scoreCandidate(inputAddress, charsToIgnore);
        boolean inputAN2isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName2());
        boolean inputAN3isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName3());
        boolean inputAN4isEmpty = StringUtilities.isEmpty((String)inputAddress.getAreaName4());
        String origAN2 = inputAddress.getAreaName2();
        double an2Score = this.getAreaName2Score();
        String origAN3 = inputAddress.getAreaName3();
        double an3Score = this.getAreaName3Score();
        if (an2Score != 1.0 && an3Score != 1.0 && !inputAN2isEmpty) {
            inputAddress.setAreaName3(origAN2);
            this.scoreAreaName3(inputAddress);
            inputAddress.setAreaName3(origAN3);
            double score = this.getAreaName3Score();
            if (score > an2Score && score > 0.85) {
                if (inputAN3isEmpty) {
                    this.setAreaName2Score(score);
                    this.setAreaName3Score(an2Score);
                    inputAN2isEmpty = true;
                    inputAN3isEmpty = false;
                } else {
                    inputAddress.setAreaName2(origAN3);
                    this.scoreAreaName2(inputAddress);
                    inputAddress.setAreaName2(origAN2);
                    this.setAreaName3Score(this.getAreaName2Score());
                    this.setAreaName2Score(score);
                }
            } else {
                this.setAreaName2Score(an2Score);
                this.setAreaName3Score(an3Score);
            }
        }
        if (!inputAN2isEmpty && StringUtilities.isEmpty((String)this.getAreaName2())) {
            this.setAreaName2Score(0.8);
        }
        if (!inputAN3isEmpty && StringUtilities.isEmpty((String)this.getAreaName3())) {
            this.setAreaName3Score(0.8);
        }
        if (!inputAN4isEmpty && StringUtilities.isEmpty((String)this.getAreaName4())) {
            this.setAreaName4Score(0.8);
        }
        this.scorePostCode1(inputAddress);
    }

    public void scoreAreaName3(Address inputAddress) {
        String[] alts;
        FRA_GeoInfoRecord m_record;
        this.setAreaName3Score(this.getStringScorer().scoreString(this.getAreaName3(), inputAddress.getAreaName3()));
        if (this.getAreaName3Score() != 1.0 && (m_record = (FRA_GeoInfoRecord)this.getGeoInfoRecord()) != null && (alts = m_record.getAltAreaName3Array()) != null) {
            for (int i = 0; i < alts.length; ++i) {
                double tempScore = this.getStringScorer().scoreString(alts[i], inputAddress.getAreaName3());
                if (!(tempScore > this.getAreaName3Score())) continue;
                this.setAreaName3Score(tempScore);
                this.m_matchedAliasIndex = i;
            }
        }
    }

    public void scorePostCode1(Address inputAddress) {
        String inputPostCode = inputAddress.getPostCode1();
        if (inputPostCode == null) {
            return;
        }
        String myPostcode = ((FRA_GeoInfoRecord)this.getGeoInfoRecord()).getPostCode();
        if (myPostcode == null) {
            return;
        }
        if (myPostcode.equals(inputPostCode)) {
            this.m_postCodeScore = 1.0;
            return;
        }
        try {
            int p1 = Integer.parseInt(myPostcode);
            int p2 = Integer.parseInt(inputPostCode);
            this.m_postCodeScore = (p1 / 10000 == p2 / 10000 ? 0.2 : 0.0) + (p1 % 10000 / 1000 == p2 % 10000 / 1000 ? 0.2 : 0.0) + (p1 % 1000 / 100 == p2 % 1000 / 100 ? 0.2 : 0.0) + (p1 % 100 / 10 == p2 % 100 / 10 ? 0.2 : 0.0) + (p1 % 10 == p2 % 10 ? 0.2 : 0.0);
        }
        catch (NumberFormatException nex) {
            this.m_postCodeScore = 0.0;
        }
    }

    public double getPostCodeScore() {
        return this.m_postCodeScore;
    }

    public int compare(Object o1, Object o2) {
        boolean cand2AliasMatch;
        FRA_InternalGeographicCandidate candidate1 = (FRA_InternalGeographicCandidate)o1;
        FRA_InternalGeographicCandidate candidate2 = (FRA_InternalGeographicCandidate)o2;
        if (candidate1.isCloseMatch() ^ candidate2.isCloseMatch()) {
            if (candidate1.isCloseMatch()) {
                return 1;
            }
            return -1;
        }
        if (candidate1.getCombinedScore() > candidate2.getCombinedScore()) {
            return 1;
        }
        if (candidate1.getCombinedScore() < candidate2.getCombinedScore()) {
            return -1;
        }
        if (candidate1.getAreaName1Score() > candidate2.getAreaName1Score()) {
            return 1;
        }
        if (candidate1.getAreaName1Score() < candidate2.getAreaName1Score()) {
            return -1;
        }
        if (candidate1.getAreaName2Score() > candidate2.getAreaName2Score()) {
            return 1;
        }
        if (candidate1.getAreaName2Score() < candidate2.getAreaName2Score()) {
            return -1;
        }
        if (candidate1.getAreaName3Score() > candidate2.getAreaName3Score()) {
            return 1;
        }
        if (candidate1.getAreaName3Score() < candidate2.getAreaName3Score()) {
            return -1;
        }
        if (candidate1.getAreaName4Score() > candidate2.getAreaName4Score()) {
            return 1;
        }
        if (candidate1.getAreaName4Score() < candidate2.getAreaName4Score()) {
            return -1;
        }
        if (candidate1.getCountryScore() > candidate2.getCountryScore()) {
            return 1;
        }
        if (candidate2.getCountryScore() > candidate2.getCountryScore()) {
            return -1;
        }
        boolean cand1AliasMatch = candidate1.m_matchedAliasIndex != -1;
        boolean bl = cand2AliasMatch = candidate2.m_matchedAliasIndex != -1;
        if (cand1AliasMatch != cand2AliasMatch) {
            if (cand2AliasMatch && candidate2.getPrecision() == 10) {
                return 1;
            }
            if (candidate2.getPrecision() == 10) {
                return -1;
            }
        }
        if (candidate1.getPrecision() == 10 && candidate2.getPrecision() != 10) {
            return 1;
        }
        if (candidate1.getPrecision() != 10 && candidate2.getPrecision() == 10) {
            return -1;
        }
        if (candidate1.getPrecision() > candidate2.getPrecision()) {
            return 1;
        }
        if (candidate1.getPrecision() < candidate2.getPrecision()) {
            return -1;
        }
        if (candidate1.getPostCodeScore() > candidate2.getPostCodeScore()) {
            return 1;
        }
        if (candidate1.getPostCodeScore() < candidate2.getPostCodeScore()) {
            return -1;
        }
        if (candidate1.getUserDictionaryPriority() < candidate2.getUserDictionaryPriority()) {
            return 1;
        }
        if (candidate2.getUserDictionaryPriority() < candidate1.getUserDictionaryPriority()) {
            return -1;
        }
        return 0;
    }

    public int compareTo(Object o1) {
        return this.compare(this, o1);
    }

    static {
        HashMap<String, String> tempMap = new HashMap<String, String>();
        tempMap.put("GUADELOUPE", "GLP");
        tempMap.put("MONACO", "MCO");
        tempMap.put("GUYANE FRANCAISE", "GUF");
        tempMap.put("GUYANE", "GUF");
        tempMap.put("MARTINIQUE", "MTQ");
        tempMap.put("MAYOTTE", "MYT");
        tempMap.put("REUNION", "REU");
        m_departmentMap = Collections.unmodifiableMap(tempMap);
    }
}

