/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.FRA.singleline.FRA_SingleLineComparatorUtils;
import com.mapinfo.mapmarker.FRA.singleline.FRA_SplitHelper;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.utils.StringUtilities;
import com.mapinfo.mapmarker.utils.TaggedTokenList;
import java.util.Map;
import java.util.StringTokenizer;

public class FRA_ScoringAddress
extends ScoringAddress {
    public static final String PRE_MAIN_ADDRESS_COMMON = "pre_main_address_common";
    public static final String PRE_ADDR_COMMON = "pre_addr_common";
    private boolean scorePostAddress = true;
    private boolean bTypeInsertedInAddress = false;
    private final Map m_mainAddrCache;
    private final Map m_generalCache;

    public FRA_ScoringAddress(Address addr, Map mainAddrCache, Map areaNamesCache, Map generalCache) {
        super(addr, generalCache, generalCache, generalCache, generalCache, mainAddrCache, generalCache, generalCache, generalCache, areaNamesCache, areaNamesCache, areaNamesCache, areaNamesCache);
        this.m_mainAddrCache = mainAddrCache;
        this.m_generalCache = generalCache;
    }

    public FRA_ScoringAddress(Address addr) {
        this(addr, null, null, null);
    }

    public StringScorer getStringScorer() {
        return FRA_ScoringHelper.getStringScorer();
    }

    public double scoreMainAddress(String candAddr, int typeInsertedInAddress) {
        this.bTypeInsertedInAddress = typeInsertedInAddress == 1;
        return this.scoreMainAddress(candAddr);
    }

    public double scoreMainAddress(String candAddr) {
        double score;
        if (this.isNamedMainAddress(candAddr) || this.isNamedMainAddress(this.getMainAddress())) {
            score = this.scoreNamedMainAddressWrapper(candAddr, this.getMainAddress());
        } else if (this.isDateMainAddress(candAddr) || this.isDateMainAddress(this.getMainAddress())) {
            score = this.scoreDateMainAddress(candAddr, this.getMainAddress());
        } else {
            String main = this.getMainAddress();
            boolean b1 = StringUtilities.hasNumeric((String)candAddr);
            boolean b2 = StringUtilities.hasNumeric((String)main);
            if (b1 && b2) {
                score = this.scoreNumericAgainstNumeric(candAddr, main);
            } else if (b1 || b2) {
                score = this.scoreNumericAgainstNonNumeric(candAddr, main, b1);
            } else if (this.bTypeInsertedInAddress && (main.indexOf(candAddr) != -1 || candAddr.indexOf(main) != -1)) {
                score = this.scoreNamedMainAddressWrapper(candAddr, main);
                if (score == 0.875) {
                    score = 1.0;
                }
            } else {
                score = super.scoreMainAddress(candAddr);
            }
        }
        return score;
    }

    private boolean isNamedMainAddress(String candMainAddress) {
        int pos;
        if (!StringUtilities.isEmpty((String)candMainAddress) && (pos = candMainAddress.indexOf(32)) > 0) {
            return FRA_ScoringHelper.isCommonNamedStreetPrefix(candMainAddress.substring(0, pos));
        }
        return false;
    }

    private boolean isDateMainAddress(String candMainAddress) {
        return !StringUtilities.isEmpty((String)candMainAddress) && StringUtilities.hasNumeric((String)candMainAddress) && FRA_SingleLineComparatorUtils.stringContainsMonthNameToken(candMainAddress);
    }

    private double scoreNumericAgainstNonNumeric(String candMain, String myMain, boolean bFirstIsNumeric) {
        String expanded;
        String nonNumeric;
        if (bFirstIsNumeric) {
            nonNumeric = myMain;
            expanded = FRA_Standardizer.replaceOrdinalsWithWords(candMain);
            if (StringUtilities.hasNumeric((String)expanded)) {
                expanded = FRA_Standardizer.replaceNumbersWithWords(expanded);
            }
        } else {
            nonNumeric = candMain;
            expanded = FRA_Standardizer.replaceOrdinalsWithWords(myMain);
            if (StringUtilities.hasNumeric((String)expanded)) {
                expanded = FRA_Standardizer.replaceNumbersWithWords(expanded);
            }
        }
        if (expanded.equals(nonNumeric)) {
            return 1.0;
        }
        StringScorer scorer = this.getStringScorer();
        return scorer.scoreString(expanded, nonNumeric);
    }

    private double scoreNumericAgainstNumeric(String candMain, String myMain) {
        String me;
        String cand = FRA_Standardizer.stripOrdinalIndicators(candMain);
        if (cand.equals(me = FRA_Standardizer.stripOrdinalIndicators(myMain))) {
            return 1.0;
        }
        StringScorer scorer = this.getStringScorer();
        return scorer.scoreString(cand, me);
    }

    private double scoreNamedMainAddressWrapper(String str1, String str2) {
        double altScore;
        String inputAddr;
        String candAddr;
        Double dbl;
        if (str1 == null) {
            if (str2 == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (str2 == null) {
            return 0.0;
        }
        if (str1.equalsIgnoreCase(str2)) {
            return 1.0;
        }
        String ignoredChars = this.getCharsToIgnore();
        if (ignoredChars.length() != 0) {
            str1 = StringUtilities.stripString((String)str1, (String)ignoredChars);
            str2 = StringUtilities.stripString((String)str2, (String)ignoredChars);
        }
        if (this.m_mainAddrCache != null && (dbl = (Double)this.m_mainAddrCache.get(str1 + str2)) != null) {
            return dbl;
        }
        double score = this.scoreNamedMainAddress(str1, str2);
        if (score < 1.0) {
            candAddr = FRA_Standardizer.replaceWordsWithOrdinals(str1);
            inputAddr = FRA_Standardizer.replaceWordsWithOrdinals(str2);
            if (!(str1.equals(candAddr) && str2.equals(inputAddr) || !((altScore = this.scoreNamedMainAddress(candAddr, inputAddr)) > score))) {
                score = altScore;
            }
        }
        if (score < 1.0) {
            candAddr = FRA_Standardizer.replaceWordsWithNumbers(str1);
            inputAddr = FRA_Standardizer.replaceWordsWithNumbers(str2);
            if (!(str1.equals(candAddr) && str2.equals(inputAddr) || !((altScore = this.scoreNamedMainAddress(candAddr, inputAddr)) > score))) {
                score = altScore;
            }
        }
        if (score < 1.0) {
            candAddr = FRA_Standardizer.replaceNumbersAndWordsWithRomanNumerals(str1);
            inputAddr = FRA_Standardizer.replaceNumbersAndWordsWithRomanNumerals(str2);
            if (!(str1.equals(candAddr) && str2.equals(inputAddr) || !((altScore = this.scoreNamedMainAddress(candAddr, inputAddr)) > score))) {
                score = altScore;
            }
        }
        if (this.m_mainAddrCache != null) {
            this.m_mainAddrCache.put(str1 + str2, new Double(score));
        }
        return score;
    }

    private double scoreNamedMainAddress(String candAddr, String inputAddr) {
        double score;
        StringScorer scorer = this.getStringScorer();
        StringTokenizer candTokens = new StringTokenizer(candAddr);
        StringTokenizer inputTokens = new StringTokenizer(inputAddr);
        int candTokenCount = candTokens.countTokens();
        int inputTokenCount = inputTokens.countTokens();
        String[] candAddrParts = new String[candTokenCount];
        int i = 0;
        while (candTokens.hasMoreTokens()) {
            candAddrParts[i] = candTokens.nextToken();
            ++i;
        }
        String[] inputAddrParts = new String[inputTokenCount];
        i = 0;
        while (inputTokens.hasMoreTokens()) {
            inputAddrParts[i] = inputTokens.nextToken();
            ++i;
        }
        double[] matchedAddrScores = new double[candTokenCount];
        int matchedStart = 0;
        int matchedEnd = candAddrParts.length - 1;
        int inputStart = 0;
        int inputEnd = inputAddrParts.length - 1;
        double extraInputPenalty = 0.0;
        if (inputEnd >= matchedEnd) {
            double bestScore = 0.0;
            int bestPos = inputEnd;
            for (int i2 = inputEnd; i2 >= matchedEnd; --i2) {
                score = scorer.scoreString(candAddrParts[matchedEnd], inputAddrParts[i2]);
                if (!(score > bestScore)) continue;
                bestScore = score;
                bestPos = i2;
            }
            matchedAddrScores[matchedEnd] = bestScore;
            --matchedEnd;
            extraInputPenalty += 1.0 - this.calculateMissingTokenScore(inputEnd - bestPos);
            inputEnd = bestPos - 1;
        }
        while (matchedStart <= matchedEnd && inputStart <= inputEnd && (score = scorer.scoreString(candAddrParts[matchedEnd], inputAddrParts[inputEnd])) >= 0.85) {
            matchedAddrScores[matchedEnd] = score;
            --matchedEnd;
            --inputEnd;
        }
        while (matchedStart <= matchedEnd && inputStart <= inputEnd && (score = scorer.scoreString(candAddrParts[matchedStart], inputAddrParts[inputStart])) >= 0.85) {
            matchedAddrScores[matchedStart] = score;
            ++matchedStart;
            ++inputStart;
        }
        while (matchedStart <= matchedEnd && inputStart <= inputEnd) {
            score = 0.0;
            if (candAddrParts[matchedEnd].length() == 1 || inputAddrParts[inputEnd].length() == 1) {
                score = scorer.scoreString(candAddrParts[matchedEnd].substring(0, 1), inputAddrParts[inputEnd].substring(0, 1));
            }
            if (score != 1.0) break;
            if (candAddrParts[matchedEnd].length() > 1 || inputAddrParts[inputEnd].length() > 1) {
                score *= 0.95;
            }
            matchedAddrScores[matchedEnd] = score;
            --matchedEnd;
            --inputEnd;
        }
        while (matchedStart <= matchedEnd && inputStart <= inputEnd) {
            score = 0.0;
            if (candAddrParts[matchedStart].length() == 1 || inputAddrParts[inputStart].length() == 1) {
                score = scorer.scoreString(candAddrParts[matchedStart].substring(0, 1), inputAddrParts[inputStart].substring(0, 1));
            }
            if (score != 1.0) break;
            if (candAddrParts[matchedStart].length() > 1 || inputAddrParts[inputStart].length() > 1) {
                score *= 0.95;
            }
            matchedAddrScores[matchedStart] = score;
            ++matchedStart;
            ++inputStart;
        }
        int candLeftoverTokens = matchedEnd - matchedStart + 1;
        int inputLeftoverTokens = inputEnd - inputStart + 1;
        if (inputLeftoverTokens > 0 && candLeftoverTokens > 0) {
            int i3;
            StringBuilder candLeftovers = new StringBuilder();
            StringBuilder inputLeftovers = new StringBuilder();
            for (i3 = matchedStart; i3 <= matchedEnd; ++i3) {
                if (candLeftovers.length() > 0) {
                    candLeftovers.append(' ');
                }
                candLeftovers.append(candAddrParts[i3]);
            }
            for (i3 = inputStart; i3 <= inputEnd; ++i3) {
                if (inputLeftovers.length() > 0) {
                    inputLeftovers.append(' ');
                }
                inputLeftovers.append(inputAddrParts[i3]);
            }
            score = scorer.scoreString(candLeftovers.toString(), inputLeftovers.toString());
        } else {
            score = this.calculateMissingTokenScore(Math.abs(candLeftoverTokens - inputLeftoverTokens));
            if (inputLeftoverTokens > candLeftoverTokens) {
                extraInputPenalty += 1.0 - score;
            }
        }
        for (int i4 = matchedStart; i4 <= matchedEnd; ++i4) {
            matchedAddrScores[i4] = score;
        }
        double firstWordScore = matchedAddrScores[0];
        double lastWordScore = matchedAddrScores[candAddrParts.length - 1];
        double middleWordsScore = 0.0;
        if (matchedAddrScores.length > 2) {
            for (int i5 = 1; i5 < matchedAddrScores.length - 1; ++i5) {
                middleWordsScore += matchedAddrScores[i5];
            }
            middleWordsScore /= (double)(matchedAddrScores.length - 2);
        } else {
            middleWordsScore = lastWordScore;
        }
        score = 0.25 * firstWordScore + 0.25 * middleWordsScore + 0.5 * lastWordScore - extraInputPenalty;
        return score;
    }

    private double calculateMissingTokenScore(int numMissingTokens) {
        double score = 1.0;
        for (int x = 0; x < numMissingTokens; ++x) {
            score *= 0.875;
        }
        return score;
    }

    public double scorePostAddress(String parsedAddress) {
        return 1.0;
    }

    public double scoreGenericField1(String str) {
        return 1.0;
    }

    public double scorePreAddress(StreetCandidateAddress parsedAddress) {
        return 1.0;
    }

    public double scoreThoroughfareType(String candThroughfaretype, String parsedThoroughfareType) {
        return this.scoreItems(candThroughfaretype, parsedThoroughfareType);
    }

    public double scoreItems(String str1, String str2) {
        return this.doScore(str1, str2, this.m_generalCache, false);
    }

    protected double doScore(String str1, String str2, Map cache, boolean bNoShortWordBonus) {
        if (cache == null) {
            cache = this.m_generalCache;
        }
        return super.doScore(str1, str2, cache, bNoShortWordBonus);
    }

    public double scorePostCode1(String str) {
        String myPostcode = this.getPostCode1();
        if (myPostcode == null) {
            if (str == null) {
                return 1.0;
            }
            return 0.0;
        }
        if (myPostcode.equals(str)) {
            return 1.0;
        }
        try {
            int p1 = Integer.parseInt(myPostcode);
            int p2 = Integer.parseInt(str);
            return (p1 / 10000 == p2 / 10000 ? 0.2 : 0.0) + (p1 % 10000 / 1000 == p2 % 10000 / 1000 ? 0.2 : 0.0) + (p1 % 1000 / 100 == p2 % 1000 / 100 ? 0.2 : 0.0) + (p1 % 100 / 10 == p2 % 100 / 10 ? 0.2 : 0.0) + (p1 % 10 == p2 % 10 ? 0.2 : 0.0);
        }
        catch (NumberFormatException nex) {
            return super.scorePostCode1(str);
        }
    }

    private double scoreDateMainAddress(String candAddr, String inputAddr) {
        String inTok;
        if (StringUtilities.equalStrings((String)candAddr, (String)inputAddr)) {
            return 1.0;
        }
        if (candAddr == null || inputAddr == null) {
            return 0.0;
        }
        StringScorer scorer = this.getStringScorer();
        double score = 0.0;
        TaggedTokenList candTokens = FRA_SplitHelper.tagString(candAddr);
        TaggedTokenList inputTokens = FRA_SplitHelper.tagString(inputAddr);
        int candIdx = candTokens.indexOfTag("WORD");
        int inIdx = inputTokens.indexOfTag("WORD");
        if (candIdx < 0 || inIdx < 0) {
            return scorer.scoreString(candAddr, inputAddr);
        }
        String candTok = candTokens.getValue(candIdx);
        if (!candTok.equalsIgnoreCase(inTok = inputTokens.getValue(inIdx))) {
            boolean bMatch;
            boolean bl = bMatch = candTok.length() > inTok.length() && candTok.startsWith(inTok);
            if (!bMatch && candTok.length() < inTok.length() && inTok.startsWith(candTok)) {
                bMatch = true;
            }
            if (!bMatch) {
                return scorer.scoreString(candAddr, inputAddr);
            }
        }
        score += 0.8;
        candIdx = candTokens.indexOfTag("NUMERIC");
        inIdx = inputTokens.indexOfTag("NUMERIC");
        if (candIdx < 0 || inIdx < 0) {
            return score;
        }
        int candFirst = 0;
        int candSecond = 0;
        int inputFirst = 0;
        int inputSecond = 0;
        try {
            candFirst = Integer.parseInt(candTokens.getValue(candIdx));
            inputFirst = Integer.parseInt(inputTokens.getValue(inIdx));
            candIdx = candTokens.indexOfTag("NUMERIC", candIdx + 1);
            inIdx = inputTokens.indexOfTag("NUMERIC", inIdx + 1);
            if (candIdx > 0) {
                candSecond = Integer.parseInt(candTokens.getValue(candIdx));
            }
            if (inIdx > 0) {
                inputSecond = Integer.parseInt(inputTokens.getValue(inIdx));
            }
            if (candSecond == inputSecond) {
                score += 0.1;
                if (candFirst == inputFirst) {
                    score += 0.1;
                }
            } else if (inputSecond == 0) {
                if (candFirst == inputFirst || candSecond == inputFirst) {
                    score += 0.15;
                }
            } else if (candSecond == 0) {
                if (inputFirst == candFirst || inputSecond == candFirst) {
                    score += 0.15;
                }
            } else if (inputFirst == candFirst) {
                score += 0.13;
            } else if (inputFirst == candSecond) {
                score = inputSecond == candFirst ? (score += 0.19) : (score += 0.12);
            } else if (inputSecond == candFirst) {
                score += 0.12;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return score;
    }
}

