/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_ScoringAddress;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StringScorer;
import com.mapinfo.mapmarker.core.IScoringHelper;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class FRA_ScoringHelper
implements IScoringHelper {
    private static StringScorer m_stringScorer;
    private static StringBuffer m_collationRulesBuffer;
    private static final Set m_commonNamedStreetPrefixes;
    Map m_mainAddrScoringCache = new HashMap();
    Map m_areaNamesScoringCache = new HashMap();
    Map m_generalScoringCache = new HashMap();

    public ScoringAddress makeScoringAddress(Address addr, IConstraints constraints, IHandler handler) {
        FRA_ScoringAddress scoringAddress = new FRA_ScoringAddress(addr, this.m_mainAddrScoringCache, this.m_areaNamesScoringCache, this.m_generalScoringCache);
        scoringAddress.setCharsToIgnore(constraints.getHandler().getMatcherConstants().getStreetMatcherConstants().getCharsToIgnore());
        constraints.setHandler(handler);
        return scoringAddress;
    }

    public static String getCollationRules() {
        return m_collationRulesBuffer.toString();
    }

    public static char getFirstNormChar(String s) {
        char c = Character.toUpperCase(s.charAt(0));
        return c;
    }

    public Address makeParsedAddressCopy(Address pa) {
        return new AddressImpl(pa);
    }

    public StringScorer makeStringScorer() {
        return m_stringScorer;
    }

    public static void setStringScorer(StringScorer scorer) {
        m_stringScorer = scorer;
    }

    public static StringScorer getStringScorer() {
        return m_stringScorer;
    }

    public static boolean isCommonNamedStreetPrefix(String str) {
        return m_commonNamedStreetPrefixes.contains(str);
    }

    static {
        m_collationRulesBuffer = new StringBuffer();
        m_collationRulesBuffer.append("& c ; \u00e7 ");
        m_collationRulesBuffer.append("& n ; \u00f1 ");
        m_collationRulesBuffer.append("& a ; \u00e0 , \u00c0 , \u00e1 , \u00e4 , \u00e2 , \u00e3 ");
        m_collationRulesBuffer.append("& e ; \u00e9 , \u00e8 , \u00eb , \u00ea , \u00c8 , \u00c9 ");
        m_collationRulesBuffer.append("& i ; \u00ec , \u00ed , \u00ee , \u00ef , \u00cd , \u00cc , \u00cf ");
        m_collationRulesBuffer.append("& o ; \u00f2 , \u00fe , \u00f4 , \u00f5 , \u00f3 , \u00d2 , \u00d3 ");
        m_collationRulesBuffer.append("& u ; \u00f9 , \u00fa , \u00fb , \u00fc , \u00da , \u00d9 ");
        FRA_ScoringHelper.setStringScorer(new StringScorer(true, new Locale("fra", "FRA"), m_collationRulesBuffer.toString(), false, 6));
        HashSet<String> prefixes = new HashSet<String>();
        prefixes.add("PRESIDENT");
        prefixes.add("COMMANDANT");
        prefixes.add("CAPITAINE");
        prefixes.add("CARDINAL");
        prefixes.add("DOCTOR");
        prefixes.add("DOCTEUR");
        prefixes.add("GENERAL");
        prefixes.add("SAINT");
        prefixes.add("MARECHAL");
        prefixes.add("FONTAINE");
        prefixes.add("ABEL");
        prefixes.add("ADOLPHE");
        prefixes.add("ALBIN");
        prefixes.add("ALBERT");
        prefixes.add("ALEXANDRE");
        prefixes.add("ALFRED");
        prefixes.add("ALPHONSE");
        prefixes.add("ANDRE");
        prefixes.add("ANTOINE");
        prefixes.add("ARISTIDE");
        prefixes.add("AUGUSTE");
        prefixes.add("BERNARD");
        prefixes.add("CAMILLE");
        prefixes.add("CARL");
        prefixes.add("CHARLES");
        prefixes.add("CLAUDE");
        prefixes.add("EDMOND");
        prefixes.add("EDOUARD");
        prefixes.add("EMILE");
        prefixes.add("ERNEST");
        prefixes.add("ETIENNE");
        prefixes.add("FERNAND");
        prefixes.add("FRANCOIS");
        prefixes.add("FREDERIC");
        prefixes.add("FRIEDRICH");
        prefixes.add("GEORGES");
        prefixes.add("GERARD");
        prefixes.add("HECTOR");
        prefixes.add("HENRI");
        prefixes.add("HENRY");
        prefixes.add("HIPPOLYTE");
        prefixes.add("JACQUES");
        prefixes.add("JEAN");
        prefixes.add("JEANNE");
        prefixes.add("JOHN");
        prefixes.add("JOSEPH");
        prefixes.add("JUDA");
        prefixes.add("JULES");
        prefixes.add("JULIUS");
        prefixes.add("JULIETTE");
        prefixes.add("LEON");
        prefixes.add("LOUIS");
        prefixes.add("MARC");
        prefixes.add("MAURICE");
        prefixes.add("NICOLAS");
        prefixes.add("OLIVER");
        prefixes.add("PAUL");
        prefixes.add("PIERRE");
        prefixes.add("PETIT");
        prefixes.add("QUENTIN");
        prefixes.add("RAYMOND");
        prefixes.add("RENE");
        prefixes.add("ROBERT");
        prefixes.add("RICHARD");
        prefixes.add("VICTOR");
        m_commonNamedStreetPrefixes = Collections.unmodifiableSet(prefixes);
    }
}

