/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_Constraints;
import com.mapinfo.mapmarker.FRA.FRA_IConstraints;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.FRA.parser.FRA_ThoroughfareTypes;
import com.mapinfo.mapmarker.FRA.singleline.FRA_SingleLineComparatorUtils;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.MapMarkerInternalException;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.common.ParsedNumber;
import com.mapinfo.mapmarker.core.CoreHandler;
import com.mapinfo.mapmarker.core.IScoringHelper;
import com.mapinfo.mapmarker.core.address.CoreStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.core.address.IResettableStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.core.address.IStreetSingleAddressGeocoder;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;

public class FRA_StreetSingleAddressGeocoder
implements IResettableStreetSingleAddressGeocoder {
    public static final String SHIFTED_CITY_TOKENS = "SHIFTED_CITY_TOKENS";
    public static final String SWAPPED_SINGLELINE_TOKENS = "SWAPPED_SINGLELINE_TOKENS";
    public static final String ALL_TOKENS_IN_STREET = "ALL_TOKENS_IN_STREET";
    private static String[] saints = new String[]{"SAINTE", "SAINT"};
    private int m_currentCase = 0;
    private int m_internalCase = 0;
    private boolean m_mustMatchSt;
    private String m_simplifiedMainAddr;
    private String m_shortestLookupKey;
    private boolean m_bHasDistinctLastToken;
    protected boolean m_resetParsedAddress = false;
    private Address m_savedParsedAddress;
    protected boolean m_resetSearchParsedAddress = false;
    private Address m_savedSearchParsedAddress;
    private Address m_originalParsedAddress;
    private Address m_currentRetryParsedAddress;
    protected IStreetSingleAddressGeocoder m_coreStreetSingleAddressGeocoder = new CoreStreetSingleAddressGeocoder();
    protected CoreHandler m_handler;
    protected IScoringHelper m_scoringHandler;

    public FRA_StreetSingleAddressGeocoder(IHandler handler) {
        this.m_handler = (CoreHandler)handler;
        this.m_scoringHandler = ((ICoreStreetGeocoder)handler).getScoringHelper();
        if (this.m_scoringHandler == null) {
            // empty if block
        }
    }

    public void combineCandidateLists(List savedCandidates, List newCandidates) {
        this.m_coreStreetSingleAddressGeocoder.combineCandidateLists(savedCandidates, newCandidates);
    }

    public void removeDuplicateCandidates(List candidates) {
        this.m_coreStreetSingleAddressGeocoder.removeDuplicateCandidates(candidates);
    }

    public void setSearchParsedAddress(Address pa) {
        this.m_handler.setSearchParsedAddress(pa);
    }

    public void setParsedAddress(Address pa) {
        this.m_handler.setParsedAddress(pa);
    }

    public IScoringHelper getScoringHelper() {
        return this.m_scoringHandler;
    }

    private void initializeNewCases(IConstraints constraints) {
        this.m_mustMatchSt = constraints.isMustMatchMainAddress();
        this.m_originalParsedAddress = new AddressImpl(constraints.getHandler().getParsedAddress());
        this.initializeKeys(this.m_originalParsedAddress, this.m_handler.getSearchParsedAddress().getMainAddress());
    }

    private void initializeKeys(Address modifiedAddress, String searchMainAddress) {
        int tmpidx;
        this.m_currentRetryParsedAddress = new AddressImpl(modifiedAddress);
        this.m_shortestLookupKey = this.m_simplifiedMainAddr = searchMainAddress;
        int n = tmpidx = this.m_shortestLookupKey == null ? -1 : this.m_shortestLookupKey.lastIndexOf(32);
        if (tmpidx > 0) {
            this.m_shortestLookupKey = this.m_shortestLookupKey.substring(tmpidx + 1);
            this.m_bHasDistinctLastToken = true;
        } else {
            this.m_bHasDistinctLastToken = false;
        }
    }

    /*
     * Unable to fully structure code
     */
    public boolean generateNewCase(IConstraints constraints) throws MapMarkerInternalException {
        if (this.m_originalParsedAddress == null) {
            this.initializeNewCases(constraints);
        }
        if (!(fraConstraints = (FRA_IConstraints)constraints).foundSacs()) {
            this.m_currentCase = 0x7FFFFFFF;
        }
        constraints.removeCustomObject((Object)"KEY_FRA_ALTERNATE_SOUNDEX_CODES");
        constraints.removeCustomObject((Object)"KEY_TYPE_INSERTED_IN_MAIN_ADDRESS");
        if (this.m_resetParsedAddress) {
            this.setParsedAddress(this.m_savedParsedAddress);
            this.m_resetParsedAddress = false;
        }
        if (this.m_resetSearchParsedAddress) {
            this.setSearchParsedAddress(this.m_savedSearchParsedAddress);
            this.m_resetSearchParsedAddress = false;
        }
        spa = this.m_handler.getSearchParsedAddress();
        pa = this.m_handler.getParsedAddress();
        tryAgain = false;
        matchingPOBox = Boolean.valueOf(constraints.getCustomString("POBOX_MATCH_IN_PROGRESS", "false"));
        switch (this.m_currentCase) {
            case 0: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_bHasDistinctLastToken) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setMainAddress(this.m_shortestLookupKey);
                    tryAgain = true;
                    break;
                }
            }
            case 1: {
                ++this.m_currentCase;
                v0 = idx = this.m_simplifiedMainAddr == null ? -1 : this.m_simplifiedMainAddr.lastIndexOf(32);
                if (!matchingPOBox && idx > 0) {
                    tmp = this.m_simplifiedMainAddr.substring(0, idx);
                    if ((idx = tmp.lastIndexOf(32)) > 0) {
                        tmp = tmp.substring(idx + 1);
                    }
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setMainAddress(tmp);
                    tryAgain = true;
                    break;
                }
            }
            case 2: {
                ++this.m_currentCase;
                if (!matchingPOBox && !this.m_mustMatchSt && this.m_shortestLookupKey != null) {
                    constraints.setCustomObject((Object)"KEY_FRA_ALTERNATE_SOUNDEX_CODES", (Object)new Integer(32));
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setMainAddress(this.m_shortestLookupKey);
                    tryAgain = true;
                    break;
                }
            }
            case 3: {
                if (matchingPOBox || this.m_simplifiedMainAddr == null || spa.getGenericField1() == null) ** GOTO lbl71
                resimplified = FRA_Standardizer.standardizeCaseAndPunctuation(spa.getGenericField1());
                bTryCase = false;
                do {
                    bTryCase = false;
                    changedStandardization = FRA_Standardizer.applyAlternateStandardization(resimplified, this.m_internalCase);
                    ++this.m_internalCase;
                    if (changedStandardization == null) ** GOTO lbl68
                    changedStandardization = FRA_Standardizer.standardizeString(changedStandardization);
                } while (spa.getMainAddress().equalsIgnoreCase(changedStandardization));
                this.m_savedSearchParsedAddress = new AddressImpl(spa);
                this.m_resetSearchParsedAddress = true;
                this.m_savedParsedAddress = new AddressImpl(pa);
                this.m_resetParsedAddress = true;
                spa.setMainAddress(changedStandardization);
                pa.setMainAddress(changedStandardization);
                bTryCase = true;
lbl68:
                // 2 sources

                if (bTryCase) {
                    tryAgain = true;
                    break;
                }
lbl71:
                // 3 sources

                ++this.m_currentCase;
                this.m_internalCase = 0;
            }
            case 4: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_simplifiedMainAddr != null && spa.getGenericField1() != null) {
                    resimplified = FRA_Standardizer.standardizeCaseAndPunctuation(spa.getGenericField1());
                    changedNumerics = FRA_Standardizer.replaceWordsWithNumbers(resimplified);
                    changedNumerics = FRA_Standardizer.standardizeString(changedNumerics);
                    if (!spa.getMainAddress().equalsIgnoreCase(changedNumerics)) {
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_resetParsedAddress = true;
                        spa.setMainAddress(changedNumerics);
                        pa.setMainAddress(changedNumerics);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 5: {
                ++this.m_currentCase;
                if (!matchingPOBox && StringUtilities.hasNumeric((String)spa.getMainAddress()) && this.m_simplifiedMainAddr != null) {
                    changedNumerics = FRA_Standardizer.replaceNumbersWithWords(this.m_simplifiedMainAddr);
                    if (!spa.getMainAddress().equalsIgnoreCase(changedNumerics)) {
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_resetParsedAddress = true;
                        spa.setMainAddress(changedNumerics);
                        pa.setMainAddress(changedNumerics);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 6: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_simplifiedMainAddr != null && spa.getGenericField1() != null) {
                    resimplified = FRA_Standardizer.standardizeCaseAndPunctuation(spa.getGenericField1());
                    changedNumerics = FRA_Standardizer.replaceWordsWithOrdinals(resimplified);
                    changedNumerics = FRA_Standardizer.standardizeString(changedNumerics);
                    if (!spa.getMainAddress().equalsIgnoreCase(changedNumerics)) {
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_resetParsedAddress = true;
                        spa.setMainAddress(changedNumerics);
                        pa.setMainAddress(changedNumerics);
                        spa.setMainAddress(changedNumerics);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 7: {
                ++this.m_currentCase;
                if (!matchingPOBox && StringUtilities.hasNumeric((String)spa.getMainAddress()) && this.m_simplifiedMainAddr != null) {
                    changedNumerics = FRA_Standardizer.replaceOrdinalsWithWords(this.m_simplifiedMainAddr);
                    if (!spa.getMainAddress().equalsIgnoreCase(changedNumerics)) {
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        spa.setMainAddress(changedNumerics);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 8: {
                ++this.m_currentCase;
                if (!matchingPOBox && spa.getPreThoroughfareType() != null) {
                    tmp = spa.getPreThoroughfareType();
                    sb = new StringBuilder(FRA_ThoroughfareTypes.lookupByPreferredName(tmp).getProperTypeName());
                    sb.append(' ');
                    sb.append(this.m_simplifiedMainAddr);
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    pa.setMainAddress(FRA_Standardizer.standardizeString(sb.toString()));
                    pa.setPreThoroughfareType(null);
                    constraints.setCustomObject((Object)"KEY_TYPE_INSERTED_IN_MAIN_ADDRESS", (Object)new Integer(1));
                    tryAgain = true;
                    break;
                }
            }
            case 9: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_simplifiedMainAddr != null && spa.getGenericField1() != null && (idx = (tmp = spa.getGenericField1()).lastIndexOf(40)) > 0 && idx < tmp.length() - 1) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    sb = new StringBuilder(tmp.substring(idx + 1));
                    sb.append(' ');
                    sb.append(tmp.substring(0, idx));
                    pa.setMainAddress(FRA_Standardizer.standardizeString(sb.toString()));
                    spa.setMainAddress(pa.getMainAddress());
                    tryAgain = true;
                    break;
                }
            }
            case 10: {
                ++this.m_currentCase;
                if (!matchingPOBox && constraints.getHandler().getInputAddress().getGenericField1() != null && constraints.getHandler().getInputAddress().getMainAddress() != null) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    tempInputAddress = new AddressImpl(constraints.getHandler().getInputAddress());
                    tempInputAddress.setGenericField1(null);
                    constraints.getHandler().getParseHandler().getParsedAddresses((Address)tempInputAddress, constraints);
                    ((ICoreStreetGeocoder)constraints.getHandler()).setSearchParsedAddress(((ICoreStreetGeocoder)constraints.getHandler()).getScoringHelper().makeParsedAddressCopy(constraints.getHandler().getParsedAddressArray()[0]));
                    return true;
                }
            }
            case 11: {
                ++this.m_currentCase;
                testCity = spa.getAreaName3();
                if (!StringUtilities.isEmpty((String)testCity) && (tokenCount = (st = new StringTokenizer(testCity)).countTokens()) > 1 && fraConstraints.useStringKeys()) {
                    okToTrim = true;
                    token = null;
                    if (testCity.contains(" SAINT ") || testCity.contains(" SAINTE ")) {
                        token = st.nextToken();
                        while (!token.equals("SAINT") && !token.equals("SAINTE")) {
                            token = st.nextToken();
                        }
                        builder = new StringBuilder(token);
                        builder.append(' ');
                        builder.append(st.nextToken());
                        token = builder.toString();
                    } else {
                        token = st.nextToken();
                        if ("SAINT".equals(token) || "SAINTE".equals(token)) {
                            if (tokenCount > 2) {
                                sb = new StringBuilder(token);
                                sb.append(' ');
                                sb.append(st.nextToken());
                                token = sb.toString();
                            } else {
                                okToTrim = false;
                            }
                        }
                    }
                    if (okToTrim) {
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_resetParsedAddress = true;
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        pa.setAreaName3(token);
                        spa.setAreaName3(token);
                        return true;
                    }
                }
            }
            case 12: {
                ++this.m_currentCase;
                testMain = spa.getMainAddress();
                if (!matchingPOBox && !StringUtilities.isEmpty((String)testMain) && !StringUtilities.isEmpty((String)spa.getPreThoroughfareType()) && (idx = testMain.indexOf(32)) > 0 && FRA_ThoroughfareTypes.isStreetType(testType = testMain.substring(0, idx))) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setPreThoroughfareType(FRA_ThoroughfareTypes.lookupByTypeName(testType).getPreferredTypeName());
                    spa.setMainAddress(testMain.substring(idx + 1));
                    pa.setPreThoroughfareType(spa.getPreThoroughfareType());
                    pa.setMainAddress(spa.getMainAddress());
                    return true;
                }
            }
            case 13: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_simplifiedMainAddr != null) {
                    changedNumerics = FRA_Standardizer.replaceNumbersAndWordsWithRomanNumerals(this.m_simplifiedMainAddr);
                    if (!spa.getMainAddress().equalsIgnoreCase(changedNumerics)) {
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        spa.setMainAddress(changedNumerics);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 14: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_bHasDistinctLastToken && this.m_shortestLookupKey.length() > 2 && (this.m_shortestLookupKey.startsWith("DE") || this.m_shortestLookupKey.startsWith("LE"))) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setMainAddress(this.m_shortestLookupKey.substring(2));
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    lastTokenIdx = this.m_simplifiedMainAddr.lastIndexOf(32);
                    sb = new StringBuilder(this.m_simplifiedMainAddr);
                    sb.insert(lastTokenIdx + 3, ' ');
                    pa.setMainAddress(FRA_Standardizer.standardizeString(sb.toString()));
                    tryAgain = true;
                    break;
                }
            }
            case 15: {
                ++this.m_currentCase;
                pn = pa.getParsedAddressNumber();
                if (!matchingPOBox && pn != null && !pn.isPureNumeric() && pn.getAddressSuffix() != null) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    sb = new StringBuilder();
                    if (pa.getPreThoroughfareType() == null) {
                        testType = pn.getAddressSuffix();
                        if (FRA_ThoroughfareTypes.isStreetType(testType)) {
                            pa.setPreThoroughfareType(testType);
                        } else {
                            sb.append(pn.getAddressSuffix());
                            sb.append(' ');
                        }
                        sb.append(spa.getMainAddress());
                        if (pa.getPostThoroughfareType() != null) {
                            sb.append(' ');
                            sb.append(FRA_ThoroughfareTypes.lookupByTypeName(pa.getPostThoroughfareType()).getExpandedTypeName());
                            spa.setPostThoroughfareType("");
                            pa.setPostThoroughfareType("");
                        }
                    } else {
                        sb.append(pn.getAddressSuffix());
                        sb.append(' ');
                        sb.append(spa.getMainAddress());
                    }
                    spa.setMainAddress(FRA_Standardizer.standardizeString(sb.toString()));
                    pa.setMainAddress(spa.getMainAddress());
                    number = new ParsedNumber(pn);
                    number.setAddressSuffix("");
                    number.setSuffixSeparator("");
                    pa.setAddressNumber(number.getCombinedAddressNumber());
                    spa.setAddressNumber(number.getCombinedAddressNumber());
                    tryAgain = true;
                    break;
                }
            }
            case 16: {
                ++this.m_currentCase;
                pn = pa.getParsedAddressNumber();
                if (!matchingPOBox && pn == null && StringUtilities.hasNumeric((String)pa.getMainAddress()) && pa.getPostThoroughfareType() != null) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setAddressNumber(spa.getMainAddress());
                    spa.setMainAddress(FRA_ThoroughfareTypes.lookupByTypeName(pa.getPostThoroughfareType()).getExpandedTypeName());
                    spa.setGenericField1(spa.getMainAddress());
                    spa.setPostThoroughfareType(null);
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    pa.setAddressNumber(pa.getMainAddress());
                    pa.setMainAddress(FRA_ThoroughfareTypes.lookupByTypeName(pa.getPostThoroughfareType()).getExpandedTypeName());
                    pa.setGenericField1(pa.getMainAddress());
                    pa.setPostThoroughfareType(null);
                    tryAgain = true;
                    break;
                }
            }
            case 17: {
                ++this.m_currentCase;
                if (!matchingPOBox && fraConstraints.isSingleLineInput() && spa.getAreaName3() == null && spa.getMainAddress() != null && spa.getAddressNumber() != null && spa.getPreThoroughfareType() == null && spa.getPostThoroughfareType() == null) {
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    spa.setAreaName3(spa.getMainAddress());
                    spa.setMainAddress(spa.getAddressNumber());
                    spa.setAddressNumber("");
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    pa.setAreaName3(pa.getMainAddress());
                    pa.setMainAddress(pa.getAddressNumber());
                    pa.setAddressNumber("");
                    tryAgain = true;
                    break;
                }
            }
            case 18: {
                ++this.m_currentCase;
                if (!matchingPOBox && this.m_simplifiedMainAddr != null && spa.getGenericField1() != null) {
                    resimplified = FRA_Standardizer.standardizeCaseAndPunctuation(spa.getGenericField1());
                    mainAddress = spa.getMainAddress();
                    if (!(mainAddress.equalsIgnoreCase(resimplified) || (idxBeg = resimplified.indexOf(mainAddress)) <= 0 || (aChar = resimplified.charAt(idxBeg - 1)) != ' ' && aChar != '-')) {
                        prevToken = resimplified.substring(0, idxBeg - 1);
                        idxBegPrevToken = prevToken.lastIndexOf(" ");
                        if (idxBegPrevToken == -1) {
                            idxBegPrevToken = prevToken.lastIndexOf("-");
                        }
                        prevToken = prevToken.substring(idxBegPrevToken + 1);
                        newMain = prevToken + mainAddress;
                        this.m_savedSearchParsedAddress = new AddressImpl(spa);
                        this.m_resetSearchParsedAddress = true;
                        this.m_savedParsedAddress = new AddressImpl(pa);
                        this.m_resetParsedAddress = true;
                        spa.setMainAddress(newMain);
                        pa.setMainAddress(newMain);
                        tryAgain = true;
                        break;
                    }
                }
            }
            case 19: {
                ++this.m_currentCase;
                testCity = spa.getAreaName3();
                if (!StringUtilities.isEmpty((String)testCity) && (tokenCount = (st = new StringTokenizer(testCity)).countTokens()) > 1 && fraConstraints.useStringKeys() && !(token = st.nextToken()).equals("SAINT") && !token.equals("SAINTE")) {
                    this.m_savedParsedAddress = new AddressImpl(pa);
                    this.m_resetParsedAddress = true;
                    this.m_savedSearchParsedAddress = new AddressImpl(spa);
                    this.m_resetSearchParsedAddress = true;
                    pa.setAreaName3(token);
                    spa.setAreaName3(token);
                    return true;
                }
            }
            default: {
                if (fraConstraints.isStrictFirstPass()) {
                    fraConstraints.setIsStrictFirstPass(false);
                    fraConstraints.setSearchAreaLevel((byte)1);
                    this.resetRetrys(this.m_currentRetryParsedAddress);
                    this.updateIgnoredSacList(fraConstraints);
                    tryAgain = true;
                    break;
                }
                if (fraConstraints.useStringKeys()) {
                    fraConstraints.setUseStringKeys(false);
                    this.resetRetrys(this.m_currentRetryParsedAddress);
                    this.updateIgnoredSacList(fraConstraints);
                    tryAgain = true;
                    break;
                }
                if (fraConstraints.getSearchAreaLevel() == 1) {
                    fraConstraints.setSearchAreaLevel((byte)2);
                    this.resetRetrys(this.m_currentRetryParsedAddress);
                    this.updateIgnoredSacList(fraConstraints);
                    tryAgain = true;
                    break;
                }
                if (!fraConstraints.isSingleLineInput() && (pa.getAreaName3() == null || pa.getAreaName3().indexOf(32) <= 0)) break;
                if (constraints.getCustomString("SHIFTED_CITY_TOKENS") == null) {
                    constraints.setCustomString("SHIFTED_CITY_TOKENS", "SHIFTED_CITY_TOKENS");
                    modified_pa = this.shiftCityTokenToStreet(pa);
                    if (modified_pa != null) {
                        pa.setMainAddress(modified_pa.getMainAddress());
                        pa.setAreaName3(modified_pa.getAreaName3());
                        spa.setMainAddress(modified_pa.getMainAddress());
                        spa.setAreaName3(modified_pa.getAreaName3());
                        this.setupNewLastLineRetry(modified_pa, fraConstraints);
                        tryAgain = true;
                        break;
                    }
                }
                if (fraConstraints.isSingleLineInput() && constraints.getCustomString("SWAPPED_SINGLELINE_TOKENS") == null) {
                    constraints.setCustomString("SWAPPED_SINGLELINE_TOKENS", "SWAPPED_SINGLELINE_TOKENS");
                    modified_pa = this.swapStreetAndCity(this.m_originalParsedAddress);
                    if (modified_pa != null) {
                        pa.setMainAddress(modified_pa.getMainAddress());
                        pa.setAreaName3(modified_pa.getAreaName3());
                        spa.setMainAddress(modified_pa.getMainAddress());
                        spa.setAreaName3(modified_pa.getAreaName3());
                        this.setupNewLastLineRetry(modified_pa, fraConstraints);
                        tryAgain = true;
                        break;
                    }
                }
                if (!fraConstraints.isSingleLineInput() || constraints.getCustomString("ALL_TOKENS_IN_STREET") != null) break;
                constraints.setCustomString("ALL_TOKENS_IN_STREET", "ALL_TOKENS_IN_STREET");
                modified_pa = this.addCityToStreet(this.m_originalParsedAddress, fraConstraints);
                if (modified_pa == null) break;
                pa.setMainAddress(modified_pa.getMainAddress());
                pa.setAreaName3(null);
                spa.setMainAddress(modified_pa.getMainAddress());
                spa.setAreaName3(null);
                this.setupNewLastLineRetry(modified_pa, fraConstraints);
                tryAgain = true;
                break;
            }
        }
        if (!tryAgain) {
            constraints.removeCustomObject((Object)"SHIFTED_CITY_TOKENS");
            constraints.removeCustomObject((Object)"SWAPPED_SINGLELINE_TOKENS");
            constraints.removeCustomObject((Object)"ALL_TOKENS_IN_STREET");
            this.resetRetrys(this.m_originalParsedAddress);
        }
        return tryAgain;
    }

    private void updateIgnoredSacList(FRA_IConstraints constraints) {
        Set<Integer> searchedSacs = constraints.getSearchedSacs();
        if (searchedSacs != null && searchedSacs.size() > 0) {
            Set<Integer> ignoredSacs = constraints.getIgnoredSacs();
            if (ignoredSacs == null) {
                constraints.setIgnoredSacs(searchedSacs);
            } else {
                ignoredSacs.addAll(searchedSacs);
            }
            constraints.setSearchedSacs(null);
        }
    }

    private void clearIgnoredSacList(FRA_IConstraints constraints) {
        constraints.setSearchedSacs(null);
        constraints.setIgnoredSacs(null);
    }

    private void resetRetrys(Address currentParsing) {
        this.m_handler.setParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(currentParsing));
        this.m_handler.setSearchParsedAddress(this.m_scoringHandler.makeParsedAddressCopy(currentParsing));
        this.m_currentCase = 0;
        this.m_resetSearchParsedAddress = false;
        this.m_resetParsedAddress = false;
        this.m_savedParsedAddress = null;
    }

    public void resetRetryCases(IConstraints constraints) {
        if (constraints instanceof FRA_Constraints) {
            ((FRA_Constraints)constraints).setSearchedSacs(new HashSet<Integer>(0));
            ((FRA_Constraints)constraints).setIgnoredSacs(new HashSet<Integer>(0));
        }
        this.resetRetrys(this.m_handler.getSearchParsedAddress());
    }

    private Address shiftCityTokenToStreet(Address pa) {
        String city = pa.getAreaName3();
        if (city != null) {
            int idx = city.indexOf(32);
            String main = pa.getMainAddress();
            if (idx > 0 && main != null) {
                StringBuilder sb = new StringBuilder(main);
                sb.append(' ');
                sb.append(FRA_SingleLineComparatorUtils.getStartingToken(city));
                main = sb.toString();
                city = city.substring(idx + 1);
                AddressImpl out = new AddressImpl(pa);
                out.setMainAddress(main);
                out.setAreaName3(city);
                return out;
            }
        }
        return null;
    }

    private Address swapStreetAndCity(Address pa) {
        if (pa.getPreThoroughfareType() == null && pa.getPostThoroughfareType() == null) {
            String city = pa.getAreaName3();
            String main = pa.getMainAddress();
            if (city != null && main != null) {
                AddressImpl out = new AddressImpl(pa);
                out.setGenericField1(city);
                out.setMainAddress(FRA_Standardizer.standardizeString(city));
                out.setAreaName3(main);
                return out;
            }
        }
        return null;
    }

    private Address addCityToStreet(Address pa, FRA_IConstraints constraints) {
        if (pa.getPostCode1() != null) {
            String city = FRA_Standardizer.standardizeString(pa.getAreaName3());
            String main = pa.getMainAddress();
            if (city != null && main != null) {
                int idxPostcode;
                String input = FRA_Standardizer.standardizeString(constraints.getCustomString("ORIGINAL_SINGLE_LINE"));
                int idxCity = input.indexOf(city);
                int idxStreet = input.indexOf(main);
                if (idxStreet < (idxPostcode = input.indexOf(pa.getPostCode1())) && idxCity < idxPostcode || idxStreet > idxPostcode && idxCity > idxPostcode) {
                    AddressImpl out = new AddressImpl(pa);
                    StringBuilder sb = new StringBuilder();
                    if (idxCity > idxStreet) {
                        sb.append(main);
                        sb.append(' ');
                        sb.append(city);
                    } else {
                        sb.append(city);
                        sb.append(' ');
                        sb.append(main);
                    }
                    out.setMainAddress(FRA_Standardizer.standardizeString(sb.toString()));
                    out.setAreaName3(null);
                    return out;
                }
            }
        }
        return null;
    }

    private void setupNewLastLineRetry(Address modifiedAddress, FRA_IConstraints fraConstraints) {
        this.initializeKeys(modifiedAddress, modifiedAddress.getMainAddress());
        this.clearIgnoredSacList(fraConstraints);
        fraConstraints.setUseStringKeys(true);
        fraConstraints.setIsStrictFirstPass(true);
        this.m_savedSearchParsedAddress = new AddressImpl(modifiedAddress);
        this.m_savedParsedAddress = new AddressImpl(modifiedAddress);
        this.m_resetSearchParsedAddress = true;
        this.m_resetParsedAddress = true;
    }
}

