/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA;

import com.mapinfo.mapmarker.FRA.FRA_Address;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.AddressImpl;
import com.mapinfo.mapmarker.user.InputAddress;
import com.mapinfo.mapmarker.utils.ISO3166;
import java.util.Map;

public final class FRA_UserInputAddress
implements InputAddress,
FRA_Address {
    private String m_postAddress = null;
    private String m_preAddress = null;
    private String m_addressNumber = null;
    private String m_postCode1 = null;
    private String m_postCode2 = null;
    private String m_mainAddress = null;
    private String m_areaName1 = null;
    private String m_areaName2 = null;
    private String m_areaName3 = null;
    private String m_areaName4 = null;
    private String m_genericField1 = null;
    private String m_genericField2 = null;
    private String m_genericField3 = null;
    private String m_genericField4 = null;
    private String m_placeName = null;
    private String m_postDirectional = null;
    private String m_postThoroughfareType = null;
    private String m_preDirectional = null;
    private String m_preThoroughfareType = null;
    private String m_unitType = null;
    private String m_unitValue = null;
    private String m_CountryString = null;
    private ISO3166 m_Country = null;
    private Map m_additionalFields = null;

    public FRA_UserInputAddress(String housenumber, String street, String postcode, String town, String department, String postaddress, String preaddress, String placeName) {
        this.setCountry("FRA");
        this.setPostAddress(postaddress);
        this.setPreAddress(preaddress);
        this.setHouseNumber(housenumber);
        this.setTown(town);
        this.setPostcode(postcode);
        this.setStreet(street);
        this.setDepartment(department);
        this.setPlaceName(placeName);
    }

    public FRA_UserInputAddress() {
        this(null, null, null, null, null, null, null, null);
    }

    @Override
    public void setPostAddress(String postaddress) {
        this.m_postAddress = postaddress;
    }

    public void setPreAddress(String preaddress) {
        this.m_preAddress = preaddress;
    }

    @Override
    public void setPlaceName(String placeName) {
        this.m_placeName = placeName;
    }

    @Override
    public String getPlaceName() {
        return this.m_placeName;
    }

    public void setLocality(String locality) {
        this.m_areaName4 = locality;
    }

    @Override
    public String getLocality() {
        return this.m_areaName4;
    }

    @Override
    public String getPostAddress() {
        return this.m_postAddress;
    }

    @Override
    public void setHouseNumber(String housenumber) {
        this.m_addressNumber = housenumber;
    }

    @Override
    public String getHouseNumber() {
        return this.m_addressNumber;
    }

    @Override
    public void setTown(String town) {
        this.m_areaName3 = town;
    }

    @Override
    public String getTown() {
        return this.m_areaName3;
    }

    @Override
    public void setPostcode(String postcode) {
        this.m_postCode1 = postcode;
    }

    @Override
    public String getPostcode() {
        return this.m_postCode1;
    }

    @Override
    public void setStreet(String street) {
        this.m_mainAddress = street;
    }

    @Override
    public String getStreet() {
        return this.m_mainAddress;
    }

    @Override
    public void setRegion(String region) {
        this.m_areaName1 = region;
    }

    @Override
    public String getRegion() {
        return this.m_areaName1;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        buff.append("\nHouseNumber: " + this.getHouseNumber());
        buff.append("\nStreet: " + this.getStreet());
        buff.append("\nPostcode: " + this.getPostcode());
        buff.append("\nTown: " + this.getTown());
        buff.append("\nDepartment: " + this.getDepartment());
        buff.append("\nPostAddress: " + this.getPostAddress());
        buff.append("\nCountry: " + this.getCountry());
        return buff.toString();
    }

    public final String getCountry() {
        return this.m_CountryString;
    }

    public final void setCountry(String countrycode) {
        if (countrycode == null) {
            return;
        }
        this.m_Country = null;
        int len = countrycode.length();
        if (len == 2) {
            this.m_Country = ISO3166.findCountryByISO2((String)countrycode);
        } else if (len == 3) {
            this.m_Country = ISO3166.findCountryByISO3((String)countrycode);
        }
        if (this.m_Country == null) {
            this.m_Country = ISO3166.findCountryByNumber((String)countrycode);
        }
        if (this.m_Country == null) {
            this.m_Country = ISO3166.findCountryByName((String)countrycode);
        }
        this.m_CountryString = this.m_Country == null ? countrycode.toUpperCase() : this.m_Country.getISO3Country();
    }

    public final Address convert() {
        AddressImpl address = new AddressImpl();
        address.setCountry(this.trimString(this.getCountry()));
        address.setAddressNumber(this.trimString(this.m_addressNumber));
        address.setAreaName1(this.trimString(this.m_areaName1));
        address.setAreaName2(this.trimString(this.m_areaName2));
        address.setAreaName3(this.trimString(this.m_areaName3));
        address.setAreaName4(this.trimString(this.m_areaName4));
        address.setGenericField1(this.trimString(this.m_genericField1));
        address.setGenericField2(this.trimString(this.m_genericField2));
        address.setGenericField3(this.trimString(this.m_genericField3));
        address.setGenericField4(this.trimString(this.m_genericField4));
        address.setMainAddress(this.trimString(this.m_mainAddress));
        address.setPlaceName(this.trimString(this.m_placeName));
        address.setPostAddress(this.trimString(this.m_postAddress));
        address.setPostCode1(this.trimString(this.m_postCode1));
        address.setPostCode2(this.trimString(this.m_postCode2));
        address.setPostDirectional(this.trimString(this.m_postDirectional));
        address.setPostThoroughfareType(this.trimString(this.m_postThoroughfareType));
        address.setPreAddress(this.trimString(this.m_preAddress));
        address.setPreDirectional(this.trimString(this.m_preDirectional));
        address.setPreThoroughfareType(this.trimString(this.m_preThoroughfareType));
        address.setUnitType(this.trimString(this.m_unitType));
        address.setUnitValue(this.trimString(this.m_unitValue));
        if (this.m_additionalFields != null && !this.m_additionalFields.isEmpty()) {
            address.getAdditionalFields().putAll(this.m_additionalFields);
        }
        return address;
    }

    private String trimString(String input) {
        if (input == null) {
            return input;
        }
        if ((input = input.trim()).length() == 0) {
            return null;
        }
        return input;
    }

    @Override
    public String getDepartment() {
        return this.m_areaName2;
    }

    @Override
    public String getGenericField3() {
        return this.m_genericField3;
    }

    @Override
    public void setDepartment(String department) {
        this.m_areaName2 = department;
    }

    @Override
    public void setGenericField3(String genericField3) {
    }
}

