/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp;

import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoBase;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeo2SacDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.StringTokenizer;

public class FRA_Geo2SacDataSourceRecordConvertorImpl
extends Geo2SacDataSourceRecordConvertorImpl {
    public FRA_Geo2SacDataSourceRecordConvertorImpl(Properties dataProperties, Soundex soundex) {
        super(dataProperties, soundex);
    }

    protected MMJGeo2SacRecord makeGeo2SacRecord(int sac, IGeoBase base) {
        return new FRA_Geo2SacRecord(sac, (FRA_GeoBase)base);
    }

    protected IGeoBase[] makeGeoBases(IGeo2SacDataSourceRecord input) throws DataSourceException {
        HashSet bases = new HashSet();
        bases.addAll(this.makeGeoBasesForArea(input.getAreaName3(), FRA_GeoBase.AREA_LEVEL_AN3));
        bases.addAll(this.makeGeoBasesForArea(input.getAlternateAreaName3(), FRA_GeoBase.AREA_LEVEL_AN3));
        bases.addAll(this.makeGeoBasesForArea(input.getAreaName4(), FRA_GeoBase.AREA_LEVEL_AN4));
        bases.addAll(this.makeGeoBasesForArea(input.getAlternateAreaName4(), FRA_GeoBase.AREA_LEVEL_AN4));
        if (bases.size() > 0) {
            return bases.toArray(new IGeoBase[bases.size()]);
        }
        return null;
    }

    private Collection makeGeoBasesForArea(String areaname, byte areaType) {
        HashSet<FRA_GeoBase> bases = new HashSet<FRA_GeoBase>();
        if (!StringUtilities.isEmpty((String)areaname)) {
            StringTokenizer st = new StringTokenizer(areaname.toUpperCase(), "/");
            while (st.hasMoreTokens()) {
                FRA_GeoBase base;
                String name = st.nextToken().trim();
                if (name.startsWith("+")) {
                    name = name.substring(1);
                }
                if (StringUtilities.isEmpty((String)name)) continue;
                ISoundexKey key = this.makeSoundexKey(name = FRA_Standardizer.standardizeAreaName(name));
                if (key != null) {
                    base = new FRA_GeoBase((FRA_SoundexKey)key, name, areaType);
                    bases.add(base);
                } else {
                    DataCreationLogger.getLogger().logError("Null soundex key created for string value: " + name);
                }
                key = FRAFrenchSoundex.getStringKey(name);
                if (key != null) {
                    base = new FRA_GeoBase((FRA_SoundexKey)key, name, areaType);
                    bases.add(base);
                    continue;
                }
                DataCreationLogger.getLogger().logError("Null string hash key created for string value: " + name);
            }
        }
        return bases;
    }
}

