/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp;

import com.mapinfo.mapmarker.FRA.dp.FRA_IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.FRA.parser.FRA_Standardizer;
import com.mapinfo.mapmarker.common.dp.DataSourceException;
import com.mapinfo.mapmarker.common.dp.GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.IGeoInfoDataSourceRecord;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiStringIndexKey;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

public class FRA_GeoInfoDataSourceRecordConvertorImpl
extends GeoInfoDataSourceRecordConvertorImpl {
    public FRA_GeoInfoDataSourceRecordConvertorImpl(Properties dataProperties) {
        super(dataProperties);
    }

    protected GeoInfoRecord makeGeoInfoRecordType() {
        return new FRA_GeoInfoRecord();
    }

    protected GeoInfoRecord makeGeoInfoRecord(IGeoInfoDataSourceRecord input) throws DataSourceException {
        FRA_GeoInfoRecord record = (FRA_GeoInfoRecord)super.makeGeoInfoRecord(input);
        if (record != null) {
            String[] standardized;
            String[] split;
            FRA_IGeoInfoDataSourceRecord fraInput = (FRA_IGeoInfoDataSourceRecord)input;
            if (!input.hasPrecision() && record.getPoint() != null) {
                if (!StringUtilities.isEmpty((String)record.getAreaName4())) {
                    record.setPrecision((byte)11);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName3())) {
                    record.setPrecision((byte)10);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName2())) {
                    record.setPrecision((byte)9);
                } else if (!StringUtilities.isEmpty((String)record.getAreaName1())) {
                    record.setPrecision((byte)8);
                }
            }
            String areaname = fraInput.getAreaName1();
            record.setOriginalAreaName1(areaname);
            areaname = FRA_Standardizer.standardizeAreaName(areaname);
            record.setAreaName1(areaname);
            areaname = fraInput.getAreaName2();
            record.setOriginalAreaName2(areaname);
            areaname = FRA_Standardizer.standardizeAreaName(areaname);
            record.setAreaName2(areaname);
            areaname = fraInput.getAreaName3();
            record.setOriginalAreaName3(areaname);
            areaname = FRA_Standardizer.standardizeAreaName(areaname);
            record.setAreaName3(areaname);
            areaname = fraInput.getAreaName4();
            record.setOriginalAreaName4(areaname);
            areaname = FRA_Standardizer.standardizeAreaName(areaname);
            record.setAreaName4(areaname);
            areaname = record.getAltAreaName1();
            if (!StringUtilities.isEmpty((String)areaname)) {
                split = this.splitAltAreaNames(areaname);
                standardized = this.standardizeAreaNames(split);
                record.setAltAreaName1(null);
                record.setOriginalAltAreaName1Array(split);
                record.setAltAreaName1Array(standardized);
            }
            if (!StringUtilities.isEmpty((String)(areaname = record.getAltAreaName2()))) {
                split = this.splitAltAreaNames(areaname);
                standardized = this.standardizeAreaNames(split);
                record.setAltAreaName2(null);
                record.setOriginalAltAreaName2Array(split);
                record.setAltAreaName2Array(standardized);
            }
            if (!StringUtilities.isEmpty((String)(areaname = record.getAltAreaName3()))) {
                split = this.splitAltAreaNames(areaname);
                standardized = this.standardizeAreaNames(split);
                record.setAltAreaName3(null);
                record.setOriginalAltAreaName3Array(split);
                record.setAltAreaName3Array(standardized);
            }
            if (!StringUtilities.isEmpty((String)(areaname = record.getAltAreaName4()))) {
                split = this.splitAltAreaNames(areaname);
                standardized = this.standardizeAreaNames(split);
                record.setAltAreaName4(null);
                record.setOriginalAltAreaName4Array(split);
                record.setAltAreaName4Array(standardized);
            }
            if (fraInput.hasPostCode1()) {
                record.setPostCode(fraInput.getPostCode1());
            }
        }
        return record;
    }

    private String[] splitAltAreaNames(String areanames) {
        ArrayList<String> split = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(areanames, "/");
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            while (s.startsWith("+")) {
                s = s.substring(1);
            }
            split.add(s);
        }
        return split.toArray(new String[split.size()]);
    }

    private String[] standardizeAreaNames(String[] areanames) {
        String[] standardized = new String[areanames.length];
        for (int i = 0; i < areanames.length; ++i) {
            standardized[i] = FRA_Standardizer.standardizeAreaName(areanames[i]);
        }
        return standardized;
    }

    protected MapMarkerIndexKey makeGeoInfoKey(GeoInfoRecord record) {
        FRA_GeoInfoRecord rec = (FRA_GeoInfoRecord)record;
        StringBuilder sb = new StringBuilder();
        String tmp = rec.getOriginalAreaName1();
        if (tmp != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getOriginalAreaName2()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getOriginalAreaName3()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getOriginalAreaName4()) != null) {
            sb.append(tmp);
        }
        if ((tmp = rec.getPostCode()) != null) {
            sb.append(tmp);
        }
        return new MiStringIndexKey(sb.toString().toUpperCase());
    }
}

