/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.Constraints;
import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.VersionInfo;
import com.mapinfo.mapmarker.FRA.dp.FRA_DataConstructionParser;
import com.mapinfo.mapmarker.FRA.dp.FRA_Geo2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FRA.dp.FRA_GeoInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FRA.dp.FRA_StreetDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_DataFileMasksProvider;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_MMJStreetRecordComparator;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_StreetBuilder;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_MultiLevelSoundexIndexFileConvertor;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.dp.IDataHandler;
import com.mapinfo.mapmarker.common.dp.IDataSourceRecordConvertor;
import com.mapinfo.mapmarker.common.dp.Post2SacDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.PostInfoDataSourceRecordConvertorImpl;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataProvider;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJSegmentComparer;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.index.GeoInfoSoundexIndexer;
import com.mapinfo.mapmarker.common.dp.binary.index.IndexFileConvertor;
import com.mapinfo.mapmarker.common.dp.intermediate.IIntermediateDataHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.ITempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.InMemoryTempDataRecordHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.IntermediateStreetDataFileFormatHandler;
import com.mapinfo.mapmarker.common.dp.intermediate.NonIntermediateDataHandler;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public abstract class FRA_AbstractDataProvider
extends AbstractDataProvider {
    private static MiVersion m_version = new MiVersion((byte)VersionInfo.getMajorVersion(), (byte)VersionInfo.getMinorVersion(), (byte)VersionInfo.getReleaseVersion());
    private static final GeoInfoSoundexIndexer m_geoSoundexIndexer = new FRA_GeoInfoSoundexIndexer();
    private MMJComplexDataFileMetadata m_geoInfoMetaData;
    private MMJComplexDataFileMetadata m_postInfoMetaData;
    private MMJComplexDataFileMetadata m_streetMetaData;

    public void initialize(Properties processingProperties) throws DataCreationException {
        super.initialize(processingProperties);
        this.m_dataBuilder = new FRA_StreetBuilder();
        String processStreets = (String)processingProperties.get("street_create");
        if ("YES".equalsIgnoreCase(processStreets)) {
            FRA_StreetDataSourceRecordConvertorImpl streetConvertor = new FRA_StreetDataSourceRecordConvertorImpl(new FRAFrenchSoundex(), processingProperties, new CollationKeyGenerator(new Locale("FR", "FRA"), FRA_ScoringHelper.getCollationRules()), new FRA_DataConstructionParser(), new Constraints());
            IntermediateStreetDataFileFormatHandler intermediateHandler = new IntermediateStreetDataFileFormatHandler(StringUtilities.appendToPath((String)processingProperties.getProperty("street_outputFilePath"), (String)"streets.tmp"));
            this.m_streetDataHandler = this.buildStreetDataHandler((IDataSourceRecordConvertor)streetConvertor, (IIntermediateDataHandler)intermediateHandler, (ITempDataRecordHandler)new InMemoryTempDataRecordHandler(), new FRA_MMJStreetRecordComparator(), new MMJSegmentComparer());
        }
        this.m_post2sacDataHandler = this.buildPost2SacDataHandler((IDataSourceRecordConvertor)new Post2SacDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_postInfoDataHandler = this.buildPostInfoDataHandler((IDataSourceRecordConvertor)new PostInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geo2sacDataHandler = this.buildGeo2SacDataHandler((IDataSourceRecordConvertor)new FRA_Geo2SacDataSourceRecordConvertorImpl(processingProperties, new FRAFrenchSoundex()), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
        this.m_geoInfoDataHandler = this.buildGeoInfoDataHandler((IDataSourceRecordConvertor)new FRA_GeoInfoDataSourceRecordConvertorImpl(processingProperties), (IIntermediateDataHandler)new NonIntermediateDataHandler(), (ITempDataRecordHandler)new InMemoryTempDataRecordHandler());
    }

    protected abstract IDataHandler buildStreetDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3, MMJStreetRecordComparator var4, MMJSegmentComparer var5) throws DataCreationException;

    protected abstract IDataHandler buildPost2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeo2SacDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildPostInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    protected abstract IDataHandler buildGeoInfoDataHandler(IDataSourceRecordConvertor var1, IIntermediateDataHandler var2, ITempDataRecordHandler var3);

    public MMJComplexDataFileMetadata getStreetMetadata() {
        if (this.m_streetMetaData == null) {
            this.m_streetMetaData = new MMJComplexDataFileMetadata();
            this.m_streetMetaData.setDataFileMasks(FRA_DataFileMasksProvider.buildStreetDataFileMasks());
            this.setMetaDataProperties(this.m_streetMetaData);
            this.m_streetMetaData.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_streetMetaData;
    }

    public MMJComplexDataFileMetadata getPostInfoMetadata() {
        if (this.m_postInfoMetaData == null) {
            this.m_postInfoMetaData = new MMJComplexDataFileMetadata();
            this.m_postInfoMetaData.setDataFileMasks(FRA_DataFileMasksProvider.buildPostInfoDataFileMasks());
            this.setMetaDataProperties(this.m_postInfoMetaData);
            this.m_postInfoMetaData.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_postInfoMetaData;
    }

    public MMJComplexDataFileMetadata getGeoInfoMetadata() {
        if (this.m_geoInfoMetaData == null) {
            this.m_geoInfoMetaData = new MMJComplexDataFileMetadata();
            this.m_geoInfoMetaData.setDataFileMasks(FRA_DataFileMasksProvider.buildGeoInfoDataFileMasks());
            this.setMetaDataProperties(this.m_geoInfoMetaData);
            this.m_geoInfoMetaData.setVendorCode(this.getVandorAndDataType());
        }
        return this.m_geoInfoMetaData;
    }

    private void setMetaDataProperties(MMJComplexDataFileMetadata metadata) {
        String country = this.m_processProperties.getProperty("street_outputFile");
        if ("mco".equalsIgnoreCase(country) || "mcoap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("MCO");
        } else if ("myt".equalsIgnoreCase(country) || "mytap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("MYT");
        } else if ("mtq".equalsIgnoreCase(country) || "mtqap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("MTQ");
        } else if ("guf".equalsIgnoreCase(country) || "gufap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("GUF");
        } else if ("glp".equalsIgnoreCase(country) || "glpap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("GLP");
        } else if ("reu".equalsIgnoreCase(country) || "reuap".equalsIgnoreCase(country)) {
            this.m_streetMetaData.setCountry("REU");
        } else {
            metadata.setCountry("FRA");
        }
        metadata.setXPow10((byte)5);
        metadata.setYPow10((byte)5);
        metadata.setVersion(m_version);
    }

    public GeoInfoSoundexIndexer getGeoInfoSoundexIndexer() {
        return m_geoSoundexIndexer;
    }

    public IndexFileConvertor getSoundexGeoInfoIndexConvertor(String tempIndex, String newIndex) {
        return new FRA_MultiLevelSoundexIndexFileConvertor(tempIndex, newIndex);
    }

    public void processStreets(boolean createStatistics) throws DataCreationException {
        String dataSetPath = this.m_processProperties.getProperty("dataSetPath");
        ((FRA_StreetBuilder)this.m_dataBuilder).initGeoInfoExactLookupIndex(dataSetPath);
        super.processStreets(createStatistics);
        Set<String> missingKeys = FRA_StreetBuilder.getMissingGeoInfoKeys();
        if (missingKeys != null && missingKeys.size() > 0) {
            DataCreationLogger.getLogger().logInternalError("");
            DataCreationLogger.getLogger().logInternalError("The following geoinfo keys could not be located:");
            for (String key : missingKeys) {
                DataCreationLogger.getLogger().logInternalError(key);
            }
            DataCreationLogger.getLogger().logInternalError("");
        }
    }

    public boolean supportsReverseGeocode() {
        return true;
    }
}

