/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.EngineInitModel;
import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.FRA_AddressUtils;
import com.mapinfo.mapmarker.FRA.FRA_DictionaryGeographyInfo;
import com.mapinfo.mapmarker.FRA.FRA_IConstraints;
import com.mapinfo.mapmarker.FRA.FRA_ScoringHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_AddressFetcher;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacData;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoBase;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_PostInfoFetcherImpl;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_QuickInitGeo2SacData;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SacData;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.IHandler;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CollationKeyGenerator;
import com.mapinfo.mapmarker.common.IDictionaryGeographyInfo;
import com.mapinfo.mapmarker.common.ISoundexKey;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.IAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostInfoFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerReadOnlyMultiLevelIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerBrowseMultiLevelIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerPreLoadedMultiLevelReadOnlyIndexFile;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetIndexFileHelper;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerStreetMultiLevelIndexKey;
import com.mapinfo.mapmarker.core.address.ICoreStreetGeocoder;
import com.mapinfo.mapmarker.utils.MappedSeekableDataInputStream;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;

public class FRA_DataDictionary
extends AbstractDataDictionary {
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    public static final String KEY_GEOBASE_USE_PROVINCE_SEARCH = "KEY_GEOBASE_USE_PROVINCE_SEARCH";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_SEARCH_ONLY_BY_PLACENAME = "search.placename.only";
    private static final Soundex m_soundex = new FRAFrenchSoundex();
    private static final CollationKeyGenerator m_collationKeyGenerator = new CollationKeyGenerator(new Locale("FR", "FRA"), FRA_ScoringHelper.getCollationRules());

    public FRA_DataDictionary(int dictionaryNumber, Properties dataManagerSettings) throws DataDictionaryIntializationException {
        super(dictionaryNumber, dataManagerSettings);
    }

    public void close() throws DataAccessException {
        super.close();
        MappedSeekableDataInputStream.releaseAllStreams();
    }

    protected IMapMarkerReadOnlyIndexFile getStreetIndexFileType() {
        return new MapMarkerPreLoadedMultiLevelReadOnlyIndexFile((IMapMarkerReadOnlyMultiLevelIndexFileHelper)new MapMarkerStreetIndexFileHelper());
    }

    protected MMJGeo2SacRecord getGeo2SacRecordType() {
        return new FRA_Geo2SacRecord();
    }

    protected CollationKeyGenerator getCollationKeyGenerator() {
        return m_collationKeyGenerator;
    }

    protected Soundex getSoundex() {
        return m_soundex;
    }

    protected IAddressFetcher initAddressFetcher() {
        return new FRA_AddressFetcher(this.getDataManagerSettings(), null);
    }

    protected IGeoInfoFetcher initGeoInfoFetcher() throws DataDictionaryIntializationException {
        FRA_GeoInfoFetcherImpl fetcher = null;
        if (!this.isUserDictionary()) {
            fetcher = new FRA_GeoInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return fetcher;
    }

    protected IPostInfoFetcher initPostInfoFetcher() throws DataDictionaryIntializationException {
        FRA_PostInfoFetcherImpl fetcher = null;
        if (!this.isUserDictionary()) {
            fetcher = new FRA_PostInfoFetcherImpl(this.getDictionaryPath(), this.getDataManagerSettings(), null);
        }
        return fetcher;
    }

    protected MMJGeo2SacData initGeo2SacData() throws DataDictionaryIntializationException {
        FRA_Geo2SacData data = null;
        try {
            data = EngineInitModel.useQuickInit() ? new FRA_QuickInitGeo2SacData(this.getGeo2SacRecordType(), new SacMetadata(), super.getDictionaryPath()) : new FRA_Geo2SacData(this.getGeo2SacRecordType(), new SacMetadata(), super.getDictionaryPath());
        }
        catch (FileNotFoundException e) {
            if (this.isGeo2SacRequired()) {
                throw new DataDictionaryIntializationException("exception.no.geo2sac", (Throwable)e);
            }
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.geo2sac", (Throwable)e);
        }
        catch (MMJEDataCorruptedException e) {
            throw new DataDictionaryIntializationException("exception.open.geo2sac", (Throwable)e);
        }
        return data;
    }

    public IGeoBase[] getGeoBases(Address addr, IConstraints preferences) {
        boolean useStringKeys = ((FRA_IConstraints)preferences).useStringKeys();
        byte geoBaseSearchLevel = FRA_GeoBase.AREA_LEVEL_ANY;
        if (preferences.getGeocodeType() != 6) {
            geoBaseSearchLevel = ((FRA_IConstraints)preferences).getSearchAreaLevel();
        }
        HashSet<IGeoBase> bases = new HashSet<IGeoBase>();
        IGeoBase base = this.makeGeoBase(addr.getAreaName3(), useStringKeys, geoBaseSearchLevel);
        if (base != null) {
            bases.add(base);
        }
        if (Boolean.parseBoolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4)) && (base = this.makeGeoBase(addr.getAreaName4(), useStringKeys, geoBaseSearchLevel)) != null) {
            bases.add(base);
        }
        if (Boolean.parseBoolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA2)) && (base = this.makeGeoBase(addr.getAreaName2(), useStringKeys, geoBaseSearchLevel)) != null) {
            bases.add(base);
        }
        return bases.toArray(new IGeoBase[bases.size()]);
    }

    public IGeoBase[] getAlternateGeoBases(Address pa, IConstraints preferences, int i) {
        IGeoBase[] bases = null;
        switch (i) {
            case 0: {
                if (!Boolean.parseBoolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA4))) {
                    preferences.setCustomString(KEY_GEOBASE_FOR_AREA4, "TRUE");
                    bases = this.getGeoBases(pa, preferences);
                    preferences.removeCustomObject((Object)KEY_GEOBASE_FOR_AREA4);
                    if (bases != null && bases.length > 0) break;
                }
            }
            case 1: {
                if (Boolean.parseBoolean(preferences.getCustomString(KEY_GEOBASE_FOR_AREA2))) break;
                preferences.setCustomString(KEY_GEOBASE_FOR_AREA2, "TRUE");
                bases = this.getGeoBases(pa, preferences);
                preferences.removeCustomObject((Object)KEY_GEOBASE_FOR_AREA2);
                if (bases != null && bases.length <= 0) break;
            }
        }
        return bases;
    }

    private IGeoBase makeGeoBase(String areaName, boolean useStringKey, byte areaNameLevel) {
        if (StringUtilities.isEmpty((String)areaName)) {
            return null;
        }
        ISoundexKey key = useStringKey ? FRAFrenchSoundex.getStringKey(areaName) : m_soundex.getSoundex(areaName);
        if (key != null) {
            return new FRA_GeoBase((FRA_SoundexKey)key, areaNameLevel);
        }
        return null;
    }

    protected IPostalBase[] getPostalBases(Address addr, IConstraints constraints) {
        String postcode = addr.getPostCode1();
        if (postcode == null || postcode.length() < 3) {
            return null;
        }
        return new IPostalBase[]{new StandardPostalBase(postcode.substring(0, 3))};
    }

    public MapMarkerIndexKey[] makeBrowseBases(Address addr, IConstraints constraints) {
        String mainAddress = addr.getMainAddress();
        if (mainAddress == null || mainAddress.length() == 0) {
            return null;
        }
        return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(mainAddress)};
    }

    protected MapMarkerIndexKey[] getAlternateBrowseBases(byte alternateType, Address addr, IConstraints constraints) {
        switch (alternateType) {
            case 0: {
                String browseStrKey = addr.getPlaceName();
                if (browseStrKey == null || FRA_AddressUtils.isEmpty(browseStrKey = browseStrKey.trim())) break;
                return new MapMarkerBrowseMultiLevelIndexKey[]{this.createBrowseIndexKey(browseStrKey)};
            }
        }
        return null;
    }

    private MapMarkerBrowseMultiLevelIndexKey createBrowseIndexKey(String browseStrKey) {
        char c = FRA_ScoringHelper.getFirstNormChar(browseStrKey);
        int[] collationKey1 = this.getCollationKeyGenerator().getCollationKey(browseStrKey);
        return new MapMarkerBrowseMultiLevelIndexKey(-1, c, collationKey1);
    }

    public ISoundexKey[] makeStreetBases(Address addr, IConstraints constraints) {
        int altTypes;
        ISoundexKey[] retvals = null;
        ISoundexKey key = null;
        String origStr = addr.getMainAddress();
        key = m_soundex.getSoundex(origStr);
        if (key == null) {
            return retvals;
        }
        Integer tmp = (Integer)constraints.getCustomObject((Object)"KEY_FRA_ALTERNATE_SOUNDEX_CODES");
        int n = altTypes = tmp == null ? -1 : tmp;
        if (altTypes <= 0) {
            retvals = new ISoundexKey[]{key};
            return retvals;
        }
        List alternates = m_soundex.calculateAlternateSoundexKeys(origStr, key, altTypes, new ArrayList());
        return alternates.toArray(new ISoundexKey[alternates.size()]);
    }

    public IDictionaryGeographyInfo getDictionaryGeographyInfo() {
        FRA_DictionaryGeographyInfo info = new FRA_DictionaryGeographyInfo();
        info.setDictionaryPath(this.getDictionaryPath());
        info.setIsUserDictionary(this.isUserDictionary());
        info.setDictionaryNumber(this.getDictionaryNumber() + 1);
        return info;
    }

    public int[] getSacList(Address addr, IConstraints constraints, boolean bDoIntersectionOnly) {
        int[] sacs = super.getSacList(addr, constraints, bDoIntersectionOnly);
        FRA_IConstraints fraconstraints = (FRA_IConstraints)constraints;
        if (sacs != null && sacs.length > 0) {
            boolean doingXSectAfterPOBOX;
            HashSet<Integer> foundSacs = new HashSet<Integer>(sacs.length);
            for (int sac : sacs) {
                foundSacs.add(sac);
            }
            Set<Integer> ignoredSacs = fraconstraints.getIgnoredSacs();
            HashMap custvals = fraconstraints.getCustomValues();
            boolean bl = doingXSectAfterPOBOX = custvals != null && custvals.containsKey("XSECT_POBOX") && custvals.get("XSECT_POBOX") == null;
            if (ignoredSacs != null && !doingXSectAfterPOBOX) {
                foundSacs.removeAll(ignoredSacs);
            }
            if (foundSacs.size() > 0) {
                fraconstraints.setFoundSacs(true);
                Set<Integer> searchedSacs = fraconstraints.getSearchedSacs();
                if (searchedSacs == null) {
                    fraconstraints.setSearchedSacs(foundSacs);
                } else {
                    searchedSacs.addAll(foundSacs);
                }
            }
            sacs = new int[foundSacs.size()];
            int i = 0;
            for (Integer sac : foundSacs) {
                sacs[i++] = sac;
            }
        }
        return sacs;
    }

    protected List getGeoSacs(Address addr, IConstraints constraints) {
        FRA_IConstraints fraconstraints = (FRA_IConstraints)constraints;
        if (fraconstraints.isStrictFirstPass()) {
            return Collections.EMPTY_LIST;
        }
        List sacList = super.getGeoSacs(addr, constraints);
        if (fraconstraints.useStringKeys()) {
            return sacList;
        }
        IHandler handler = constraints.getHandler();
        ScoringAddress scoringAddr = ((ICoreStreetGeocoder)handler).getScoringHelper().makeScoringAddress(handler.getParsedAddress(), constraints, handler);
        ArrayList<SacData> filteredList = new ArrayList<SacData>();
        for (FRA_SacData sacData : sacList) {
            filteredList.add(sacData.filter(scoringAddr));
        }
        return filteredList;
    }

    protected MapMarkerIndexKey[] getAlternateSearchBases(byte alternateType, Address addr, IConstraints constraints) {
        MiSoundexKey sndxKey;
        if (constraints.containsCustomObjectKey((Object)KEY_SEARCH_ONLY_BY_PLACENAME) && addr != null && !StringUtilities.isEmpty((String)addr.getPlaceName()) && (sndxKey = (MiSoundexKey)m_soundex.getSoundex(addr.getPlaceName())) != null) {
            return new MapMarkerIndexKey[]{new MapMarkerStreetMultiLevelIndexKey(-1, sndxKey)};
        }
        return null;
    }

    protected String getAlternateStreetBrowseIndexExtension(byte alternateBrowseType) {
        switch (alternateBrowseType) {
            case 0: {
                return ".pbx";
            }
        }
        return null;
    }

    protected String getAlternateStreetSearchIndexExtension(byte alternateSearchType) {
        switch (alternateSearchType) {
            case 0: {
                return ".pdx";
            }
        }
        return null;
    }
}

