/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.EngineThreadingModel;
import com.mapinfo.mapmarker.FRA.FRATerritory;
import com.mapinfo.mapmarker.FRA.FRA_IConstraints;
import com.mapinfo.mapmarker.FRA.FRA_InternalCandidateAddress;
import com.mapinfo.mapmarker.FRA.FRA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.FRA.FRA_StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_AddressFetcher;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_DataDictionary;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.CountryGeographyInfoImpl;
import com.mapinfo.mapmarker.common.FieldScores;
import com.mapinfo.mapmarker.common.ICountryGeographyInfo;
import com.mapinfo.mapmarker.common.MiSoundexKey;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.StreetCandidateAddressFilter;
import com.mapinfo.mapmarker.common.dp.DataAccessException;
import com.mapinfo.mapmarker.common.dp.DataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.DataManagerSettingsProvider;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessRuntimeException;
import com.mapinfo.mapmarker.common.dp.binary.AbstractDataManager;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GenericAddressFetcher;
import com.mapinfo.mapmarker.common.dp.binary.IDataDictionary;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataManagerInitializationException;
import com.mapinfo.mapmarker.common.dp.binary.MiSoundexGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.StandardPostalBase;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.MiSoundexIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.PostInfoIndexKey;
import com.mapinfo.mapmarker.common.dp.binary.index.StandardPostInfoIndexKey;
import com.mapinfo.mapmarker.core.CoreRetrievedCandidates;
import com.mapinfo.mapmarker.core.IRetrievedCandidates;
import com.mapinfo.mapmarker.licensing.LicenseFilter;
import com.mapinfo.mapmarker.user.ReverseGeocodeLocation;
import com.mapinfo.mapmarker.utils.MMJLog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Properties;
import java.util.ResourceBundle;

public final class FRA_DataManager
extends AbstractDataManager {
    private static Throwable m_SetupException;
    private static final String LSTRING_FILE = "com.mapinfo.mapmarker.common.dp.binary.DataManagerMessageStrings";
    private static final String ERROR_LOAD_DICT_MSG = "exception.error.reading.dictionaries";
    public static final String KEY_POSTALBASE_FOR_POSTCODE_FALLBACK = "KEY_POSTALBASE_FOR_POSTCODE_FALLBACK";
    public static final String KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID = "KEY_GEOBASE_FOR_GEOGRAPHIC_CENTROID";
    public static final String KEY_GEOBASE_STRING_ONLY = "KEY_GEOBASE_STRING_ONLY";
    public static final String KEY_GEOBASE_FOR_AREA1 = "KEY_GEOBASE_FOR_AREA1";
    public static final String KEY_GEOBASE_FOR_AREA2 = "KEY_GEOBASE_FOR_AREA2";
    public static final String KEY_GEOBASE_FOR_AREA3 = "KEY_GEOBASE_FOR_AREA3";
    public static final String KEY_GEOBASE_FOR_AREA4 = "KEY_GEOBASE_FOR_AREA4";
    public static final String KEY_IGNORE_NO_SAC_ERROR = "KEY_IGNORE_NO_SAC_ERROR";
    public static final String KEY_STREETS_TO_REMOVE = "KEY_STREETS_TO_REMOVE";
    public static final String KEY_FRA_ALTERNATE_SOUNDEX_CODES = "KEY_FRA_ALTERNATE_SOUNDEX_CODES";
    private FRA_StreetCandidateAddressFilter m_FRAstreetFilter;
    static IDataDictionary[] m_dataDicts;
    static int m_numDicts;
    static Properties m_DataResources;
    static FRA_InternalCandidateAddress m_forceAddrInit;
    static FRA_InternalGeographicCandidate m_forceGeoInit;
    public static final String KEY_SAC_ERROR_HAS_OCCURED = "KEY_SAC_ERROR_HAS_OCCURED";
    public static final String KEY_SUCCESS_HAS_OCCURED = "KEY_SUCCESS_HAS_OCCURED";
    public static final String KEY_SET_SAC_ERROR = "KEY_SET_SAC_ERROR";
    public static final String KEY_SAC_MUSTMATCH_NUM_GEOAREAS = "KEY_SAC_MUSTMATCH_NUM_GEOAREAS";
    public static final String KEY_GEOBASE_FOR_AREANAME3 = "KEY_GEOBASE_FOR_AREANAME3";
    public static final short GEOINFO_ALIAS_KEY_POSTCODE_LENGTH = 5;
    public static final double STREET_FILTER_SCORE_THRESHOLD_MAINADDRESS = 0.5;

    public FRA_DataManager() throws MMJEDataManagerInitializationException {
        if (m_SetupException != null) {
            ResourceBundle rb = FRA_DataManager.loadBundleForLocale(null, (String)LSTRING_FILE);
            throw new MMJEDataManagerInitializationException(rb.getString(ERROR_LOAD_DICT_MSG), m_SetupException);
        }
    }

    public void reset() throws MMJEDataManagerInitializationException {
        if (!EngineThreadingModel.isThreadsafe()) {
            try {
                this.shutdown();
            }
            catch (DataAccessException DAEx) {
                throw new MMJEDataManagerInitializationException(DAEx.getMessage(), (Throwable)DAEx);
            }
            FRA_DataManager.start();
            if (m_SetupException != null) {
                throw new MMJEDataManagerInitializationException(m_SetupException.getMessage(), m_SetupException);
            }
        }
    }

    private void shutdown() throws DataAccessException {
        for (int i = 0; i < m_numDicts; ++i) {
            IDataDictionary dict = m_dataDicts[i];
            dict.close();
            FRA_DataManager.m_dataDicts[i] = null;
        }
        m_dataDicts = null;
    }

    public PostInfoIndexKey makePostInfoIndexKey(IPostalBase base) {
        return new StandardPostInfoIndexKey((StandardPostalBase)base);
    }

    public GenericAddressFetcher getAddressFetcher() {
        return new FRA_AddressFetcher(null, null);
    }

    public int getDictionaryCount() {
        return m_numDicts;
    }

    public MapMarkerIndexKey makeGeoInfoIndexKey(IGeoBase geoBase) {
        return new MiSoundexIndexKey((MiSoundexKey)((MiSoundexGeoBase)geoBase));
    }

    public IRetrievedCandidates retrieveCandidates(Address pa, ScoringAddress scoringAddress, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates;
        ((FRA_IConstraints)preferences).setFoundSacs(false);
        try {
            retCandidates = super.retrieveCandidates(pa, scoringAddress, preferences);
            this.filterForTerritory(retCandidates, preferences);
        }
        catch (DataAccessException e) {
            if (e.getErrorCode() == 2104) {
                retCandidates = new CoreRetrievedCandidates(new ArrayList());
            }
            throw e;
        }
        return retCandidates;
    }

    public IRetrievedCandidates retrievePostalCentroids(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates = super.retrievePostalCentroids(pa, preferences);
        this.filterForTerritory(retCandidates, preferences);
        return retCandidates;
    }

    public IRetrievedCandidates retrieveGeographicCentroids(Address pa, IConstraints preferences) throws FatalDataAccessException, DataAccessException {
        IRetrievedCandidates retCandidates = super.retrieveGeographicCentroids(pa, preferences);
        this.filterForTerritory(retCandidates, preferences);
        return retCandidates;
    }

    public IRetrievedCandidates retrieveBrowseAddresses(Address pa, IConstraints preferences) throws DataAccessException, FatalDataAccessException {
        IRetrievedCandidates retCandidates = super.retrieveBrowseAddresses(pa, preferences);
        this.filterForTerritory(retCandidates, preferences);
        return retCandidates;
    }

    public IRetrievedCandidates retrieveReverseGeocodeCandidates(ReverseGeocodeLocation location, IConstraints constraints) throws DataAccessRuntimeException, FatalDataAccessRuntimeException {
        IRetrievedCandidates candidates = super.retrieveReverseGeocodeCandidates(location, constraints);
        this.filterForTerritory(candidates, constraints);
        return candidates;
    }

    private void filterForTerritory(IRetrievedCandidates retCandidates, IConstraints preferences) {
        String territory = preferences.getCustomString("KEY_TERRITORY_INPUT");
        if (territory != null) {
            ArrayList cands = new ArrayList(retCandidates.getCandidates());
            ListIterator candsItr = cands.listIterator();
            while (candsItr.hasNext()) {
                Object cand = candsItr.next();
                String candCountry = ((FRATerritory)cand).getCountry();
                if (territory.equalsIgnoreCase(candCountry)) continue;
                candsItr.remove();
            }
            retCandidates.setCandidates(cands);
        }
    }

    protected ICountryGeographyInfo getCountryGeographyInfoObject() {
        return new CountryGeographyInfoImpl("FRA");
    }

    protected LicenseFilter getLicenseFilter() {
        return null;
    }

    public IDataDictionary getDictionary(int idx) {
        return m_dataDicts[idx];
    }

    private static void start() {
        m_SetupException = null;
        try {
            m_DataResources = DataManagerSettingsProvider.getInstance().getSettingsForCountry("FRA");
        }
        catch (IOException e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
        try {
            m_numDicts = Integer.parseInt(m_DataResources.getProperty("DICTIONARY_COUNT"));
            if (m_numDicts < 1) {
                m_numDicts = 1;
            }
        }
        catch (Exception e) {
            m_numDicts = 1;
        }
        m_dataDicts = new FRA_DataDictionary[m_numDicts];
        try {
            for (int i = 0; i < m_numDicts; ++i) {
                try {
                    FRA_DataManager.m_dataDicts[i] = new FRA_DataDictionary(i, m_DataResources);
                    continue;
                }
                catch (DataDictionaryIntializationException DDIEx) {
                    MMJLog.getLog().error(DDIEx.getMessage(), (Throwable)DDIEx);
                    m_SetupException = DDIEx;
                }
            }
        }
        catch (Exception e) {
            MMJLog.getLog().error(e.getMessage(), (Throwable)e);
            m_SetupException = e;
        }
    }

    protected StreetCandidateAddressFilter getStreetFilter() {
        if (this.m_FRAstreetFilter == null) {
            FieldScores thresholds = new FieldScores();
            thresholds.setMainAddress(0.5);
            this.m_FRAstreetFilter = new FRA_StreetCandidateAddressFilter(thresholds);
        }
        return this.m_FRAstreetFilter;
    }

    static {
        FRA_DataManager.start();
    }
}

