/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_Geo2SacRecord;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoBase;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SacData;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacData;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.common.dp.binary.SacMetadata;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class FRA_Geo2SacData
extends MMJGeo2SacData {
    private Map<IGeoBase, SacData> m_soundexMap;
    private Map<IGeoBase, SacData> m_stringMap;

    public FRA_Geo2SacData(MMJGeo2SacRecord recordType, SacMetadata metadataType, String dataPath) throws IOException, MMJEDataCorruptedException {
        super(recordType, metadataType, dataPath);
    }

    protected void optimizeSacMap() {
        this.m_soundexMap = Collections.unmodifiableMap(this.m_soundexMap);
        this.m_stringMap = Collections.unmodifiableMap(this.m_stringMap);
    }

    protected void initSacMap() {
        this.m_soundexMap = new HashMap<IGeoBase, SacData>(this.getSize() / 2, 1.0f);
        this.m_stringMap = new HashMap<IGeoBase, SacData>(this.getSize() / 2, 1.0f);
    }

    protected void addSacForGeoBase(IGeoBase base, SacData info) {
        if (((FRA_GeoBase)base).getKeyType() == 0) {
            this.m_soundexMap.put(base, info);
        } else {
            this.m_stringMap.put(base, info);
        }
    }

    public SacData getSacForGeoBase(IGeoBase base) {
        FRA_GeoBase fraBase = (FRA_GeoBase)base;
        if (fraBase.getAreaLevel() == FRA_GeoBase.AREA_LEVEL_ANY) {
            fraBase.setAreaLevel(FRA_GeoBase.AREA_LEVEL_AN3);
            FRA_SacData sacs = (FRA_SacData)this.getSacsFromMap(fraBase);
            fraBase.setAreaLevel(FRA_GeoBase.AREA_LEVEL_AN4);
            FRA_SacData additionalSacs = (FRA_SacData)this.getSacsFromMap(fraBase);
            fraBase.setAreaLevel(FRA_GeoBase.AREA_LEVEL_ANY);
            if (sacs == null) {
                return additionalSacs;
            }
            if (additionalSacs != null) {
                sacs.addAll(additionalSacs);
            }
            return sacs;
        }
        return this.getSacsFromMap(fraBase);
    }

    protected SacData getSacsFromMap(FRA_GeoBase base) {
        if (base.getKeyType() == 0) {
            return this.m_soundexMap.get((Object)base);
        }
        return this.m_stringMap.get((Object)base);
    }

    protected void addSacDataForRecord(MMJGeo2SacRecord record) {
        FRA_SacData info = (FRA_SacData)this.getSacForGeoBase(record.getGeoBase());
        if (info == null) {
            info = new FRA_SacData();
            this.addSacForGeoBase(record.getGeoBase(), info);
        }
        info.addSac(record.getSac(), ((FRA_Geo2SacRecord)record).getSource());
    }
}

