/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoBase;
import com.mapinfo.mapmarker.common.dp.binary.IGeoBase;
import com.mapinfo.mapmarker.common.dp.binary.MMJEDataCorruptedException;
import com.mapinfo.mapmarker.common.dp.binary.MMJGeo2SacRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class FRA_Geo2SacRecord
extends MMJGeo2SacRecord {
    private String m_source;
    private byte m_areaLevel;

    public FRA_Geo2SacRecord() {
        super(-1, (IGeoBase)new FRA_GeoBase());
        this.m_areaLevel = FRA_GeoBase.AREA_LEVEL_ANY;
    }

    public FRA_Geo2SacRecord(int sac, FRA_GeoBase base) {
        super(sac, (IGeoBase)base);
        this.m_source = base.getSource();
        this.m_areaLevel = base.getAreaLevel();
    }

    public MMJGeo2SacRecord newInstance() {
        return new FRA_Geo2SacRecord();
    }

    public String getSource() {
        return this.m_source;
    }

    public void setSource(String source) {
        this.m_source = source;
    }

    public byte getAreaLevel() {
        return this.m_areaLevel;
    }

    public void setAreaLevel(byte level) {
        this.m_areaLevel = level;
    }

    public void write(DataOutput out) throws IOException, MMJEDataCorruptedException {
        super.write(out);
        out.writeUTF(this.m_source);
        out.writeByte(this.m_areaLevel);
    }

    public void read(DataInput in) throws IOException, MMJEDataCorruptedException {
        super.read(in);
        this.m_source = in.readUTF();
        this.m_areaLevel = in.readByte();
        FRA_GeoBase base = (FRA_GeoBase)this.getGeoBase();
        base.setAreaLevel(this.getAreaLevel());
    }

    public String toString() {
        String t = "";
        String c = "";
        String v = "";
        FRA_GeoBase base = (FRA_GeoBase)this.getGeoBase();
        if (base != null) {
            t = String.valueOf(base.getKeyType());
            c = String.valueOf(base.getFirstChar());
            v = String.valueOf(base.getNumericValue());
        }
        return String.format("KEY_TYPE=%1s FIRST_CHAR=%1s NUMERIC_VALUE=%8s SOURCE=%s LVL=%d", t, c, v, this.m_source != null ? this.m_source : "", this.m_areaLevel);
    }
}

