/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.FRAFrenchSoundex;
import com.mapinfo.mapmarker.FRA.FRA_IConstraints;
import com.mapinfo.mapmarker.FRA.FRA_InternalGeographicCandidate;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.FRA.dp.binary.FRA_SoundexKey;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_GeoInfoIndexFile;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_MultiLevelSoundexIndexKey;
import com.mapinfo.mapmarker.FRA.dp.binary.index.FRA_ReadOnlyMultiLevelSoundexIndexFile;
import com.mapinfo.mapmarker.IConstraints;
import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.InternalGeographicCandidate;
import com.mapinfo.mapmarker.common.Soundex;
import com.mapinfo.mapmarker.common.dp.FatalDataAccessException;
import com.mapinfo.mapmarker.common.dp.binary.DataDictionaryIntializationException;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoFetcherImpl;
import com.mapinfo.mapmarker.common.dp.binary.IDataAccessHelper;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.index.IMapMarkerIndex;
import com.mapinfo.mapmarker.common.dp.binary.index.MapMarkerIndexKey;
import com.mapinfo.mapmarker.utils.MiVersion;
import com.mapinfo.mapmarker.utils.SeekableDataInputNIO;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.DataInput;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Properties;

public class FRA_GeoInfoFetcherImpl
extends GeoInfoFetcherImpl {
    private static final MiVersion m_newGeoInfoDataFormatVersion = new MiVersion(4, 5, 0);
    private final MMJComplexDataFileMetadata m_metadata;
    private final boolean m_useOldDataFormat;
    protected final Soundex m_soundex = new FRAFrenchSoundex();
    protected FRA_GeoInfoIndexFile m_geoInfoStringIndex;

    public FRA_GeoInfoFetcherImpl(String dataPath, Properties localSettings, Properties localMessages) throws DataDictionaryIntializationException {
        super(dataPath, localSettings, localMessages, false);
        this.m_metadata = new MMJComplexDataFileMetadata();
        try {
            this.initMetaData(StringUtilities.appendToPath((String)dataPath, (String)this.getGeoInfoFileName()));
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.data.geoinfo", (Throwable)e);
        }
        this.m_useOldDataFormat = this.m_metadata.getVersion().compareTo((Object)m_newGeoInfoDataFormatVersion) < 0;
        this.init();
        try {
            this.m_geoInfoStringIndex = new FRA_GeoInfoIndexFile();
            this.m_geoInfoStringIndex.open(StringUtilities.appendToPath((String)dataPath, (String)"geoinfo.jdx"));
        }
        catch (IOException e) {
            throw new DataDictionaryIntializationException("exception.open.data.geoinfo", (Throwable)e);
        }
    }

    private void initMetaData(String datapath) throws IOException {
        try (SeekableDataInputNIO stream = new SeekableDataInputNIO(new File(datapath));){
            this.m_metadata.read((DataInput)stream);
        }
    }

    protected IMapMarkerIndex getGeoInfoIndexType() {
        if (this.m_useOldDataFormat) {
            throw new RuntimeException((Throwable)new FatalDataAccessException(2111));
        }
        return new FRA_ReadOnlyMultiLevelSoundexIndexFile();
    }

    protected IDataAccessHelper getDataAccessHelperType() {
        if (this.m_useOldDataFormat) {
            throw new RuntimeException((Throwable)new FatalDataAccessException(2111));
        }
        return new FRA_GeoInfoPreLoadedDataHelper();
    }

    protected String getGeoInfoIndexFileName() {
        return "geoinfo.sdx";
    }

    protected MapMarkerIndexKey[] makeGeoInfoIndexKeys(Address addr, IConstraints constraints) {
        HashSet<FRA_SoundexKey> keySet = new HashSet<FRA_SoundexKey>();
        boolean useStringKeys = ((FRA_IConstraints)constraints).useStringKeys();
        FRA_SoundexKey key = this.makeAreaNameKey(addr.getAreaName1(), useStringKeys);
        if (key != null) {
            keySet.add(key);
        }
        if ((key = this.makeAreaNameKey(addr.getAreaName2(), useStringKeys)) != null) {
            keySet.add(key);
        }
        if ((key = this.makeAreaNameKey(addr.getAreaName3(), useStringKeys)) != null) {
            keySet.add(key);
        }
        if ((key = this.makeAreaNameKey(addr.getAreaName4(), useStringKeys)) != null) {
            keySet.add(key);
        }
        MapMarkerIndexKey[] wrapped = keySet.toArray(new MapMarkerIndexKey[keySet.size()]);
        for (int i = 0; i < wrapped.length; ++i) {
            wrapped[i] = new FRA_MultiLevelSoundexIndexKey((FRA_SoundexKey)wrapped[i]);
        }
        return wrapped;
    }

    private FRA_SoundexKey makeAreaNameKey(String areaName, boolean makeStringKey) {
        FRA_SoundexKey key;
        if (!StringUtilities.isEmpty((String)areaName) && (key = makeStringKey ? (FRA_SoundexKey)FRAFrenchSoundex.getStringKey(areaName) : (FRA_SoundexKey)this.m_soundex.getSoundex(areaName)) != null) {
            return key;
        }
        return null;
    }

    protected InternalGeographicCandidate makeInternalGeographicCandidate() {
        return new FRA_InternalGeographicCandidate();
    }
}

