/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.dp.binary.FRA_GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationException;
import com.mapinfo.mapmarker.common.dp.binary.DataCreationLogger;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GenericDataItemAccessor;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoDataItem;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoPreLoadedDataHelper;
import com.mapinfo.mapmarker.common.dp.binary.GeoInfoRecord;
import com.mapinfo.mapmarker.common.dp.binary.IDataFileDataItem;
import com.mapinfo.mapmarker.common.dp.binary.LocalizationException;
import com.mapinfo.mapmarker.common.dp.binary.MMJComplexDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJDataFileMetadata;
import com.mapinfo.mapmarker.common.dp.binary.MMJETypeArraySizeExceededException;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FRA_GeoInfoPreLoadedDataHelper
extends GeoInfoPreLoadedDataHelper {
    public MMJDataFileMetadata getMetadataType() {
        return new MMJComplexDataFileMetadata();
    }

    protected GeoInfoRecord makeGeoInfoRecord() {
        return new FRA_GeoInfoRecord();
    }

    public Object makeDataRecord(IDataFileDataItem item, MMJDataFileMetadata metadata) throws LocalizationException {
        byte[] bytes;
        FRA_GeoInfoRecord record = (FRA_GeoInfoRecord)((Object)super.makeDataRecord(item, metadata));
        GenericDataItem genericItem = (GenericDataItem)item;
        if (genericItem.hasString(32)) {
            record.setOriginalAreaName1(GenericDataItemAccessor.getDataString((int)32, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(33)) {
            record.setOriginalAreaName2(GenericDataItemAccessor.getDataString((int)33, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(34)) {
            record.setOriginalAreaName3(GenericDataItemAccessor.getDataString((int)34, (GenericDataItem)genericItem));
        }
        if (genericItem.hasString(35)) {
            record.setOriginalAreaName4(GenericDataItemAccessor.getDataString((int)35, (GenericDataItem)genericItem));
        }
        if (genericItem.hasBlob(32)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)32, (GenericDataItem)genericItem);
            record.setAltAreaName1Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(33)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)33, (GenericDataItem)genericItem);
            record.setAltAreaName2Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(34)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)34, (GenericDataItem)genericItem);
            record.setAltAreaName3Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(35)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)35, (GenericDataItem)genericItem);
            record.setAltAreaName4Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(36)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)36, (GenericDataItem)genericItem);
            record.setOriginalAltAreaName1Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(37)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)37, (GenericDataItem)genericItem);
            record.setOriginalAltAreaName2Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(38)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)38, (GenericDataItem)genericItem);
            record.setOriginalAltAreaName3Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasBlob(39)) {
            bytes = GenericDataItemAccessor.getDataBlob((int)39, (GenericDataItem)genericItem);
            record.setOriginalAltAreaName4Array(this.decodeStringArray(bytes));
        }
        if (genericItem.hasInteger(32)) {
            int pc = GenericDataItemAccessor.getDataInt((int)32, (GenericDataItem)genericItem);
            StringBuilder sb = new StringBuilder(String.valueOf(pc));
            while (sb.length() < 5) {
                sb.insert(0, '0');
            }
            record.setPostCode(sb.toString());
        }
        return record;
    }

    public void populateLocalGeoInfo(GeoInfoRecord geoInfoRecord, IDataFileDataItem dataFileDataItem, MMJComplexDataFileMetadata metadata) throws DataCreationException {
        FRA_GeoInfoRecord record = (FRA_GeoInfoRecord)geoInfoRecord;
        GeoInfoDataItem dataItem = (GeoInfoDataItem)dataFileDataItem;
        try {
            String postcode;
            String[] arr;
            String str = record.getOriginalAreaName1();
            if (!StringUtilities.isEmpty((String)str)) {
                dataItem.putString(32, str);
            }
            if (!StringUtilities.isEmpty((String)(str = record.getOriginalAreaName2()))) {
                dataItem.putString(33, str);
            }
            if (!StringUtilities.isEmpty((String)(str = record.getOriginalAreaName3()))) {
                dataItem.putString(34, str);
            }
            if (!StringUtilities.isEmpty((String)(str = record.getOriginalAreaName4()))) {
                dataItem.putString(35, str);
            }
            if ((arr = record.getAltAreaName1Array()) != null && arr.length > 0) {
                dataItem.putBlob(32, this.encodeStringArray(arr));
            }
            if ((arr = record.getAltAreaName2Array()) != null && arr.length > 0) {
                dataItem.putBlob(33, this.encodeStringArray(arr));
            }
            if ((arr = record.getAltAreaName3Array()) != null && arr.length > 0) {
                dataItem.putBlob(34, this.encodeStringArray(arr));
            }
            if ((arr = record.getAltAreaName4Array()) != null && arr.length > 0) {
                dataItem.putBlob(35, this.encodeStringArray(arr));
            }
            if ((arr = record.getOriginalAltAreaName1Array()) != null && arr.length > 0) {
                dataItem.putBlob(36, this.encodeStringArray(arr));
            }
            if ((arr = record.getOriginalAltAreaName2Array()) != null && arr.length > 0) {
                dataItem.putBlob(37, this.encodeStringArray(arr));
            }
            if ((arr = record.getOriginalAltAreaName3Array()) != null && arr.length > 0) {
                dataItem.putBlob(38, this.encodeStringArray(arr));
            }
            if ((arr = record.getOriginalAltAreaName4Array()) != null && arr.length > 0) {
                dataItem.putBlob(39, this.encodeStringArray(arr));
            }
            if (!StringUtilities.isEmpty((String)(postcode = record.getPostCode()))) {
                dataItem.putInt(32, Integer.parseInt(postcode));
            }
        }
        catch (NumberFormatException nfe) {
            DataCreationLogger.getLogger().logInternalError("Unable to parse postcode as int for record:");
            DataCreationLogger.getLogger().logInternalError(record.toString());
        }
        catch (MMJETypeArraySizeExceededException e) {
            DataCreationLogger.getLogger().logInternalError("Unable to populate geoinfo data for record:");
            DataCreationLogger.getLogger().logInternalError(record.toString());
            DataCreationLogger.getLogger().logInternalError(e.getMessage());
            DataCreationLogger.getLogger().logStackTrace((Throwable)e);
            throw new DataCreationException(301, (Throwable)e);
        }
    }

    private byte[] encodeStringArray(String[] strings) throws DataCreationException {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(strings.length);
            for (int i = 0; i < strings.length; ++i) {
                out.writeUTF(strings[i]);
            }
            out.close();
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new DataCreationException((Throwable)e);
        }
    }

    private String[] decodeStringArray(byte[] bytes) throws LocalizationException {
        try {
            DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
            int count = in.readByte();
            String[] strings = new String[count];
            for (int i = 0; i < count; ++i) {
                strings[i] = in.readUTF();
            }
            return strings;
        }
        catch (IOException e) {
            throw new LocalizationException((Throwable)e);
        }
    }
}

