/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.common.Address;
import com.mapinfo.mapmarker.common.dp.binary.MMJRangeRecordComparator;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecord;
import com.mapinfo.mapmarker.common.dp.binary.MMJStreetRecordComparator;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.Collections;

public class FRA_MMJStreetRecordComparator
extends MMJStreetRecordComparator {
    protected MMJRangeRecordComparator m_rangeComparator = new MMJRangeRecordComparator();

    public int compare(Object o1, Object o2) {
        MMJStreetRecord record1 = (MMJStreetRecord)o1;
        MMJStreetRecord record2 = (MMJStreetRecord)o2;
        if (record1.getSegment().getRanges() != null && !record1.getSegment().rangesSorted()) {
            Collections.sort(record1.getSegment().getRanges(), this.m_rangeComparator);
            record1.getSegment().setRangesSorted();
        }
        if (record2.getSegment().getRanges() != null && !record2.getSegment().rangesSorted()) {
            Collections.sort(record2.getSegment().getRanges(), this.m_rangeComparator);
            record2.getSegment().setRangesSorted();
        }
        if (record1.getSac() == record2.getSac()) {
            if (record1.getKey().equals(record2.getKey())) {
                return this.compareStreetInfo(record1, record2);
            }
            return record1.getKey().compareTo((Object)record2.getKey());
        }
        if (record1.getSac() < record2.getSac()) {
            return -1;
        }
        return 1;
    }

    protected int compareStreetInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        String addressString2;
        String addressString1 = this.buildStreetString(record1.getAddress());
        if (addressString1.equals(addressString2 = this.buildStreetString(record2.getAddress()))) {
            return this.comparePostalInfo(record1, record2);
        }
        return addressString1.compareTo(addressString2);
    }

    protected String buildStreetString(Address address) {
        if (address == null) {
            return null;
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(address.getPreDirectional() == null ? "" : address.getPreDirectional());
        buffer.append(address.getPreThoroughfareType() == null ? "" : address.getPreThoroughfareType());
        buffer.append(address.getMainAddress() == null ? "" : address.getMainAddress());
        buffer.append(address.getPostThoroughfareType() == null ? "" : address.getPostThoroughfareType());
        buffer.append(address.getPostDirectional() == null ? "" : address.getPostDirectional());
        return buffer.toString();
    }

    protected int comparePostalInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        int compare = this.compareSidedFields(record1.getSegment().getLeftPostalCode1(), record1.getSegment().getRightPostalCode1(), record2.getSegment().getLeftPostalCode1(), record2.getSegment().getRightPostalCode1());
        if (compare != 0) {
            return compare;
        }
        return this.compareGeoInfo(record1, record2);
    }

    protected int compareGeoInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        int compare = this.compareSidedFields(record1.getSegment().getLeftAreaName1(), record1.getSegment().getRightAreaName1(), record2.getSegment().getLeftAreaName1(), record2.getSegment().getRightAreaName1());
        if (compare != 0) {
            return compare;
        }
        compare = this.compareSidedFields(record1.getSegment().getLeftAreaName2(), record1.getSegment().getRightAreaName2(), record2.getSegment().getLeftAreaName2(), record2.getSegment().getRightAreaName2());
        if (compare != 0) {
            return compare;
        }
        compare = this.compareSidedFields(record1.getSegment().getLeftAreaName3(), record1.getSegment().getRightAreaName3(), record2.getSegment().getLeftAreaName3(), record2.getSegment().getRightAreaName3());
        if (compare != 0) {
            return compare;
        }
        compare = this.compareSidedFields(record1.getSegment().getLeftAreaName4(), record1.getSegment().getRightAreaName4(), record2.getSegment().getLeftAreaName4(), record2.getSegment().getRightAreaName4());
        if (compare != 0) {
            return compare;
        }
        return this.compareRangeInfo(record1, record2);
    }

    private int compareSidedFields(String leftField1, String rightField1, String leftField2, String rightField2) {
        if (!StringUtilities.isEmpty((String)leftField1) && !StringUtilities.isEmpty((String)leftField2)) {
            int compare = leftField1.compareTo(leftField2);
            if (compare != 0) {
                return compare;
            }
            if (!StringUtilities.isEmpty((String)rightField1) && !StringUtilities.isEmpty((String)rightField2)) {
                compare = rightField1.compareTo(rightField2);
                if (compare != 0) {
                    return compare;
                }
            } else {
                if (StringUtilities.isEmpty((String)rightField1) && !StringUtilities.isEmpty((String)rightField2)) {
                    return -1;
                }
                if (StringUtilities.isEmpty((String)rightField2) && !StringUtilities.isEmpty((String)rightField1)) {
                    return 1;
                }
            }
        } else {
            if (!StringUtilities.isEmpty((String)leftField1)) {
                return 1;
            }
            if (!StringUtilities.isEmpty((String)leftField2)) {
                return -1;
            }
            if (!StringUtilities.isEmpty((String)rightField1) && !StringUtilities.isEmpty((String)rightField2)) {
                int compare = rightField1.compareTo(rightField2);
                if (compare != 0) {
                    return compare;
                }
            } else {
                if (!StringUtilities.isEmpty((String)rightField1) && StringUtilities.isEmpty((String)rightField2)) {
                    return 1;
                }
                if (!StringUtilities.isEmpty((String)rightField2) && StringUtilities.isEmpty((String)rightField1)) {
                    return -1;
                }
            }
        }
        return 0;
    }

    protected int compareRangeInfo(MMJStreetRecord record1, MMJStreetRecord record2) {
        if (record1.getSegment().getRanges() != null) {
            if (record2.getSegment().getRanges() != null) {
                return this.m_rangeComparator.compare(record1.getSegment().getRanges().get(0), record2.getSegment().getRanges().get(0));
            }
            return 1;
        }
        if (record2.getSegment().getRanges() != null) {
            return -1;
        }
        return 0;
    }
}

