/*
 * Decompiled with CFR 0.152.
 */
package com.mapinfo.mapmarker.FRA.dp.binary;

import com.mapinfo.mapmarker.FRA.FRA_MatcherConstants;
import com.mapinfo.mapmarker.common.ScoringAddress;
import com.mapinfo.mapmarker.common.dp.binary.SacData;
import com.mapinfo.mapmarker.utils.StringUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FRA_SacData
extends SacData {
    private static final double SAC_GEO_FILTER_THRESHHOLD = FRA_MatcherConstants.getSacGeoFilterThreshold();
    private final Map<Integer, List<SacEntry>> m_buckets = new HashMap<Integer, List<SacEntry>>();

    public void addSac(int sac, String geo) {
        super.addSac(sac);
        int key = sac / 10;
        List<SacEntry> bucket = this.m_buckets.get(key);
        if (bucket == null) {
            bucket = new ArrayList<SacEntry>(1);
            this.m_buckets.put(key, bucket);
        }
        bucket.add(new SacEntry(sac, geo));
    }

    public void addAll(FRA_SacData other) {
        if (other == null) {
            return;
        }
        for (Integer otherBucketKey : other.m_buckets.keySet()) {
            List<SacEntry> otherBucketEntries = other.m_buckets.get(otherBucketKey);
            for (SacEntry otherSacEntry : otherBucketEntries) {
                List<SacEntry> myBucket = this.m_buckets.get(otherBucketKey);
                if (myBucket == null) {
                    myBucket = new ArrayList<SacEntry>(1);
                    this.m_buckets.put(otherBucketKey, myBucket);
                }
                myBucket.add(new SacEntry(otherSacEntry.sac, otherSacEntry.geo));
            }
        }
    }

    public SacData filter(ScoringAddress addr) {
        String pc = addr.getPostCode1();
        int pcKey = -1;
        if (pc != null && pc.length() > 2) {
            try {
                pcKey = Integer.parseInt(pc.substring(0, 2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (pcKey < 0) {
            return this.filterOnGeo(addr);
        }
        return this.filterOnPostCode(pcKey);
    }

    private SacData filterOnPostCode(int key) {
        HashSet<Integer> sacs = new HashSet<Integer>();
        List<SacEntry> entries = this.m_buckets.get(key);
        if (entries != null) {
            for (SacEntry entry : entries) {
                sacs.add(entry.sac);
            }
        }
        return new SacData(sacs);
    }

    private SacData filterOnGeo(ScoringAddress addr) {
        HashSet<Integer> sacs = new HashSet<Integer>();
        boolean scoreAN1 = false;
        boolean scoreAN2 = false;
        boolean scoreAN3 = !StringUtilities.isEmpty((String)addr.getAreaName3());
        boolean scoreAN4 = !StringUtilities.isEmpty((String)addr.getAreaName4());
        for (List<SacEntry> sacBucket : this.m_buckets.values()) {
            for (SacEntry entry : sacBucket) {
                if (sacs.contains(entry.sac)) continue;
                double an4score = -1.0;
                double an3score = -1.0;
                double an2score = -1.0;
                double an1score = -1.0;
                String geo = entry.geo;
                if (!(scoreAN3 && (an3score = addr.scoreAreaName3(geo)) >= SAC_GEO_FILTER_THRESHHOLD || scoreAN4 && (an4score = addr.scoreAreaName4(geo)) >= SAC_GEO_FILTER_THRESHHOLD || scoreAN1 && (an1score = addr.scoreAreaName1(geo)) >= SAC_GEO_FILTER_THRESHHOLD)) {
                    double d;
                    if (!scoreAN2) continue;
                    an2score = addr.scoreAreaName2(geo);
                    if (!(d >= SAC_GEO_FILTER_THRESHHOLD)) continue;
                }
                sacs.add(entry.sac);
            }
        }
        return new SacData(sacs);
    }

    public SacData filterExactGeo(String geo) {
        HashSet<Integer> sacs = new HashSet<Integer>();
        if (geo != null) {
            for (List<SacEntry> sacBucket : this.m_buckets.values()) {
                for (SacEntry entry : sacBucket) {
                    if (sacs.contains(entry.sac) || !geo.equals(entry.geo)) continue;
                    sacs.add(entry.sac);
                }
            }
        }
        return new SacData(sacs);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(256);
        String linesep = System.getProperty("line.separator");
        int count = 0;
        for (Integer key : this.m_buckets.keySet()) {
            List<SacEntry> entries = this.m_buckets.get(key);
            count += entries.size();
            sb.append(String.format("bucket: %3d, sacs: %3d", key, entries.size()));
            for (SacEntry sacEntry : entries) {
                sb.append(",[");
                sb.append(sacEntry.sac);
                sb.append(":");
                sb.append(sacEntry.geo);
                sb.append("]");
            }
            sb.append(linesep);
        }
        sb.insert(0, "Total sacs: " + count + linesep);
        return sb.toString();
    }

    private class SacEntry {
        int sac;
        String geo;

        private SacEntry(int sac, String geo) {
            this.sac = sac;
            this.geo = geo;
        }
    }
}

